#include <Cvo/Application.h++>
#include <Cvo/Frame.h++>
#include <Cvo/Label.h++>

// Change these resources.

static Cvo_Default def[] = {
    "*label1.label: Label One",
    "*label2.label: Label Two",
    "*label3.label: Label Three",
    "*label4.label: Label Four"
};

main(int argc, char **argv)
{
    // Parse the command line arguments.

    Cvo_Parse(&argc, &argv);

    // Create Cvo_Application object, with a resource name
    // of Test. As this is the initial object, it has no
    // parent argument.

    Cvo_Application *app = new Cvo_Application("example");

    // Create three Cvo_Frame objects. The first is assigned
    // to the app object. The other two Cvo_Frame objects are
    // assigned to the back Cvo_Frame object.

    Cvo_Frame *back = new Cvo_Frame(app);
    Cvo_Frame *frame1 = new Cvo_Frame(back);
    Cvo_Frame *frame2 = new Cvo_Frame(back);

    // The back Cvo_Frame will organize its children
    // horizontally. The other two Cvo_Frame objects will
    // organize their children vertically.

    back->HorizontalChildren();
    frame1->VerticalChildren();
    frame2->VerticalChildren();

    // Create four labels, the first three in the frame1
    // object, the last in the frame2 object. Also, tell the
    // last label to expand to fill the frame it is in.

    Cvo_ChamferedLabel *label1 = new Cvo_ChamferedLabel("label1", frame1, "NR");
    Cvo_ChamferedLabel *label2 = new Cvo_ChamferedLabel("label2", frame1, "NR");
    Cvo_ChamferedLabel *label3 = new Cvo_ChamferedLabel("label3", frame1, "NR");
    Cvo_ChamferedLabel *label4 = new Cvo_ChamferedLabel("label4", frame2, "NR");
    label4->ExpandFrame();

    // Let X map the application and let the application
    // begin processing events.

    app->MainLoop();
}
