#include <Cvo/Application.h++>
#include <Cvo/Button.h++>
#include <Cvo/Frame.h++>
#include <Cvo/Separator.h++>

// Set some default X resource values.

static Cvo_Default def[] = {
    "*buttonWide.label: Wide Button",
    "*buttonFrame.buttonOne.label: Button One",
    "*buttonFrame.buttonTwo.label: Button Two",
    "*buttonFrame.buttonPressMe.label: Press Me",
    "*buttonFrame.buttonQuit.label: Quit"
};

// Our functions to handle events.

void Quit(Cvo_Object *, XEvent *, void *);
void Change(Cvo_Object *, XEvent *, void *);

main(int argc, char **argv)
{
    // Parse command line options.

    Cvo_Parse(&argc, &argv);

    // Create the application.

    Cvo_Application *exampleApp = new Cvo_Application("exampleApp");

    // Put a button in the window. This will expand to fill the width of
    // the parent window. Place a separator next.
    // The "NR" is simply an indication that no resource was set for
    // this button.  It could be replaced by a default label for the button.

    Cvo_Button *buttonWide = new Cvo_Button("buttonWide", exampleApp, "NR");
    new Cvo_Separator(exampleApp);

    // Create a frame to hold more buttons.

    Cvo_Frame *buttonFrame = new Cvo_Frame("buttonFrame", exampleApp);
    buttonFrame->HorizontalChildren();
    buttonFrame->ExpandFrame();

    // Create four buttons. They will expand to fill the frame.

    Cvo_Button *buttonOne = new Cvo_Button("buttonOne", buttonFrame, "NR");
    Cvo_Button *buttonTwo = new Cvo_Button("buttonTwo", buttonFrame, "NR");
    Cvo_Button *buttonPressMe = new Cvo_Button("buttonPressMe", buttonFrame, "NR");
    Cvo_Button *buttonQuit = new Cvo_Button("buttonQuit", buttonFrame, "NR");

    buttonOne->ExpandFrame();
    buttonTwo->ExpandFrame();
    buttonPressMe->ExpandFrame();
    buttonQuit->ExpandFrame();

    // Register CvoButtonUpEvents from the PressMe button to a
    // function, and those from the Quit button to another.

    Cvo_Register(buttonPressMe, CvoButtonUpEvent, Change, exampleApp);
    Cvo_Register(buttonQuit, CvoButtonUpEvent, Quit, exampleApp);

    exampleApp->MainLoop();
}

void
Quit(Cvo_Object *, XEvent *, void *)
{
    Cvo_Exit(0);
}

void
Change(Cvo_Object *b, XEvent *, void *a)
{
    // Create a static counter, so each time the button is pressed,
    // we can increment the count.

    static cnt = 0;
    char buf[40];

    // Cast the arguments.

    Cvo_Button *button = (Cvo_Button *) b;
    Cvo_Application *app = (Cvo_Application *) a;

    // Create a new label from the resource and counter, and set the
    // text.

    sprintf(buf, "%s (%d)", button->GetResource("label", "Label", "NR"), cnt++);
    button->SetText(buf);

    // Tell the application to lay itself out again, because
    // the label has changed size.

    app->NewLayout(1);

    // button->NewLayout(1); // This should work.
}
