//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	$Id: WindowViewPort.h++,v 1.2 1994/08/10 18:11:11 prb Exp $
//
#if     !defined(_Cvo_WindowViewPort_)
#define	_Cvo_WindowViewPort_

#if	!defined(_Cvo_ViewPort_)
#include <Cvo/ViewPort.h++>
#endif

class Cvo_WindowViewPort;
class Cvo_WindowViewPortPanner;

class Cvo_WindowViewPortClipFrame : public Cvo_Frame {
    Cvo_WindowViewPort	*wvp;
    void _Init(Cvo_WindowViewPort *);
public:
    CONSTRUCDECL_1ARG(Cvo_WindowViewPortClipFrame, Cvo_WindowViewPort *)
    int StandardComputeLayoutSize(int);
    int StandardLayoutFunction(int, int, int, int);
};

class Cvo_WindowViewPortWindow : public Cvo_Window {
    Cvo_Frame		*clipframe;
    Cvo_Window		*viewframe;
    Cvo_WindowViewPort	*wvp;
    void _Init(Cvo_WindowViewPort *);
public:
    CONSTRUCDECL_1ARG(Cvo_WindowViewPortWindow, Cvo_WindowViewPort *)
    Cvo_Window	*Frame()		{ return(viewframe); }
    Cvo_Frame	*ClipFrame()		{ return(clipframe); }
    void SetFrame(Cvo_Window *f)	{ viewframe = f; }
    friend void Cvo_WindowViewPort_Resize(Cvo_Object *, XEvent *, void *);
};

class Cvo_WindowViewPort : public Cvo_ViewPort {
    friend Cvo_WindowViewPortWindow;
    friend Cvo_WindowViewPortPanner;
    BOOL	moving:1;
    BOOL	synchronize:1;
    void _Init();
protected:
    void ResetFrame(Cvo_Window *);
public:
    CONSTRUCDECL(Cvo_WindowViewPort)
    Cvo_Window	*Frame()	
	{ return(((Cvo_WindowViewPortWindow *)main)->Frame()); }
    Cvo_Frame	*ClipFrame()
	{ return(((Cvo_WindowViewPortWindow *)main)->ClipFrame()); }
    void AddHorizontal();
    void AddVertical();
    void Synchronize(BOOL v = True)	{ synchronize = v; }

    friend void Cvo_WindowViewPort_ScrollHorizontal(Cvo_Object *, XEvent *, void *);
    friend void Cvo_WindowViewPort_ScrollVertical(Cvo_Object *, XEvent *, void *);
    friend void Cvo_WindowViewPort_ViewResize(Cvo_Object *, XEvent *, void *);
    friend void Cvo_WindowViewPort_Resize(Cvo_Object *, XEvent *, void *);
    friend void Cvo_WindowViewPort_Move(Cvo_Object *, XEvent *, void *);

    friend void Cvo_WindowViewPort_Mapped(Cvo_Object *, XEvent *, void *);
    friend void Cvo_WindowViewPort_Panner(Cvo_Object *, XEvent *, void *);

};

class Cvo_WindowViewPortPanner : public Cvo_Frame {
    Cvo_Window*		panner;
    Cvo_WindowViewPort	*vp;

    Cvo_Registration	*r1;
    Cvo_Registration	*r2;
    Cvo_Registration	*r3;

    XSegment		lines[4];
    Cvo_Color		lineColor;
    BOOL		follow:1;
    BOOL		holdstate : 1;
protected:
    BOOL		dirty:1;

private:
    short		prev_x_org;
    short		prev_y_org;
    short		prev_x_ext;
    short		prev_y_ext;

    int 		xoffset;
    int 		yoffset;

    void _Init(Cvo_WindowViewPort*);

protected:
    virtual void Load_Pixmap() { };
public:
    CONSTRUCDECL_1ARG(Cvo_WindowViewPortPanner, Cvo_WindowViewPort *)

    Cvo_Window* Panner()			{ return(panner); }
    Cvo_WindowViewPort* VPort()			{ return(vp); }

    void FollowPanner()				{ follow = 1; }
    void NoFollowPanner()			{ follow = 0; }
    void MakeDirty()				{ dirty = 1; }

    int StandardLayoutFunction(int, int, int, int);

    friend void Cvo_WindowViewPortPanner_Resize(Cvo_Object *, XEvent *, void*);
    friend void Cvo_WindowViewPortPanner_Move(Cvo_Object *, XEvent *, void*);
    friend void Cvo_WindowViewPort_Panner(Cvo_Object *, XEvent *, void*);
};

#define MAGN 100
#define	CvoWindowViewPortMoveEvent	(Cvo_WindowViewPortType+InternalEvent0)
#define CvoWindowViewPortPannerEvent	(Cvo_WindowViewPortType+InternalEvent1)

struct Cvo_WindowViewPortMoveEvent : Cvo_AnyEvent {
    int		old_x;		// Old coordinates of the window in the viewport
    int		old_y;
    int		new_x;		// New coordinates of the window in the viewport
    int		new_y;
};
#endif
