//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	$Id: Paint.h++,v 1.2 1994/08/10 18:11:11 prb Exp $
//
#if	!defined(_Cvo_Paint_)
#define	_Cvo_Paint_

#if	!defined(_Cvo_Window_)
#include <Cvo/Window.h++>
#endif
#if	!defined(_Cvo_Pixmap_)
#include <Cvo/Pixmap.h++>
#endif

class Cvo_Paint : public Cvo_Window {
protected:
    Cvo_Pixmap	*pixmap;		// Off screen pixmap
    Cvo_Pixmap	*altmap;		// Alternate pixmap for double buffer
private:
    int		xoffset;		// Offset of window into pixmap
    int		yoffset;		// Offset of window into pixmap
    BOOL	dirty:1;		// pixmap out of date with altmap
    BOOL	realdirty:1;		// window out of date with pixmap

    int		pwidth;			// Requested pixmap size
    int		pheight;		// Requested pixmap size

    void	_Init(int, int);
    void	_Init()	{ _Init(-1,-1); }
protected:
    void	Bind();
    CVO_DEFINE_REGISTER_FUNCTIONS(Cvo_Paint)
    void SetSize(CARD w, CARD h)	{ pwidth = int(w); pheight = int(h); }
public:
    CONSTRUCDECL_2ARG(Cvo_Paint, int, int)
    CONSTRUCDECL(Cvo_Paint)
    void	_Create();
    void ResetCanvas(int, int, BOOL = True);
    void DoResize(XEvent *, void *);
    void Exposure(XExposeEvent *);
    void Flush(int r = 0);
    void Erase();

    void ConvertCoord(int *x, int *y);

    void EraseArea(int x, int y, int w, int h);
    void SetWidth(int width);
    void Fill(const Cvo_Color &color);
    void FillArea(int x, int y, int w, int h, const Cvo_Color &color);
    void DrawRectangle(int x, int y, int w, int h, const Cvo_Color &color);
    void DrawLine(int x0, int y0, int x1, int y1, const Cvo_Color &color);
    void DrawArc(int x, int y, int w, int h, int a1, int a2, const Cvo_Color &color);
    void DrawShape(int x, int y, int shape, int size, const Cvo_Color &color);
    void DrawShape(int x, int y, int shape, const Cvo_Color &color)
	{ DrawShape(x, y, shape, 6, color); }

    void PanTo(int, int);
    int PWidth()			{ return(pwidth); }
    int PHeight()			{ return(pheight); }

    virtual void Move(XEvent *, int, char **);

    Cvo_Pixmap *GetPixmap()	{ return(altmap); }
    void MakeDirty()		{ dirty = 1; }

    // 
    // Below are helper functions to standard X Lib calls.
    //
    void DrawLine(int x1, int y1, int x2, int y2)
    { XDrawLine(Dpy(), altmap->Object(), gc, x1, y1, x2, y2);
		  dirty = 1;}
    void DrawPoint(int x, int y)
    { XDrawPoint(Dpy(), altmap->Object(), gc, x, y);
	  dirty = 1;}
    void DrawArc(int x, int y, int w, int h, int ang1, int ang2)
    { XDrawArc(Dpy(), altmap->Object(), gc, x, y, w, h, ang1, ang2);
	  dirty = 1;}
    void DrawRectangle(int x, int y, int w, int h)
    { XDrawRectangle(Dpy(), altmap->Object(), gc, x, y, w, h);
	  dirty = 1;}
    void DrawRectangle(const XRectangle &r)
    { DrawRectangle(r.x, r.y, r.width, r.height); }
    void FillArc(int x, int y, int w, int h, int ang1, int ang2)
    { XFillArc(Dpy(), altmap->Object(), gc, x, y, w, h, ang1, ang2);
	  dirty = 1;}
    void FillRectangle(int x, int y, int w, int h)
    { XFillRectangle(Dpy(), altmap->Object(), gc, x, y, w, h);
	  dirty = 1;}
    void FillRectangle(const XRectangle &r)
    { FillRectangle(r.x, r.y, r.width, r.height); }
    void ClearArea(int x, int y, int w, int h, Bool exp = False)
    { XClearArea(Dpy(), altmap->Object(), x, y, w, h, exp);
	  dirty = 1;}
    void ClearArea(const XRectangle &r, Bool exp = False)
    { ClearArea(r.x, r.y, r.width, r.height, exp); }
    void CopyArea(int x, int y, int w, int h, int dx, int dy)
    { XCopyArea(Dpy(), altmap->Object(), altmap->Object(), gc, x, y, w, h, dx, dy);
	  dirty = 1;}
    void PutImage(XImage *im, int x, int y, int dx, int dy, int w, int h)
    { XPutImage(Dpy(), altmap->Object(), gc, im, x, y, dx, dy, w, h);
	  dirty = 1;}
    void PutImage(XImage *im, int dx, int dy, int w, int h)
    { XPutImage(Dpy(), altmap->Object(), gc, im, 0, 0, dx, dy, w, h);
	  dirty = 1;}
};

#define	CVOP_POINT_SHAPE	0x0000
#define	CVOP_BOX_SHAPE		0x0001
#define	CVOP_CIRCLE_SHAPE	0x0002
#define	CVOP_X_SHAPE		0x0003
#define	CVOP_SQUARE_SHAPE	0x0004
#define	CVOP_DISC_SHAPE		0x0005
#define	CVOP_LAST_SHAPE		CVOP_DISC_SHAPE

#define CvoPaintChangedSizeEvent          (Cvo_PaintEventType + InternalEvent0)

struct Cvo_PaintChangedSizeEvent : Cvo_AnyEvent {
        int             width; 
        int             height;
        int             pwidth; 
        int             pheight;
        int             old_pwidth; 
        int             old_pheight;
};

#endif
