//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	$Id: Menu.h++,v 1.5 1994/08/10 18:11:11 prb Exp $
//
#if	!defined(_Cvo_Menu_)
#define	_Cvo_Menu_

#if	!defined(_Cvo_Window_)
#include <Cvo/Window.h++>
#endif
#include <Cvo/MenuSession.h++>

class Cvo_Menu;
class Cvo_MenuFilter;
struct Cvo_MenuItem;

typedef void (*Cvo_MenuFunc)(Cvo_Object *, XEvent *, void *);

class Cvo_MenuEntry {
public:
    Cvo_MenuEntry	*next;			// Next item in menu
    Cvo_MenuEntry	*prev;			// Previous item in menu

    Cvo_Menu		*menu;			// Menu which owns this item
    Cvo_Window		*label;			// Button or label or ...
    void		*data;			// Client data
    int			flags;			// Flags associated with item
    Cvo_MenuFunc	func;			// Users function
    Cvo_Menu		*cascade;		// Menu to cascade to
private:
    Cvo_MenuFunc	ifunc;			// Internal function to call

private:
    void _Init(Cvo_Menu *, Cvo_Window *, Cvo_MenuEntry *, 
	       Cvo_MenuFunc, void *, int);
public:
    Cvo_MenuEntry(Cvo_Menu *, Cvo_Window *,
		     Cvo_MenuFunc = 0, void * = 0, int = 0);
    Cvo_MenuEntry(Cvo_Menu *, Cvo_Window *, Cvo_MenuEntry *,
		     Cvo_MenuFunc = 0, void * = 0, int = 0);
    Cvo_MenuEntry(Cvo_Menu *, Cvo_Window *,
		     Cvo_MenuFunc, int);
    Cvo_MenuEntry(Cvo_Menu *, Cvo_Window *, Cvo_MenuEntry *,
		     Cvo_MenuFunc, int);
    Cvo_MenuEntry(Cvo_Menu *, Cvo_Window *, int);
    Cvo_MenuEntry(Cvo_Menu *, Cvo_Window *, Cvo_MenuEntry *, int);
    Cvo_MenuEntry(Cvo_Menu *, Cvo_MenuItem *, Cvo_MenuEntry * = 0);

    Cvo_MenuSessionFilterResponse Select();
    Cvo_MenuSessionFilterResponse Cascade();
    void Call();

    ~Cvo_MenuEntry();

    //
    // This routine should only be called internally by Cvo.
    //
    void SetInternalFunc(Cvo_MenuFunc f)	{ ifunc = f; }
};

struct Cvo_MenuItem {
    char		*resource;	// Resource name of menu item;
    Cvo_MenuFunc	func;		// Function to call on selection
    void		*data;		// Client data
    int			flags;		// How to create the item
    Cvo_MenuEntry	*entry;		// Last entry assigned to this item
};

typedef Cvo_MenuItem Cvo_MenuItem;

class Cvo_Menu : public Cvo_Window {
    friend Cvo_MenuEntry;
    friend Cvo_MenuFilter;
    Cvo_MenuEntry	*items;
    Cvo_MenuEntry	*current;		// Current item highlighted
    Cvo_Menu 		*cascadefrom;		// Where we cascaded from
    Cvo_Menu 		*cascade;		// Current cascade up for us
    Cvo_MenuFilter	*filter;		// Our filter
    Cvo_Window		*owner;			// Window which owns us
    Cvo_Cursor		curs;			// Cursor to use while up
    void _Init();
    void _Init(Cvo_MenuItem *);
protected:
    CVO_DEFINE_REGISTER_FUNCTIONS(Cvo_Menu)
    void InsertItem(Cvo_Window *, int);
    void MapEvent(XEvent *, void *);
    void UnmapEvent(XEvent *, void *);
public:
    CONSTRUCDECL(Cvo_Menu)
    CONSTRUCDECL_1ARG(Cvo_Menu, Cvo_MenuItem *)
    Cvo_Menu(char *, Cvo_MenuItem * = 0);
    Cvo_MenuEntry *MenuEntries();
    Cvo_MenuEntry *&Current();
    void Start(int);
    void Start(int, int, int);
    void Start(int, Cvo_Object *);
    void StartCascade(int, Cvo_Object *);
    Cvo_Window	*Owner()			{ return(owner); }
    void Owner(Cvo_Window *o)			{ owner = o; }

    static void enter(Cvo_Object *, XEvent *, void *);
    static void leave(Cvo_Object *, XEvent *, void *);
};

class Cvo_MenuFilter : public Cvo_MenuSessionFilter {
protected:
    Cvo_Menu                 *menu;
    Cvo_MenuEntry		*entry;
    Cvo_MenuSessionFilterResponse Select(Cvo_MenuEntry *);
public:
    Cvo_MenuFilter(Cvo_Menu *);
    ~Cvo_MenuFilter();
    Cvo_MenuSessionFilterResponse Filter(Cvo_Object *, XEvent *);
    Cvo_MenuEntry *Entry();
};

#define CvoM_SEPARATOR          0x0001  // Place separator above this item
#define CvoM_CASCADE            0x0002  // This is a cascading item
#define CvoM_ALWAYSFLAT         0x0004  // This button is always flat
#define CvoM_TOGGLE             0x0008  // This is a toggle item
#define CvoM_APPEND             0x0010  // Append to the end of the menu
#define CvoM_UPDATE_TOGGLE      0x0020  // data is a BOOL * and updated
#define	CvoM_MENU_LABEL		0x1000	// This is a menu label

#define	CvoM_File	"file"
#define	CvoM_Quit	"quit"
#define	CvoM_New	"new"
#define	CvoM_Save	"save"
#define CvoM_SaveAs     "saveas"
#define	CvoM_Open	"open"
#define	CvoM_Close	"close"
#define	CvoM_About	"about"
#define	CvoM_Version	"version"
#define	CvoM_Help	"help"
#define	CvoM_Dismiss	"dismiss"

#define	 CvoNewMenuItemEvent		(Cvo_MenuEventType + InternalEvent0)
#define	 CvoDelMenuItemEvent		(Cvo_MenuEventType + InternalEvent1)
#define	 CvoMenuEvent			(Cvo_MenuEventType + InternalEvent2)
#define	 CvoMenuCascadeEvent		(Cvo_MenuEventType + InternalEvent3)
#define	 CvoMenuDoCascadeEvent		(Cvo_MenuEventType + InternalEvent4)

struct Cvo_NewMenuItemEvent : Cvo_AnyEvent {
    Cvo_MenuEntry	*item;
};

struct Cvo_MenuEvent : Cvo_AnyEvent {
    Cvo_Menu		*menu;
    Cvo_MenuEntry	*item;
};

typedef Cvo_NewMenuItemEvent Cvo_DelMenuItemEvent;

inline Cvo_MenuEntry *
Cvo_Menu::MenuEntries()
{
    return(items);
}

inline Cvo_MenuEntry *&
Cvo_Menu::Current()
{
    return(current);
}

inline
Cvo_MenuEntry::Cvo_MenuEntry(Cvo_Menu *m, Cvo_Window *w,
				  Cvo_MenuFunc f, void *d, int F)
{
    _Init(m, w, 0, f, d, F);
}

inline
Cvo_MenuEntry::Cvo_MenuEntry(Cvo_Menu *m, Cvo_Window *w,
				   Cvo_MenuEntry *p, Cvo_MenuFunc f,
				   void *d, int F)
{
    _Init(m, w, p, f, d, F);
}

inline
Cvo_MenuEntry::Cvo_MenuEntry(Cvo_Menu *m, Cvo_Window *w,
		     		   Cvo_MenuFunc f, int F)
{
    _Init(m, w, 0, f, 0, F);
}

inline
Cvo_MenuEntry::Cvo_MenuEntry(Cvo_Menu *m, Cvo_Window *w,
				   Cvo_MenuEntry *p, Cvo_MenuFunc f,
				   int F)
{
    _Init(m, w, p, f, 0, F);
}

inline
Cvo_MenuEntry::Cvo_MenuEntry(Cvo_Menu *m, Cvo_Window *w, int F)
{
    _Init(m, w, 0, 0, 0, F);
}

inline
Cvo_MenuEntry::Cvo_MenuEntry(Cvo_Menu *m, Cvo_Window *w,
				   Cvo_MenuEntry *p, int F)
{
    _Init(m, w, p, 0, 0, F);
}
#endif
