//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	$Id: Color.h++,v 1.2 1994/08/10 18:11:11 prb Exp $
//
#if	!defined(_Cvo_Color_)
#define	_Cvo_Color_

class Cvo_Window;

#define	CvoC_BACKGROUND	1		// Dummy arg for background creates
#define	_U1	((CARD32)-1)

struct _Cvo_MonoColorDatabase {
    char        *name;
    CARD8	red;
    CARD8	green;
    CARD8	blue;
    CARD8       level;
    CARD8       upper;
    CARD8       lower;
    CARD8       select;
};

_Cvo_MonoColorDatabase *_Cvo_FindMonoColor(char *, int = CvoC_BACKGROUND);
_Cvo_MonoColorDatabase *_Cvo_FindMonoColor(int);

class _Cvo_Color;

class Cvo_Color {
    friend _Cvo_Color;
    _Cvo_Color  *color;
    inline Cvo_Color(_Cvo_Color *rc)	{ color = rc; }
public:
    Cvo_Color(Cvo_BasicObject *, XColor &, int = 0);
    Cvo_Color(Cvo_BasicObject *, int, int = 0, _Cvo_MonoColorDatabase * = 0);
    Cvo_Color(Cvo_BasicObject *, char *, int = 0);
    Cvo_Color(Cvo_BasicObject *, double h, double l, double s, int = 0);

    inline Cvo_Color()			{ color = 0; }
    inline Cvo_Color(const Cvo_Color &);
    inline Cvo_Color &operator=(const Cvo_Color &);
    inline ~Cvo_Color();

    _Cvo_Color *operator->() const      { return(color); }

    BOOL Empty() const			{ return(color ? False : True); }
    BOOL Full()	const			{ return(color ? True : False); }
    int operator ==(const Cvo_Color &cc) const
					{ return(cc.color == color); }
    int operator !=(const Cvo_Color &cc) const
					{ return(cc.color != color); }
};

class _Cvo_Color {
    friend Cvo_Color;
    static _Cvo_Color	*freelist;	// Root of all free colors
    _Cvo_Color		*next;		// Next color in list
    XrmQuark		name;		// Name of color
    XColor		color;		// RGB value of color
    Cvo_BasicObject	*window;	// A window this color was created on
    CARD32   		pixel;		// The actual pixel
    Pixmap  		pixmap;		// A potential pixmap
    Pixmap   		pixmap1;	// A potential pixmap
    Cvo_Color		upper;		// Upper chamfer color
    Cvo_Color		lower;		// Lower chamfer color
    Cvo_Color		select;		// Select color
    Cvo_Color		raised;		// Raised color
    CARD8	  	level;
    CARD32    		refcnt:16;	// number of windows using this guy
    BOOL      		usepixmap:1;
    BOOL	  	monochrome:1;

    Cvo_Color &MakeUpper();
    Cvo_Color &MakeLower();
    Cvo_Color &MakeSelect();
    Cvo_Color &MakeRaised();

    _Cvo_Color(_Cvo_Color *&);
    ~_Cvo_Color();
    _Cvo_Color *Copy()			{ ++refcnt; return(this); }
    void Release()			{ if (--refcnt <= 0) delete this; }
public:
    CARD32 Pixel() const		{ return(pixel); }
    BOOL UsePixmap() const		{ return(usepixmap); }
    BOOL Monochrome() const		{ return(monochrome); }
    Pixmap GetPixmap(int i = 0) const	{ return(i ? pixmap1 : pixmap); }
    XColor xcolor() const		{ return(color); }
    //
    // On monochrome systems, only Pixel() is meaningful.  The functions
    // below should only be called on color systems.
    //
    Cvo_Color &Grayed()	{ return(upper.Full()  ? upper  : MakeUpper()); }
    Cvo_Color &Upper()	{ return(upper.Full()  ? upper  : MakeUpper()); }
    Cvo_Color &Lower()	{ return(lower.Full()  ? lower  : MakeLower()); }
    Cvo_Color &Select()	{ return(select.Full() ? select : MakeSelect()); }
    Cvo_Color &Raised()	{ return(raised.Full() ? raised : MakeRaised()); }

    double Hue() const;
    double Lightness() const;
    double Saturation() const;

    inline int Level();
};

//
// Inlines for Cvo_Color
//
inline
Cvo_Color::Cvo_Color(const Cvo_Color &cc)
{
    if (cc.color)
	color = cc->Copy();
    else
	color = 0;
}

inline Cvo_Color &
Cvo_Color::operator=(const Cvo_Color &cc)
{
    if (color != cc.color) {
	if (color)
	    color->Release();
	if (cc.color)
	    color = cc->Copy();
	else
	    color = 0;
    }
    return(*this);
}
inline
Cvo_Color::~Cvo_Color()	
{
    if (color)
	color->Release();
}

inline int
_Cvo_Color::Level()
{
    return(monochrome ? (level % 17) : int(Lightness() * 17));
}

//
// The following Cvo_LoadColor functions are for backwards compatibility
//
inline Cvo_Color &
Cvo_LoadColor(Cvo_BasicObject *obj, XColor &xc, int bg)
{
    return(*new Cvo_Color(obj, xc, bg));
}

inline Cvo_Color &
Cvo_LoadColor(Cvo_BasicObject *obj, int x, int bg, _Cvo_MonoColorDatabase *db)
{
    return(*new Cvo_Color(obj, x, bg, db));
}

inline Cvo_Color &
Cvo_LoadColor(Cvo_BasicObject *obj, char *name, int bg)
{
    return(*new Cvo_Color(obj, name, bg));
}

inline Cvo_Color &
Cvo_LoadColor(Cvo_BasicObject *obj, double hue, double lit, double sat, int bg)
{
    return(*new Cvo_Color(obj, hue, lit, sat, bg));
}
#undef	_U1
#endif
