/*
 * Copyright 1999 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.tree.*;
import javax.swing.undo.*;
import java.awt.*;
import java.awt.event.*;

import java.beans.*;
import java.io.*;
import java.net.URL;
import java.util.*;

class PropsDialog extends JDialog {
    JTextField textfields[];
    JSlider slider;
    JLabel slider_label;
    Checktool ct;
    final String name="props_";
    
    String lists[]={
        "date",
        "name",
        "-",
        "hostname",
        "arch",
        "framebuffer",
        "keyboard",
        "-",
        "os",
        "openwindows_cde",
        "jfp",
        "-",
        "JDK_VERSION",
        "SHEET_CODE",
        "SHEET_VER",
        "-",
        "total",
        "pass",
        "fail"
    };
    
    public PropsDialog(Frame frame, Checktool ct) {
        super(frame);
        this.ct=ct;
        setTitle(ct.tool_title + " : " + ct.getString(name+"title"));
        JButton closeButton;
        JPanel buttonPanel = new JPanel(new FlowLayout(FlowLayout.RIGHT));
        
        closeButton = new JButton(ct.getString(name+"close_btn"));
        buttonPanel.add(closeButton);
        closeButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                setVisible(false);
            }
        });
        
        textfields = new JTextField[lists.length];
        
        PropertyPanel itemPanel=new PropertyPanel();
        for (int i=0;i<lists.length;i++) {
            if (lists[i].equals("-")) {
                itemPanel.addHeader(new JLabel(" "));
                itemPanel.addAnchor(new JLabel(" "));
            } else {
                itemPanel.addHeader(new JLabel(ct.getString(name+lists[i])+":",JLabel.RIGHT));
                itemPanel.addAnchor(textfields[i]=new JTextField(30));
            }
        }
        
        itemPanel.addHeader(new JLabel(ct.getString(name+"sqa_coverage"),JLabel.RIGHT));
        JPanel ppp=new JPanel(new BorderLayout());
        ppp.add("Center", slider=new JSlider(JSlider.HORIZONTAL, 0, 100, 0));
        ppp.add("West", slider_label=new JLabel("100%"));
        itemPanel.addAnchor(ppp);
        
        slider.setPaintTicks(true);
        slider.setMajorTickSpacing(20);
        slider.setMinorTickSpacing(5);
        slider.setEnabled(false);
        
        JPanel panel=new JPanel() {
            public Insets getInsets() {
                return new Insets(10,10,10,10);
            }
        };
        
        panel.setLayout(new BorderLayout());
        panel.add(BorderLayout.CENTER, itemPanel);
        panel.add(BorderLayout.SOUTH, buttonPanel);
        
        getContentPane().setLayout(new BorderLayout());
        getContentPane().add(BorderLayout.CENTER, panel);
        pack();
        
        Shared.setWindowPosition(frame, this, Shared.POSITION_SIDE);
    }
    
    public String getResults() {
        String r="";
        int max_len=0;
        for (int i=0;i<lists.length;i++) {
            if (lists[i].equals("-")==false) {
                if (max_len<ct.getString(name+lists[i]).getBytes().length) {
                    max_len=ct.getString(name+lists[i]).getBytes().length;
                }
            }
        }
        if (max_len<ct.getString(name+"sqa_coverage").getBytes().length) {
            max_len=ct.getString(name+"sqa_coverage").getBytes().length;
        }
        
        max_len+=1;
        
        //System.out.println("max_len=" + max_len);
        
        setResults();
        
        for (int i=0;i<lists.length;i++) {
            if (lists[i].equals("-")) {
                r +="\n";
            } else {
                String s=ct.getString(name+lists[i]) + ":";
                //System.out.println("s=" + s);
                for (int j=s.getBytes().length;j<=max_len;j++) {
                    s+=" ";
                }
                //System.out.println("s=[" + s + "]");
                r += (s + textfields[i].getText() + "\n");
            }
        }
        String s=ct.getString(name+"sqa_coverage") + ":";
        for (int j=s.getBytes().length;j<=max_len;j++) {
            s+=" ";
        }
        r += (s + slider_label.getText() + "\n");
        return r;
    }
    
    public void setInitResults() {
        if (ct.sheet_code!=null) {
            setValue("SHEET_CODE", ct.sheet_code);
        }
        if (ct.sheet_ver!=null) {
            setValue("SHEET_VER", ct.sheet_ver);
        }
        setValue("JDK_VERSION", Shared.getJvmVer());
        setValue("os", Shared.getOsName());
        setValue("arch", Shared.getOsArch());
        setValue("name", Shared.getUserName());
        setValue("date", new Date().toString());
        setValue("hostname", Shared.getHostName());
    }
    
    private void setResults() {
        if (ct.calcResult()==true) {
            int total=ct.passed+ct.failed+ct.nocheck;
            setValue("total", new Integer(total).toString());
            setValue("pass", new Integer(ct.passed).toString());
            setValue("fail", new Integer(ct.failed).toString());
            int cov=(ct.passed+ct.failed)*100/total;
            slider.setValue(cov);
            slider_label.setText(new Integer(cov).toString() + "%");
        }
    }
    
    public void setVisible() {
        setResults();
        setVisible(true);
    }
    
    public void setValue(String key, String value) {
        if (key == null || value == null) {
            return;
        }
        for (int i=0;i<lists.length;i++) {
            if (lists[i].equals(key)) {
                textfields[i].setText(value);
            }
        }
    }
}
