/*
 * Copyright 1999 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.tree.*;
import javax.swing.undo.*;
import java.awt.*;
import java.awt.event.*;

import java.beans.*;
import java.io.*;
import java.net.URL;
import java.util.*;

class MailDialog extends JDialog {
    JTextField to, subject, cc;
    JTextArea textarea;
    Frame frame;
    Checktool ct;
    final String name="mail_";
    
    public MailDialog(Frame frame, Checktool ct) {
        super(frame);
        this.frame=frame;
        this.ct=ct;
        
        setTitle(ct.tool_title + " : " + ct.getString(name+"title"));
        
        JPanel panel = new JPanel() {
            public Insets getInsets() {
                return new Insets(10,10,10,10);
            }
        };
        
        JPanel headerPanel = new JPanel(new BorderLayout());
        
        JButton closeButton, sendButton, clearButton;
        
        JPanel buttonPanel = new JPanel(new BorderLayout());
        
        JPanel buttonPanel1 = new JPanel(new FlowLayout(FlowLayout.LEFT));
        
        sendButton = new JButton(ct.getString(name+"send_btn"));
        sendButton.setToolTipText(ct.getString(name+"send_btn_tip"));
        clearButton = new JButton(ct.getString(name+"clear_btn"));
        clearButton.setToolTipText(ct.getString(name+"clear_btn_tip"));
        closeButton = new JButton(ct.getString(name+"cancel_btn"));
        closeButton.setToolTipText(ct.getString(name+"cancel_btn_tip"));
        
        buttonPanel1.add(sendButton);
        buttonPanel1.add(clearButton);
        
        JPanel buttonPanel2 = new JPanel(new FlowLayout(FlowLayout.RIGHT));
        buttonPanel2.add(closeButton);
        
        buttonPanel.add(BorderLayout.WEST, buttonPanel1);
        buttonPanel.add(BorderLayout.EAST, buttonPanel2);
        
        sendButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                send();
            }
        });
        closeButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                setVisible(false);
            }
        });
        clearButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                clear();
            }
        });
        
        PropertyPanel itemPanel=new PropertyPanel();
        itemPanel.addHeader(new JLabel("To:",JLabel.RIGHT));
        itemPanel.addAnchor(to=new JTextField(50));
        itemPanel.addHeader(new JLabel("Subject:",JLabel.RIGHT));
        itemPanel.addAnchor(subject=new JTextField(50));
        itemPanel.addHeader(new JLabel("Cc:",JLabel.RIGHT));
        itemPanel.addAnchor(cc=new JTextField(50));
        
        headerPanel.add(BorderLayout.NORTH, buttonPanel);
        headerPanel.add(BorderLayout.SOUTH, itemPanel);
        
        panel.setLayout(new BorderLayout());
        panel.add("North", headerPanel);
        
        textarea=new JTextArea();
        JScrollPane scrollPane = new JScrollPane(textarea);
        
        panel.add("Center", scrollPane);
        
        getContentPane().add(BorderLayout.CENTER, panel);
        textarea.setFont(Shared.getInputFont());
        setSize(600, 400);
        
        Shared.setWindowPosition(frame, this, Shared.POSITION_SIDE);
    }
    
    public void setAll(String t, String s, String c, String b) {
        setTo(t);
        setSubject(s);
        setCc(c);
        setBody(b);
    }
    
    public void setTo(String s) {
	to.setText(s);
	}
    public void setSubject(String s) {
	subject.setText(s);
	}
    public void setCc(String s) {
	cc.setText(s);
	}
    public void setBody(String s) {
	textarea.setText(s);
	}
    
    public void clear() {
        Object[]      message = new Object[1];
        message[0] = ct.getString(name+"clear_message");
        if (ct.showYesNoDialog(this,
            ct.getString(name+"clear_title"),
        message)==false) {
            return;
        }
        setAll("","","","");
    }
    
    public void send() {
        String to_=to.getText().trim();
        String subject_=subject.getText().trim();
        String cc_=cc.getText().trim();
        String body_=textarea.getText();
        
        
        if (to_==null || to_.equals("")) {
            Object[]      message = new Object[1];
            message[0] = ct.getString(name+"fillto_message");
            ct.showConfirmDialog(this,
                ct.getString(name+"fillto_title"),
            message);
            return;
        }
        
        Object[]      message = new Object[1];
        message[0] = ct.getString(name+"send_message");
        if (ct.showYesNoDialog(this,
            ct.getString(name+"send_title"),
        message)==false) {
            return;
        }
        
        String from=ct.getSmtpAddr();
        if (from == null || from.length() < 1) {
            return;
        }
        
        ct.setBusy(true);
        
        if (ct.debug) {
            System.out.println(from);
            System.out.println(to_);
            System.out.println(cc_);
            System.out.println(subject_);
            System.out.println(body_);
        }
        //String res=Shared.sendMail(from, to_, cc_, subject_, body_);
        
        String charset=ct.getString("mail_charset");
        if (charset.equals("mail_charset")) {
            charset=null;
        }

        //boolean res=Shared.sendMail(from,
        boolean res=JavaMailSender.SendMail(from,
            to_,
            cc_,
            subject_,
            body_,
            ct.getSmtpHost(),
            charset
        );

        ct.setBusy(false);

        if (res == false){
            ct.errorDisplay(ct.getString(name+"send_error_message"));
        } else {
            setVisible(false);
        }
    }
    
    public void setVisible() {
        if (ct.sheet_code!=null && ct.sheet_ver!=null) {
            setSubject(ct.sheet_code + " " + ct.sheet_ver);
        } else {
            setSubject("");
        }
        setTo(System.getProperty("user.name"));
        setCc("");
        setBody(ct.getResult());
        setVisible(true);
    }
}
