/*
 * Copyright 1999 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */
import java.util.*;
import java.io.*;
import javax.mail.*;
import javax.mail.internet.*;
import javax.activation.*;

abstract class JavaMailSender {
    public static boolean SendMail(String from,
        String to,
        String cc,
        String subject,
        String body,
        String host,
        String charset) {
        boolean debug = false;
        String subject2 = subject;
        
        try {
        //create some properties and get the default Session
        Properties props = new Properties();
        props.put("mail.smtp.host", host);
        if (debug) {
            props.put("mail.debug", "false");
        }
        
        if (to.length() < 1) {
            return false;
        }
        
        //Session session = Session.getDefaultInstance(props, null);
        Session session = Session.getInstance(props, null);
        //session.setDebug(debug);
        
            //create a message
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom(new InternetAddress(from));
            InternetAddress[] address = {
                new InternetAddress(to)
            };
            msg.setRecipients(Message.RecipientType.TO, address);
            
            if (cc.length() > 1) {
                InternetAddress[] address_cc = {
                    new InternetAddress(cc)
                };
                msg.setRecipients(Message.RecipientType.CC, address_cc);
            }
            if (subject.length() > 1) {
                if (charset != null) {
                    try {
                        subject2 = MimeUtility.encodeText(subject, charset, null);
                        msg.setSubject(subject2);
                    } catch(Exception ex) {
                        return false;
                    }
                } else {
                    msg.setSubject(subject);
                }
            }
            msg.setSentDate(new Date());
            if (body == null || body.length() < 2) {
                body = " ";
            }
            if (charset != null) {
                msg.setText(body, charset);
            } else {
                msg.setText(body);
            }
            
/*
            System.out.println("from:" + from);
            System.out.println("to:" + to);
            System.out.println("cc:" + cc);
            System.out.println("subject:" + subject2);
            System.out.println("body:" + body);
            System.out.println("host:" + host);
            System.out.println("charset:" + charset);
*/

            Transport.send(msg);
            
            return true;
        } catch(Exception mex) {
		return false;
	}
/*
        } catch(MessagingException mex) {
            if (debug) {
                System.out.println("\n--Exception handling in msgsendsample.java");
                mex.printStackTrace();
                System.out.println();
            }
            Exception ex = mex;
            do {
                if (ex instanceof SendFailedException) {
                    SendFailedException sfex = (SendFailedException) ex;
                    Address[] invalid = sfex.getInvalidAddresses();
                    if (invalid != null) {
                        if (debug) {
                            System.out.println("    ** Invalid Addresses");
                            if (invalid != null) {
                                for (int i = 0; i < invalid.length; i++)
                                System.out.println("         " + invalid[i]);
                            }
                        }
                    }
                    Address[] validUnsent = sfex.getValidUnsentAddresses();
                    if (validUnsent != null) {
                        if (debug) {
                            System.out.println("    ** ValidUnsent Addresses");
                            if (validUnsent != null) {
                                for (int i = 0; i < validUnsent.length; i++)
                                System.out.println("         " + validUnsent[i]);
                            }
                        }
                    }
                    Address[] validSent = sfex.getValidSentAddresses();
                    if (validSent != null) {
                        if (debug) {
                            System.out.println("    ** ValidSent Addresses");
                            if (validSent != null) {
                                for (int i = 0; i < validSent.length; i++)
                                System.out.println("         " + validSent[i]);
                            }
                        }
                    }
                }
                if (debug) {
                    System.out.println();
                }
            } while ((ex = ((MessagingException) ex).getNextException())
            != null);
            return false;
	}
*/
    }
}
