/*
 * Copyright 1999 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.tree.*;
import javax.swing.undo.*;
import java.awt.*;
import java.awt.event.*;

import java.awt.*;
import java.net.URL;
import java.net.MalformedURLException;
import java.io.*;

public class HtmlPanel extends JPanel implements HyperlinkListener {
    JEditorPane html;

    public void setPage(URL url){
	try {
		html.setPage(url);
	} catch (Exception ex){
	}
    }
    
    public HtmlPanel(URL url) {
        // setBackground(Color.white);
        //setBorder(Shared.emptyBorder10);
        setLayout(new BorderLayout());
        try {
/*
            File a=new File(url_text);
            if (a.exists()==false) {
                System.out.println("does not find " + a.getAbsolutePath());
            }
            URL url = new URL("file:" + a.getAbsolutePath());
*/
            html = new JEditorPane(url);
            html.setEditable(false);
            html.addHyperlinkListener(this);
            JScrollPane scroller = new JScrollPane();
            scroller.setBorder(Shared.loweredBorder);
            JViewport vp = scroller.getViewport();
            vp.add(html);
            vp.setBackingStoreEnabled(true);
            add(scroller, BorderLayout.CENTER);
        } catch (MalformedURLException e) {
            System.out.println("Malformed URL: " + e);
        } catch (IOException e) {
            System.out.println("IOException: " + e);
        }
        
    }
    
    /**
    * Notification of a change relative to a
    * hyperlink.
    */
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            linkActivated(e.getURL());
        }
    }
    
    protected void linkActivated(URL u) {
        Cursor c = html.getCursor();
        Cursor waitCursor = Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR);
        html.setCursor(waitCursor);
        SwingUtilities.invokeLater(new PageLoader(u, c));
    }
    
    /**
    * temporary class that loads synchronously (although
    * later than the request so that a cursor change
    * can be done).
    */
    class PageLoader implements Runnable {
        
        PageLoader(URL u, Cursor c) {
            url = u;
            cursor = c;
        }
        
        public void run() {
            if (url == null) {
                // restore the original cursor
                html.setCursor(cursor);
                
                // PENDING(prinz) remove this hack when
                // automatic validation is activated.
                Container parent = html.getParent();
                parent.repaint();
            } else {
                Document doc = html.getDocument();
                try {
                    html.setPage(url);
                } catch (IOException ioe) {
                    html.setDocument(doc);
                    getToolkit().beep();
                } finally {
                    // schedule the cursor to revert after
                    // the paint has happended.
                    url = null;
                    SwingUtilities.invokeLater(this);
                }
            }
        }
        URL url;
        Cursor cursor;
    }
}
