/*
 * Copyright 1999 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.tree.*;
import javax.swing.undo.*;
import java.awt.*;
import java.awt.event.*;

import java.beans.*;
import java.io.*;
import java.net.URL;
import java.util.*;

class ConsoleDialog extends JDialog {
    JTextArea textarea;
    JTextArea textarea2;
    final String name="consoledialog_";
    JLabel url_label;
    JButton closeButton;
    JButton clearButton;
    public ConsoleDialog(Frame frame) {
        super(frame);
        
        JTabbedPane tf = new JTabbedPane();
        
        textarea=new JTextArea();
        textarea.setEditable(false);
        
        JPanel buttonPanel = new JPanel(new BorderLayout());
        JPanel buttonPanel1 = new JPanel(new FlowLayout(FlowLayout.RIGHT));
        
        closeButton = new JButton("close");
        clearButton = new JButton("clear");
        buttonPanel1.add(clearButton);
        clearButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                textarea.setText("");
            }
        });
        buttonPanel1.add(closeButton);
        closeButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                setVisible(false);
            }
        });
        
        JScrollPane scrollPane = new JScrollPane(textarea);
        
        JPanel panel = new JPanel() {
            public Insets getInsets() {
                return new Insets(10,10,10,10);
            }
        };
        
        panel.setLayout(new BorderLayout());
        panel.add(BorderLayout.CENTER, scrollPane);
        
        panel.add(BorderLayout.SOUTH, buttonPanel1);
        
        getContentPane().add(BorderLayout.CENTER, panel);
        
        textarea.setFont(Shared.getInputFont());
        setSize(600, 400);
        Shared.setWindowPosition(frame, this, Shared.POSITION_SIDE);
    }
    public void append(String c) {
        textarea.append(c);
    }
    public void append(char c) {
        char j[] = {c};
        String p=new String(j);
        textarea.append(p);
    }
    public void setCloseButton(String s) { closeButton.setLabel(s); }
    public void setClearButton(String s) { clearButton.setLabel(s); }
}
