/*
 * Copyright 1999 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.tree.*;
import javax.swing.undo.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.print.*;

import java.awt.*;
import java.awt.geom.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.net.URL;
import java.util.*;

class CheckList extends JPanel implements Printable {
    DefaultListModel model;
    JList list;
    JScrollBar scrollbar;
    Checktool ct_;
    int w, t;
    
    public CheckList(Checktool ct) {
        this.ct_=ct;
        
        setLayout(new BorderLayout());
        if (false) {
            model = new DefaultListModel();
            for (int i = 0; i < 5; i++) {
                model.addElement(new Integer(i));
            }
            list=new JList(model);
            list.setCellRenderer(new TestCellRenderer(list));
        } else {
            list=new JList();
        }
        list.setFont(Shared.getInputFont());
        
        FontMetrics fm = this.getFontMetrics(Shared.getInputFont());
        int ascent = fm.getAscent();
        int descent = fm.getDescent();
        Rectangle2D p=fm.getStringBounds(" katakai", this.getGraphics());
        w=fm.stringWidth("      ");
        t=fm.stringWidth("      PASS");
        
        JScrollPane scrollPane = new JScrollPane(list);
        scrollbar=scrollPane.getVerticalScrollBar();
        scrollPane.getViewport().setView(list);
        add(scrollPane,BorderLayout.CENTER);
        
        list.unregisterKeyboardAction(KeyStroke.getKeyStroke(KeyEvent.VK_UP, 0));
        list.unregisterKeyboardAction(KeyStroke.getKeyStroke(KeyEvent.VK_DOWN, 0));
        list.unregisterKeyboardAction(KeyStroke.getKeyStroke(KeyEvent.VK_LEFT, 0));
        list.unregisterKeyboardAction(KeyStroke.getKeyStroke(KeyEvent.VK_RIGHT, 0));
        
        /*
        KeyListener keyListener = new KeyAdapter() {
            public void keyReleased(KeyEvent e) {
                int k=e.getKeyCode();
                if (k==KeyEvent.VK_LEFT) {
                    ct_.passList();
                } else if (k==KeyEvent.VK_RIGHT) {
                    ct_.failList();
                } else if (k==KeyEvent.VK_DOWN) {
                    ct_.nextList();
                } else if (k==KeyEvent.VK_UP) {
                    ct_.prevList();
                }
            }
        };
        list.addKeyListener(keyListener);
        */
        
        MouseListener mouseListener = new MouseAdapter() {
            public void mouseClicked(MouseEvent e) {
                int index = list.locationToIndex(e.getPoint());
                if (index < 0) {
                    return;
                }
                int x=e.getX();
                if (x>w&&x<t) {
                    //if (x>45&&x<73) {
                    ct_.singleClicked(index);
                    ct_.toggleState();
                    //setStatus("clicked on Item " + index);
                    list.repaint();
                    return;
                }
                if (e.getClickCount() == 2) {
                    ct_.doubleClicked(index);
                    //setStatus("Double clicked on Item " + index);
                } else if (e.getClickCount() == 1) {
                    ct_.singleClicked(index);
                    //setStatus("clicked on Item " + index);
                }
            }
        };
        list.addMouseListener(mouseListener);
    }
    
    public void setData() {
        model = new DefaultListModel();
        for (int i = 0; i < ct_.cdatas.length; i++) {
            model.addElement(new Integer(i));
        }
        list.setModel(model);
        list.setCellRenderer(new TestCellRenderer(list));
        list.repaint();
        list.revalidate();
    }
    
    public int getSelectedIndex() {
        return list.getSelectedIndex();
    }
    
    public void prevPage() {
        int starti=list.getFirstVisibleIndex();
        if (starti==0) {
            return;
        }
        int endi=list.getLastVisibleIndex();
        int rows=endi-starti;
        int newi=starti-rows;
        if (newi<0) {
            newi=0;
        }
        list.ensureIndexIsVisible(newi);
    }
    
    public void nextPage() {
        int starti=list.getFirstVisibleIndex();
        int endi=list.getLastVisibleIndex();
        if (endi==ct_.cdatas.length-1) {
            return;
        }
        int rows=endi-starti;
        int newi=endi+rows;
        if (newi>ct_.cdatas.length-1) {
            newi=ct_.cdatas.length-1;
        }
        list.ensureIndexIsVisible(newi);
    }
    
    public void setSelectedIndex(int i) {
        int starti=list.getFirstVisibleIndex();
        int endi=list.getLastVisibleIndex();
        //int rows=list.getVisibleRowCount();
        int rows=endi-starti;
        
        list.setSelectedIndex(i);
        
        if (endi<i) {
            i+=(rows/2);
            /* workaround for JDK 1.2 */
            if (i > ct_.cdatas.length) {
                i=ct_.cdatas.length-1;
            }
            list.ensureIndexIsVisible(i);
        } else if (starti>i) {
            i-=(rows/2);
            if (i<0) {
                i=0;
            }
            list.ensureIndexIsVisible(i);
        }
    }
    
    public int locationToIndex(Point i) {
        return list.locationToIndex(i);
    }
    
    //class TestCellRenderer extends BasicListCellRenderer {
    //class TestCellRenderer extends JLabel implements ListCellRenderer {
    class TestCellRenderer extends DefaultListCellRenderer {
        
        TestCellRenderer(JList listBox) {
            super();
        }
        
        public Component getListCellRendererComponent(
		JList list,
		Object value,
		int modelIndex,
		boolean isSelected,
		boolean cellHasFocus)
            {
            int index = ((Integer)value).intValue();
            String text;
            
            if (isSelected) {
            }
            
            CData cdata=ct_.cdatas[index];
            
            String item=cdata.item;
            String cmt=cdata.comment;
            String help=cdata.help;

	    if(cdata.imageicon != null){
		setIcon(cdata.imageicon);
		return super.getListCellRendererComponent(list,
		    "", index, isSelected, cellHasFocus);
	    }

            if (cdata.item.trim().startsWith("IMG:")){
		StringTokenizer st = new StringTokenizer(cdata.item, ":");
                if(st.hasMoreTokens()) {
                   String imgfile=st.nextToken();
                   if(st.hasMoreTokens()) {
			imgfile=st.nextToken().trim();
			String curfile=ct_.currentFile.getAbsolutePath();
			String aimgfile=curfile.substring(0, curfile.lastIndexOf(File.separatorChar));
                	cdata.imageicon=new ImageIcon(aimgfile + "/" + imgfile, imgfile);
		   }
                }
		if(cdata.imageicon != null){
			setIcon(cdata.imageicon);
			return super.getListCellRendererComponent(list,
			    "", index, isSelected, cellHasFocus);
		}
	    }
            
            text = " ";
            
            if (help != null && help.equals("")==false) {
                text += "H";
            } else {
                text += " ";
            }
            
            if (cmt != null && cmt.equals("")==false) {
                text += "C";
            } else {
                text += " ";
            }
            
            text += " ";
            setIcon(null);
            
            if (cdata.state == CData.NONE) {
                text += "       ";
            } else if (cdata.state == CData.NOCHECK) {
                text += "  ---- ";
            } else if (cdata.state == CData.PASSED) {
                text += "  PASS ";
            } else if (cdata.state == CData.FAILED) {
                text += "  FAIL ";
            }
            text += item;
/*
            setFont(Shared.getInputFont());
*/
            if (item != null && item.length() > 1 && item.charAt(0)!=' ') {
                setFont(Shared.getBoldFont());
            } else {
                setFont(Shared.getInputFont());
            }
            /*
            setText(text);
            return this;
            */
            return super.getListCellRendererComponent(list,
                text, index, isSelected, cellHasFocus);
        }
    }
    
    
    public int print(Graphics g, PageFormat pf, int pi)
    throws PrinterException {
        
        if (pi >= 3) {
            return Printable.NO_SUCH_PAGE;
        }
        
        System.out.println(pf.toString());
        
        g.setColor(Color.black);
        
        int height=(int)pf.getImageableHeight();
        int width=(int)pf.getImageableWidth();
        int startx=(int)pf.getImageableX();
        int starty=(int)pf.getImageableY();
        
        int font_height=14;
        int line_height=16;
        int xmargin=10;
        int ymargin=10;
        
        g.setFont(new Font("DialogInput", Font.PLAIN, font_height));
        
        for (int i=0;;i++) {
            if (font_height*i>(height-ymargin)) {
                break;
            }
            g.drawString("ҳ" + " page " + pi + " line " + i,
                startx + xmargin,
                starty + ymargin + 16*i);
        }
        
        return Printable.PAGE_EXISTS;
    }
    
}
