/*
 * Copyright 1999 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.tree.*;
import javax.swing.undo.*;

import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.net.*;
import java.util.*;

class CalcSheet {
    static Checktool ct;
    static int tpass, tfail, tnocheck;
    public static void main(String[] args) {
        tpass=0;
        tfail=0;
        tnocheck=0;
        
        if (args.length<1) {
            System.err.println("Usage: calc_sheet [*.sqa *.rpt]");
            System.exit(1);
        }
        
        showHeader();
        ct=new Checktool();
        for (int i=0;i<args.length;i++) {
            File f=new File(args[i]);
            if (f.canRead() && ct.tryLoadFile(f)==true) {
                if (ct.calcResult()==true) {
                    if (ct.debug) {
                        System.out.println(ct.passed);
                        System.out.println(ct.failed);
                        System.out.println(ct.nocheck);
                    }
                    showResult(f);
                    tpass+=ct.passed;
                    tfail+=ct.failed;
                    tnocheck+=ct.nocheck;
                } else {
                    System.err.println(f.toString() + " can not be loaded correctly");
                }
            } else {
                System.err.println(f.toString() + " can not be loaded correctly");
            }
        }
        showTail();
        System.exit(0);
    }
    public static void showTail() {
        System.out.println(" ----- ---- ---- -------- ----------------------------");
        ct.passed=tpass;
        ct.failed=tfail;
        ct.nocheck=tnocheck;
        showResult(new File("TOTAL"));
    }
    public static void showHeader() {
        System.out.println(" Total Pass Fail Coverage FileName");
        System.out.println(" ----- ---- ---- -------- ----------------------------");
    }
    public static void showResult(File s) {
        String r=" ";
        
        String p=new Integer(ct.passed+ct.failed+ct.nocheck).toString();
        int l=5;
        for (int i=0;i<(l-p.length());i++) { r+=" "; }
        r+=p;
        r+=" ";
        
        p=new Integer(ct.passed).toString();
        l=4;
        for (int i=0;i<(l-p.length());i++) { r+=" "; }
        r+=p;
        r+=" ";
        
        p=new Integer(ct.failed).toString();
        l=4;
        for (int i=0;i<(l-p.length());i++) { r+=" "; }
        r+=p;
        r+=" ";
        
        p=new Integer((ct.passed+ct.failed)*100/(ct.passed+ct.failed+ct.nocheck)).toString();
        l=7;
        for (int i=0;i<(l-p.length());i++) { r+=" "; }
        r+=p;
        r+="% ";
        
        r+=s.toString();
        
        System.out.println(r);
    }
    
    /*
    Total Pass Fail Coverage FileName
    ----- ---- ---- -------- ----------------------------
    66    1    0       1% 1.sqa
    */
}
