/*
 * Copyright 1999 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.tree.*;
import javax.swing.undo.*;
import java.awt.*;
import java.awt.event.*;

import java.net.*;
import java.awt.*;
import java.applet.*;
import java.io.*;
import java.util.*;

public class CData {
    public String comment=null;	// comment
    public String help=null;	// exact item
    public String item=null;	// item - replace tab
    public String ritem=null;	// exact item
    
    public static final int	NONE=0;
    public static final int	NOCHECK=1;
    public static final int	PASSED=2;
    public static final int	FAILED=3;
    public static final int	CMD=4;
    public static final int	IMG=5;
    
    public static final String SHEET_CODE_STR="SHEET_CODE:";
    public static final String SHEET_VER_STR="SHEET_VER:";
    
    public static final String CHECK_START_STR="CHECK_START:";
    public static final String CHECK_END_STR="CHECK_END:";
    public static final String HELP_START_STR="HELP_START:";
    public static final String HELP_END_STR="HELP_END:";
    public static final String IMG_STR="IMG:";
    public static final String PASSED_STR1="[o]";
    public static final String PASSED_STR2="[O]";
    public static final String FAILED_STR1="[X]";
    public static final String FAILED_STR2="[x]";
    public static final String NOCHECK_STR1="[]";
    public static final String NOCHECK_STR2="[ ]";
    public static final String COMMENT_STR="#";
    public static final String HELP_STR="!";
    
    public int	state=NONE;
    public ImageIcon	imageicon=null;

    public Icon icon;
    
    public CData() {
    }
    public CData(String c) {
        setData(c);
    }
    public void setData(String line) {
        String linenew="";
        for (int i=0;i<line.length();i++) {
            if (line.charAt(i) == '\t') {
                linenew+="    ";
            } else {
                linenew+=line.charAt(i);
            }
        }
        ritem=line;
        if (line.endsWith(FAILED_STR1) || line.endsWith(FAILED_STR2)) {
            state=FAILED;
        } else if (line.endsWith(PASSED_STR1) || line.endsWith(PASSED_STR2)) {
            state=PASSED;
        } else if (line.endsWith(NOCHECK_STR1) || line.endsWith(NOCHECK_STR2)) {
            state=NOCHECK;
        }
        item=linenew;
        if (state!=NONE) {
            item=linenew.substring(0, linenew.lastIndexOf("["));
        }
    }
    public void appendComment(String line) {
        if (comment==null) {
            comment="";
        }
        comment += line;
    }
    public void setComment(String line) {
        comment = line;
    }
    
    public void appendHelp(String line) {
        if (help==null) {
            help="";
        }
        help += line;
    }
    public void setHelp(String line) {
        help = line;
    }
    public void markPass() {
        if (state == NONE) {
            return;
        }
        state = PASSED;
    }
    public void markFail() {
        if (state == NONE) {
            return;
        }
        state = FAILED;
    }
    public void markNocheck() {
        if (state == NONE) {
            return;
        }
        state = NOCHECK;
    }
    public void toggleState() {
        if (state == NONE) {
            return;
        }
        if (state==PASSED) {
            state=FAILED;
        } else if (state==FAILED) {
            state=NOCHECK;
        } else if (state==CData.NOCHECK) {
            state=PASSED;
        }
    }
}
