/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#ifndef UDENGINE_HH
#define UDENGINE_HH

#include "CodeTable.h"

/* input context arguments */

#define MAX_SESSION		512    
#define MAX_CANDIDATE		40
#define MAX_CHAR_PREEDIT	13
#define MAX_CHAR_COMMIT		25
#define IM_NAME_LEN		16

/* operation type */

#define CIM_INTERM          0
#define CIM_COMMIT          1
#define CIM_BOUNCEKEY       2
#define CIM_COMMITSYMBOL    6
#define CIM_STATUS          8

/* label type */

#define USE_HTT_LABEL	    0
#define NUMERIC_LABEL	    1
#define LOWER_LABEL	    2
#define UPPER_LABEL	    3

/* status value */

#define QUANJIAO_ON     0
#define QUANJIAO_OFF    1

#define QUANJIAO_STR    "/ȫ\0"
#define BANJIAO_STR     "/\0"

#define LOOKUP_CHOICE   0
#define PRE_EDIT        1

#define PAGEUP          0
#define PAGEDOWN        1

/* aux value id */

#define PUNCTUATION_STATUS    1
#define SOFTKEYBOARD_LAYOUT   2
#define GBKSWITCH_STATUS      3
#define IM_STATUS	      1

/* data struct to transfer to sunim */

typedef struct _im_data {
    int      operation;            /* operation type */
    unsigned char pre_str[256];    /* the preedit string */
    int      caret_pos;            /* the caret postion */
    char     luc_str[10][48];      /* the lookup choice string */
    int      luc_num;              /* the number of choices */
    char     commit_str[512];      /* the committed string */
    char     status_str[32];       /* the status string */
    int      error_num;
    int      labeltype;		   /* label type "123", "abc", "ABC" */
} im_data;


/* data buffer for engine */

#define Mode            buffer[session_id]->mode
#define IM_Status       buffer[session_id]->status
#define Preedit_Buf     buffer[session_id]->preedit
#define Preedit_Len     buffer[session_id]->preedit_len
#define Inbuf           buffer[session_id]->inbuf
#define Inbuf_Len       buffer[session_id]->inbuf_len
#define Commit_Buf      buffer[session_id]->commit
#define WildChar_Pos    buffer[session_id]->wildchar_pos
#define Candidate       buffer[session_id]->candidate
#define First_Candidate buffer[session_id]->candidate_low
#define Last_Candidate  buffer[session_id]->candidate_high
#define S_Pointer       buffer[session_id]->search_pointer
#define S_Direction     buffer[session_id]->search_direction
#define LUC_Low         buffer[session_id]->lookupchoice_low
#define LUC_High        buffer[session_id]->lookupchoice_high
#define LUC_Number      buffer[session_id]->lookupchoice_number
#define This_Operation  buffer[session_id]->this_operation
#define Input_Method    buffer[session_id]->input_method
#define Quanjiao        buffer[session_id]->quanjiao

struct im_buffer {
    char        preedit[MAX_CHAR_PREEDIT];
    short int   preedit_len;
    char        commit[MAX_CHAR_COMMIT];
    char        inbuf[MAX_CHAR_PREEDIT];
    short int   inbuf_len;
    short int   wildchar_pos;
    char        * candidate[MAX_CANDIDATE];
    int         candidate_low;
    int         candidate_high;
    int         lookupchoice_low;
    int         lookupchoice_high;
    int		lookupchoice_number;
    int         search_pointer;
    int 	search_direction;
    int         this_operation;
    int         mode;
    char        status[20];
    int         input_method;
    int         quanjiao;
};

/*
 * input method structure:
 */

typedef struct _engine_info {
        char            name[16];       /* input method name */
        char            locale[16];
        char            next_choice;    /* key for next choice */
        char            prev_choice;    /* key for prev choice */
        char            del_pe_char;    /* key for delete preedit character */
        char            del_pe_str;     /* key for delete preedit string */
        char            wild_char;      /* */
        char            symbol;
        char            status_native[32];
        char            ct_file[80];    /* Code table file */
        table_index     tab_idx[MAXIDX];
        code_table      *c_tab;         /* Initial = NULL */
        char            *data;
} engine_info;

/*
  for new mode of Chinese symbols. -- roxon
*/

#define PERIOD 0xa1a3           /* . */
#define COMMAM 0xa3ac           /* , */
#define EXCLMM 0xa3a1           /* ! */
#define COLONM 0xa3ba           /* : */
#define HYPHEN 0xa3ad           /* - */
#define CARETM 0xa3de           /* ^ */
#define DSPACE 0xa1a1           /*   */

#define LPARNT 0xa3a8           /* ( */
#define RPARNT 0xa3a9           /* ) */
#define LCUBRT 0xa3fb           /* { */
#define RCUBRT 0xa3fd           /* } */
#define LSQBRT 0xa3db           /* [ */
#define RSQBRT 0xa3dd           /* ] */

#define SNGQUO 0xa1e4           /* ' */
#define ACCENT 0xa3e0           /* ` */
#define DBLQUO 0xa1e5           /* " */

#define AMPERS 0xa3a6           /* & */
#define COMMAT 0xa3c0           /* @ */
#define SOLDUS 0xa1a2           /* / 0xa3af*/
#define SEMCLN 0xa3bb           /* ; */
#define QUESTM 0xa3bf           /* ? */
#define LESSTH 0xa3bc           /* < */
#define GREATH 0xa3be           /* > */
#define VERBAR 0xa3fc           /* | */
#define EQUALS 0xa3bd           /* = */

#define SGNNUM 0xa3a3           /* # */
#define DALLAR 0xa3a4           /* $ */
#define PERCNT 0xa3a5           /* % */
#define SGNSTR 0xa3aa           /* * */
#define UNDSCR 0xa3df           /* _ */
#define BCKSLH 0xa3dc           /* \ */
#define STILDE 0xa1ab           /* ~ */
#define SGNADD 0xa3ab           /* + */

#define DIGITS 0xa3b0           /* 0-9 */

#define UPPERS 0xa3c1           /* A-Z */

#define LOWERS 0xa3e1           /* a-z */

#define CTRL_F 6
#define CTRL_P 16
#define CTRL_N  14

#endif
