/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include <stdlib.h>
#include <stdio.h>
#include <limits.h>

#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <X11/X.h>
#include <X11/Xmd.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>

#include "trace_message.h"

#include "xaux_common.h"
#include "xaux_ext_common.h"

#include "sampleja3_xaux.h"

/* Define Aux class */
xaux_class_t xaux_class = {
    "com.sun.sampleja3.LookupAux", 2,
    (Window) 0, (Window) 0,
    (Atom) 0, (Atom) 0, (Atom) 0, (Atom) 0, (Atom) 0,
    NULL,
};

GdkFilterReturn
gdk_ext_event_handler(GdkXEvent * gdk_xevent,
		      GdkEvent * event,
		      gpointer data);

Bool
key_event_handler(Display * display, Window window,
		  XEvent * event, XPointer clientdata);

Bool
key_event_handler(Display * display, Window window,
		  XEvent * event, XPointer clientdata)
{

    int keycode, keychar, state;
    int integers[4];

    KeyEventToVirtualKey((XKeyEvent *) event, &keycode, &keychar, &state);
    integers[0] = SAMPLEJA3_AUXSETVAL_KEYPRESS;
    integers[1] = keycode;
    integers[2] = keychar;
    integers[3] = state;

    ReturnToEngine(4, integers, 0, 0);

    return True;
}

GdkFilterReturn
gdk_ext_event_handler(GdkXEvent * gdk_xevent,
		      GdkEvent * event,
		      gpointer data)
{
    XEvent *xevent;
    xevent = (XEvent *) gdk_xevent;
    if (xevent->type == ClientMessage) {
	xaux_ext_process_client_message(GDK_DISPLAY(), (XClientMessageEvent *) xevent);
	return GDK_FILTER_REMOVE;
    } else if (xevent->type == KeyRelease) {
	key_event_handler(0, 0, xevent, 0);
	return GDK_FILTER_REMOVE;
    }
    return GDK_FILTER_CONTINUE;
}

GtkWidget *window;
GtkWidget *list;

const gchar *list_item_data_key = "list_item_data";

static xaux_class_t *xc_ = 0;
static int im_ = 0;
static int ic_ = 0;

int choice_per_window;
int ncolumns;
int nrows;
int drawUpDirection;
int n_choices;
int index_of_first_candidate;
int index_of_last_candidate;
int index_of_current_candidate;

int popuped = 0;

/* Method - Start */
Bool
xaux_ext_Start(
	       xaux_class_t * xc,
	       aux_ext_data_t * aux_ext_data)
{
    return True;
}

/* Method - Draw */
Bool
xaux_ext_Draw(
	      xaux_class_t * xc,
	      aux_ext_data_t * aux_ext_data)
{
    size_t i;
    char *sp;
    Bool rv = True;
    char buf[256];
    Display *display = GDK_DISPLAY();
    int x, y;
    Window w_none;
    XWindowAttributes attr;
    char **candidates;
    char tmp[256];

    im_ = aux_ext_data->im;
    ic_ = aux_ext_data->ic;
    xc_ = xc;

    printf("ext_Draw im:0x%x, ic:0x%x\n", aux_ext_data->im, aux_ext_data->ic);

    strcpy(buf, (const char *) aux_ext_data->aux_name);

    printf("ext_Draw[%s] im:0x%x, ic:0x%x\n",
	   buf, aux_ext_data->im, aux_ext_data->ic);

    for (i = 0; i < aux_ext_data->integer_count; i++) {
	printf("\tiv[%02d]=%d\n", i, aux_ext_data->integer_list[i]);
    }

    for (i = 0; i < aux_ext_data->string_count; i++) {
	memset(tmp, 0, sizeof(char) * 256);
	strncpy(tmp, aux_ext_data->string_list[i].ptr, aux_ext_data->string_list[i].length);
    }

    switch (aux_ext_data->integer_list[0]) {
    case SAMPLEJA3_AUXLUC_DONE:
	popdown();
	break;

    case SAMPLEJA3_AUXLUC_START:

	choice_per_window = aux_ext_data->integer_list[1];
	ncolumns = aux_ext_data->integer_list[2];
	nrows = aux_ext_data->integer_list[3];
	drawUpDirection = aux_ext_data->integer_list[4];

	break;

    case SAMPLEJA3_AUXLUC_DRAW:

	index_of_current_candidate = aux_ext_data->integer_list[1];
	n_choices = aux_ext_data->integer_list[2];
	index_of_first_candidate = aux_ext_data->integer_list[3];
	index_of_last_candidate = aux_ext_data->integer_list[4];

	if (!popuped) {
	    XGetWindowAttributes(display, aux_ext_data->clientwin, &attr);
	    XTranslateCoordinates(display, aux_ext_data->clientwin, attr.root,
			 -(attr.border_width), -(attr.border_width),
				  &x, &y, &w_none);
	    gtk_widget_set_uposition(GTK_WIDGET(window),
				     x + aux_ext_data->point.x,
				     y + aux_ext_data->point.y + 20);
	    popup();
	}
	candidates = (char **) calloc(aux_ext_data->string_count, sizeof(char *));
	for (i = 0; i < aux_ext_data->string_count; i++) {
	    candidates[i] = (char *) calloc(1, aux_ext_data->string_list[i].length + 1);
	    strncpy(candidates[i], (char *) aux_ext_data->string_list[i].ptr,
		    aux_ext_data->string_list[i].length);
	}

	util_SetListItems(candidates, aux_ext_data->string_count);
	for (i = 0; i < aux_ext_data->string_count; i++) {
	    free(candidates[i]);
	}
	free(candidates);

    case SAMPLEJA3_AUXLUC_UPDATE:
	index_of_current_candidate = aux_ext_data->integer_list[1];
	util_SetSelectPost(index_of_current_candidate + 1);
	break;

    }
    return True;
}

/* Method - Done */
Bool
xaux_ext_Done(
	      xaux_class_t * xc,
	      aux_ext_data_t * aux_ext_data)
{
    int i;
    char buf[256];

    strncpy(buf, (const char *) aux_ext_data->aux_name,
	    aux_ext_data->aux_name_length);

    printf("ext_Done[%s] im:0x%x, ic_id:0x%x\n",
	   buf, aux_ext_data->im, aux_ext_data->ic);

    popdown();

    return True;
}

void
list_callback(
	      GtkList * list,
	      GtkWidget * widget,
	      gpointer data)
{
    int i = (int) gtk_object_get_data(GTK_OBJECT(widget), list_item_data_key);
}

void
button_callback(GtkWidget * widget,
		gpointer data)
{
    int i = (int) data;
    char *strings[5];
    int integers[5];

    if (i == 1) {
	/* Next Candidate */
	integers[0] = SAMPLEJA3_AUXSETVAL_KEYPRESS;
	integers[1] = ' ';
	integers[2] = ' ';
	integers[3] = 0;
	ReturnToEngine(4, integers, 0, 0);
    } else if (i == 2) {
	/* Test */
	integers[0] = 1;
	integers[1] = 2;
	integers[2] = 3;
	integers[3] = 4;
	strings[0] = "test_string1";
	strings[1] = "test_string2";
	strings[2] = "test_string3";
	strings[3] = "test_string4";
	ReturnToEngine(4, integers, 4, strings);
    } else if (i == 0) {
	/* Prev */
	integers[0] = SAMPLEJA3_AUXSETVAL_KEYPRESS;
	integers[1] = 0x26;	/* IM_VK_UP */
	integers[2] = 0x26;
	integers[3] = 0;
	ReturnToEngine(4, integers, 0, 0);
    }
}

int
main(int argc,
     char *argv[])
{
    GtkWidget *button_next;
    GtkWidget *button_prev;
    GtkWidget *button_test;
    GtkWidget *box1;
    GtkWidget *scrolled_window;

    gtk_set_locale();

    gtk_init(&argc, &argv);

    window = gtk_window_new(GTK_WINDOW_TOPLEVEL);

    gtk_window_set_title(GTK_WINDOW(window), "GTK LOOKUP");

    box1 = gtk_vbox_new(FALSE, 0);
    gtk_container_add(GTK_CONTAINER(window), box1);

    gtk_widget_show(box1);

    gtk_container_set_border_width(GTK_CONTAINER(window), 10);
    gtk_widget_realize(window);

    scrolled_window = gtk_scrolled_window_new(NULL, NULL);
    gtk_widget_set_usize(scrolled_window, 250, 150);
    gtk_container_add(GTK_CONTAINER(box1), scrolled_window);
    gtk_widget_show(scrolled_window);

    list = gtk_list_new();

    gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolled_window),
					  list);

    gtk_list_set_selection_mode(GTK_LIST(list), GTK_SELECTION_BROWSE);

    button_next = gtk_button_new_with_label("Next");
    button_prev = gtk_button_new_with_label("Prev");
    button_test = gtk_button_new_with_label("Test");

    gtk_signal_connect(GTK_OBJECT(button_next), "clicked",
		    GTK_SIGNAL_FUNC(button_callback), (gpointer) 1);

    gtk_signal_connect(GTK_OBJECT(button_prev), "clicked",
		    GTK_SIGNAL_FUNC(button_callback), (gpointer) 0);

    gtk_signal_connect(GTK_OBJECT(button_test), "clicked",
		    GTK_SIGNAL_FUNC(button_callback), (gpointer) 2);

    gtk_widget_show(button_next);
    gtk_widget_show(button_prev);
    gtk_widget_show(button_test);

    gtk_container_add(GTK_CONTAINER(box1), button_next);
    gtk_container_add(GTK_CONTAINER(box1), button_prev);
    gtk_container_add(GTK_CONTAINER(box1), button_test);

    gtk_widget_show(list);

    gtk_signal_connect(GTK_OBJECT(list), "select-child",
		       GTK_SIGNAL_FUNC(list_callback), NULL);

    gdk_window_add_filter(GTK_WIDGET(window)->window, gdk_ext_event_handler, 0);

    gtk_widget_show(window);

    /* Register Aux class */
    if (xaux_ext_init_classes(GDK_DISPLAY(),
			      &xaux_class, GDK_WINDOW_XWINDOW(GTK_WIDGET(window)->window)) == False) {
	exit(1);
    }
    /*
     * gtk_widget_hide(GTK_WIDGET(window));
     */

    gtk_main();

    return (0);
}

popup()
{
    gtk_widget_show(GTK_WIDGET(window));
    gtk_widget_grab_focus(GTK_WIDGET(list));
    popuped = 1;
}

popdown()
{
    gtk_widget_hide(GTK_WIDGET(window));
    popuped = 0;
}

util_SetListItems(char **candidates, int num_candidates)
{
    GList *dlist;
    GtkWidget *list_item;
    guint i;
    char buf[256];

    dlist = GTK_LIST(list)->children;

    /* Unregister Filter */
    while (dlist) {
	GtkWidget *list_item;
	list_item = GTK_WIDGET(dlist->data);
	_XUnregisterFilter(GDK_DISPLAY(),
			   GDK_WINDOW_XWINDOW(list_item->window),
			   key_event_handler,
			   0);
	dlist = dlist->next;
    }

    gtk_list_clear_items(GTK_LIST(list), 0, -1);

    dlist = NULL;
    for (i = 0; i < num_candidates; i++) {
	sprintf(buf, "%d. %s", i + 1, candidates[i]);
	list_item = gtk_list_item_new_with_label(buf);
	dlist = g_list_append(dlist, list_item);

	gtk_object_set_data(GTK_OBJECT(list_item),
			    list_item_data_key,
			    (gpointer) i);

	gtk_widget_show(list_item);
    }

    gtk_list_append_items(GTK_LIST(list), dlist);

    dlist = GTK_LIST(list)->children;

    /* Register Filter */
    while (dlist) {
	GtkWidget *list_item;
	list_item = GTK_WIDGET(dlist->data);

	_XRegisterFilterByType(GDK_DISPLAY(),
			       GDK_WINDOW_XWINDOW(list_item->window),
			       KeyRelease, KeyRelease,
			       key_event_handler,
			       0);
	dlist = dlist->next;
    }
}

util_GetSelectedPos()
{
}

util_SetSelectPost(int position)
{
    gtk_list_select_item(GTK_LIST(list), position - 1);
}

ReturnToEngine(
	       int integer_count,
	       int *integers,
	       int string_count,
	       char **strings
)
{
    int i;

    aux_ext_data_t *aux_data;

    if (!im_ || !ic_ || !xc_)
	return;

    if (!integer_count && !string_count)
	return;

    aux_data = (aux_ext_data_t *) calloc(1, sizeof(aux_ext_data_t));

    aux_data->im = im_;
    aux_data->ic = ic_;
    aux_data->integer_count = integer_count;
    aux_data->string_count = string_count;

    if (aux_data->integer_count) {
	aux_data->integer_list = (int *) calloc(1, sizeof(int) * aux_data->integer_count);
	for (i = 0; i < aux_data->integer_count; i++) {
	    aux_data->integer_list[i] = integers[i];
	}
    }
    if (aux_data->string_count) {
	aux_data->string_list = (aux_ext_string_t *) calloc(1,
		 sizeof(aux_ext_string_t) * aux_data->string_count);
	for (i = 0; i < aux_data->string_count; i++) {
	    aux_ext_string_t *p = &aux_data->string_list[i];
	    p->length = strlen(strings[i]);
	    p->ptr = (unsigned char *) strdup(strings[i]);
	}
    }
    xaux_ext_SetValue(GDK_DISPLAY(), xc_, aux_data);

    if (aux_data->integer_list)
	free(aux_data->integer_list);
    if (aux_data->string_list) {
	for (i = 0; i < aux_data->string_count; i++) {
	    aux_ext_string_t *p = &aux_data->string_list[i];
	    if (p && p->ptr)
		free(p->ptr);
	}
	free(aux_data->string_list);
    }
    free(aux_data);
}
