/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include <string.h>
#include "util.hh"
#include "CompoundString.hh"
#include "svric.hh"
#include "IMUser.hh"
#include "imsession.hh"

SvrIc::SvrIc(Itt * p_itt, InputContext *input_context) 
				: itt(p_itt), ic(input_context)
{
  imuser = (IMUser *)0;
  if (ic) {
     CompoundString cs = input_context->getUser();
     char *hostname = (char *)0;
     char *username = (char *)0;
     char *uhaname = (char *)cs;
     char *uhname = (char *)0;
     char *authpasswd = (char *)0;

     username = Util::getFirstWord(uhaname, "@");
     uhname = Util::getFirstWord(uhaname, "#");

     if (uhname)
        hostname = strstr(uhname, "@");
     if (hostname)
        hostname++; 

     if (uhaname)
        authpasswd = strstr(uhaname, "#");
     if (authpasswd)
        authpasswd++;

     imuser = IMUser::getIMUser(username, hostname, "#1", authpasswd);
     if (!imuser) 
        imuser = new IMUser(username, hostname, "#1", authpasswd);
     CompoundString input_locale = input_context->getLocaleName();
     session = IMSession::create(this, (char *)input_locale);

     delete username;
     if(strstr(uhaname,"#")) delete uhname;
  } else { // Itt wants to create a dummy ic
     session = IMSession::create(this, " "); // pass " " for locale
  }
  pstate = PreeditDisable;
}

SvrIc::~SvrIc()
{
  session->destroy();
}

int
SvrIc::realizeIC()
{
 int ret_val = 0;
 ret_val = session->realize();
 return(ret_val);
}

int
SvrIc::forwardEvent(IMInputEvent *ev)
{
 int ret_val = 0;
 ret_val = session->forwardEvent(ev);
 return(ret_val);
}

int
SvrIc::setICFocus()
{
 int ret_val = 0;
  ret_val = session->setFocus();
 return(ret_val);
}

int
SvrIc::unsetICFocus()
{
 int ret_val = 0;
 ret_val =  session->unsetFocus();
 return(ret_val);
}

IMText * 
SvrIc::resetIC()
{
  IMText * ret_string;

  ret_string = session->reset();
  return (ret_string);
}

int
SvrIc::setICValues()
{
 int ret_val = 0;
 ret_val = session->setValues((char *)0, (void *)0);
 return(ret_val);
}

int
SvrIc::getICValues()
{
 int ret_val = 0;
 ret_val = session->getValues((char *)0, (void *)0);
 return(ret_val);
}

int
SvrIc::startConversion()
{
 int ret_val = 0;
 ret_val = session->startConversion();
 pstate = PreeditEnable;
 return(ret_val);
}

int
SvrIc::endConversion()
{
 int ret_val = 0;
 ret_val = session->endConversion();
 pstate = PreeditDisable;
 return(ret_val);
}

SvrIc::PreeditState
SvrIc::getPreeditState()
{
  return pstate;
}

Itt&
SvrIc::getItt()
{
  return *itt;
}

IMUser&
SvrIc::getIMUser()
{
  return *imuser;
}

InputContext&
SvrIc::getInputContext()
{
  return *ic;
}
