/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "itt.hh"
#include "IMUser.hh"
#include "IMSystem.hh"
#include "sessioniml_xsunim.hh"
#include "CompoundString.hh"
#include <X11/Xutil.h>

extern "C" {
extern void iml_post_proc(iml_session_t*, iml_inst**);
iml_inst* iml_execute(iml_session_t *s, iml_inst **rrv);
}

LocaleService * XSunIMSession::loc = (LocaleService *)0;
Converter * XSunIMSession::converter = (Converter *)0;

static int label_type;
static char *alpha_label = "abcdefghijklmnopqrstuvwxyz";
static char *upper_alpha_label = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
static char *numeric_label = "1234567890";

IMSession*
IMSession::create(SvrIc* p_ic, char *locale)
{
  IMSession* session = (IMSession *)0;
  if (locale)  // else Itt may want to create dummy session to get LE info
     session = (IMSession *)new XSunIMSession(p_ic, locale);
  return (session);
}

/*************************************************************************
* $DESC_BEGIN
* Contructor function.
* $DESC_END
*************************************************************************/
int XSunIMSession::num_of_labels = 0;
XIMText XSunIMSession::label_text[] = {0};

XSunIMSession::~XSunIMSession() {
  delete htt->im;		// in getImChain
  delete htt;
  delete choice;
}

XSunIMSession::XSunIMSession(SvrIc* p_ic, char *locale) :
  SC_LOOKUP_NCOLS(6), SC_LOOKUP_NROWS(5) {
  svric = p_ic;
  Itt& itt = p_ic->getItt();
  IMUser& imuser = svric->getIMUser();
  htt=0;
  if (!loc) {
     Itt& itt = p_ic->getItt();
     char *locale_name = (char *)0;
     imuser.getResourceValues(0, RDB_LOCALE_NAME, &locale_name, (char*)0); 
     loc = LocaleService::create(locale_name);
     delete [] locale_name;
  }
  if (!converter)
    converter = new Converter(loc->getShortName());

  if (!num_of_labels) init_label();

  choice = new LookupChoice(num_of_labels);
  choice->set_converter(converter);

  openSession(loc->getLocaleName());
  iml_session_t *s = getActiveSession();
  InputContext& ic = svric->getInputContext();
  CompoundString cs = ic.getUser();
  if_SetSCValue(s, SC_user_name, (char *)cs);

  // lookup values
  const int SC_LOOKUP_CWIDTH = 12;
  const	int SC_LOOKUP_EWIDTH = 12;
  const int SC_LOOKUP_LINES  = 0;
  const int SC_LOOKUP_ROOTWIDTH = 0;
  const int SC_LOOKUP_NCHOICES	= num_of_labels;
  
  if_SetSCValue(s, SC_lookup_root, (char*)False);
  if_SetSCValue(s, SC_lookup_cwidth, (char*)SC_LOOKUP_CWIDTH);
  if_SetSCValue(s, SC_lookup_ewidth, (char*)SC_LOOKUP_EWIDTH);
  if_SetSCValue(s, SC_lookup_lines, (char*)SC_LOOKUP_LINES);
  if_SetSCValue(s, SC_lookup_rootwidth, (char*)SC_LOOKUP_ROOTWIDTH);
  if_SetSCValue(s, SC_lookup_imscontrol, (char*)True);
  if_SetSCValue(s, SC_lookup_nchoices, (char*)SC_LOOKUP_NCHOICES);
  if_SetSCValue(s, SC_lookup_ncols, (char*)SC_LOOKUP_NCOLS);
  if_SetSCValue(s, SC_lookup_nrows, (char*)SC_LOOKUP_NROWS);
  if_SetSCValue(s, SC_lookup_direction, (char*)DrawUpHorizontally);
  if_SetSCValue(s, SC_lookup_labeltype, (char*)label_type);
  if_SetSCValue(s, SC_lookup_whoownslabel, (char*)CBOwnsLabel);
  if_SetSCValue(s, SC_nego_flush, (char*)True);
}

/*************************************************************************
* $DESC_BEGIN
* open a session handler for the ic with the language engine.
* $DESC_END
*************************************************************************/
Bool XSunIMSession::openSession(char *locale) {
    char *if_name = (char*)0;
    static char *le_name = "0";
    iml_if_t	*interface;
    ImChain im = getImChain();
    Itt& itt = svric->getItt();
    IMUser& imuser = svric->getIMUser();
    ImlSession * sessioniml = (ImlSession *)0;
    imuser.getResourceValues(0, RDB_IF_LIST, &if_name, (char*)0);

    sessioniml = new ImlSession();
    session_list.addItem(sessioniml);

    interface = if_OpenIF((char*)if_name, (char*)locale,
			  (void*)im);
    if (!interface) {
      delete [] if_name;
      return False;
    }
    delete [] if_name;

    // Needed for backward compatibility
    imlg = new IMLGlueRec;
    if (!imlg) {
        if_CloseIF(interface);
        return False;
    }
    memset(imlg, 0, sizeof(IMLGlueRec));

    imlg->cell_link = (XSFrrvCell)0;
    imlg->session = (void *)this;
    imlg->window = 0;  // XicClientWindow(s->xic);
    imlg->screen = 0; // XicScreen(s->xic);
	
    sessioniml->interface = interface;
    sessioniml->status = (iml_status_t)0;
    sessioniml->s = if_CreateSC(interface, imlg, (char*)le_name);

    if (!sessioniml->s) {
	if_CloseIF(interface);
	return False;
    }
    
    active_session = sessioniml;
    return True;
}

/*************************************************************************
* $DESC_BEGIN
* destroys the current instance.
* $DESC_END
*************************************************************************/
void XSunIMSession::destroy() {
  int n = session_list.getSize();
  for (int i = 1; i <= n; i++) {
    ImlSession *sessioniml = &(session_list.getItem(i));
    if_DestroySC(sessioniml->s);
    delete sessioniml;
  }
  session_list.destroy();
  delete this;
  return;
}

int XSunIMSession::startConversion() {
  if (svric->getPreeditState() != SvrIc::PreeditEnable) {
    int flag = 1;
    iml_session_t *s = getActiveSession();
    if_SetSCValue(s, SC_Henkan_Mode, (caddr_t)flag);
  }
  InputContext& ic = svric->getInputContext();
  ic.conversion_start();
  return 1;
}

int XSunIMSession::endConversion() {
  if (svric->getPreeditState() != SvrIc::PreeditDisable) {
    iml_session_t *s = getActiveSession();
    int flag = 0;
    if_SetSCValue(s, SC_Henkan_Mode, (caddr_t)flag);
  }
  InputContext& ic = svric->getInputContext();
  ic.conversion_end();
  return 1;
}

int XSunIMSession::forwardEvent(IMInputEvent *input_event)
{
  iml_session_t *s = getActiveSession();

  switch (input_event->type) {
  case IM_EventKeyList:
    {
      XEvent ev;
      IMKeyListEvent *key_list = (IMKeyListEvent*)input_event;
      IMKeyEventStruct *p;
      int n = key_list->n_key;
      IMSystem::begin_im_transaction();
      for (p = key_list->keylist; p < &(key_list->keylist[n]); p++) {
	converter->getXKeyEvent(*p, ev);
	if_SendEvent(s, (XEvent*)&ev);
      }
      IMSystem::end_im_transaction();
      break;
    }
  case IM_EventAux:
    {
      IMAuxEvent *aux_event = (IMAuxEvent*)input_event;
      IMAuxDrawCallbackStruct *call_data = aux_event->aux;
      XIMAuxDrawCallbackStruct aux_data;
      memset(&aux_data, 0, sizeof(XIMAuxDrawCallbackStruct));

      aux_data.engine_name = call_data->engine_name;
      aux_data.engine_class_index = call_data->engine_class_index;

      aux_data.count_integer_values = call_data->count_integer_values;
      aux_data.integer_values = call_data->integer_values;

      aux_data.count_string_values = call_data->count_string_values;
      XIMText *it = new XIMText[aux_data.count_string_values];

      int i;
      for(i = 0;i < call_data->count_string_values; i++){
	IMText *lt = &(call_data->string_values[i]);
	XIMText *xlt=converter->convfromutf(lt);
	it[i].encoding_is_wchar=xlt->encoding_is_wchar;
	it[i].length=xlt->length;
	it[i].string.multi_byte=xlt->string.multi_byte;
	delete xlt;
      }
      aux_data.string_values = it;

      IMSystem::begin_im_transaction();
      if_SetAuxValues(s, &aux_data);
      IMSystem::end_im_transaction();

      for(i = 0;i < aux_data.count_string_values; i++){
	XIMText *xlt = &(aux_data.string_values[i]);
	delete [] xlt->string.multi_byte;
      }
      delete [] aux_data.string_values;
      break;
    }
  }
  return 1;
}


/*************************************************************************
* $DESC_BEGIN
* send set focus message to the language engine.
* $DESC_END
*************************************************************************/
int XSunIMSession::setFocus() {
  iml_session_t *s = getActiveSession();
  IMSystem::begin_im_transaction();
  if_SetSCFocus(s);
  IMSystem::end_im_transaction();
  return 1;
}

/*************************************************************************
* $DESC_BEGIN
* send unset focus message to the language engine.
* $DESC_END
*************************************************************************/
int XSunIMSession::unsetFocus() {
  iml_session_t *s = getActiveSession();
  IMSystem::begin_im_transaction();
  if_UnsetSCFocus(s);
  IMSystem::end_im_transaction();
  return 1;
}

/*************************************************************************
* $DESC_BEGIN
* Switches between another language engine based on the key pressed.
* $DESC_END
*************************************************************************/
Bool XSunIMSession::engineSwitch(XEvent *ev) {
    /* not yet: Need to implement engine switch */
    return (False);
}

/*************************************************************************
* $DESC_BEGIN
* reset the session with the language engine.
* $DESC_END
*************************************************************************/
IMText* XSunIMSession::reset() {
 iml_session_t *s = getActiveSession(); 
 InputContext& ic = svric->getInputContext();
 char * returned = (char *)0; 
 if (svric->getPreeditState() == SvrIc::PreeditEnable) {
        IMSystem::begin_im_transaction();
	returned = if_ResetSC(s);
        IMSystem::end_im_transaction();
 }
 // Convert the char* to IMText 
 return (IMText*)0;
}

/*************************************************************************
* $DESC_BEGIN
* sets the values for the session.
* $DESC_END
*************************************************************************/
int XSunIMSession::setValues(char *attr, void *value) {
    if(attr == NULL){
	return 0;
    }
    iml_session_t *s = getActiveSession(); 
    IMSystem::begin_im_transaction();
    if_SetSCValue(s, attr, (char *)value);
    IMSystem::end_im_transaction();
    return 0;
}

/*************************************************************************
* $DESC_BEGIN
* returns the ic values for the session.
* $DESC_END
*************************************************************************/
int XSunIMSession::getValues(char *attr, void *value) {
    if(attr == NULL){
	return 0;
    }
    iml_session_t *s = getActiveSession(); 
    IMSystem::begin_im_transaction();
    if_GetSCValue(s, attr, (char *)value);
    IMSystem::end_im_transaction();
    return 0;
}

/*************************************************************************
* $DESC_BEGIN
* returns the active session on the session list.
* $DESC_END
*************************************************************************/
iml_session_t *XSunIMSession::getActiveSession() {
   return active_session->s;
}

int 
XSunIMSession::imli_nop(iml_inst *rv, XEvent *e) {
    return XLookupNone;
}

int 
XSunIMSession::imli_set_status(iml_inst *rv, XEvent *e) {
  SvrIc::PreeditState state = svric->getPreeditState();
  InputContext& ic = svric->getInputContext();
  iml_status_t   prev_status = 0;
  iml_status_t   status = *(iml_status_t *) & (rv->operand);

  if (state == SvrIc::PreeditEnable)
    prev_status |= IMLSTATUS_Henkan_Mode;

  if (((status & IMLSTATUS_Henkan_Mode) != IMLSTATUS_Henkan_Mode) &&
      ((prev_status & IMLSTATUS_Henkan_Mode) == IMLSTATUS_Henkan_Mode)) {
    svric->endConversion();
  } else if (((status & IMLSTATUS_Henkan_Mode) == IMLSTATUS_Henkan_Mode) &&
	     ((prev_status & IMLSTATUS_Henkan_Mode) != 
	      IMLSTATUS_Henkan_Mode)) {
    svric->startConversion();
  }
  return XLookupNone;
} 

int 
XSunIMSession::imli_reset(iml_inst *rv, XEvent *e) {
    return XLookupNone;
}

int 
XSunIMSession::imli_keypress(iml_inst *rv, XEvent *e) {
    InputContext& ic = svric->getInputContext();
    imm_keypress_t *kp = (imm_keypress_t *)&rv->operand ;

    IMKeyEventStruct key;
    converter->getIMKeyEvent(*e, key);
    ic.forward_event(&key);
    return XLookupNone;
}

int 
XSunIMSession::imli_commit(iml_inst *rv, XEvent *e) {
    /*
     * FIX ME! This routine can accept only multi byte.
     */
    IMText *imtext;
    InputContext& ic = svric->getInputContext();
    committed_string_t *cs;
    cs = (committed_string_t *) & rv->operand;
    // Need to convert the char* to text
    imtext = converter->convtoutf(cs->string, 0, strlen(cs->string));
    ic.commit_string(imtext);

    delete imtext->feedback;
    delete [] imtext->text.utf_chars;
    delete imtext;

    return (cs->status);
}

int 
XSunIMSession::imli_reset_return(iml_inst *rv, XEvent *e) {
    /*
     * FIX ME! This routine can accept only multi byte.
     */
    IMText* imtext;
    InputContext& ic = svric->getInputContext();
    committed_string_t *cs;
    cs = (committed_string_t *) & rv->operand;
    // Need to convert the char* to text
    if (strlen(cs->string) > 0) {
      imtext = converter->convtoutf(cs->string, 0, strlen(cs->string));
      ic.commit_string(imtext);
      delete imtext->feedback;
      delete [] imtext->text.utf_chars;
      delete imtext;
      return XLookupNone;
    }
    return (cs->status);
}

int 
XSunIMSession::imli_preedit_start(iml_inst *rv, XEvent *e) {
    InputContext& ic = svric->getInputContext();
    ic.preedit_start((IMPreeditStruct *)0);
    return (XLookupNone);
}

int 
XSunIMSession::imli_preedit_draw(iml_inst *rv, XEvent *e) {
    InputContext& ic = svric->getInputContext();

    IMPreeditStruct ps;
    memset(&ps, 0, sizeof(IMPreeditStruct));

    // Convert XIMStatusDrawCallbackStruct to IMStatusDrawCallbackStruct
    XIMPreeditDrawCallbackStruct *xp = 
      (XIMPreeditDrawCallbackStruct *)&rv->operand;
    XIMText *xt = xp->text;

    ps.todo.draw.caret = xp->caret;
    ps.todo.draw.chg_first = xp->chg_first;
    ps.todo.draw.chg_length = xp->chg_length;
    if (xt && xt->length != 0) {
      if (xt->encoding_is_wchar) {
	char *mbs = converter->encodeWcText(xt->string.wide_char);
	ps.todo.draw.text = converter->convtoutf(mbs,
						 xp->text->feedback,
						 strlen(mbs));
	delete [] mbs;
      } else {
	ps.todo.draw.text = converter->convtoutf(xt->string.multi_byte,
						  xp->text->feedback,
						  xt->length);
      }
      ic.preedit_draw(&ps);

      delete ps.todo.draw.text->feedback;
      delete [] ps.todo.draw.text->text.utf_chars;
      delete ps.todo.draw.text;

    } else {
      ps.todo.draw.text = 0;
      ic.preedit_draw(&ps);
    }
    return (XLookupNone);
}

int 
XSunIMSession::imli_preedit_done(iml_inst *rv, XEvent *e) {
    InputContext& ic = svric->getInputContext();
    ic.preedit_done((IMPreeditStruct *)0);
    return (XLookupNone);
}

int 
XSunIMSession::imli_preedit_caret(iml_inst *rv, XEvent *e) {
    InputContext& ic = svric->getInputContext();
    IMPreeditStruct ps;
    memset(&ps, 0, sizeof(IMPreeditStruct));
    memcpy(&(ps.todo.draw), (void *)&rv->operand, 
	   sizeof(IMPreeditCaretCallbackStruct));
    ic.preedit_caret(&ps);
    return (XLookupNone);
}

int 
XSunIMSession::imli_status_start(iml_inst *rv, XEvent *e) {
    InputContext& ic = svric->getInputContext();
    ic.status_start((IMStatusStruct *)0);
    return (XLookupNone);
}

int 
XSunIMSession::imli_status_draw(iml_inst *rv, XEvent *e) {
    InputContext& ic = svric->getInputContext();

    IMStatusStruct ss;
    memset(&ss, 0, sizeof(IMStatusStruct));

    // Convert XIMStatusDrawCallbackStruct to IMStatusDrawCallbackStruct
    XIMStatusDrawCallbackStruct *xs =
      (XIMStatusDrawCallbackStruct *)&rv->operand;
    XIMText *xt = xs->data.text;

    if (xt->length != 0) {
      if (xt->encoding_is_wchar) {
	char *mbs = converter->encodeWcText(xt->string.wide_char);
	ss.todo.draw.text = converter->convtoutf(mbs,
						 xs->data.text->feedback,
						 strlen(mbs));	
	delete [] mbs;
      } else {
	ss.todo.draw.text = converter->convtoutf(xt->string.multi_byte,
						 xs->data.text->feedback,
						 xt->length);
      }
      ic.status_draw(&ss);

      delete ss.todo.draw.text->feedback;
      delete [] ss.todo.draw.text->text.utf_chars;
      delete ss.todo.draw.text;

    }
    return (XLookupNone);
}

int 
XSunIMSession::imli_status_done(iml_inst *rv, XEvent *e) {
    InputContext& ic = svric->getInputContext();
    ic.status_done((IMStatusStruct *)0);
    return (XLookupNone);
}

int 
XSunIMSession::imli_lookup_start(iml_inst *rv, XEvent *e) {
    InputContext &ic = svric->getInputContext();

    IMLookupStruct ls;
    memset(&ls, 0, sizeof(IMLookupStruct));

    XIMLookupStartCallbackStruct *call_data = 
      (XIMLookupStartCallbackStruct *)&rv->operand;
    // Now the conversion starts

    ls.todo.start.whoIsMaster = call_data->whoIsMaster;

    if (call_data->whoIsMaster == CBIsMaster) {
      choice->set_WhoIsMaster(CBIsMaster);
      choice->set_nrows(call_data->CBPreference->nrows);
      choice->set_ncolumns(call_data->CBPreference->ncolumns);
    } else if (call_data->whoIsMaster == IMIsMaster) {
      choice->set_WhoIsMaster(CBIsMaster);
      choice->set_nrows(call_data->XIMPreference->nrows);
      choice->set_ncolumns(call_data->XIMPreference->ncolumns);
    } else {			/* fallback */
      choice->set_nrows(SC_LOOKUP_NROWS);
      choice->set_ncolumns(SC_LOOKUP_NCOLS);
    }

    ls.todo.start.IMPreference = call_data->XIMPreference;
    ls.todo.start.CBPreference = call_data->CBPreference;
    ic.lookup_start(&ls);

    return (XLookupNone);
}

int
XSunIMSession::init_label() {
  int i;
  wchar_t *my_label, *my_labelp;
  RmLabelType type = RmLower; /* default */
  Itt& itt = svric->getItt();
  IMUser& imuser = svric->getIMUser();
  imuser.getResourceValues(0, RDB_LOOKUP_LABEL_TYPE, &type,
			(char*)0); 
  switch (type) {
  case RmUpper:
    label_type = IM_LUC_LABEL_ALPHA_UPPER;
    num_of_labels = 26;
    my_label = new wchar_t[num_of_labels];
    mbstowcs(my_label, upper_alpha_label, num_of_labels);
    break;
  case RmNumeric:
    label_type = IM_LUC_LABEL_NUMERIC;
    num_of_labels = 10;
    my_label = new wchar_t[num_of_labels];
    mbstowcs(my_label, numeric_label, num_of_labels);
    break;
  default:
    label_type = IM_LUC_LABEL_ALPHABETIC;
    num_of_labels = 26;
    my_label = new wchar_t[num_of_labels];
    mbstowcs(my_label, alpha_label, num_of_labels);
    break;
  }
  my_labelp = my_label;
  for (i = 0; i < num_of_labels; i++) {
    label_text[i].length = 1;
    label_text[i].encoding_is_wchar = 1;
    label_text[i].string.wide_char = new wchar_t[2];
    label_text[i].string.wide_char[0] = *my_labelp++;
    label_text[i].string.wide_char[1] = (wchar_t)0;
    label_text[i].feedback = new XIMFeedback;
    label_text[i].feedback[0] = 0;
  }
  delete [] my_label;
  return True;
}

int
XSunIMSession::imli_lookup_draw(iml_inst *rv, XEvent *e) {
    InputContext& ic = svric->getInputContext();

    IMLookupStruct ls;
    memset(&ls, 0, sizeof(IMLookupStruct));

    XIMLookupDrawCallbackStruct *lds =
      (XIMLookupDrawCallbackStruct *)&rv->operand;

    choice->set_choices(lds, label_text);

    choice->create_page(ls.todo.draw);

    // if feedback can tell which is the current index, reverse it
    for (int i = 0; i < ls.todo.draw.index_of_last_candidate + 1; i++) {
      if (ls.todo.draw.choices[i].value->feedback[0] != 0) {
	ls.todo.draw.index_of_current_candidate = i;
      }
    }
    ic.lookup_draw(&ls);

    return (XLookupNone);
}

int
XSunIMSession::imli_lookup_process(iml_inst *rv, XEvent *e) {
    InputContext& ic = svric->getInputContext();
    IMLookupStruct ls;
    memset(&ls, 0, sizeof(IMLookupStruct));

    XIMLookupProcessCallbackStruct *call_data =
      (XIMLookupProcessCallbackStruct *)&rv->operand;
    XKeyEvent *event = (XKeyEvent*)call_data->event;
    KeySym keysym;
    if (event->display == (Display*)0) {
      // event->keycode contains keysym value...
      keysym = event->keycode;
    } else {
      XComposeStatus NotSupported ;
      char buffer[4];
      XLookupString(event, buffer, sizeof(char) * 4, &keysym,
		    &NotSupported);
    }
    if (event->state & ControlMask) {
      switch (keysym) {
      case XK_a:		/* Ctrl-a */
      case XK_A:		/* Ctrl-A */
	// move focus to top candidate in the same page
	if (choice->move_top()) {
	  call_data->index_of_choice_selected = XIM_UNDETERMINED;
	}
	break;
      case XK_e:		/* Ctrl-e */
      case XK_E:		/* Ctrl-E */
	// move focus to last candidate in the same page
	if (choice->move_last()) {
	  call_data->index_of_choice_selected = XIM_UNDETERMINED;
	}
	break;
      case XK_b:		/* Ctrl-b */
      case XK_B:		/* Ctrl-B */
	// move focus to previous candidate in the same page
	if (choice->move_prev()) {
	  call_data->index_of_choice_selected = XIM_UNDETERMINED;
	}
	break;
      case XK_f:		/* Ctrl-f */
      case XK_F:		/* Ctrl-F */
	// move focus to next candidate in the same page
	if (choice->move_next()) {
	  call_data->index_of_choice_selected = XIM_UNDETERMINED;
	}
	break;
      case XK_p:		/* Ctrl-p */
      case XK_P:		/* Ctrl-P */
	// goto previous page if any
	if (choice->move_prev_page()) {
	  call_data->index_of_choice_selected = XIM_UNDETERMINED;
	}
	break;
      case XK_n:		/* Ctrl-n */
      case XK_N:		/* Ctrl-N */
	// goto next page
	if (choice->move_next_page()) {
	  // index_of_choice_selected is used to determine the results
	  // of the lookup process operation */
	  call_data->index_of_choice_selected = XIM_UNDETERMINED;
	}
	break;
      }
    } else if (event->state == 0 || event->state == ShiftMask) {
      switch (keysym) {
      case XK_Return:	/* RET */
	// select a candidate
	call_data->index_of_choice_selected = choice->get_focus_index();
	break;
      case XK_Down:		/* Down Arrow */
	if (choice->move_down()) {
	  call_data->index_of_choice_selected = XIM_UNDETERMINED;
	}
	break;
      case XK_Up:		/* Up Arrow */
	if (choice->move_up()) {
	  call_data->index_of_choice_selected = XIM_UNDETERMINED;
	}
	break;
      case XK_Left:		/* Left Arrow */
	// move focus to previous candidate in the same page
	if (choice->move_prev()) {
	  call_data->index_of_choice_selected = XIM_UNDETERMINED;
	}
	break;
      case XK_Right:	/* Right Arrow */
	// move focus to next candidate in the same page
	if (choice->move_next()) {
	  call_data->index_of_choice_selected = XIM_UNDETERMINED;
	}
	break;
      default:
	// select a candidate
	if (XK_a <= keysym && keysym <= XK_z) {
	  call_data->index_of_choice_selected
	    = choice->select_choice(keysym - XK_a);
	} else if (XK_A <= keysym && keysym <= XK_Z) {
	  call_data->index_of_choice_selected
	    = choice->select_choice(keysym - XK_A);
	} else if (XK_1 <= keysym && keysym <= XK_9) {
	  call_data->index_of_choice_selected
	    = choice->select_choice(keysym - XK_1);
	} else if (keysym == XK_0) {
	  call_data->index_of_choice_selected
	    = choice->select_choice(9);
	} else {
	  call_data->index_of_choice_selected = XIM_UNKNOWN_CONTROL;
	  break;
	}
	if (call_data->index_of_choice_selected > choice->last_index()) {
	  call_data->index_of_choice_selected = XIM_UNKNOWN_CONTROL;
	}
	break;
      }
    }
    if (call_data->index_of_choice_selected == XIM_UNDETERMINED) {
      // update luc page
      choice->create_page(ls.todo.draw);

      ic.lookup_draw(&ls);
    }
    return (XLookupNone);
}

int 
XSunIMSession::imli_lookup_done(iml_inst *rv, XEvent *e) {
    InputContext& ic = svric->getInputContext();
    ic.lookup_done((IMLookupStruct *)0);

    choice->clear();
    return (XLookupNone);
}

int 
XSunIMSession::imli_aux_start(iml_inst *rv, XEvent *e) {
    InputContext& ic = svric->getInputContext();
    IMAuxStruct as;
    XIMAuxStartCallbackStruct *aux_start = 
		(XIMAuxStartCallbackStruct *)&rv->operand;
    memset(&as, 0, sizeof(IMAuxStruct));
    as.todo.start.engine_name=aux_start->engine_name;
    as.todo.start.engine_class_index =  aux_start->engine_class_index;
    ic.auxiliary_start(&as);
    return (XLookupNone);
}

int 
XSunIMSession::imli_aux_draw(iml_inst *rv, XEvent *e) {
    InputContext& ic = svric->getInputContext();
    IMAuxStruct as;
    XIMAuxDrawCallbackStruct *aux_draw = 
		(XIMAuxDrawCallbackStruct *)&rv->operand;
    memset(&as, 0, sizeof(IMAuxStruct));
    as.todo.draw.engine_name=aux_draw->engine_name;
    as.todo.draw.engine_class_index =  aux_draw->engine_class_index;
    as.todo.draw.count_integer_values =  aux_draw->count_integer_values;
    as.todo.draw.integer_values =  aux_draw->integer_values;
    as.todo.draw.count_string_values =  aux_draw->count_string_values;
    IMText *it = new IMText[aux_draw->count_string_values];
    for (int i=0; i<aux_draw->count_string_values; i++) {
        XIMText *xt = &(aux_draw->string_values[i]);
        IMText *t_it = (IMText *)0;
        if (xt && xt->length != 0) {
	   if (xt->encoding_is_wchar) {
	      char *mbs = converter->encodeWcText(xt->string.wide_char);
	      t_it = converter->convtoutf(mbs, 
					aux_draw->string_values[i].feedback,	
					strlen(mbs));
	      delete[] mbs;		
	   } else {
	      t_it =  converter->convtoutf(xt->string.multi_byte,
					aux_draw->string_values[i].feedback,
						xt->length);
	   }
           if (t_it == 0) {
	       t_it = (IMText *)new IMText;
	       t_it->encoding = UTF16_CODESET;
	   }
	   if (t_it->text.utf_chars == NULL) {
	       t_it->text.utf_chars = new UTFCHAR[1];
               t_it->text.utf_chars[0] = 0x0;
               t_it->char_length=1;
               t_it->feedback=0;
           }
        } else {
            t_it = (IMText *)new IMText;
	    t_it->encoding = UTF16_CODESET;
            t_it->text.utf_chars=(UTFCHAR*)new UTFCHAR[1];
            t_it->text.utf_chars[0]=0x0;
            t_it->char_length=1;
            t_it->feedback=0;
	}
	it[i] = *t_it;
    }
    as.todo.draw.string_values = it;
    ic.auxiliary_draw(&as);
    return (XLookupNone);
}

int 
XSunIMSession::imli_aux_done(iml_inst *rv, XEvent *e) {
    InputContext& ic = svric->getInputContext();
    IMAuxStruct as;
    XIMAuxDoneCallbackStruct *aux_done = 
		(XIMAuxDoneCallbackStruct *)&rv->operand;
    memset(&as, 0, sizeof(IMAuxStruct));
    as.todo.done.engine_name=aux_done->engine_name;
    as.todo.done.engine_class_index =  aux_done->engine_class_index;
    ic.auxiliary_done(&as);
    return (XLookupNone);
}

int 
XSunIMSession::imli_key_info(iml_inst *rv, XEvent *e) {
    InputContext& ic = svric->getInputContext();
    return (XLookupNone);
}

// called from IMdkit
void
BC_xsunim_filterevent_wrapper(XEvent *e) {
        printf("BC_xsunim_filterevent_wrapper\n");
	XSunIMSession::BC_xsunim_filterevent(e);
}

void
XSunIMSession::BC_xsunim_filterevent(XEvent *e) {
    if_FilterEvent(e);
}

int 
XSunIMSession::imli_put_queue(iml_inst *rv, XEvent *e) {
    InputContext& ic = svric->getInputContext();
    return (XLookupNone);
}

int
XSunIMSession::executeHandler(int opcode,
                                iml_inst* inst,
                                XEvent* ev)
{
     int ret_val = 0;
  switch (opcode) {
     case IMM_NOP        : ret_val = imli_nop(inst, ev);
                           break;
     case IMM_SET_STATUS : ret_val = imli_set_status(inst, ev);
                           break;
     case IMM_RESET      : ret_val = imli_reset(inst, ev);
                           break;
     case IMM_KEYPRESS   : ret_val = imli_keypress(inst, ev);
                           break;
     case IMM_COMMIT     : ret_val = imli_commit(inst, ev);
                           break;
     case IMM_RESET_RETURN : ret_val = imli_reset_return(inst, ev);
                           break;
     case IMM_PREEDIT_START : ret_val = imli_preedit_start(inst, ev);
                           break;
     case IMM_PREEDIT_DRAW : ret_val = imli_preedit_draw(inst, ev);
                           break;
     case IMM_PREEDIT_DONE : ret_val = imli_preedit_done(inst, ev);
                           break;
     case IMM_PREEDIT_CARET :
                        ret_val = imli_preedit_caret(inst, ev);
                        break;
     case IMM_STATUS_START :
                        ret_val = imli_status_start(inst, ev);
                        break;
     case IMM_STATUS_DRAW : ret_val = imli_status_draw(inst, ev);
                           break;
     case IMM_STATUS_DONE : ret_val = imli_status_done(inst, ev);
                           break;
     case IMM_LOOKUP_START : ret_val = imli_lookup_start(inst, ev);
                           break;
     case IMM_LOOKUP_DRAW : ret_val = imli_lookup_draw(inst, ev);
                           break;
     case IMM_LOOKUP_PROCESS : ret_val = imli_lookup_process(inst, ev);
                           break;
     case IMM_LOOKUP_DONE : ret_val = imli_lookup_done(inst, ev);
                           break;
     case IMM_AUX_START_2 : ret_val = imli_aux_start(inst, ev);
                           break;
     case IMM_AUX_DRAW_2 : ret_val = imli_aux_draw(inst, ev);
                           break;
     case IMM_AUX_DONE_2 : ret_val = imli_aux_done(inst, ev);
                           break;
     case IMM_KEY_INFO : ret_val = imli_key_info(inst, ev);
                           break;
     case IMM_PUT_QUEUE : ret_val = imli_put_queue(inst, ev);
                           break;
     default :            ret_val = imli_nop(inst, ev);
                           break;
  }
  return ret_val;
}

/*
 * This function expects to be invoked from X*LookupString() basically. The
 * function value is meaningless if it's not invoked from X*LookupString()
 */


iml_inst *
iml_execute(iml_session_t *s, iml_inst **rrv) {
    iml_inst       *rv = *rrv;
    IMLGlue         t_imlg = (IMLGlue)s->ic;
    iml_inst       *i;
    iml_inst	   *result = (iml_inst*)0;
    XSFrrvCell     cell;
    int             op;
    XSunIMSession *session;
    int ret_val;

    iml_post_proc(s, &rv);  /* possible optimization and region management */
    /* New rrv Link cell Create */
    cell = new XSFrrvCellRec;
    memset(cell, 0, sizeof(XSFrrvCellRec));

    /* rrv Link */
    cell->rv = rv;

    /* Cell Link to IC */
    cell->nlink = t_imlg->cell_link;
    t_imlg->cell_link = cell;
    session = (XSunIMSession *)t_imlg->session;
    for (; t_imlg->cell_link ;) {
	cell = t_imlg->cell_link;
	for (i = cell->rv; i != (iml_inst*)0; i = i->next) {
	    cell->rv = i->next;
	    cell->called_rv = i;
	    op = i->opcode & ~IMM_CB_RESULT_REQUIRED ;
	    if ((op < 0) || (op >= MAX_IMM_OPCODE)) {
		break;
	    }
	    t_imlg->callback_flg = 0;
	    // (*opsw[op])((XSunIMSessionIml *)t_imlg->session, i, (XEvent *)s->event);
	    session->executeHandler(op, i, (XEvent *)s->event);
	    if (i->opcode & IMM_CB_RESULT_REQUIRED) {
		if(result){
		} else {
		    result = i ;
		}
	    }
	}
	t_imlg->cell_link = cell->nlink;
	delete cell;
    }
    return result ;
}

ImChain
XSunIMSession::getImChain()
{
  XrmDatabase cmd_db = (XrmDatabase)0;
  Itt& itt = svric->getItt();

  if (htt == 0) {
    htt = new HttRec;
    memset((void *)htt, 0, sizeof(HttRec));
    htt->im = new ImChainRec;
    memset((void *)(htt->im), 0, sizeof(ImChainRec));
    htt->im->htt = htt;
    htt->app_defaults = 0;
    htt->special      = 0;
    htt->dot_rc = 0;
    htt->command_name = itt.getCommandName();
    htt->class_name = itt.getClassName();
  }
  htt->rdb = htt->cmdlines = cmd_db;
  return htt->im;
}

