/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <locale.h>
#include <fstream.h>
#include "localeservice.hh"
#include "util.hh"

/*************************************************************************
* $DESC_BEGIN
* Contructor function.
* $DESC_END
*************************************************************************/
LocaleObject::LocaleObject(char *sname, char *lname)
{
  short_name = strdup(sname);
  long_name  = strdup(lname);
}

/*************************************************************************
* $DESC_BEGIN
* destructor function.
* $DESC_END
*************************************************************************/
LocaleObject::~LocaleObject() 
{
  free(short_name);
  free(long_name);
}

/*************************************************************************
* $DESC_BEGIN
* Contructor function.
* itt member is initialized thru member initialization list.
* $DESC_END
*************************************************************************/
LocaleService::LocaleService(char *locale)
{
  name = (char *)0;
  locale_filename = (char *)0;
  setlocale(LC_ALL, locale);
  if (locale == (char*)0 || locale[0] == (char)0) {
     locale = setlocale(LC_CTYPE, (char*)0);
  }
  name = strdup(locale);

  num_locales = 0;
  // Get the locale_filename;
#ifndef LOCALE_ALIAS
#define LOCALE_ALIAS    "locale.alias"
#endif
  getLocaleFileName((char*)0, (char*)0, (char*)LOCALE_ALIAS);
  initializeCore(name);
}

/*************************************************************************
* $DESC_BEGIN
* destructor function.
* $DESC_END
*************************************************************************/ 
LocaleService::~LocaleService()
{
  free(locale_filename);
}

/*************************************************************************
* $DESC_BEGIN
* static member function to create an instance.
* $DESC_END
*************************************************************************/ 
LocaleService * LocaleService::create(char *locales) {
    LocaleService * loc = (LocaleService *)0;

    loc = new LocaleService(locales);
    return loc;
}

/*************************************************************************
* $DESC_BEGIN
* gets the locale file name
* $DESC_END
*************************************************************************/
int LocaleService::getLocaleFileName(char *dir, char *locale, char *basename)
{
#ifndef BUFSIZE
#define BUFSIZE	256
#endif
    char locale_file[BUFSIZE];
    if (!locale_filename)
       locale_filename = (char *)malloc(BUFSIZE);
    char * buf = locale_filename;
    if (locale)
        sprintf(locale_file, "%s/%s", locale, basename);
    else
        strcpy(locale_file, basename);
    
    if (dir) {
        sprintf(buf, "%s/%s", dir, locale_file);
        return 0;
    }

#ifndef XLIBI18N_PATH
#define XLIBI18N_PATH   "/usr/openwin/lib/locale"
#endif

    if (dir = getenv("XLIBI18N_PATH")) {
        sprintf(buf, "%s/%s", dir, locale_file);
        return 0;
    }
    if (dir = getenv("OPENWINHOME")) {
        sprintf(buf, "%s/lib/locale/%s", dir, locale_file);
	return 0;
    }
    sprintf(buf, "%s/%s", XLIBI18N_PATH, locale_file);

    return 0;;
}

/*************************************************************************
* $DESC_BEGIN
* gets the long name from the locale alias
* $DESC_END
*************************************************************************/
Bool LocaleService::getLongNameFromAlias(char *locale, char *name_ret) {
    char *bufptr, buf[BUFSIZE];
    int length;
    fstream fin;

    fin.open(locale_filename, ios::in);
    if (!fin)
       return False;;
    while (!fin.eof()) {
	fin.getline(buf, BUFSIZE, '\n');
        bufptr = Util::getWord(buf, &length);
        if (bufptr == 0)
           continue;
        bufptr[length] = '\0';
        if (strcmp(locale, bufptr))
           continue;

        bufptr += length + 1;
        bufptr = Util::getWord(bufptr, &length);
        if (bufptr == 0)
           continue;
           
        bufptr[length] = '\0';
        locale = bufptr;
        break;
    }

#if notdef
    if((bufptr = strrchr(locale, '.')))
	*bufptr = '\0';
#endif

    strcpy(name_ret, locale);
    fin.close();
    return True;
}

/*************************************************************************
* $DESC_BEGIN
* return a locale object for the given locale.
* $DESC_END
*************************************************************************/
LocaleObject * LocaleService::supportLocale(char *loc_name)
{
    LocaleObject * core;
    char lname[BUFSIZE];

    if (!getLongNameFromAlias(loc_name, lname))
	return ((LocaleObject *)0);
    core = new LocaleObject(loc_name, lname); 
    return core;
}

/*************************************************************************
* $DESC_BEGIN
* initialize the locale service object.
* $DESC_END
*************************************************************************/
void LocaleService::initializeCore(char *locales) {
    LocaleObject * loc = (LocaleObject *)0;
    char *p, *pp = locales;
    num_locales = 0;
    if (!locales || !(*locales)) {
        if (loc = supportLocale("")) {
	   corelist.addItem(loc);
           num_locales = 1;
	}
	return;
    } else {
    	for (;;) {
	    p = strchr(pp, ':');
	    if (p) {
		*p = 0;
	    }
	    if (loc = supportLocale(pp)) {
	       corelist.addItem(loc);
	       num_locales++;
	    }
	    if (!p) break;
	    pp = p+1;
    	}
    }
    return;
}

/*************************************************************************
* $DESC_BEGIN
* return the number of locales supported.
* $DESC_END
*************************************************************************/
int LocaleService::numberOfLocaleObject() {
    return num_locales;
}

/*************************************************************************
* $DESC_BEGIN
* Return the long name for the corresponding short name of a locale.
* $DESC_END
*************************************************************************/
char *LocaleService::getLongName(char *short_name) {
    LocaleObject * p;
    int num;
    char *long_name = (char*)0;
    int i;
    num = corelist.getSize();

    for (i = 1; i <= num; i++) {
      p = &(corelist.getItem(i));
      if (!strcmp(short_name, p->short_name)) {
	    long_name = p->long_name;
	    break;
	}
    }
    return long_name;
}

/*************************************************************************
* $DESC_BEGIN
* Return the locale name member. (in long name format)
* $DESC_END
*************************************************************************/
char *LocaleService::getLocaleName()
{
  return getLongName(name);
}

char *LocaleService::getShortName()
{
  return name;
}

/*************************************************************************
* $DESC_BEGIN
* Destroy the current instancei.
* $DESC_END
*************************************************************************/
void LocaleService::destroy() {
    corelist.destroy();
    delete this;
    return;
}
