/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <wchar.h>
#include "KeyConverter.hh"
#include "converter.hh"
#include <X11/Xlib.h>

typedef struct _ConvTablesRec {
    char *locale;
    int len;
    char *euc_encoding;
    char *utf8_encoding;
} ConvTablesRec;

static ConvTablesRec conv_entry[] = {
    {"ja", 2, "eucJP", "UTF-8"},
    {"ko", 2, "ko_KR-euc", "ko_KR-UTF-8"},
    {"zh_CN", 5, "zh_CN.euc", "UTF-8"},
    {"zh_TW", 5, "zh_TW-euc", "UTF-8"},
    {"zh", 2, "zh_CN.euc", "UTF-8"}
};

const int Converter::UTF16_STRLEN = 1024;
Converter::Converter(char *loc_name)
{
  keyconv = new KeyConverter();
  i_conv1 = NULL;
  i_conv2 = NULL;
  i_conv1_FromUTF16 = NULL;
  i_conv2_FromUTF16 = NULL;
  current_locale = (char *)0;
  int num = sizeof(conv_entry)/sizeof(conv_entry[0]);
  int i;
  for (i = 0; i < num; i++) {
    if (!strncmp(loc_name, conv_entry[i].locale,
               conv_entry[i].len)) {
       euc_encoding = strdup(conv_entry[i].euc_encoding);
       utf8_encoding = strdup(conv_entry[i].utf8_encoding);
       break;
    }
  }

}

char* Converter::encodeWcText(wchar_t *str)
{
  int wcstr_len = wcslen(str);
  char *mb_str  = (char*)0;
  int mb_len    = wcstombs(NULL, str, wcstr_len * MB_CUR_MAX);
 
  if (mb_len == -1)
    return (char*)0;
 
  mb_str = new char[mb_len + 1];
  if (mb_str == 0)
    return (char*)0;
  memset(mb_str, 0, mb_len + 1);
  if (mb_len != wcstombs(mb_str, str, mb_len)) {
    delete [] mb_str;
    return (char*)0;
  }
  return (char*)mb_str;
}

IMText *
Converter::convtoutf(char *src, XIMFeedback *feedback, int src_len)
{
 int str_length, byte_length;
 int i;
 char *dst;
 unsigned int dst_len;
 char utf16_str[UTF16_STRLEN];
 IMText * text;
 UTFCHAR first_byte, second_byte;
 UTFCHAR utfchar;

 dst = utf16_str;
 dst_len = UTF16_STRLEN;
 ConvertToUTF16(src, (unsigned int)src_len, &dst, &dst_len);
 byte_length = (UTF16_STRLEN - dst_len);
 str_length  = byte_length / 2;

 text = new IMText;
 memset(text, 0, sizeof(IMText));
 text->encoding = UTF16_CODESET;

 if (feedback != 0) {
   text->feedback = new IMFeedback[src_len];
   memset(text->feedback, 0, sizeof(IMFeedback) * src_len);
 }

 text->char_length = str_length;
 text->text.utf_chars = new UTFCHAR[str_length + 1];
 for (i = 0; i < str_length; i++) {
    UTFCHAR utfchar = utf16_str[2*i] & 0x00ff;
    utfchar = utfchar << 8;
    text->text.utf_chars[i] = utfchar | (utf16_str[2*i+1] & 0x00ff);
    if (feedback != 0) text->feedback[i] = feedback[i];
 }
 return text;
} 

XIMText *
Converter::convfromutf(IMText *src)
{
 int str_length;
 int i, len;
 char *dst;
 unsigned int dst_len;
 char *utf16_str;
 char utf16_str_src[UTF16_STRLEN];
 char *j=utf16_str_src;
 XIMText * text;

 memset(utf16_str_src, 0, sizeof(char)*(UTF16_STRLEN));

 for(i=0;i<src->char_length;i++){
	*j++=((src->text.utf_chars[i]>>8)& 0x00ff);
	*j++=(src->text.utf_chars[i] & 0x00ff);
 }
 len = j-utf16_str_src;

 utf16_str = new char[len+1];
 memset(utf16_str, 0, sizeof(char)*(len+1));

 dst = utf16_str;
 dst_len = UTF16_STRLEN;
 ConvertFromUTF16(utf16_str_src, len, &dst, &dst_len);
 str_length = (UTF16_STRLEN - dst_len);

 text = new XIMText;
 memset(text, 0, sizeof(XIMText));

 text->encoding_is_wchar = False;
 text->string.multi_byte = dst;
 text->feedback = 0;	// never used
 text->length = str_length;

 return text;
}

int
Converter::ConvertToUTF16(char *from_buf, size_t from_left,
                    char **to_buf, size_t *to_left) {
    size_t src_len, dst_len;
    char *src, *dst;
    char buffer[UTF16_STRLEN];          /* Fix me! */
    const size_t buf_len = UTF16_STRLEN;
    size_t ret = 0;
    char *source_encoding = (char*)0;
    int i;

    if(i_conv1 == (iconv_t)-1 || i_conv2 == (iconv_t)-1){
        goto done;
    }
    if(i_conv1 == NULL){
        if ((i_conv1 = iconv_open(utf8_encoding, euc_encoding))
        == (iconv_t)-1)
        goto done;
    }
    if(i_conv2 == NULL){
        if ((i_conv2 = iconv_open("UCS-2",
                              "UTF-8")) == (iconv_t)-1)
        goto done;
    }

    src = from_buf;
    src_len = (size_t)strlen(from_buf);
    dst = buffer;
    dst_len = buf_len;
    ret = iconv(i_conv1, (const char **)&src, (size_t*)&src_len,
                (char**)&dst, &dst_len);
    if (ret != 0) goto done;

    src = buffer;
    src_len = buf_len - dst_len;
    dst = *((char **)to_buf);

    ret = iconv(i_conv2, (const char**)&src, (size_t*)&src_len,
                (char**)&dst, (size_t*)to_left);
done:
    return(ret);
}

int
Converter::ConvertFromUTF16(char *from_buf, size_t from_left,
                    char **to_buf, size_t *to_left) {

    size_t src_len, dst_len;
    char *src, *dst;
    char buffer[UTF16_STRLEN];  /* Fix me! */
    const size_t buf_len = UTF16_STRLEN;
    char *source_encoding = (char *) 0;
    size_t ret = 0;
    int i;

    if (i_conv1_FromUTF16 == (iconv_t)-1 ||
        i_conv2_FromUTF16 == (iconv_t)-1) {
      goto done;
    }

    if(i_conv2_FromUTF16 == NULL){
        if ((i_conv2_FromUTF16 = iconv_open(euc_encoding, utf8_encoding))
        == (iconv_t)-1)
        goto done;
    }
    if(i_conv1_FromUTF16 == NULL){
        if ((i_conv1_FromUTF16 = iconv_open("UTF-8",
                              "UCS-2")) == (iconv_t)-1)
        goto done;
    }

    src = from_buf;
    src_len = (size_t) strlen(from_buf);
    src_len = from_left;        /* don't stop at '\0' in case of ascii */

    src = from_buf;
    dst = buffer;
    dst_len = buf_len;
    ret = iconv(i_conv1_FromUTF16, (const char**)&src, (size_t*)&src_len,
                (char**)&dst, &dst_len);
    if (ret != 0) {
        goto done;
    }
    src = buffer;
    src_len = buf_len - dst_len;
    dst = *((char **) to_buf);

    ret = iconv(i_conv2_FromUTF16, (const char**)&src, (size_t*)&src_len,
                (char**)&dst, (size_t*)to_left);
done:
    return(ret);
}

void
Converter::getXKeyEvent(IMKeyEventStruct &fev, XEvent& ev)
{
  keyconv->getXKeyEvent(fev.keyCode, fev.keyChar, fev.modifier,
			ev);
  return;
}

void
Converter::getIMKeyEvent(XEvent &ev, IMKeyEventStruct &fev) {
  keyconv->getIMKeyEvent(ev,
		       fev.keyCode, fev.keyChar, fev.modifier);
  return;
}
