/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include <stddef.h>
#include <fstream.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <stdarg.h>

#include "resource_iiimp.hh"
#include "resource.hh"
#include "imurl.hh"

#define LINE_SIZE 256

static Resourcedb rdb_items1[] = {
    {"interfacemodule", ResString, 15, 
         offsetof(ResourceStruct, if_name), (char *)"cm"},
    {"portnumber", ResInt, 10,
	offsetof(ResourceStruct, port_number), (int *)"9010"},
    {"conversionkeys", ResString, 14, 
	offsetof(ResourceStruct, conv_keys), (char *)"<Ctrl>space"},
};

IMResourceIiimp::IMResourceIiimp(char *p_classname, 
				char *p_urlpath) 
			: IMResource(p_classname, p_urlpath)
{
  int max_items = sizeof(rdb_items1)/sizeof(rdb_items1[0]);

  IMURL *url = new IMURL(urlpath); 
  memset(&resources, 0, sizeof(resources));
  initialize(rdb_items1, max_items, (char *)&resources);
  // right now we support only file protocol
#if 0
  if (url->isFileProtocol()) { 
     initialize(rdb_items1, max_items, (char *)&resources, url->getFileName());
  }
  if (!strcmp(url_proto, "http")) {
     sprintf(filename, "%s/%s", path, classname);
     getFromRemote(filename);
     initialize(rdb_items1, max_items, (char *)&resources, filename);
  }
#endif
}

IMResourceIiimp::~IMResourceIiimp() 
{
}

int IMResourceIiimp::resourceGetValues(IttResourceArg *args) 
{
  // Check if we can get the resources

  // Since we cannot get it, let the base class do it
  IMResource::resourceGetValues(args);
  return 0;
}
