/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include <stdlib.h>
#include <stddef.h>
#include <fstream.h>
#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include <stdarg.h>
#include <locale.h>

#include "resource.hh"
#if USE_RESOURCE_IIIMP
#include "resource_iiimp.hh"
#endif
#include "util.hh"
#include "CompoundString.hh"

#define LINE_SIZE 256

static Resourcedb myrdb_items[] = {
    {"lc_basiclocale", ResString, 14, 
         offsetof(ResourceStruct, locale_name), (char *)""},
#ifdef WIN32
    {"ifpath_name", ResString, 11,
	offsetof(ResourceStruct, ifpath_name), (char *)"D:\\WINNT\\System32\\iiimf"},
#else
    {"ifpath_name", ResString, 11,
	offsetof(ResourceStruct, ifpath_name), (char *)"/usr/lib/im/leif"},
#endif

    {"if", ResString, 2, offsetof(ResourceStruct, if_name), (char *)""},

    {"port", ResInt, 4,
	offsetof(ResourceStruct, port_number), (int *)"9010"},
    {"hostname", ResString, 8,
	offsetof(ResourceStruct, host_name), (char *)"localhost"},
    {"conversionkeys", ResString, 14, 
	offsetof(ResourceStruct, conv_keys), (char *)"<Ctrl>space"},
#if 0
    {"lookupLabelType", ResString, 15,
         offsetof(ResourceStruct, label_name), (char *)"numeric"},
#endif
    {"label", ResString, 5,
         offsetof(ResourceStruct, label_name), (char *)"numeric"},
    {"setTriggerOffKeys", ResNone,  17,
     offsetof(ResourceStruct, use_trigger_off), (char *)"false"},
    {"imconfig", ResString,  8,
     offsetof(ResourceStruct, imconfig), (char *)"/usr/lib/im/etc/im.config"},
    {"direct_xsunim", ResNone,  13,
     offsetof(ResourceStruct, direct_xsunim), (char *)"true"},
    {"syslog", ResNone,  6,
     offsetof(ResourceStruct, use_syslog), (char *)"false"},
    {"message_locale", ResString,  14,
     offsetof(ResourceStruct, message_locale), (char *)""},
    {"lookupRow", ResInt, 9,
     offsetof(ResourceStruct, lookup_rows), (int *)"4"},
    {"lookupColumn", ResInt, 12,
     offsetof(ResourceStruct, lookup_cols), (int *)"4"}
};

IMResource::IMResource(char *p_classname, char *p_urlpath)
{
  
  classname = strdup(p_classname);
  if (p_urlpath)
     urlpath = strdup(p_urlpath);
  else
     urlpath = strdup("/opt/SUNWiiimf/lib/locale/ja/im");	
  memset(&resources, 0, sizeof(resources));
}

IMResource::~IMResource()
{
  free(classname);
  free(urlpath);
}

IMResource&
IMResource::operator=(const IMResource& res) {
   memset(&resources, 0, sizeof(resources));
   urlpath = strdup(res.urlpath);
   classname = strdup(res.classname);
   resources.locale_name = new char[strlen(res.resources.locale_name)+1];
   strcpy(resources.locale_name, res.resources.locale_name);
#if 0
   resources.if_name = new char[strlen(res.resources.if_name)+1];
   strcpy(resources.if_name, res.resources.if_name);
#endif
   resources.ifpath_name = new char[strlen(res.resources.ifpath_name)+1];
   strcpy(resources.ifpath_name, res.resources.ifpath_name);
   resources.host_name = new char[strlen(res.resources.host_name)+1];
   strcpy(resources.host_name, res.resources.host_name);
   resources.conv_keys = new char[strlen(res.resources.conv_keys)+1];
   strcpy(resources.conv_keys, res.resources.conv_keys);
   resources.label_name = new char[strlen(res.resources.label_name)+1];
   strcpy(resources.label_name, res.resources.label_name);
   resources.imconfig = new char[strlen(res.resources.imconfig)+1];
   strcpy(resources.imconfig, res.resources.imconfig);
   resources.port_number = res.resources.port_number;
   resources.use_trigger_off = res.resources.use_trigger_off;
   resources.direct_xsunim = res.resources.direct_xsunim;
   return *this;
}
  
char *
IMResource::checkOption(char * opt_name, int argc, char **argv)
{
  int opt_len = strlen(opt_name);
  int i = 1;

  while (i < argc)
  for (i = 1; i< argc; i++)
   {
     if (!strncmp(opt_name, argv[i], opt_len))
        return argv[i+1];
   }
   return (char *)0;
}

IMResource* IMResource::create(char *classname, int argc, char **argv)
{
  IMResource *resource = (IMResource *)0;
  CompoundString * proto_name;
  char *urlpath = (char *)0;

  urlpath = IMResource::checkOption("res", argc, argv);
  // proto_name = new CompoundString(sys->getProperty(PROP_PROTONAME));
  proto_name = new CompoundString("NOTHING");
#if USE_RESOURCE_IIIMP
  if (proto_name->compare("IIIMP")) {
     resource = (IMResource *)new IMResourceIiimp(classname, urlpath); 
  } else if (proto_name->compare("XIMP")) {
     // resource = (IMResource *)new IMResourceXimp(classname, urlpath);
  } else {
     resource = (IMResource *)new IMResource(classname, urlpath);
  }
#else
  resource = (IMResource *)new IMResource(classname, urlpath);
#endif
  delete proto_name;
  resource->initialize(myrdb_items,
		       sizeof(myrdb_items)/sizeof(myrdb_items[0]),
		       (char *)&(resource->resources));
  resource->readCmdLineArgs(myrdb_items,
			    sizeof(myrdb_items)/sizeof(myrdb_items[0]),
			    (char *)&(resource->resources), argc, argv);
  return resource;
}

int IMResource::convertResValue(char * from_value, int * to_addr,
                                                void * default_value)
{
    if (from_value)
       *(int *)to_addr = atoi((const char *)from_value);
    else
       *(int *)to_addr = atoi((const char *)default_value);
    return 1;
}

int IMResource::convertResValue(char * from_value, Bool * to_addr,
                                        void * default_value)
{
    if (from_value) {
        if (!strncmp((const char*)from_value, "true", 4))
            *(Bool *)to_addr = True;
        else
            *(Bool *)to_addr = False;
    } else {
        if (!strncmp((const char *)default_value, "true", 4))
            *(Bool *)to_addr = True;
        else
            *(Bool *)to_addr = False;
    }
    return 1;
}

int IMResource::convertResValue(char * from_value, char ** to_addr,
                        void * default_value)
{
    if (from_value)
        *to_addr = from_value;
    else
        *to_addr = (char*)default_value;
    return 1;
}

void IMResource::initialize(Resourcedb * rdb_items,
                                int max_items, char * myres)
{
    /* Read the resource name and value from the file */
    int i = 0;

    // Update the resources database with default value
    for (i = 0; i < max_items; i++) {
      switch (rdb_items[i].type) {
         case ResString :
              convertResValue((char *)0,
                      (char **)(myres+rdb_items[i].offset),
                      rdb_items[i].default_value);
              break;
         case ResInt :
              convertResValue((char *)0,
                      (int *)(myres+rdb_items[i].offset),
                      rdb_items[i].default_value);
              break;
         case ResBoolean :
         case ResNone :
              convertResValue((char *)0,
                      (Bool *)(myres+rdb_items[i].offset),
                      rdb_items[i].default_value);
	      break;
      }
    }
}

void IMResource::readCmdLineArgs(Resourcedb * rdb_items,
                                int max_items, char * myres,
				int argc, char **argv)
{
    /* Read the resource name and value from the file */
    int i = 0;
    int j = 1;
    char * l_name;
    
    while (j<argc) {
      // l_name = Util::toLowerString(argv[j]);
      l_name = argv[j];
      l_name++; // skip the -		
      for (i = 0; i < max_items; i++) {
          if (!strncmp(rdb_items[i].name, l_name, rdb_items[i].len) ) {
             switch (rdb_items[i].type) {
                case ResString :
                     convertResValue((char *)argv[j+1],
                        (char **)(myres+rdb_items[i].offset),
                        rdb_items[i].default_value);
		     j++; // increment for value
                     break;
                case ResInt :
                     convertResValue((char *)argv[j+1],
                        (int *)(myres+rdb_items[i].offset),
                        rdb_items[i].default_value);
		     j++; // increment for value 
                    break;
                case ResBoolean :
                     convertResValue((char *)argv[j+1],
                        (Bool *)(myres+rdb_items[i].offset),
                        rdb_items[i].default_value);
		     j++; // increment for value
                     break;
                case ResNone :
                     convertResValue((char *)"true",
                        (Bool *)(myres+rdb_items[i].offset),
                        rdb_items[i].default_value);
                     break;
             } // switch
             i = max_items;
           } // if compare
        }
	j++;  // increment for name
   }
}

void IMResource::mergeResourceString(char *resourceString)
{
    Resourcedb * rdb_items = myrdb_items;
    int max_items = sizeof(myrdb_items)/sizeof(myrdb_items[0]);
    char * myres = (char *)&(resources);

    int index = 0;
    char *res_name, *res_val;
    char *resval_pair = (char *)0;
    int i = 0; 
    while (1) {
      resval_pair = Util::getSubString(resourceString, ",", index);
      if (!resval_pair)
         break; 
      res_name = Util::getSubString(resval_pair, ":", 0);
      res_val  = Util::getSubString(resval_pair, ":", 1);
      for (i = 0; i < max_items; i++) {
          if (!strncmp(rdb_items[i].name, res_name, rdb_items[i].len) ) {
             switch (rdb_items[i].type) {
                case ResString :
                     convertResValue((char *)res_val,
                        (char **)(myres+rdb_items[i].offset),
                        rdb_items[i].default_value);
                     break;
                case ResInt :
                     convertResValue((char *)res_val,
                        (int *)(myres+rdb_items[i].offset),
                        rdb_items[i].default_value);
                    break;
                case ResBoolean :
                     convertResValue((char *)res_val,
                        (Bool *)(myres+rdb_items[i].offset),
                        rdb_items[i].default_value);
                     break;
                case ResNone :
                     convertResValue((char *)"true",
                        (Bool *)(myres+rdb_items[i].offset),
                        rdb_items[i].default_value);
                     break;
             } // switch
             i = max_items;
           } // if compare
        }
	index++;  // increment for name
   }
}

#if USE_RESOURCE_IIIMP
void IMResource::initialize(Resourcedb* rdb_items, int max_items,
			    char *myres, char * filename)
{
    /* Read the resource name and value from the file */
    fstream fin;
    char fLine[LINE_SIZE];
    char name[80], value[80];
    int i = 0;
    char * l_name;

    fin.open(filename, ios::in);
    if (!fin)
       return;
    while (!fin.eof()) {
        fin.getline(fLine, LINE_SIZE, '\n');
        sscanf(fLine, "%[^:]%*c%s", name, value);
        /* Go thru the rdb_items and get the field_value */
        l_name = Util::toLowerString(name);
        for (i = 0; i < max_items; i++) {
           if (!strncmp(rdb_items[i].name, l_name, rdb_items[i].len) ) {
              switch (rdb_items[i].type) {
                case ResString :
                     convertResValue((char *)value,
                        (char **)(myres+rdb_items[i].offset),
                        rdb_items[i].default_value);
                     break;
                case ResInt :
                     convertResValue((char *)value,
                        (int *)(myres+rdb_items[i].offset),
                        rdb_items[i].default_value);
                     break;
                case ResBoolean :
                case ResNone :
                     convertResValue((char *)value,
                        (Bool *)(myres+rdb_items[i].offset),
                        rdb_items[i].default_value);
                     break;
             }
             i = max_items;
           }
        }
        free(l_name);
   }
   fin.close();
}
#endif

int IMResource::resourceGetValues(IttResourceArg *args) {
    IttResourceArg *p;

    for (p = args; p->name != (int)0; p++) {
        switch (p->name) {
          case RDB_IF_LIST:
        {
            char **pp = (char**)p->value;
            *pp = new char[strlen(resources.if_name) + 1];
            if (!*pp) return RDB_IF_LIST;
            strcpy(*pp, resources.if_name);
            break;
        }
          case RDB_IMCONFIG:
        {
            char **pp = (char**)p->value;
            *pp = new char[strlen(resources.imconfig) + 1];
            if (!*pp) return RDB_IMCONFIG;
            strcpy(*pp, resources.imconfig);
            break;
        }
          case RDB_IFPATH_NAME:
        {
            char **pp = (char**)p->value;
	    *pp = new char[strlen(resources.ifpath_name) + 1];
            if (!*pp) return RDB_IFPATH_NAME;
            strcpy(*pp, resources.ifpath_name);
            break;
        }
          case RDB_HOST_NAME:
        {
            char **pp = (char**)p->value;
            *pp = new char[strlen(resources.host_name) + 1];
            if (!*pp) return RDB_HOST_NAME;
            strcpy(*pp, resources.host_name);
            break;
        }
          case RDB_LOCALE_NAME:
	  case RDB_SUPPORTED_LOCALES:
	    {
	      char **pp = (char**)p->value;

	      if (setlocale(LC_CTYPE, resources.locale_name) == NULL) {
		setlocale(LC_CTYPE, "C");
	      }
	      resources.locale_name = strdup(setlocale(LC_CTYPE, NULL));
	      *pp = new char[strlen(resources.locale_name) + 1];
	      if (!*pp) return RDB_LOCALE_NAME;
	      strcpy(*pp, resources.locale_name);
	      break;
	    }
          case RDB_PORT_NUMBER:
            *((int*)(p->value)) = resources.port_number;
            break;
          case RDB_CONV_ON_KEY:
        {
            char **pp = (char**)p->value;
            *pp = new char[strlen(resources.conv_keys) + 1];
            if (!*pp) return RDB_CONV_ON_KEY;
            strcpy(*pp, resources.conv_keys);
            break;
        }
          case RDB_DIRECT_XSUNIM:
            *((Bool*)(p->value)) = resources.direct_xsunim;
            break;
          case RDB_USE_TRIGGER_OFF:
            *((Bool*)(p->value)) = resources.use_trigger_off;
            break;
	  case RDB_MESSAGE_SYSLOG:
	    *((int*)(p->value)) = resources.use_syslog;
            break;
	  case RDB_MESSAGE_LOCALE:
	    {
	      char **pp = (char**)p->value;
	      *pp = new char[strlen(resources.message_locale) + 1];
	      if (!*pp) return RDB_MESSAGE_LOCALE;
	      strcpy(*pp, resources.message_locale);
	      break;
	    }
            break;
          case RDB_LOOKUP_LABEL_TYPE:
	    {	
	      if (!strcmp(resources.label_name, "upper")) {
		*((int*)(p->value)) = RmUpper;
	      } else if (!strcmp(resources.label_name, "number") ||
			 !strcmp(resources.label_name, "numeric")) {
		*((int*)(p->value)) = RmNumeric;
	      } else {
		*((int*)(p->value)) = RmLower;
	      }
	    }
	    break;
          case RDB_LOOKUP_NROWS:
            *((int*)(p->value)) = resources.lookup_rows;
            break;
          case RDB_LOOKUP_NCOLUMNS:
            *((int*)(p->value)) = resources.lookup_cols;
            break;
          default:
            break;
        }
    }
    return (int)0;
}

int IMResource::resourceSetValues(IttResourceArg *args) {
    return (int)0;
}

void IMResource::destroy()
{
  delete this;
}
