#ifndef lint
#ident	"@(#)XSunIMTransP.h	2.5	94/08/08 SMI"
#endif

/******************************************************************

              Copyright 1990, 1991, by Sun Microsystems, Inc.

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and
that both that copyright notice and this permission notice appear
in supporting documentation, and that the name of Sun Microsystems, Inc.
not be used in advertising or publicity pertaining to distribution
of the software without specific, written prior permission.
Sun Microsystems, Inc. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without
express or implied warranty.

Sun Microsystems Inc. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
IN NO EVENT SHALL Sun Microsystems, Inc. BE LIABLE FOR ANY SPECIAL, INDIRECT
OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
OR PERFORMANCE OF THIS SOFTWARE.

                                             Sun Microsystems, Inc.
******************************************************************/

#ifndef	_XSunTransP_DEFINED
#define	_XSunTransP_DEFINED

#include <X11/Xresource.h>

#ifdef  __cplusplus
extern "C" {
#endif

typedef char   *String;

typedef int     Cardinal;

typedef Bool Boolean;


/*
 * Binding Result Table Definitions
 */
typedef struct _CompiledAction {
    XrmQuark        signature;
    IMActionProc    proc;
}               CompiledAction, *CompiledActionTable;

/*
 * Reserved Event Table Definitions
 */
typedef struct _ReserveEvent {
    int             n_events;
    XEvent         *events;
}               ReserveEvent;

typedef struct _TranslationData *XtTranslations;

typedef struct _XtTMRec {
    XtTranslations  translations;	/* private to
					 * Translation Manager    */
    /* XtBoundActions  proc_table; */	/* procedure bindings for
				 * actions    */
    struct _XtStateRec *current_state;	/* Translation Manager
					 * state ptr     */
    unsigned long   lastEventTime;
}               XtTMRec, *XtTM;

/*
 * Action Table Definitions
 */
typedef struct _IMActionTableRec {
    CompiledActionTable	action_table;
    int			num_actions;
}               IMActionTableRec;

/*
 * Binding Table Definitions
 */
typedef struct _IMBindTableRec {
    XtTM           *binding_table;
    IMTMid         *indicate_binding_table;
    int             num_binding_table;
    ReserveEvent    reserve_event;
}               IMBindTableRec;

#if defined(__STDC__)
extern Bool     XimTMInitializeTM(void);
extern void     XimTMDestroyTM(void);
extern IMBindTable XimTMInitBindingTable(void);
extern void     XimTMDestroyBindingTable(IMBindTable, Bool);
extern Bool     XimTMParseTranslation(IMBindTable, char *, IMTMid *);
extern Bool     XimTMParseIDTranslation(IMBindTable, IMTMid, IMTMid *);
extern void     XimTMDestroyTranslation(IMBindTable, IMTMid);
extern IMActionTable XimTMAddActionsTable(IMActionsList, int);
extern void     XimTMDestroyActionsTable(IMActionTable);
extern int      XimTMLookupBinding(XEvent *, IMBindTable, IMActionTable,
		    IMTMid, IMBindResult *);
extern void     XimTMDestroyBindResult(IMBindResult *);
extern void     XimTMResetBinding(IMBindTable, IMTMid);

#else

extern Bool     XimTMInitializeTM();
extern void     XimTMDestroyTM();
extern IMBindTable     XimTMInitBindingTable();
extern void     XimTMDestroyBindingTable();
extern Bool     XimTMParseTranslation();
extern Bool     XimTMParseIDTranslation();
extern void     XimTMDestroyTranslation();
extern IMActionTable   XimTMAddActionsTable();
extern void     XimTMDestroyActionsTable();
extern int      XimTMLookupBinding();
extern void     XimTMDestroyBindResult();
extern void     XimTMResetBinding();

#endif				/* __STDC__ */

#ifdef  __cplusplus
}
#endif

#endif				/* _XSunTransP_DEFINED */
