#ifndef lint
#ifdef sccs
static char     sccsid[] = "@(#)XSunIMMthd.h	2.7 94/08/08 SMI";
#endif
#endif

/******************************************************************

              Copyright 1990, 1991, 1992 by Sun Microsystems, Inc.

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and
that both that copyright notice and this permission notice appear
in supporting documentation, and that the name of Sun Microsystems, Inc.
not be used in advertising or publicity pertaining to distribution
of the software without specific, written prior permission.
Sun Microsystems, Inc. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without
express or implied warranty.

Sun Microsystems Inc. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
IN NO EVENT SHALL Sun Microsystems, Inc. BE LIABLE FOR ANY SPECIAL, INDIRECT
OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
OR PERFORMANCE OF THIS SOFTWARE.

  Author: Hideki Hiura (hhiura@Sun.COM)
	  				     Sun Microsystems, Inc.
******************************************************************/

#ifndef  XSUNIMMTHD_H
#define  XSUNIMMTHD_H

typedef struct _iml_session *iml_session;
typedef struct _iml_if_t *iml_if;
typedef struct _iml_aux_t *iml_aux;
typedef struct _IMActionTableRec *IMActionTable;
typedef struct _IMBindTableRec *IMBindTable;
typedef int IMTMid;

typedef struct _iml_methods {
    /*
     * drawing methods
     */
    iml_inst *	   (*iml_make_preedit_start_inst)(iml_session);
    iml_inst *	   (*iml_make_preedit_draw_inst)(
#ifndef NO_COLOR_FEEDBACK
						 iml_session,
						 wchar_t*,
						 XIMFeedback*,
						 XIMTextColorFeedback*,
						 XIMTextColorFeedback*
#else
						 iml_session,
						 wchar_t*,
						 XIMFeedback*
#endif
						 );
    iml_inst *	   (*iml_make_preedit_erase_inst)(iml_session);
    iml_inst *	   (*iml_make_preedit_caret_inst)(iml_session);
    iml_inst *	   (*iml_make_preedit_done_inst)(iml_session);
    iml_inst *	   (*iml_make_status_start_inst)(iml_session);
    iml_inst *	   (*iml_make_status_draw_inst)(
#ifndef NO_COLOR_FEEDBACK
						iml_session
						wchar_t*,
						XIMFeedback*,
						XIMTextColorFeedback*,
						XIMTextColorFeedback*
#else
						iml_session,
						wchar_t*,
						XIMFeedback*
#endif
						);
    iml_inst *	   (*iml_make_status_done_inst)(iml_session);
    iml_inst *	   (*iml_make_lookup_start_inst)(iml_session);
    iml_inst *	   (*iml_make_lookup_draw_inst)(iml_session,
						unsigned char**,
						int);
    iml_inst *	   (*iml_make_lookup_process_inst)(iml_session,
						   Bool, int);
    iml_inst *	   (*iml_make_lookup_done_inst)(iml_session);
    /*
     * 
     */
    iml_inst *	   (*iml_make_status_notify_inst)(iml_session);
    iml_inst *	   (*iml_make_nop_inst)(iml_session);
    iml_inst *	   (*iml_make_commit_inst)(iml_session,
					   int, unsigned char*);
    iml_inst *     (*iml_make_keypress_inst)(iml_session, char*);
    iml_inst *     (*iml_make_reset_return_inst)(iml_session,
						 int, unsigned char *);
    iml_inst *     (*iml_execute)(iml_session, iml_inst**);
    /*
     * convenient methods
     */
    int		   (*iml_lookupString)(XKeyEvent*, char*, int, KeySym*);
    iml_inst  	  *(*iml_link_inst_tail)(iml_inst**, iml_inst*);
    void	   (*iml_destruct_session)(iml_session,
					   int(*)(iml_session));
    void          *(*iml_construct_session)(iml_if, void*, int, int,
					    int (*)(int, iml_session, int));
    		/* actual return value is iml_session */
    /*
     * Translation Manager
     */
    Bool           (*iml_tm_init_translation_manager)(void);
    Bool           (*iml_tm_init_binding_table)(iml_session,
						IMBindTable*);
    void           (*iml_tm_destroy_binding_table)(iml_session,
						   IMBindTable,
						   Bool);
    Bool           (*iml_tm_parse_translation)(iml_session,
					       IMBindTable,
					       char*,
					       IMTMid*);
    Bool           (*iml_tm_parse_id_translation)(iml_session,
						  IMBindTable,
						  IMTMid, IMTMid*);
    void           (*iml_tm_destroy_translation)(iml_session,
						 IMBindTable,
						 IMTMid);
    Bool           (*iml_tm_add_action_table)();
    void           (*iml_tm_destroy_action_table)();
    int            (*iml_tm_lookup_binding)();
    void           (*iml_tm_destroy_binding_result)();
    void           (*iml_tm_reset_binding_state)();

    /* AUX */
    iml_inst *	   (*iml_make_aux_start_inst)(iml_session, iml_aux);
    iml_inst *	   (*iml_make_aux_draw_inst)(iml_session, iml_aux);
    iml_inst *	   (*iml_make_aux_done_inst)(iml_session, iml_aux);
} iml_methods_t ;
/*
 * NOTE:
 * iml_methods $B$O!"(Bs->If->m $B$GD>@\;2>H$G$-$k$N$G(B override $B$O!"(B
 * register $B4X?t$r;H$o$:!"D>@\$*$3$J$&!#(B
 */

typedef struct _if_methods {
    Bool                (*if_OpenIF)(iml_if, char*, void*);
    Bool                (*if_CloseIF)(iml_if);
    Bool                (*if_GetIFValue)(iml_if, char*, void*);
    Bool                (*if_SetIFValue)(iml_if, char*, void*);
    void               *(*if_CreateSC)(iml_if, void*, char*);
    Bool                (*if_DestroySC)(iml_session);
    Bool                (*if_SetSCValue)(iml_session, char*, void*);
    Bool                (*if_GetSCValue)(iml_session, char*, void*);
    char               *(*if_ResetSC)(iml_session);
    void                (*if_SetSCFocus)(iml_session);
    void                (*if_UnsetSCFocus)(iml_session);
    void                (*if_SendEvent)(iml_session, XKeyEvent*);
    Bool                (*if_FilterEvent)(XEvent*);
    void                (*if_SetAuxValues)(iml_session,
					   XIMAuxDrawCallbackStruct*);
} if_methods_t ;
/*
 * NOTE:
 * if_*Value() $B4X?t$O!"$=$NL>$NDL$j!"0l2s$K0l$D$N(B value $B$7$+(B
 * get/set $B$G$-$J$$(B
 */

typedef struct _extended_if {
    if_methods_t   *pre;
    if_methods_t   *post;
    char 	    *if_name;
} if_ext;

/*
 * Per interface data structure
 */
typedef struct _iml_if_t {
    int               ref_count ; 
    struct _iml_if_t *next ;
    void             *im ; /* should be casted to im_t */
    char             *if_name ;
    char             *if_version ;
    char             *locale ;
    if_methods_t     *ifm ;
    iml_methods_t    *m ;
    void             *if_spec ; /* pointer to the interface specific data */
    if_ext	     *ext;
} iml_if_t ;

/*  
 *  Hook for the external module to get status
 *  change notification.
 */

typedef struct _sc_callback {
    void    (*callback)();
    void     *client_data;
} IFCallback;

typedef struct _SCStatusChangeCallbackData {
    unsigned long   status;
    void    *opt;
} SCStatusChangeCallbackData;

#define IS_PRE_FUNC_VALID(If, method) (If->ext && If->ext->pre && If->ext->pre->method)
#define IS_POST_FUNC_VALID(If, method) (If->ext && If->ext->post && If->ext->post->method)

/*
 * XXXXXXX For backword source compatibility.
 */
#define _iml_make_preedit_start_inst(a)      s->if->m->iml_make_preedit_start_inst(a)
#define _iml_make_preedit_draw_inst()        s->if->m->iml_make_preedit_draw_inst()
#define _iml_make_preedit_erase_inst(a)      s->if->m->iml_make_preedit_erase_inst(a)
#define _iml_make_preedit_caret_inst(a)      s->if->m->iml_make_preedit_caret_inst(a)
#define _iml_make_preedit_done_inst(a)       s->if->m->iml_make_preedit_done_inst(a)
#define _iml_make_status_start_inst(a)       s->if->m->iml_make_status_start_inst(a)
#define _iml_make_status_draw_inst()         s->if->m->iml_make_status_draw_inst()
#define _iml_make_status_caret_inst()        s->if->m->iml_make_status_caret_inst()
#define _iml_make_status_done_inst(a)        s->if->m->iml_make_status_done_inst()
#define _iml_make_lookup_start_inst(a)       s->if->m->iml_make_lookup_start_inst(a)
#define _iml_make_lookup_draw_inst()         s->if->m->iml_make_lookup_draw_inst()
#define _iml_make_lookup_process_inst(a,b,c) s->if->m->iml_make_lookup_process_inst(a,b,c)
#define _iml_make_lookup_done_inst(a)        s->if->m->iml_make_lookup_done_inst(a)
#define _iml_make_set_status_inst(a)         s->if->m->iml_make_status_notify_inst(a)
#define _iml_make_nop_inst(a)                s->if->m->iml_make_nop_inst(a)
#define _iml_make_commit_inst(a)             s->if->m->iml_make_commit_inst(a)
#define _iml_get_session(a)                  s->if->m->iml_get_session(a)
#define _iml_lookupKanaString(a,b,c,d)       s->if->m->iml_lookupKanaString(a,b,c,d)
#define _iml_link_inst_tail(a,b)             s->if->m->iml_link_inst_tail(a,b)
#define _iml_destruct_session(a,b,c)         s->if->m->iml_destruct_session(a,b,c)

/*
 * if_GetIFValue()/if_SetIFValue() attributes
 */
#define IF_VERSION		"if_version"
#define IF_LE_NAME		"if_le_name"
#define IF_STATUS_CALLBACK	"if_status_callback"
#define IF_LE_NENGINES          "if_le_nengines"
#define IF_LE_LIST              "if_le_list"
#define IF_LE_CURRENT           "if_le_current"
#define IF_QUERY_VAR_LIST       "if_query_var_list"
#define IF_IMS_RDB              "if_ims_rdb"
#define IF_IMS_APP_DEFAULTS     "if_ims_app_defaults"
#define IF_IMS_COMMAND_NAME     "if_ims_command_name"
#define IF_IMS_COMMAND_CLASS    "if_ims_command_class"
/*
 * if_GetSCValue()/if_SetSCValue() attributes
 */
#define SC_STATUS		"sc_status"
#define SC_Henkan_Mode		"sc_henkan_mode"
#define SC_MODIFIER_MASK	"modifier_mask"
#define SC_QUERY_VAR_LIST       "sc_query_var_list"
#define SC_IC_SCREEN_NUMBER     "sc_ic_screen_number"

#define	SC_Lookup_info		"sc_lookup_info"
#define SC_lookup_imscontrol	"sc_lookup_imscontrol"
#define	SC_lookup_root		"sc_lookup_root"
#define SC_lookup_whoownslabel	"sc_lookup_whoownslabel"
#define	SC_lookup_labeltype	"sc_lookup_labeltype"
#define	SC_lookup_nchoices	"sc_lookup_nchoices"
#define	SC_lookup_rootwidth	"sc_lookup_rootwidth"
#define	SC_lookup_lines		"sc_lookup_nlines"
#define	SC_lookup_ewidth	"sc_lookup_ewidth"
#define	SC_lookup_cwidth	"sc_lookup_cwidth"
#define	SC_lookup_ncols		"sc_lookup_ncols"
#define	SC_lookup_nrows		"sc_lookup_nrows"
#define SC_lookup_direction	"sc_lookup_direction"
#define	SC_nego_flush		"sc_nego_flush"
#define SC_nego_data		"sc_nego_data"
#define SC_user_name		"userName" /* jsi.so looks at this */
#define SC_protocol_name	"sc_protocol_name"

#endif  /*  XSUNIMMTHD_H */
