/******************************************************************

              Copyright 1990, 1991, by Sun Microsystems, Inc.

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and
that both that copyright notice and this permission notice appear
in supporting documentation, and that the name of Sun Microsystems, Inc.
not be used in advertising or publicity pertaining to distribution
of the software without specific, written prior permission.
Sun Microsystems, Inc. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without
express or implied warranty.

Sun Microsystems Inc. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
IN NO EVENT SHALL Sun Microsystems, Inc. BE LIABLE FOR ANY SPECIAL, INDIRECT
OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
OR PERFORMANCE OF THIS SOFTWARE.

  Author: Hideki Hiura (hhiura@Sun.COM)
	  				     Sun Microsystems, Inc.
******************************************************************/

#ifndef lint
#ident  "@(#)XSunIMConf.c	2.13    94/08/08 SMI"
#endif

#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dlfcn.h>
#include <X11/X.h>
#include <X11/Xlib.h>
#if XlibSpecificationRelease < 5
#include <X11/XlibR5.h>
#endif /* XlibSpecificationRelease */
#include "XSunExt.h"
#include <X11/keysym.h>
#include "XSunIMProt.h"
#include "XSunIMMMan.h"
#include "XSunIMMthd.h"
#include "XSunIMPriv.h"
#include "XSunIMCore.h"
#include "XSunIMPub.h"

#ifdef SVR4
#include <libintl.h>
#endif /* SVR4 */

#ifndef DYNAMICIF

#ifndef SVR4
#define SJ3
#endif

typedef struct _iml_le_sw {
    char *if_name ;
    if_methods_t *m ;
} iml_le_sw_t ;

#ifdef CM
extern if_methods_t cm_methods;
#endif
#ifdef WNN403
extern if_methods_t wnn4_methods;
#endif
#ifdef CIO
extern if_methods_t cio_methods;
#endif
#ifdef SJ3
extern if_methods_t sj3_methods;
#endif
#ifdef canna
extern if_methods_t canna_method;
#endif

Private iml_le_sw_t iml_le_sw[]={
#ifdef CM
    {"cm", &cm_methods },
#endif
#ifdef WNN403
    {"wnn4", &wnn4_methods },
#endif
#ifdef CIO
    {"cio", &cio_methods },
#endif
#ifdef SJ3
    {"sj3", &sj3_methods },
#endif
#ifdef canna
    {"canna", &canna_methods },
#endif
    {"", NULL}
};
#define HOW_MANY_LES_STATICALLY_ATTACHED   (sizeof(iml_le_sw) / sizeof(iml_le_sw_t))

#endif /* ifndef DYNAMICIF */

#define IFPATH "HTT_LIBRARY_PATH"
#ifdef _POSIX_PATH_MAX
#define PATHNAME_MAX _POSIX_PATH_MAX
#else
#define PATHNAME_MAX 1024
#endif
#define SYMNAME_MAX 255

Private char *ow_home_default="/usr/openwin" ;
Public iml_methods_t *_iml_dup_iml_methods();
Public char *getenv();
extern char       *GetStringDefault();

#ifndef ITT_PROTOTYPE
Private void ext_if_configure();
#endif

/*
 * if_configure $B$O!"(B1 interface $B$K$D$-!"(Blocale $B$4$H$K(B 1 $B2s$N$_8F$P$l$k!#(B
 */
Public Bool
if_configure(If, if_method_name, locale, im)
iml_if_t *If ;
char *if_method_name ;
char *locale ;
void  *im ;
{
    char *ow_home ;
    char if_path[PATHNAME_MAX] ;
    char if_entry[SYMNAME_MAX] ;
    void *if_so = (void *)NULL;
    register i = 0;
    char *if_name;
    char *method_name;
    char *dup_if_method_name;

    dup_if_method_name = strdup(if_method_name);

    if_name = dup_if_method_name;
    method_name = strstr(dup_if_method_name, ":");
    if (!method_name) {
      method_name = if_name;
    } else {  
      *method_name = '\0';
      method_name++;
      if (*method_name == '\0')
        method_name = if_name;
    }
    for (i=0 ; i<HOW_MANY_LES_STATICALLY_ATTACHED ; i++){
	if(!strcmp(iml_le_sw[i].if_name, if_name)){
	    If->ifm = iml_le_sw[i].m ;
	    goto Found;
	}
    }
    /*
     * Fall down to search dynamic if
     */
    if((ow_home = getenv("OPENWINHOME")) == NULL)
        ow_home = ow_home_default ;
    sprintf(if_path, "%s/lib/locale/%s/xim/%s.so", ow_home, locale, if_name);
    if_so = dlopen(if_path, RTLD_LAZY);
    if(if_so == NULL){
        sprintf(if_path, "%s/lib/locale/common/xim/%s.so", ow_home, if_name);
        if_so = dlopen(if_path, RTLD_LAZY);
	if(if_so == NULL){
	    sprintf(if_path, "%s/lib/locale/%s/htt/%s.so", ow_home, locale, if_name);
	    if_so = dlopen(if_path, RTLD_LAZY);
	}
    }
    if(if_so){
        sprintf(if_entry, "%s_methods", method_name);
        If->ifm = dlsym(if_so, if_entry);
    }
    free(dup_if_method_name);
    if(!if_so || !If->ifm ){
#ifdef VERBOSE
#ifdef SVR4
        fprintf(stderr, dgettext("SUNW_XIM_HTT_MSG", "Fatal error in dynamic LE i/f loader -  A library is missing in your system. Please call your system administrator.\n"));
#else /* SVR4 */
        fprintf(stderr, "Fatal error in dynamic LE i/f loader -  A library is missing in your system. Please call your system administrator.\n");
#endif /* SVR4 */
#endif /* VERBOSE */
	return False ;
    }
Found:    
#ifndef ITT_PROTOTYPE
    ext_if_configure(If, ow_home, locale, im);
#endif
    
    If->m = _iml_dup_iml_methods();
    if(If->ifm->if_OpenIF(If, locale, im) == False){
	return False ;
    }
    if(If->ifm->if_GetIFValue(If, IF_VERSION, &If->if_version) == True){
/*
 * Following messages are hibernated.
 */
#ifdef SVR4
/*	printf(dgettext("SUNW_XIM_HTT_MSG","htt: Language Engine I/F \"%s\" version %s for locale %s is attached.\n"), */
#else /* SVR4 */ 
/*        printf("htt: Language Engine I/F \"%s\" version %s for locale %s is attached.\n", */
#endif /* SVR4 */
#ifdef DEBUG
#ifdef DYNAMICIF
/*	       if_path, */
#else
/*	       if_name, */
#endif
#else
/*	       if_name, */
#endif	
/*	       If->if_version, locale); */
    } else {
#ifdef SVR4
/*	printf(dgettext("SUNW_XIM_HTT_MSG","htt: Language Engine I/F %s for the locale %s is attached\n"), */
#else /* SVR4 */
/*        printf("htt: Language Engine I/F %s for the locale %s is attached\n", */
#endif /* SVR4 */
#ifdef DEBUG
#ifdef DYNAMICIF
/*	       if_path, */
#else
/*	       if_name, */
#endif
#else
/*	       if_name, */
#endif	
/*	       locale); */
    }
    return True ;
}	

#ifndef ITT_PROTOTYPE
Private void
ext_if_configure(If, ow_home, locale, im)
iml_if_t *If ;
char *ow_home;
char *locale ;
void *im;
{
    char *if_dir = (char *)NULL;
    char if_path[PATHNAME_MAX] ;
    char if_entry[SYMNAME_MAX] ;
    void *if_so = (void *)NULL;
    char *ext_name;
    IFCallback *statuscb;
    Bool       cb_registered = False;

    If->ext = (if_ext *)0;
/*
    ext_name = 
	GetStringDefault("extension_if_name", "Extension_if_name", (char *)0);
*/
    if(!ext_name){
        if ((ext_name = (char *)getenv("HTT_EXTENSION_IF_NAME")) == NULL) {
		return;
        }
    }

    sprintf(if_path, "%s/lib/locale/%s/xim/%s.so", ow_home, locale, ext_name);
    if_so = dlopen(if_path, RTLD_LAZY);
    if(if_so == NULL){
        sprintf(if_path, "%s/lib/locale/common/xim/%s.so", ow_home, ext_name);
        if_so = dlopen(if_path, RTLD_LAZY);
    }

    if(if_so){
	If->ext = (if_ext *)malloc(sizeof(if_ext));
	If->ext->if_name = strdup(ext_name);

        sprintf(if_entry, "%s_ext_pre_methods", ext_name);
        If->ext->pre = dlsym(if_so, if_entry);
	
        sprintf(if_entry, "%s_ext_post_methods", ext_name);
        If->ext->post = dlsym(if_so, if_entry);

	if(!If->ext->pre && !If->ext->post) {
		free(If->ext->if_name);
		free(If->ext);
		If->ext = (if_ext *)0;
		dlclose(if_so);
	}
    }
	
    if(IS_PRE_FUNC_VALID(If, if_OpenIF))
    	If->ext->pre->if_OpenIF(If, locale, im); 
    if(IS_POST_FUNC_VALID(If, if_OpenIF))
    	If->ext->post->if_OpenIF(If, locale, im); 

    if(IS_PRE_FUNC_VALID(If, if_GetIFValue)) 
	cb_registered = 
		If->ext->pre->if_GetIFValue(If, IF_STATUS_CALLBACK, &statuscb);
    if(!cb_registered && IS_POST_FUNC_VALID(If, if_GetIFValue))
	cb_registered = 
		If->ext->post->if_GetIFValue(If, IF_STATUS_CALLBACK, &statuscb);
	
    if(cb_registered)
	If->ifm->if_SetIFValue(If, IF_STATUS_CALLBACK, statuscb);
}	
#endif /* ITT_PROTOTYPE */

