#ifndef lint
#ident	"@(#)XSunIM.c	2.9    94/08/08 SMI"
#endif
/******************************************************************

              Copyright 1990, 1991, by Sun Microsystems, Inc.

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and
that both that copyright notice and this permission notice appear
in supporting documentation, and that the name of Sun Microsystems, Inc.
not be used in advertising or publicity pertaining to distribution
of the software without specific, written prior permission.
Sun Microsystems, Inc. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without
express or implied warranty.

Sun Microsystems Inc. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
IN NO EVENT SHALL Sun Microsystems, Inc. BE LIABLE FOR ANY SPECIAL, INDIRECT
OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
OR PERFORMANCE OF THIS SOFTWARE.

  Author: Hideki Hiura (hhiura@Sun.COM)
	  				     Sun Microsystems, Inc.
******************************************************************/
#include <stdio.h>
#include <stdlib.h>

#ifdef X_LOCALE
#include <X11/Xlocale.h>
#else
#include <locale.h>
#endif
#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/keysym.h>
#include <X11/Xutil.h>
#include <pwd.h>
#include <grp.h>
#include <string.h>
#if XlibSpecificationRelease < 5 
#include <X11/XlibR5.h> 
#endif /* XlibSpecificationRelease */

#include "XSunExt.h"
#include "XSunIMProt.h"
#include "XSunIMPriv.h"   
#include "XSunIMMMan.h"   
#include "XSunIMMthd.h"   
#include "XSunIMCore.h"   
#include "XSunIMPub.h"

extern Bool if_configure(iml_if_t *, char*, char*, void *);
extern iml_inst* iml_execute(iml_session_t*, iml_inst**);

Private iml_if_t *if_terminal = NULL ;
/*
 * 
 */
Public iml_if_t *
if_OpenIF(if_name, locale, im)
char * if_name ; 
char * locale ;
void *im ;
{
    iml_if_t *If = if_terminal ;
    iml_if_t *pIf = if_terminal ;

    if(If){
	for(;If;pIf=If,If=If->next){
	    if(!strcmp(If->if_name, if_name) && !strcmp(If->locale, locale)) {
		return If ;
	    }
	}
	If = pIf->next = (iml_if_t*)calloc(sizeof(iml_if_t),1);
	if(if_configure(If, if_name, locale,im) == False){
	    free(If);
	    If = pIf->next = NULL ;
	} else {
	    If->im = im ;
	    If->locale = strdup(locale);
	    If->if_name = strdup(if_name);
	    If->ref_count ++ ;
	}
	return If ;
    } else {
	if_terminal = (iml_if_t*)calloc(sizeof(iml_if_t),1);
	if(if_configure(if_terminal, if_name, locale, im) == False){
	    free(if_terminal);
	    if_terminal = NULL ;
	} else {
	    if_terminal->im = im ;
	    if_terminal->locale = strdup(locale);
	    if_terminal->if_name = strdup(if_name);
	    if_terminal->ref_count = 1 ;
	}
	return if_terminal ;
    }
}

Public void
if_CloseIF(if_to_be_closed)
iml_if_t *if_to_be_closed ;
{
    iml_if_t *If = if_terminal ;
    iml_if_t *pIf = if_terminal ;

    if(If){
	for(;If;pIf=If,If=If->next){
	    if(If == if_to_be_closed) {
		if(If->ref_count <= 1){
		    if(If->next){
			pIf->next = If->next ;
		    } else {
			pIf->next = NULL ;
		    }
		    if(IS_PRE_FUNC_VALID(If, if_CloseIF))
			If->ext->pre->if_CloseIF(If);
		    If->ifm->if_CloseIF(If);
		    if(IS_POST_FUNC_VALID(If, if_CloseIF))
			If->ext->post->if_CloseIF(If);
		    free(If) ;
		} else {
		    If->ref_count-- ;
		}
	    }
	}
    }
}

Public Bool
if_GetIFValue(If, attr, value)
iml_if_t *If ;
char *attr ;
caddr_t value ;
{
    Bool  ret;

    if(IS_PRE_FUNC_VALID(If, if_GetIFValue))
	If->ext->pre->if_GetIFValue(If, attr, value);
    ret = If->ifm->if_GetIFValue(If, attr, value);
    if(IS_POST_FUNC_VALID(If, if_GetIFValue))
	If->ext->post->if_GetIFValue(If, attr, value);

    return ret;
}

Public Bool
if_SetIFValue(If, attr, value)
iml_if_t *If ;
char *attr ;
caddr_t value ;
{
    Bool  ret;

    if(IS_PRE_FUNC_VALID(If, if_SetIFValue))
	If->ext->pre->if_SetIFValue(If, attr, value);
    ret = If->ifm->if_SetIFValue(If, attr, value);
    if(IS_POST_FUNC_VALID(If, if_SetIFValue))
	If->ext->post->if_SetIFValue(If, attr, value);

    return ret;
}

/*
 * if $B$K$*$1$k(B session context $B$K(B ic $B$r(B bind $B$7$F(B session id $B$rF@$k(B
 */
Public iml_session_t *
if_CreateSC(If, ic, le_name)
iml_if_t *If ;
void *ic ;
char *le_name ;
{
    iml_session_t  *ret;

    if(IS_PRE_FUNC_VALID(If, if_CreateSC))
	If->ext->pre->if_CreateSC(If, ic, le_name);
    ret = If->ifm->if_CreateSC(If, ic, le_name);
    if(IS_POST_FUNC_VALID(If, if_CreateSC))
	If->ext->post->if_CreateSC(If, ic, le_name);

    return ret;
}

Public Bool
if_DestroySC(s)
iml_session_t *s ;
{
    if(s){
	Bool ret;
 	_iml_delete(s);	

	if(IS_PRE_FUNC_VALID(s->If, if_DestroySC))
		s->If->ext->pre->if_DestroySC(s);
	ret = s->If->ifm->if_DestroySC(s);
	if(IS_POST_FUNC_VALID(s->If, if_DestroySC))
		s->If->ext->post->if_DestroySC(s);
	if(s->active_regions & STATUS_IS_ACTIVE){
	    iml_inst *rv = NULL;
	    XIMFeedback fb = (XIMFeedback)0;
#ifndef NO_COLOR_FEEDBACK
	    iml_inst *lp = s->If->m->iml_make_status_draw_inst(s, "\00\00\00\00", &fb,
		(XIMTextColorFeedback *)NULL, (XIMTextColorFeedback *)NULL);
#else
	    iml_inst *lp = s->If->m->iml_make_status_draw_inst(s, (wchar_t*)"\00\00\00\00", &fb );
#endif  /* NO_COLOR_FEEDBACK */
	    s->If->m->iml_link_inst_tail(&rv, lp);
	    lp = s->If->m->iml_make_status_done_inst(s);
	    s->If->m->iml_link_inst_tail(&rv, lp);
	    s->active_regions &= ~STATUS_IS_ACTIVE ;
	    iml_execute(s, &rv);
	}
	_iml_delete(s);
	return ret ;
    }
    return False ;
}

Public Bool
if_SetSCValue(s, attr, value)
iml_session_t *s ;
char *attr;
caddr_t value ;
{
    if(s) {
        Bool	ret;
 	_iml_delete(s);	

	if(IS_PRE_FUNC_VALID(s->If, if_SetSCValue))
		s->If->ext->pre->if_SetSCValue(s, attr, value);
	ret = s->If->ifm->if_SetSCValue(s, attr, value);
	if(IS_POST_FUNC_VALID(s->If, if_SetSCValue))
		s->If->ext->post->if_SetSCValue(s, attr, value);

    	return ret;
    }
    return False ;
}

Public Bool
if_GetSCValue(s, attr, value)
iml_session_t *s ;
char *attr;
caddr_t value ;
{
    if(s){
 	_iml_delete(s);	
	if(!strcmp(SC_STATUS, attr)){
	    iml_inst *lp = s->If->m->iml_make_status_notify_inst(s);
	    iml_execute(s, &lp);
	    return True;
	} 
	{
	    Bool  ret;
	    if(IS_PRE_FUNC_VALID(s->If, if_GetSCValue))
		s->If->ext->pre->if_GetSCValue(s, attr, value);
       	    ret = s->If->ifm->if_GetSCValue(s, attr, value);
	    if(IS_POST_FUNC_VALID(s->If, if_GetSCValue))
		s->If->ext->post->if_GetSCValue(s, attr, value);
	    return ret;
	}
    }
    return False ;
}

Public char *         
if_ResetSC(s)
iml_session_t *s ;
{
    char *prs = NULL;
    if(s){
	_iml_delete(s);
	s->private_status |= BEING_RESET ;
	if(IS_PRE_FUNC_VALID(s->If, if_ResetSC))
		s->If->ext->pre->if_ResetSC(s);
	prs = s->If->ifm->if_ResetSC(s);
	if(IS_POST_FUNC_VALID(s->If, if_ResetSC))
		s->If->ext->post->if_ResetSC(s);
	s->private_status &= ~BEING_RESET ;
	if(s->private_status & RESET_DATA_EXIST){
	    s->private_status &= ~RESET_DATA_EXIST ;
	} else {
	    iml_inst *lp = s->If->m->iml_make_reset_return_inst(s, 0, NULL);
	    iml_execute(s, &lp);
	}
    }
    return prs ;
}

Public void           
if_SetSCFocus(s)
iml_session_t *s ;
{
    iml_inst *rv = NULL;
    iml_inst *lp ;

    if(s){
	_iml_delete(s);
	if(s->status_cache.ws && s->status_cache.fb){
	    lp = s->If->m->iml_make_status_start_inst(s);
	    s->If->m->iml_link_inst_tail(&rv, lp);
#ifndef NO_COLOR_FEEDBACK
	    lp = s->If->m->iml_make_status_draw_inst(s, s->status_cache.ws,  
		s->status_cache.fb, s->status_cache.cffg, s->status_cache.cfbg);
#else
	    lp = s->If->m->iml_make_status_draw_inst(s, s->status_cache.ws,  s->status_cache.fb);
#endif  /* NO_COLOR_FEEDBACK */
	    s->If->m->iml_link_inst_tail(&rv, lp);
	    iml_execute(s, &rv);
	}
	s->private_status |= BEING_FOCUSED ;
	if(IS_PRE_FUNC_VALID(s->If, if_SetSCFocus))
		s->If->ext->pre->if_SetSCFocus(s);
	s->If->ifm->if_SetSCFocus(s);
	if(IS_POST_FUNC_VALID(s->If, if_SetSCFocus))
		s->If->ext->post->if_SetSCFocus(s);
    }
    return ;
}

Public void           
if_UnsetSCFocus(s)
iml_session_t *s ;
{
    iml_inst *rv = NULL;
    iml_inst *lp ;
    XIMFeedback fb = (XIMFeedback)0;

    if(s){
	_iml_delete(s);
#if DO_NOT_HACK
	switch(((htt_t*)(((im_t*)(s->If->im))->htt))->core->status_feedback){
	case FEEDBACK_STIPPLE:
	    if(s->status_cache.ws && s->status_cache.fb){
#ifndef NO_COLOR_FEEDBACK
		lp = s->If->m->iml_make_status_draw_inst(s, 
			s->status_cache.ws,  s->status_cache.sfb,
			s->status_cache.scffg,  s->status_cache.scfbg);
#else
		lp = s->If->m->iml_make_status_draw_inst(s, s->status_cache.ws,  s->status_cache.sfb);
#endif
		s->If->m->iml_link_inst_tail(&rv, lp);
		break ;
	    } else ;
		/* Fall into... */ 
	case FEEDBACK_UNMAP:
#ifndef NO_COLOR_FEEDBACK
	    lp = s->If->m->iml_make_status_draw_inst(s, "\00\00\00\00", &fb,
		(XIMTextColorFeedback *)NULL, (XIMTextColorFeedback *)NULL);
#else
	    lp = s->If->m->iml_make_status_draw_inst(s, "\00\00\00\00", &fb );
#endif
	    s->If->m->iml_link_inst_tail(&rv, lp);
	    break ;
	case FEEDBACK_NONE:
	    break ;
	}
#endif /* DO_NOT_HACK */
	lp = s->If->m->iml_make_status_done_inst(s);
	s->If->m->iml_link_inst_tail(&rv, lp);
	iml_execute(s, &rv);
	s->private_status &= ~BEING_FOCUSED ;
	if(IS_PRE_FUNC_VALID(s->If, if_UnsetSCFocus))
		s->If->ext->pre->if_UnsetSCFocus(s);
	s->If->ifm->if_UnsetSCFocus(s);
	if(IS_POST_FUNC_VALID(s->If, if_UnsetSCFocus))
		s->If->ext->post->if_UnsetSCFocus(s);
    }
    return ;
}

Public void           
if_SendEvent(s, e)
iml_session_t *s ;
XKeyEvent *e ;
{
    if(s){
	_iml_delete(s);
	if(IS_PRE_FUNC_VALID(s->If, if_SendEvent))
		s->If->ext->pre->if_SendEvent(s, e);
	s->If->ifm->if_SendEvent(s, e);
	if(IS_POST_FUNC_VALID(s->If, if_SendEvent))
		s->If->ext->post->if_SendEvent(s, e);
    }
    return ;
}
Public Bool
if_FilterEvent(event)
XEvent *event ;
{
    iml_if_t *If = if_terminal ;

    if(If){
	for(;If;If=If->next){
	    if(IS_PRE_FUNC_VALID(If, if_FilterEvent))
		If->ext->pre->if_FilterEvent(event);
	    if(If->ifm->if_FilterEvent){
		if(If->ifm->if_FilterEvent(event))
		    return True ;
	    }
	    if(IS_POST_FUNC_VALID(If, if_FilterEvent))
		If->ext->post->if_FilterEvent(event);
	}
	return False ;
    }
    return False ;
}

Public void           
if_SetAuxValues(s, e)
iml_session_t *s ;
XIMAuxDrawCallbackStruct *e;
{
    if(s){
	_iml_delete(s);
	if(IS_PRE_FUNC_VALID(s->If, if_SetAuxValues))
	    s->If->ext->pre->if_SetAuxValues(s, e);
	if (s->If->ifm->if_SetAuxValues != NULL)
	    s->If->ifm->if_SetAuxValues(s, e);
	if(IS_POST_FUNC_VALID(s->If, if_SetAuxValues))
	    s->If->ext->post->if_SetAuxValues(s, e);
    }
    return;
}
