/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include "SystemMessage.h"

#define HTT_TEXT_DOMAIN	"SUNW_HTT_MSG"



static char *	my_name;
static int	use_syslog;


#if defined(sun)

#define WEAK_SYMBOL	static
#pragma weak system_message_init	= _system_message_init
#pragma weak system_message_destroy	= _system_message_destroy
#pragma weak system_message		= _system_message
#pragma weak system_message_error	= _system_message_error

#else /* !sun */

#define WEAK_SYMBOL
#define _system_message_init		system_message_init
#define _system_message_destroy		system_message_destroy
#define _system_message			system_message
#define _system_message_error		system_message_error

#endif /* !sun */


WEAK_SYMBOL void
_system_message_init(
	const char *	name,
	int		opt_syslog,
	const char *	opt_locale) {

	system_message_destroy();

	my_name = strdup(name);

	use_syslog = 0;


	return;
}


WEAK_SYMBOL void
_system_message_destroy(void) {
	free(my_name);

	return;
}


WEAK_SYMBOL void
_system_message(int log_priority, const char * format, ...) {
	int	priority;

	va_list		ap;
	va_start(ap, format);


	(void)vfprintf(stderr, format, ap);


	va_end(ap);

	return;
}

WEAK_SYMBOL void
_system_message_error(int log_priority, const char * msgid, int en) {
	char *	lc;
	char *	me;

	me = strerror(en);

	system_message(log_priority, "%s: %s\n", msgid, me);

	return;
}
