/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "util.hh"

char * 
Util::getFirstWord(char * str, char * token)
{
  char *strptr;
  int len;
  char * marker;
  char * ret_str = (char *)0;

  strptr = str;
  if ((!token) || (!str))
     return (char *)0;

  marker = strstr(strptr, token);
  if (!marker)
     return (char *)strptr;
  len = 0;
  while (1) {
    if (strptr++ == marker)
       break;
    len++;
  }
  ret_str = new char[len+1];
  memcpy(ret_str, str, len);
  ret_str[len] = '\0';
  return (char *)ret_str;
}

char * 
Util::getSubString(char * str, char * token, int index)
{
  char *strptr;
  int len = 0;
  char * ret_str = (char *)0;
  int token_len = strlen(token);
  int prev_len = 0 - token_len;  // will be added later
  char * r_bound;
  strptr = str;
  if ((!token) || (!str))
     return (char *)0;
  r_bound = str + strlen(str);
  for (int i=0; i <= index; i++) { 
     prev_len += len + token_len;
     len = 0;
     while (strptr < r_bound) {
	if (!strncmp(strptr, token, token_len)) {
	    strptr++;
            break;
	 } else {
            strptr++;
	    len++;
	 }
     }
  }
  if (len) {
     ret_str = new char[len+1];
     memcpy(ret_str, str + prev_len, len); 
     ret_str[len] = '\0';
  }
  return (char *)ret_str;
}

char * 
Util::getWord(char *str, int *len)
{
    char ch, *strptr;

    ch = *str;
    while (ch == ' ' || ch == '\t' || ch == '\n')
        ch = *(++str);

    strptr = str;
    ch = *strptr;
    while (ch != ' ' && ch != '\t' && ch != '\n' && ch != 0)
        ch = *(++strptr);

    if (strptr == str)
        return 0;

    *len = strptr - str;
    return str;
}

char *
Util::toLowerString(char * string)
{
    size_t len = strlen((const char*)string);
    size_t i;
    char * ret_str = new char[len];

    for (i = 0; i < len; i++) {
        ret_str[i] = (char)tolower((int)string[i]);
    }
    return ret_str;
}

char * 
Util::toUpperString(char * string)
{
    size_t len = strlen((const char*)string);
    size_t i;
    char * ret_str = new char[len];

    for (i = 0; i < len; i++) {
        ret_str[i] = (char)toupper((int)string[i]);
    }
    return ret_str;
}
