/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include <stdio.h>
#include <ctype.h>
#include <X11/Xlib.h>

#include "XSunExt.h"
#include "XSunIMProt.h"
#include "XSunIMPriv.h"
#include "XSunIMMMan.h"
#include "XSunIMMthd.h"
#include "XSunIMCore.h"
#include "XSunIMPub.h"

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>

#define	XSUNIMSUBR

#include "XSunIMLookup.h"

static char *alpha_label = "abcdefghijklmnopqrstuvwxyz";
static char *upper_alpha_label = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
static char *numeric_label = "1234567890";

static IMLLookupCallbackList callback_list = (IMLLookupCallbackList) 0;

IMLookupCallback
luc_create(
    void *s_,
    int type
)
{
    wchar_t *my_label;
    int i;
    iml_session_t *s = (iml_session_t *) s_;
    IMLookupCallback luc = (IMLookupCallback) calloc(1, sizeof(IMLookupCallbackRec));
    int num_of_labels;
    int label_type;
    wchar_t *w_label;
    
    memset(luc, 0, sizeof(IMLookupCallbackRec));
    
    switch (type) {
        case IM_LUC_LABEL_ALPHA_UPPER:
            label_type = IM_LUC_LABEL_ALPHA_UPPER;
            num_of_labels = 26;
            w_label = (wchar_t *) calloc(1, sizeof(wchar_t) * num_of_labels);
            mbstowcs(w_label, upper_alpha_label, num_of_labels);
            my_label = w_label;
            break;
        case IM_LUC_LABEL_NUMERIC:
            label_type = IM_LUC_LABEL_NUMERIC;
            num_of_labels = 10;
            w_label = (wchar_t *) calloc(1, sizeof(wchar_t) * num_of_labels);
            mbstowcs(w_label, numeric_label, num_of_labels);
            my_label = w_label;
            break;
        default:
            label_type = IM_LUC_LABEL_ALPHABETIC;
            num_of_labels = 26;
            w_label = (wchar_t *) calloc(1, sizeof(wchar_t) * num_of_labels);
            mbstowcs(w_label, alpha_label, num_of_labels);
            my_label = w_label;
            break;
        }
    
    for (i = 0; i < num_of_labels; i++) {
        luc->label_text[i].length = 1;
        luc->label_text[i].encoding_is_wchar = 1;
        luc->label_text[i].string.wide_char = (wchar_t *) calloc(1, sizeof(wchar_t) * 2);
        luc->label_text[i].string.wide_char[0] = *my_label++;
        luc->label_text[i].string.wide_char[1] = (wchar_t) 0;
        luc->label_text[i].feedback = (XIMFeedback *) calloc(1, sizeof(XIMFeedback));
        luc->label_text[i].feedback[0] = 0;
    }
    free(w_label);
    
    luc->style.layout = (LayoutInfo *) calloc(1, sizeof(LayoutInfo));
    memset(luc->style.layout, 0, sizeof(LayoutInfo));
    
    luc->page.choices = (XIMChoiceObject *) calloc(1, num_of_labels * sizeof(XIMChoiceObject));
    luc->current_page_num = num_of_labels;
    memset(luc->page.choices, 0, num_of_labels * sizeof(XIMChoiceObject));
    
    luc->num_of_labels = num_of_labels;
    luc->label_type = label_type;
    
    return luc;
}

IMLookupCallback
find_luccallback(
    int session_id
)
{
    IMLLookupCallbackList p, *prev;
    for (prev = &callback_list; (p = *prev) != 0; prev = &p->next) {
        iml_session_t *s = (iml_session_t *) p->session;
        if (s->session_id == session_id) {
            return p;
        }
    }
    return (IMLookupCallback) NULL;
}

void
remove_luccallback_by_session(
    void *s_
)
{
    int i;
    iml_session_t *s = (iml_session_t *) s_;
    IMLLookupCallbackList p, *prev;
    for (prev = &callback_list; (p = *prev) != 0; prev = &p->next) {
        if (p->session == s) {
            *prev = p->next;
	    for (i = 0; i < p->num_of_labels; i++) {
        	free(p->label_text[i].string.wide_char);
        	free(p->label_text[i].feedback);
	    }
            free((char *) p->style.layout);
            free((char *) p->page.choices);
            free((char *) p->items.choices);
            free((char *) p);
            break;
        }
        if (p->next == NULL) {
            break;
        }
    }
}

void
remove_luccallback(
    IMLookupCallback c
)
{
    IMLLookupCallbackList p, *prev;
    for (prev = &callback_list; (p = *prev) != 0; prev = &p->next) {
        if (p == c) {
            *prev = p->next;
            break;
        }
        if (p->next == NULL) {
            break;
        }
    }
}

void
add_luccallback(
    void *s_,
    IMLookupCallback c
)
{
    iml_session_t *s = (iml_session_t *) s_;
    c->next = callback_list;
    c->session = s;
    callback_list = c;
}

#define SC_LOOKUP_CWIDTH        12
#define SC_LOOKUP_EWIDTH        12
#define SC_LOOKUP_LINES         0
#define SC_LOOKUP_ROOTWIDTH     0
#define SC_LOOKUP_NCHOICES      lc->num_of_labels
#define SC_LOOKUP_NCOLS         6
#define SC_LOOKUP_NROWS         5

void luc_start();
void luc_draw();

void
luc_start(
    IMLookupCallback lc,
    XIMLookupStartCallbackStruct * call_data
)
{
    XIMLookupStartCallbackStruct2 *style = (XIMLookupStartCallbackStruct2 *) & lc->style;
    LayoutInfo *layout = style->layout;
    int nrows = call_data->XIMPreference->nrows;
    int ncolumns = call_data->XIMPreference->ncolumns;

    if (call_data->whoIsMaster == CBIsMaster) {
        style->whoIsMaster = CBIsMaster;
        layout->WhoOwnsLabel = XIMOwnsLabel;
        layout->choice_per_window = call_data->CBPreference->choice_per_window;
        layout->nrows = call_data->CBPreference->nrows;
        layout->ncolumns = call_data->CBPreference->ncolumns;
    } else if (call_data->whoIsMaster == XIMIsMaster) {
        style->whoIsMaster = XIMIsMaster;
        layout->WhoOwnsLabel = CBOwnsLabel;
	if( (nrows == 0) && (ncolumns == 0) ) {
	    layout->choice_per_window = SC_LOOKUP_NCHOICES;
	    layout->nrows = SC_LOOKUP_NROWS;
	    layout->ncolumns = SC_LOOKUP_NCOLS;
        }
	else {
            layout->choice_per_window = call_data->XIMPreference->choice_per_window;
            layout->nrows = nrows;
            layout->ncolumns = ncolumns;
	}
    } else {			/* fallback */
	layout->choice_per_window = SC_LOOKUP_NCHOICES;
	layout->nrows = SC_LOOKUP_NROWS;
	layout->ncolumns = SC_LOOKUP_NCOLS;
    }
    layout->DrawUpDirection = DrawUpHorizontally;
}

int
set_luc_labels(
    IMLookupCallback lc,
    XIMLookupDrawCallbackStruct * items,
    XIMLookupDrawCallbackStruct * call_data
)
{
    int i;
    if (items->n_choices != 0 && items->choices != NULL) {
        if (call_data->choices[0].label == NULL) {
            XIMText *my_label = lc->label_text;
            for (i = 0; i < items->n_choices; i++) {
                if (i % lc->num_of_labels == 0)
                    my_label = lc->label_text;
                items->choices[i].label = my_label++;
            }
            return CBIsMaster;
        } else {
            for (i = 0; i < items->n_choices; i++) {
                items->choices[i].label = call_data->choices[i].label;
            }
            return XIMIsMaster;
        }
    }
}

void
set_luc_items(
    XIMLookupDrawCallbackStruct * items,
    XIMLookupDrawCallbackStruct * call_data
)
{
    int i;
    if (items->n_choices != 0 && items->choices != NULL) {
        for (i = 0; i < items->n_choices; i++) {
            items->choices[i].value = call_data->choices[i].value;
        }
    }
}

void
create_luc_items(
    iml_session_t * s,
    XIMLookupDrawCallbackStruct * items
)
{
    if (items->choices == NULL) {
        items->choices = (XIMChoiceObject *) calloc(1, items->n_choices * sizeof(XIMChoiceObject));
    } else {
        items->choices = (XIMChoiceObject *) realloc(items->choices, items->n_choices * sizeof(XIMChoiceObject));
    }
}

void
create_luc_page(
    IMLookupCallback lc,
    XIMLookupDrawCallbackStruct * from,
    XIMLookupDrawCallbackStruct2 * to,
    int first_index, int focus_index,
XIMLookupStartCallbackStruct2 style)
{
    int i;
    
    int number_of_candidate;
    
    to->max_len = from->max_len;
    to->index_of_first_candidate = 0;
    to->title = from->title;
    
    if (style.whoIsMaster == XIMIsMaster) {
        to->index_of_last_candidate = from->index_of_last_candidate;
        to->n_choices = from->n_choices;
    } else {
        to->index_of_last_candidate = SC_LOOKUP_NCHOICES - 1;
        to->n_choices = SC_LOOKUP_NCHOICES;
    }
    
    for (i = 0; i < to->n_choices; i++) {
        if (i + first_index == from->n_choices) {
            to->n_choices = i;
            to->index_of_last_candidate = i - 1;
            break;
        }
        to->choices[i].value = from->choices[i + first_index].value;
        to->choices[i].label = from->choices[i + first_index].label;
    }
    
    to->index_of_current_candidate = focus_index - first_index;
    return;
}

void
luc_draw(
    iml_session_t * s,
    IMLookupCallback lc,
    XIMLookupDrawCallbackStruct * call_data
)
{
    XIMLookupDrawCallbackStruct *items = (XIMLookupDrawCallbackStruct *) & lc->items;
    XIMLookupDrawCallbackStruct2 *page = (XIMLookupDrawCallbackStruct2 *) & lc->page;
    int i;
    
    items->max_len = call_data->max_len;
    items->index_of_first_candidate = call_data->index_of_first_candidate;
    items->index_of_last_candidate = call_data->index_of_last_candidate;
    items->title = call_data->title;
    items->n_choices = call_data->n_choices;
    if (items->n_choices > lc->current_items_num) {
        create_luc_items(s, items);
    }
    set_luc_items(items, call_data);
    lc->style.whoIsMaster = set_luc_labels(lc, items, call_data);
    
    lc->current_first_index = items->index_of_first_candidate;
    lc->current_focus_index = items->index_of_first_candidate;
    
    if (items->n_choices > lc->current_page_num) {
        page->choices = (XIMChoiceObject *)
        realloc(page->choices,
            items->n_choices * sizeof(XIMChoiceObject));
        lc->current_page_num = items->n_choices;
    }
    create_luc_page(lc, items, page, lc->current_first_index,
        lc->current_focus_index, lc->style);
    
    /*
    * if feedback can tell which is the current index, reverse it
    */
    for (i = 0; i < page->index_of_last_candidate + 1; i++) {
        if (page->choices[i].value->feedback[0] != 0) {
            page->index_of_current_candidate = i;
            break;
        }
    }
}

/* candidate focus move on LUC window */
void
move_previous_page(
    IMLookupCallback lc,
    XIMLookupProcessCallbackStruct * call_data
)
{
    XIMLookupDrawCallbackStruct *items =
    (XIMLookupDrawCallbackStruct *) & lc->items;
    XIMLookupDrawCallbackStruct2 *page =
    (XIMLookupDrawCallbackStruct2 *) & lc->page;
    if (lc->current_first_index >= SC_LOOKUP_NCHOICES) {
        lc->current_first_index -= SC_LOOKUP_NCHOICES;
        lc->current_focus_index = lc->current_first_index;
        /*
        * index_of_choice_selected is used to determine the results
        * of the lookup process operation
        */
        call_data->index_of_choice_selected = XIM_UNDETERMINED;
        create_luc_page(lc, items, page, lc->current_first_index,
            lc->current_focus_index, lc->style);
    }
}

void
move_next_page(
    IMLookupCallback lc,
    XIMLookupProcessCallbackStruct * call_data
)
{
    XIMLookupDrawCallbackStruct *items =
    (XIMLookupDrawCallbackStruct *) & lc->items;
    XIMLookupDrawCallbackStruct2 *page =
    (XIMLookupDrawCallbackStruct2 *) & lc->page;
    if (lc->current_first_index + SC_LOOKUP_NCHOICES <=
    items->index_of_last_candidate) {
        lc->current_first_index += SC_LOOKUP_NCHOICES;
        lc->current_focus_index = lc->current_first_index;
        /*
        * index_of_choice_selected is used to determine the results
        * of the lookup process operation
        */
        call_data->index_of_choice_selected = XIM_UNDETERMINED;
        create_luc_page(lc, items, page, lc->current_first_index,
            lc->current_focus_index, lc->style);
    }
}

void
move_top(
    IMLookupCallback lc,
    XIMLookupProcessCallbackStruct * call_data
)
{
    XIMLookupDrawCallbackStruct *items =
    (XIMLookupDrawCallbackStruct *) & lc->items;
    XIMLookupDrawCallbackStruct2 *page =
    (XIMLookupDrawCallbackStruct2 *) & lc->page;
    if (lc->current_focus_index != lc->current_first_index) {
        lc->current_focus_index = lc->current_first_index;
        /*
        * index_of_choice_selected is used to determine the results
        * of the lookup process operation
        */
        call_data->index_of_choice_selected = XIM_UNDETERMINED;
        create_luc_page(lc, items, page, lc->current_first_index,
            lc->current_focus_index, lc->style);
    }
}

void
move_last(
    IMLookupCallback lc,
    XIMLookupProcessCallbackStruct * call_data
)
{
    XIMLookupDrawCallbackStruct *items =(XIMLookupDrawCallbackStruct *) & lc->items;
    XIMLookupDrawCallbackStruct2 *page =(XIMLookupDrawCallbackStruct2 *) & lc->page;
    
    if (lc->current_focus_index != items->index_of_last_candidate &&
      lc->current_focus_index !=
    lc->current_first_index + SC_LOOKUP_NCHOICES - 1) {
        lc->current_focus_index = min(items->index_of_last_candidate,
            lc->current_first_index + SC_LOOKUP_NCHOICES - 1);
        /*
        * index_of_choice_selected is used to determine the results
        * of the lookup process operation
        */
        call_data->index_of_choice_selected = XIM_UNDETERMINED;
        create_luc_page(lc, items, page, lc->current_first_index,
            lc->current_focus_index, lc->style);
    }
}

void
move_previous(
    IMLookupCallback lc,
    XIMLookupProcessCallbackStruct * call_data
)
{
    XIMLookupDrawCallbackStruct *items =
    (XIMLookupDrawCallbackStruct *) & lc->items;
    XIMLookupDrawCallbackStruct2 *page =
    (XIMLookupDrawCallbackStruct2 *) & lc->page;
    if (lc->current_focus_index > lc->current_first_index) {
        lc->current_focus_index--;
        /*
        * index_of_choice_selected is used to determine the results
        * of the lookup process operation
        */
        call_data->index_of_choice_selected = XIM_UNDETERMINED;
        create_luc_page(lc, items, page, lc->current_first_index,
            lc->current_focus_index, lc->style);
    } else if (lc->current_focus_index == lc->current_first_index) {
        /* goto previous page if any */
        move_previous_page(lc, call_data);
        if (call_data->index_of_choice_selected == XIM_UNDETERMINED)
            move_last(lc, call_data);
    }
}

void
move_next(
    IMLookupCallback lc,
    XIMLookupProcessCallbackStruct * call_data
)
{
    XIMLookupDrawCallbackStruct *items =
    (XIMLookupDrawCallbackStruct *) & lc->items;
    XIMLookupDrawCallbackStruct2 *page =
    (XIMLookupDrawCallbackStruct2 *) & lc->page;
    if (lc->current_focus_index < items->index_of_last_candidate &&
      lc->current_focus_index <
    lc->current_first_index + SC_LOOKUP_NCHOICES - 1) {
        lc->current_focus_index++;
        /*
        * index_of_choice_selected is used to determine the results
        * of the lookup process operation
        */
        call_data->index_of_choice_selected = XIM_UNDETERMINED;
        create_luc_page(lc, items, page, lc->current_first_index,
            lc->current_focus_index, lc->style);
    } else if (lc->current_focus_index ==
    min(items->index_of_last_candidate,
        lc->current_first_index + SC_LOOKUP_NCHOICES - 1)) {
        /* at the last candidate */
        move_next_page(lc, call_data);
        if (call_data->index_of_choice_selected == XIM_UNDETERMINED)
            move_top(lc, call_data);
    }
}

void
move_up(
    IMLookupCallback lc,
    XIMLookupProcessCallbackStruct * call_data
)
{
    XIMLookupDrawCallbackStruct *items =
    (XIMLookupDrawCallbackStruct *) & lc->items;
    XIMLookupDrawCallbackStruct2 *page =
    (XIMLookupDrawCallbackStruct2 *) & lc->page;
    XIMLookupStartCallbackStruct2 *style =
    (XIMLookupStartCallbackStruct2 *) & lc->style;
    LayoutInfo *layout = style->layout;
    
    if (lc->current_focus_index - layout->ncolumns >= lc->current_first_index) {
        lc->current_focus_index -= layout->ncolumns;
        /*
        * index_of_choice_selected is used to determine the results
        * of the lookup process operation
        */
        call_data->index_of_choice_selected = XIM_UNDETERMINED;
        create_luc_page(lc, items, page, lc->current_first_index,
            lc->current_focus_index, lc->style);
    } else if (lc->current_focus_index - layout->ncolumns <
    lc->current_first_index) {
        while (lc->current_focus_index + layout->ncolumns <=
        min(items->index_of_last_candidate,
            lc->current_first_index + SC_LOOKUP_NCHOICES - 1)) {
            lc->current_focus_index += layout->ncolumns;
        }
        /*
        * index_of_choice_selected is used to determine the results
        * of the lookup process operation
        */
        call_data->index_of_choice_selected = XIM_UNDETERMINED;
        create_luc_page(lc,
            items, page, lc->current_first_index,
            lc->current_focus_index, lc->style);
    }
}


void
move_down(
    IMLookupCallback lc,
    XIMLookupProcessCallbackStruct * call_data
)
{
    XIMLookupDrawCallbackStruct *items =
    (XIMLookupDrawCallbackStruct *) & lc->items;
    XIMLookupDrawCallbackStruct2 *page =
    (XIMLookupDrawCallbackStruct2 *) & lc->page;
    XIMLookupStartCallbackStruct2 *style =
    (XIMLookupStartCallbackStruct2 *) & lc->style;
    LayoutInfo *layout = style->layout;
    
    if (lc->current_focus_index + layout->ncolumns <= items->index_of_last_candidate &&
      lc->current_focus_index + layout->ncolumns <=
    lc->current_first_index + SC_LOOKUP_NCHOICES - 1) {
        lc->current_focus_index += layout->ncolumns;
        /*
        * index_of_choice_selected is used to determine the results
        * of the lookup process operation
        */
        call_data->index_of_choice_selected = XIM_UNDETERMINED;
        create_luc_page(lc, items, page, lc->current_first_index,
            lc->current_focus_index, lc->style);
    } else if (lc->current_focus_index + layout->ncolumns >
    min(items->index_of_last_candidate,
        lc->current_first_index + SC_LOOKUP_NCHOICES - 1)) {
        while (lc->current_focus_index - layout->ncolumns >=
        lc->current_first_index) {
            lc->current_focus_index -= layout->ncolumns;
        }
        /*
        * index_of_choice_selected is used to determine the results
        * of the lookup process operation
        */
        call_data->index_of_choice_selected = XIM_UNDETERMINED;
        create_luc_page(lc, items, page, lc->current_first_index,
            lc->current_focus_index, lc->style);
    }
}
