/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#ifndef XSUNIM_ADAPTER_HH
#define XSUNIM_ADAPTER_HH

#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <fcntl.h>
#include <dlfcn.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <sys/socket.h>
#include <errno.h>
#include <wchar.h>

#include "IMProtocolStruct.h"
#include "VMSharedMemory.hh"
#include "VMAdapterStub.hh"
#include "Utility.hh"
#include "SunIM.h"
#include "Public.h"
#include "XSunIMManager.hh"

class XSunIMAdapter {
  public:
    XSunIMAdapter();
    ~XSunIMAdapter();

    Bool OpenIF(iml_if_t * If);
    int CloseIF(iml_if_t * If);
    void OpenDesktop(iml_desktop_t *);
    void CloseDesktop(iml_desktop_t *);
    Bool CreateSC(iml_session_t * session, IMArgList args, int n_args);
    Bool DestroySC(iml_session_t * session);
    Bool SetSCValue(iml_session_t * session, IMArgList args, int n_args);
    IMText *ResetSC(iml_session_t * session);
    Bool SetSCFocus(iml_session_t * session);
    Bool UnsetSCFocus(iml_session_t * session);
    Bool SendEvent(iml_session_t * session, IMInputEvent * event);
    
  private:
    int driver_id;
    VMSignalData reply;
    VMAdapterStub *stub;
    VMSharedMemory *sharedmemory;
    int shm_alloced;
    void decode_iml(iml_session_t *);
    void init();

#ifdef	notdef
    char *mbs_str;
    int mbs_len;
#endif

    iml_inst *make_keypress_inst(iml_session_t *);
    iml_inst *make_commit_inst(iml_session_t *);
    iml_inst *make_aux_start_inst(iml_session_t *);
    iml_inst *make_aux_draw_inst(iml_session_t *);
    iml_inst *make_aux_done_inst(iml_session_t *);
    iml_inst *make_preedit_start_inst(iml_session_t *);
    iml_inst *make_preedit_done_inst(iml_session_t *);
    iml_inst *make_preedit_draw_inst(iml_session_t *);
    iml_inst *make_status_start_inst(iml_session_t *);
    iml_inst *make_status_draw_inst(iml_session_t *);
    iml_inst *make_status_done_inst(iml_session_t *);
    iml_inst *make_lookup_start_inst(iml_session_t *);
    iml_inst *make_lookup_draw_inst(iml_session_t *);
    iml_inst *make_lookup_done_inst(iml_session_t *);
    iml_inst *make_status_notify_inst(iml_session_t *);

    iml_session_t *findSession(iml_session_t *, int);
};

#endif
