/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include "XSunIMAdapter.hh"
#include <locale.h>

XSunIMAdapter::XSunIMAdapter()
{
    shm_alloced = 0;
    init();
}

XSunIMAdapter::~XSunIMAdapter()
{
    delete sharedmemory;
    delete stub;
}

void
XSunIMAdapter::init()
{
    if (shm_alloced) {
        return;
    }
    sharedmemory = new VMSharedMemory(MAX_SHM_SIZE);
    shm_alloced = 1;
    stub = new VMAdapterStub(sharedmemory);
}

Bool
XSunIMAdapter::OpenIF(
    iml_if_t * If
)
{
    VMDriverStub *ret;
    char *locale = setlocale(LC_CTYPE, (char *) 0);
    
    XSUNIMManager *drvman;

#ifdef	notdef
    /* 4272789:
	workaround for Solaris 8
	htt_server for xsunim adapter should always fork()

	To fix this problem correctly, dlclose() should be
	called for dlmodule opened by parent htt_server
    */
    if (!strcmp(locale, If->locale)) {
        drvman = new XSUNIMManager(False);
        ret = stub->AddDriverWithoutFork(drvman, If->locale, If->if_name, 0);
    } else {
        drvman = new XSUNIMManager(True);
        ret = stub->AddDriver(drvman, If->locale, If->if_name, 0);
    }
#else
        drvman = new XSUNIMManager(True);
        ret = stub->AddDriver(drvman, If->locale, If->if_name, 0);
#endif
    if (ret == NULL) {
	return False;
    }
    driver_id = stub->getDriverId(If->locale, If->if_name);
    stub->initAddress(driver_id);
    
    stub->putInt(strlen(If->locale));
    stub->putString(If->locale, strlen(If->locale));
    
    stub->putInt(strlen(If->if_name));
    stub->putString(If->if_name, strlen(If->if_name));
    
    stub->sendRequest(driver_id, 0, XSUNIM_OPEN_IF, &reply);

    if (reply.type == XSUNIM_REPLY_FAIL) {
	return False;
    }

    return True;
}

int
XSunIMAdapter::CloseIF(
    iml_if_t * If
)
{
    driver_id = stub->getDriverId(If->locale, If->if_name);
    stub->initAddress(driver_id);
    stub->sendRequest(driver_id, 0, XSUNIM_CLOSE_IF, &reply);

    XSUNIMManager *manager=(XSUNIMManager*)stub->getDrvManager(If->locale, If->if_name);
    delete manager;
    stub->DeleteDriver(If->locale, If->if_name);

    /* return number of existing driver */
    return stub->getDriverCount();
}

void
XSunIMAdapter::OpenDesktop(
    iml_desktop_t * desktop
)
{
    driver_id = stub->getDriverId(desktop->If->locale, desktop->If->if_name);
    stub->initAddress(driver_id);
    stub->sendRequest(driver_id, 0, XSUNIM_OPEN_DESKTOP, &reply);
}

void
XSunIMAdapter::CloseDesktop(
    iml_desktop_t * desktop
)
{
    driver_id = stub->getDriverId(desktop->If->locale, desktop->If->if_name);
    stub->initAddress(driver_id);
    stub->sendRequest(driver_id, 0, XSUNIM_CLOSE_DESKTOP, &reply);
}

Bool
XSunIMAdapter::CreateSC(
    iml_session_t *s,
    IMArgList args,
    int n_args
)
{
    iml_desktop_t *desktop = s->desktop;
    VMSessionPrivate *sp = (VMSessionPrivate *) new VMSessionPrivate;
    memset(sp, 0, sizeof(VMSessionPrivate));

    sp->locale = new char [strlen(desktop->If->locale) + 1];
    strcpy(sp->locale, desktop->If->locale);
    sp->locale[strlen(desktop->If->locale)]='\0';

    sp->name = new char [strlen(desktop->If->if_name) + 1];
    strcpy(sp->name, desktop->If->if_name);
    sp->name[strlen(desktop->If->if_name)]='\0';

    s->specific_data = (void*) sp;

    return True;
}

Bool
XSunIMAdapter::DestroySC(
    iml_session_t * s
)
{
    VMSessionPrivate *sp = (VMSessionPrivate *) s->specific_data;
    driver_id = stub->getDriverId(s->If->locale, s->If->if_name);
    stub->initAddress(driver_id);
    stub->sendRequest(driver_id, sp->session_id, XSUNIM_DESTROY_SC, &reply);
    
    if (reply.type == XSUNIM_REPLY_EXECUTE) {
        decode_iml(s);
    }
    stub->initAddress(driver_id);
    stub->sendRequest(driver_id, sp->session_id, XSUNIM_POST_DESTROY_SC, &reply);

    delete [] sp->locale;
    delete [] sp->name;
    delete sp;
    
    return True;
}

Bool
XSunIMAdapter::SetSCValue(
    iml_session_t * s,
    IMArgList arg,
    int n_args
)
{
    int i, argid, value;
    IMArg *p = arg;
    VMSessionPrivate *sp = (VMSessionPrivate *) s->specific_data;
    
#ifdef	DEBUG
    printf("XSunIMAdapter::SetSCValue\n");
#endif
    
    driver_id = stub->getDriverId(s->If->locale, s->If->if_name);
    
    for (i = 0; i < n_args; i++, p++) {
        stub->initAddress(driver_id);
        switch (p->id) {
            case SC_TRIGGER_ON_NOTIFY:
                
#ifdef	DEBUG
                printf("XSunIMAdapter::SetSCValue SC_TRIGGER_ON_NOTIFY session_id=%d\n", sp->session_id);
#endif
                argid = _SC_HENKAN_MODE_ON;
                value = 0;
                stub->putInt(argid);
                stub->putInt(value);
                stub->sendRequest(driver_id, sp->session_id, XSUNIM_SET_SC_VALUE, &reply);
    		if (reply.type == XSUNIM_REPLY_EXECUTE) {
                    decode_iml(s);
                }
                break;
                
            case SC_TRIGGER_OFF_NOTIFY:
#ifdef	DEBUG
                printf("XSunIMAdapter::SetSCValue SC_TRIGGER_OFF_NOTIFY sessioin_id=%d\n", sp->session_id);
#endif
                argid = _SC_HENKAN_MODE_OFF;
                value = 0;
                stub->putInt(argid);
                stub->putInt(value);
                stub->sendRequest(driver_id, sp->session_id, XSUNIM_SET_SC_VALUE, &reply);
    		if (reply.type == XSUNIM_REPLY_EXECUTE) {
                    decode_iml(s);
                }
                break;
                
            case SC_LOOKUP_NROWS:
#ifdef	DEBUG
                printf("XSunIMAdapter::SetSCValue SC_LOOKUP_NROWS\n");
#endif
                argid = _SC_LOOKUP_NROWS;
                value = (int) p->value;
                stub->putInt(argid);
                stub->putInt(value);
                stub->sendRequest(driver_id, 0, XSUNIM_SET_SC_VALUE, &reply);
                break;
                
            case SC_LOOKUP_NCOLS:
#ifdef	DEBUG
                printf("XSunIMAdapter::SetSCValue SC_LOOKUP_NCOLS\n");
#endif
                argid = _SC_LOOKUP_NCOLS;
                value = (int) p->value;
                stub->putInt(argid);
                stub->putInt(value);
                stub->sendRequest(driver_id, 0, XSUNIM_SET_SC_VALUE, &reply);
                break;
                
            case SC_LOOKUP_LABELTYPE:
#ifdef	DEBUG
                printf("XSunIMAdapter::SetSCValue SC_LOOKUP_LABELTYPE\n");
#endif
                argid = _SC_LOOKUP_LABELTYPE;
                value = (int) p->value;
                stub->putInt(argid);
                stub->putInt(value);
                stub->sendRequest(driver_id, 0, XSUNIM_SET_SC_VALUE, &reply);
                break;
                
            case SC_REALIZE:
#ifdef	DEBUG
                printf("XSunIMAdapter::SetSCValue SC_REALIZE\n");
#endif
                {
                    int username_len;
                    char *username;
                    
                    username_len = strlen(s->desktop->user_name) + strlen(s->desktop->host_name) + 1;
                    username = new char[username_len + 1];
                    sprintf(username, "%s@%s", s->desktop->user_name, s->desktop->host_name);
                    
                    stub->putInt(username_len);
                    stub->putString(username, sizeof(char) * username_len);
                    
                    stub->sendRequest(driver_id, 0, XSUNIM_CREATE_SC, &reply);
                    
                    sp->session_id = reply.session_id;
                    
    		    if (reply.type == XSUNIM_REPLY_EXECUTE) {
                        decode_iml(s);
                    }
                    delete [] username;
                    
                    return True;
                }
                break;
            default:
                break;
            }
#ifdef	DEBUG
        printf("XSunIMAdapter::session_id=%d\n", sp->session_id);
#endif
    }
    return True;
}

IMText *
XSunIMAdapter::ResetSC(
    iml_session_t * s
)
{
    VMSessionPrivate *sp = (VMSessionPrivate *) s->specific_data;
    driver_id = stub->getDriverId(s->If->locale, s->If->if_name);
    stub->initAddress(driver_id);
    stub->sendRequest(driver_id, sp->session_id, XSUNIM_RESET_SC, &reply);
    
    if (reply.type == XSUNIM_REPLY_EXECUTE) {
        decode_iml(s);
    }
    return NULL;
}

Bool
XSunIMAdapter::SetSCFocus(
    iml_session_t * s
)
{
    VMSessionPrivate *sp = (VMSessionPrivate *) s->specific_data;
    driver_id = stub->getDriverId(s->If->locale, s->If->if_name);
    stub->initAddress(driver_id);
    stub->sendRequest(driver_id, sp->session_id, XSUNIM_SET_SC_FOCUS, &reply);
    if (reply.type == XSUNIM_REPLY_EXECUTE) {
        decode_iml(s);
    } else if (reply.type == XSUNIM_REPLY_FAIL) {
        /* need to restart */
        return False;
    }
    return True;
}

Bool
XSunIMAdapter::UnsetSCFocus(
    iml_session_t * s
)
{
    VMSessionPrivate *sp = (VMSessionPrivate *) s->specific_data;
    driver_id = stub->getDriverId(s->If->locale, s->If->if_name);
    stub->initAddress(driver_id);
    stub->sendRequest(driver_id, sp->session_id, XSUNIM_UNSET_SC_FOCUS, &reply);
    if (reply.type == XSUNIM_REPLY_EXECUTE) {
        decode_iml(s);
    } else if (reply.type == XSUNIM_REPLY_FAIL) {
        /* need to restart */
        return False;
    }
    return True;
}

Bool
XSunIMAdapter::SendEvent(
    iml_session_t * s,
    IMInputEvent * e
)
{
    VMSessionPrivate *sp = (VMSessionPrivate *) s->specific_data;
    driver_id = stub->getDriverId(s->If->locale, s->If->if_name);
    
    /* workaround for xjsi's bushu input */
    stub->resetAddress(driver_id);
    stub->sendRequest(driver_id, sp->session_id, XSUNIM_OTEHR, &reply);
    if (reply.type == XSUNIM_REPLY_EXECUTE) {
        decode_iml(s);
    }
    stub->initAddress(driver_id);
    
    if (e->type == IM_EventKeyList) {
        IMKeyListEvent *keylist = (IMKeyListEvent *) e;
        IMKeyEventStruct *k = (IMKeyEventStruct *) keylist->keylist;
        
        stub->putInt(k->modifier);
        stub->putInt(k->keyCode);
        stub->putInt(k->keyChar);
        
        stub->sendRequest(driver_id, sp->session_id, XSUNIM_SEND_EVENT, &reply);
        
    	if (reply.type == XSUNIM_REPLY_EXECUTE) {
            decode_iml(s);
        } else if (reply.type == XSUNIM_REPLY_FAIL) {
            /* need to restart */
	    return False;
	}
#ifdef	notdef
        if ((sp->trigger_on) && (k->modifier == 2) && (k->keyCode == 32)) {
            sp->trigger_on = 0;
            iml_inst *lp = s->If->m->iml_make_end_conversion_inst(s);
            s->If->m->iml_execute(s, &lp);
        }
#endif
    } else if (e->type == IM_EventX) {
        IMXEvent *imxevent = (IMXEvent *) e;
        XEvent *xev = (XEvent *) imxevent->xevent;
        
        stub->putAny(xev, sizeof(XEvent));
        
        stub->sendRequest(driver_id, sp->session_id, XSUNIM_FILTER_EVENT, &reply);
        
    	if (reply.type == XSUNIM_REPLY_EXECUTE) {
            decode_iml(s);
        }
    } else if (e->type == IM_EventAux) {
        IMAuxEvent *aux = (IMAuxEvent *) e;
        IMAuxDrawCallbackStruct *data = aux->aux;
        
        int engine_name_len = strlen(data->aux_name);
        
        char *aux_name = data->aux_name;
        int aux_index = data->aux_index;
        int count_integer_values = data->count_integer_values;
        int *integer_values = data->integer_values;
        int count_string_values = data->count_string_values;
        IMText *string_values = data->string_values;
        
        stub->putInt(engine_name_len);
        stub->putString(aux_name, engine_name_len);
        stub->putInt(aux_index);
        stub->putInt(count_integer_values);
        if (count_integer_values != 0) {
            stub->putAny(integer_values, sizeof(int) * count_integer_values);
        }
        stub->putInt(count_string_values);
        if (count_string_values != 0) {
            for (int i = 0; i < count_string_values; i++) {
                IMText *im = &string_values[i];
                UTFCHAR *uc = im->text.utf_chars;
                int utflen = im->char_length;
                char *buf = Utility::CreateMBSFromUTF16(s, sp->locale, uc, utflen);
                int len;
                if (buf == NULL) {
                    len = 0;
                    stub->putInt(len);
                } else {
                    len = strlen(buf);
                    stub->putInt(len);
                    stub->putString(buf, len);
                }
            }
        }
        stub->sendRequest(driver_id, sp->session_id, XSUNIM_SET_AUX_VALUE, &reply);
    	if (reply.type == XSUNIM_REPLY_EXECUTE) {
            decode_iml(s);
        } else if (reply.type == XSUNIM_REPLY_FAIL) {
            /* need to restart */
	    return False;
	}
    }
    return True;
}
