/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include "Utility.hh"
#include "SystemMessage.h"

KeyConverter *Utility::keyconv = NULL;
ConvList Utility::convlist;

#define	UTF16_STRLEN	1024

XSunIMConv *
Utility::getConv(
    char *locale,
    char *from,
    char *to
)
{
    int i;
    XSunIMConv *p;

    for (i = 1; i <= convlist.getSize(); i++) {
        p = &(convlist.getItem(i));
        if (!strcmp(p->locale, locale) && !strcmp(p->from, from) && !strcmp(p->to, to)) {
#ifdef	DEBUG
            printf("RECYCLED CONV LOCALE=%s FROM=%s TO=%s\n", locale, from, to);
#endif
            return p;
        }
    }
    CodeSetConverter *conv = new CodeSetConverter(locale, to, from);
    if (conv->valid()) {
#ifdef	DEBUG
        printf("NEW CONV LOCALE=%s FROM=%s TO=%s\n", locale, from, to);
#endif
        p = new XSunIMConv(conv, locale, from, to);
        convlist.addItem(p);
        return p;
    } else {
        system_message(MSG_ERROR,
		       "Unable to open converter LOCALE=%s FROM=%s TO=%s\n",
		       locale, from, to);
/*        fprintf(stderr, "Unable to open converter LOCALE=%s FROM=%s TO=%s\n", locale, from, to); */
    }
    return NULL;
}

IMText *
Utility::CreateIMText(
    iml_session_t * s,
    IMEncoding encoding,
    char *source,
    XIMFeedback * feedback,
    int length,
    int char_length
)
{
    int i;
    IMFeedbackList *fbl;
    IMFeedback *fb;
    IMText *p = (IMText *) s->If->m->iml_new(s, sizeof(IMText));
    p->encoding = encoding;
    p->char_length = char_length;
    p->feedback = (IMFeedbackList*) s->If->m->iml_new(s, sizeof(IMFeedbackList) * char_length);
    memset(p->feedback, 0, sizeof(IMFeedbackList) * char_length);

    for (i = 0; i < char_length; i++) {
	fbl=&p->feedback[i];
	IM_FEEDBACK_COUNT(fbl)=1;
	fb=fbl->feedbacks=(IMFeedback*)s->If->m->iml_new(s, sizeof(IMFeedback));
	memset(fbl->feedbacks, 0, sizeof(IMFeedback));
	IM_FEEDBACK_TYPE(fb)=IM_DECORATION_FEEDBACK;
	IM_FEEDBACK_VALUE(fb)=IMNormal;
    }
    if (feedback) {
        for (i = 0; i < char_length; i++) {
	    fbl=&p->feedback[i];
	    IM_FEEDBACK_COUNT(fbl)=1;
	    fb=&fbl->feedbacks[i];
	    IM_FEEDBACK_TYPE(fb)=IM_DECORATION_FEEDBACK;
	    IM_FEEDBACK_VALUE(fb)=(int)feedback[i];
	}
    }
    p->text.native_chars = (char *) s->If->m->iml_new(s, sizeof(char) * (length + 1));
    memset(p->text.native_chars, 0, sizeof(char) * (length + 1));
    memcpy(p->text.native_chars, source, sizeof(char) * length);
    return p;
}

IMText *
Utility::CreateIMTextFromBuf(
    iml_session_t * s,
    char *source,
    XIMFeedback * feedback,
    int length,
    CodeSetConverter * conv
)
{
    IMFeedbackList *fbl;
    IMFeedback *fb;
    UTFCHAR tmp;
    IMText *p;
    unsigned int len, i;
    char from[UTF16_STRLEN], to[UTF16_STRLEN];
    char *from_buf = from, *to_buf = to;
    size_t from_len, to_len;
    
    p = (IMText *) s->If->m->iml_new(s, sizeof(IMText));
    memset(p, 0, sizeof(IMText));
    
    p->encoding = UTF16_CODESET;
    
    from_len = length;
    
#ifdef	DEBUG
    for (i = 0; i < from_len; i++) {
        printf("%x ", source[i]);
    }
    printf("\n");
#endif
    
    to_len = UTF16_STRLEN;
    
    memset(from_buf, 0, UTF16_STRLEN);
    memcpy(from_buf, source, from_len);
    
#ifdef	DEBUG
    printf("source: [%ws] len=%d\n", source, from_len);
#endif
    
    conv->run((const char **) (&from_buf), &from_len, &to_buf, &to_len);
    
    len = (UTF16_STRLEN - to_len) / sizeof(UTFCHAR);	/* the number of utf16 */

#ifdef	DEBUG
    printf("converted: len = %d\n", len);
#endif

    /* return a default null IMText to avoid error occurs on client side */

    if (len < 1) {
        p->text.utf_chars = (UTFCHAR *) s->If->m->iml_new(s, sizeof(UTFCHAR));
        p->char_length = 1;
        p->text.utf_chars[0] = 0;

        p->feedback = (IMFeedbackList*) s->If->m->iml_new(s, sizeof(IMFeedbackList));
        (&(p->feedback[0]))->count_feedbacks = 1;
        (&(p->feedback[0]))->feedbacks = (IMFeedback*)s->If->m->iml_new(s, sizeof(IMFeedback));
        (&(p->feedback[0]))->feedbacks->type = IM_DECORATION_FEEDBACK;
        (&(p->feedback[0]))->feedbacks->value = IMNormal;

        return p;
    }

    p->text.utf_chars = (UTFCHAR *) s->If->m->iml_new(s, sizeof(UTFCHAR) * len);
    
    for (i = 0; i < len; i++) {
        bcopy((to + 2 * i), &tmp, sizeof(UTFCHAR));
        p->text.utf_chars[i] = tmp;

#ifdef	DEBUG
        printf("%0x -- ", tmp);
#endif
    }

#ifdef	DEBUG
    printf("\n");
#endif
    
    p->char_length = len;
    p->feedback = (IMFeedbackList*) s->If->m->iml_new(s, sizeof(IMFeedbackList) * p->char_length);
    for (i = 0; i < p->char_length; i++) {
        fbl=&p->feedback[i];
        IM_FEEDBACK_COUNT(fbl)=1;
        fb=fbl->feedbacks=(IMFeedback*)s->If->m->iml_new(s, sizeof(IMFeedback));
        memset(fbl->feedbacks, 0, sizeof(IMFeedback));
        if (feedback && feedback[i]) {
	    IM_FEEDBACK_TYPE(fb)=IM_DECORATION_FEEDBACK;
	    IM_FEEDBACK_VALUE(fb)=(int)feedback[i];
        }
    }
    return p;
}

char *
Utility::CreateMBSFromUTF16(
    iml_session_t *s,
    char *locale,
    UTFCHAR * utf_chars,
    int utf_char_length
)
{
    int str_length;
    int i;
    char *dst;
    char *utf16_str;
    char *utf16_str_src;
    char *j;
    XSunIMConv *xsunconv;
    CodeSetConverter *conv;
    size_t len, dst_len;
    
    xsunconv = getConv(locale, "UTF-16", "MultiByte");
    if (xsunconv == NULL) {
	return NULL;
    }

    conv = xsunconv->conv;
    
    if (conv == NULL) {
        return NULL;
    }
    utf16_str_src = (char *) s->If->m->iml_new(s, sizeof(char) * UTF16_STRLEN);
    memset(utf16_str_src, 0, sizeof(char) * UTF16_STRLEN);
    j = utf16_str_src;
    
    for (i = 0; i < utf_char_length; i++) {
        *j++ = ((utf_chars[i] >> 8) & 0x00ff);
        *j++ = (utf_chars[i] & 0x00ff);
    }
    len = j - utf16_str_src;
    
    len *= sizeof(UTFCHAR);
    utf16_str = (char *) s->If->m->iml_new(s, sizeof(char) * (len + 1));
    memset(utf16_str, 0, sizeof(char) * (len + 1));
    
    dst = utf16_str;
    dst_len = UTF16_STRLEN;
    
    conv->run((const char **) (&utf16_str_src), &len, &dst, &dst_len);
    
    str_length = (UTF16_STRLEN - dst_len);
    
    return utf16_str;
}

IMText *
Utility::CreateIMTextFromMBS(
    iml_session_t * s,
    unsigned char *mbs,
    int length,
    char *locale
)
{
    
    XSunIMConv *xsunconv;
    CodeSetConverter *conv;
    IMText *imtext;
    
    xsunconv = getConv(locale, "MultiByte", "UTF-16");
    if (xsunconv == NULL) {
	return NULL;
    }
    conv = xsunconv->conv;
    if (conv == NULL) {
	return NULL;
    }
    
    imtext = (IMText *) CreateIMTextFromBuf(s, (char *) mbs, NULL, length, conv);
    return imtext;
}

IMText *
Utility::CreateIMTextFromWCS(
    iml_session_t * s,
    wchar_t * cws,
    XIMFeedback * cfb,
    int length,
    char *locale
)
{
    XSunIMConv *xsunconv;
    CodeSetConverter *conv;
    IMText *imtext;
    int len = length * (sizeof(wchar_t));

    xsunconv = getConv(locale, "WideChar", "UTF-16");
    if (xsunconv == NULL) {
	return NULL;
    }
    conv = xsunconv->conv;
    if (conv == NULL) {
	return NULL;
    }
    
    imtext = (IMText *) CreateIMTextFromBuf(s, (char *) cws, cfb, len, conv);
    return imtext;
}

XEvent ev;

XEvent *
Utility::getXKeyEvent(
    int keycode,
    int keychar,
    int state
)
{
    if (keyconv == NULL) {
        keyconv = new KeyConverter();
    }
    keyconv->getXKeyEvent(keycode, keychar, state, ev);
    return &ev;
}

KeySym
Utility::getX11Keysym(
    long keycode
)
{
    if (keyconv == NULL) {
        keyconv = new KeyConverter();
    }
    return keyconv->getX11KeySym(keycode);
}

static Display *display = (Display *) 0;
static Window root = (Window) 0;

void
Utility::getIMKey(
    IMKeyEventStruct & imkey,
    int keycode,
    int state
)
{
    int imkeycode, imkeystate;
    int imkeychar;
    
#ifdef  notdef
    if (!display)
        display = (Display *) XOpenDisplay(NULL);
    if (!root)
        root = DefaultRootWindow(display);
#endif
    
    if (keyconv == NULL) {
        keyconv = new KeyConverter();
    }
    memset(&ev, 0, sizeof(XEvent));
    ev.type = (int) KeyPress;
    ev.xany.display = display;
    ev.xkey.root = root;
    ev.xkey.window = 0;
    ev.xkey.x = 0;
    ev.xkey.y = 0;
    ev.xkey.x_root = 0;
    ev.xkey.y_root = 0;
    
    ev.xkey.keycode = keycode;
    ev.xkey.state = state;
    
    keyconv->getIMKeyEvent(ev, imkeycode, imkeychar, imkeystate);
    imkey.keyCode = imkeycode;
    imkey.keyChar = imkeychar;
    imkey.modifier = imkeystate;
}

#ifdef	notdef

/* workaround until PI_Conv bug's fix */

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <wchar.h>
#include <iconv.h>

static iconv_t i_conv1 = NULL;
static iconv_t i_conv2 = NULL;

static int ConvertToUTF16(char *from_buf, size_t from_left, char **to_buf, size_t * to_left);
static int ConvertFromUTF16(char *from_buf, size_t from_left, char **to_buf, size_t * to_left);

IMText *
Utility::convtoutf(
    char *src,
    XIMFeedback * feedback,
    int src_len
)
{
    int str_length, byte_length;
    int i;
    char *dst;
    unsigned int dst_len;
    char utf16_str[UTF16_STRLEN];
    IMText *text;
    UTFCHAR first_byte, second_byte;
    UTFCHAR utfchar;
    memset(utf16_str, 0, UTF16_STRLEN);
    
    dst = utf16_str;
    dst_len = UTF16_STRLEN;
    ConvertToUTF16(src, (unsigned int) src_len, &dst, &dst_len);
    byte_length = (UTF16_STRLEN - dst_len);
    str_length = byte_length / 2;
    
    text = new IMText;
    memset(text, 0, sizeof(IMText));
    
    if (feedback != 0) {
        text->feedback = new IMFeedback[src_len];
        memset(text->feedback, 0, sizeof(IMFeedback) * src_len);
    }
    text->char_length = str_length;
    text->text.utf_chars = new UTFCHAR[str_length + 1];
    for (i = 0; i < str_length; i++) {
        UTFCHAR utfchar = utf16_str[2 * i] & 0x00ff;
        utfchar = utfchar << 8;
        text->text.utf_chars[i] = utfchar | (utf16_str[2 * i + 1] & 0x00ff);
        if (feedback != 0)
            text->feedback[i] = feedback[i];
    }
    return text;
}

static int
ConvertToUTF16(
    char *from_buf,
    size_t from_left,
    char **to_buf,
    size_t * to_left
)
{
    size_t src_len, dst_len;
    char *src, *dst;
    char buffer[UTF16_STRLEN];	/* Fix me! */
    const size_t buf_len = UTF16_STRLEN;
    size_t ret = 0;
    char *source_encoding = (char *) 0;
    int i;
    
    if (i_conv1 == (iconv_t) - 1 || i_conv2 == (iconv_t) - 1) {
        goto done;
    }
    if (i_conv1 == NULL) {
        if ((i_conv1 = iconv_open("UTF-8", "eucJP"))
            == (iconv_t) - 1)
        goto done;
    }
    if (i_conv2 == NULL) {
        if ((i_conv2 = iconv_open("UCS-2",
            "UTF-8")) == (iconv_t) - 1)
        goto done;
    }
    src = from_buf;
    src_len = (size_t) strlen(from_buf);
    dst = buffer;
    dst_len = buf_len;
    ret = iconv(i_conv1, (const char **) &src, (size_t *) & src_len,
        (char **) &dst, &dst_len);
    if (ret != 0)
        goto done;
    
    src = buffer;
    src_len = buf_len - dst_len;
    dst = *((char **) to_buf);
    
    ret = iconv(i_conv2, (const char **) &src, (size_t *) & src_len,
        (char **) &dst, (size_t *) to_left);
    done:
    return (ret);
}

char *
Utility:
convfromutf(
    UTFCHAR * utf_chars,
    int utf_char_length
)
{
    int str_length;
    int i, len;
    char *dst;
    unsigned int dst_len;
    char *utf16_str;
    char utf16_str_src[UTF16_STRLEN];
    char *j = utf16_str_src;
    XIMText *text;
    
    memset(utf16_str_src, 0, sizeof(char) * UTF16_STRLEN);
    
    for (i = 0; i < utf_char_length; i++) {
        *j++ = ((utf_chars[i] >> 8) & 0x00ff);
        *j++ = (utf_chars[i] & 0x00ff);
    }
    len = j - utf16_str_src;
    
    utf16_str = (char *) calloc(1, sizeof(char) * (len + 1));
    
    dst = utf16_str;
    dst_len = UTF16_STRLEN;
    ConvertFromUTF16(utf16_str_src, len, &dst, &dst_len);
    str_length = (UTF16_STRLEN - dst_len);
    
    return utf16_str;
}

static iconv_t i_conv1_FromUTF16 = NULL;
static iconv_t i_conv2_FromUTF16 = NULL;

static int
ConvertFromUTF16(
    char *from_buf,
    size_t from_left,
    char **to_buf,
    size_t * to_left
)
{
    
    size_t src_len, dst_len;
    char *src, *dst;
    char buffer[UTF16_STRLEN];	/* Fix me! */
    const size_t buf_len = UTF16_STRLEN;
    char *source_encoding = (char *) 0;
    size_t ret = 0;
    int i;
    
    if (i_conv1_FromUTF16 == (iconv_t) - 1 ||
      i_conv2_FromUTF16 == (iconv_t) - 1) {
        goto done;
    }
    if (i_conv2_FromUTF16 == NULL) {
        if ((i_conv2_FromUTF16 = iconv_open("eucJP", "UTF-8"))
            == (iconv_t) - 1)
        goto done;
    }
    if (i_conv1_FromUTF16 == NULL) {
        if ((i_conv1_FromUTF16 = iconv_open("UTF-8",
            "UCS-2")) == (iconv_t) - 1)
        goto done;
    }
    src = from_buf;
    src_len = (size_t) strlen(from_buf);
    src_len = from_left;
    /* don't stop at '\0' in case of * ascii */
    
    src = from_buf;
    dst = buffer;
    dst_len = buf_len;
    ret = iconv(i_conv1_FromUTF16, (const char **) &src, (size_t *) & src_len,
        (char **) &dst, &dst_len);
    if (ret != 0) {
        goto done;
    }
    src = buffer;
    src_len = buf_len - dst_len;
    dst = *((char **) to_buf);
    
    ret = iconv(i_conv2_FromUTF16, (const char **) &src, (size_t *) & src_len,
        (char **) &dst, (size_t *) to_left);
    done:
    return (ret);
}

#endif
