/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include "HotKey.hh"

static HotKeyNode * HKeyList = 0;

HotKeyNode * HotKey::createNewNode(
char *locale, char * keyline, char * if_name, char * method_name, LevelTag tag )
{
    HotKeyNode             key;
    char                *modifier, *detail;
    char                *ss;
    int                 ii;
    Bool                exclamation, tilde;
    HotKeyNode             *ret_node = (HotKeyNode *)NULL;
    static struct {
        char    *name;
        int     len;
        long    mask;
    } mod[] = {
        { (char*)"Ctrl",       4,      ControlMask     },
        { (char*)"Lock",       4,      LockMask        },
        { (char*)"Caps",       4,      LockMask        },
        { (char*)"Shift",      5,      ShiftMask       },
        { (char*)"Alt",        3,      Mod1Mask        },
        { (char*)"Meta",       4,      Mod1Mask        },
        { (char*)NULL,         0,      0               }};
#define AllMask (ControlMask | LockMask | ShiftMask | Mod1Mask)

    if( (ss = (char *)strrchr( keyline, '>' )) == NULL )
        detail = keyline;
    else
        detail = ss + 1;
    modifier = keyline;
    key.modifier = 0;
    key.modifier_mask = 0;
    key.keysym = XK_VoidSymbol;
    exclamation = False;
    /* Check the event state */
    do {
        while( *modifier == ' '  ||  *modifier == '\t' || *modifier == '<'
                                                || *modifier == '>' )
            modifier++;
        if( *modifier == (char)NULL )
            break;
        if( strncmp( modifier, "None", 4 ) == 0 ) {
            if( key.modifier_mask != 0  ||  exclamation )
                return NULL;
            key.modifier_mask = AllMask;
            modifier += 4;
        } else {
            if( *modifier == '!' ) {
                if( key.modifier_mask != 0  ||  exclamation )
                    return NULL;
                key.modifier_mask = AllMask;
                exclamation = True;
                modifier++;
                continue;
            }
            if( (tilde = (*modifier == '~')) ) {
                modifier++;
                while( *modifier == ' '  ||  *modifier == '\t' )
                    modifier++;
            }
            for( ii = 0; mod[ii].name != NULL; ii++ ) {
                if( strncmp( modifier, mod[ii].name, mod[ii].len ) == 0 ) {
                    key.modifier_mask |= mod[ii].mask;
                    if( !tilde )
                        key.modifier |= mod[ii].mask;
                    modifier += mod[ii].len;
                    break;
                }
            }
        }
        if( mod[ii].name == NULL )
            break;
    } while( *modifier != (char)NULL );

    /* Now check the actual key */
    while( *detail == ' '  ||  *detail == '\t' )
        detail++;
    for( ss = detail; isalnum(*ss)  ||  *ss == '_'; ss++ );
    *ss = (char)NULL;
    if (!strcmp(detail, "F11"))
        key.keysym = SunXK_F36;		/* labeled F11 */
    else 
        if (!strcmp(detail, "F12"))
	    key.keysym = SunXK_F37;	/* labeled F12 */
	else  
	    key.keysym = XStringToKeysym( detail );
    if (key.keysym !=  NoSymbol ) {
        ret_node = (HotKeyNode *)malloc(sizeof(HotKeyNode));
        ret_node->tag = tag;
        ret_node->keysym = key.keysym;
        ret_node->modifier = key.modifier;
        ret_node->modifier_mask = key.modifier_mask;
	ret_node->if_name = (char *)malloc(strlen(if_name) + 1);
        sprintf(ret_node->if_name, "%s", if_name);
	ret_node->if_name[strlen(if_name)] = '\0';
	ret_node->locale = strdup(locale);
	ret_node->methods_name = strdup(method_name);
#ifdef DEBUG
	printf("key %d, locale %s, if %s, method %s, level %d\n",
	ret_node->keysym, ret_node->locale, ret_node->if_name, ret_node->methods_name, ret_node->tag);
#endif
    }
    return ret_node;
}


void
HotKey::addHotKeyTable(char* locale, char *key, char *if_name, char *method_name, LevelTag tag)
{
  HotKeyNode * newnode;
  HotKeyNode * tmplist;

  tmplist = HKeyList;
  newnode = (HotKeyNode *)createNewNode(locale, key, if_name, method_name, tag);
  if (!newnode)
     return;
  newnode->next = NULL;

  if (!tmplist) {
     HKeyList = newnode;
  } else {
     while (tmplist->next)
        tmplist = tmplist->next;
     tmplist->next = newnode;
  }
  return;
}

Bool
HotKey::isRegisteredKey( HotKeyNode *list, XKeyEvent *ev, LevelTag * tag)
{
#define BUFFLIM         32
    KeySym              keysym = 0;
    char                buff[BUFFLIM];

/*
printf("key->code is %d, list->keysym is %d\n", ev->keycode, list->keysym);
    XLookupString( (XKeyEvent *)ev, buff, BUFFLIM, &keysym, NULL );
*/
    keysym = ev->keycode;

    if(!keysym || list == NULL) return False ;
    if ((keysym == list->keysym) && ((ev->state & list->modifier_mask)
                                         == list->modifier ) ){
	    *tag = list->tag;
            return True ;
        }
    return False ;
}

/************************************************************************
 *      char * getLanguageEngineFromHotKey(XKeyEvent * ev)		*
 *	Returns : Interface object name corresponding to the hotkey.    *
 *									*
 ************************************************************************/
char *
HotKey::getMethodsName(char *locale, char *engine_name)
{
  HotKeyNode * tmplist;

  if(HKeyList == NULL) buildHotKeyTable(locale);
  tmplist = HKeyList;
  while (tmplist) {
    if ((!strcmp(tmplist->locale, locale)) &&
	(!strcmp(tmplist->if_name, engine_name))) 
        return (char *)(tmplist->methods_name);
    tmplist = tmplist->next;
  }
  return (char *)0;
}

unsigned long
HotKey::getHotKeyKeysym(char *locale, char *engine_name)
{
  HotKeyNode * tmplist;

  tmplist = HKeyList;
  while (tmplist) {
    if ((!strcmp(tmplist->locale, locale)) &&
        (!strcmp(tmplist->if_name, engine_name)))
        return (unsigned long)(tmplist->keysym);
    tmplist = tmplist->next;
  }
  return (unsigned long) 0;
}

unsigned int
HotKey::getHotKeyModifier(char *locale, char *engine_name)
{
  HotKeyNode * tmplist;

  tmplist = HKeyList;
  while (tmplist) {
    if ((!strcmp(tmplist->locale, locale)) &&
        (!strcmp(tmplist->if_name, engine_name)))
        return (unsigned int)(tmplist->modifier);
    tmplist = tmplist->next;
  }
  return (unsigned int) 0;
}

LevelTag
HotKey::getHotKeyLevel(char *locale, char *engine_name)
{
  HotKeyNode * tmplist;

  tmplist = HKeyList;
  while (tmplist) {
    if ((!strcmp(tmplist->locale, locale)) &&
        (!strcmp(tmplist->if_name, engine_name)))
        return (LevelTag)(tmplist->tag);
    tmplist = tmplist->next;
  }
  return (LevelTag) 0;
}

char *
HotKey::getLanguageEngineFromHotKey(XKeyEvent *ev, LevelTag * tag)
{
  HotKeyNode * tmplist;

  tmplist = HKeyList;
  while (tmplist) {
    if (isRegisteredKey(tmplist, ev, tag))
        return (char *)(tmplist->if_name);
    tmplist = tmplist->next;
  }
  return (char *)0;
}


/************************************************************************
 *      void buildHotKeyTable(char * locale)				*
 *	     Build the internal hot-key table.				*
 *	     The hot-key file ("hotkey.dat") shld be in the foll. format*
 *		<Hot Key>	<Interface name>	<Method name>	*
 *		eg:							*
 *		F2		xci			golden		*
 *		<Shift>F3	cm			newPY		*
 *									*
 ************************************************************************/
/*
void
HotKey::buildHotKeyTable() {
static char* locales[] = { "ja", "ko", "zh", "zh.GBK", "zh_TW", "zh.UTF-8", 
			   "zh_TW.UTF-8", "ko.UTF-8", "ja_JP.UTF-8" };
int i;

    for(i = 0; i < 9; i ++) {
	buildSystemHotKeyTable(locales[i]);
        buildUserHotKeyTable(locales[i]);
    }
    return;
}
*/

void
HotKey::buildHotKeyTable(char *locale) {

    buildSystemHotKeyTable(locale);
    buildUserHotKeyTable(locale);
    return;
}

void
HotKey::buildSystemHotKeyTable(char * locale) {
#define LINE_SIZE	256
    FILE *fp;
    struct stat stat_buf;
    char keylist[128], if_method_name[128];
    char engine_name[64], method_name[64];
    char file_line[LINE_SIZE];
    char filename[128];
    char *ow_home = NULL;
    Bool path_formed  = True;
    static char * ow_home_default = "/usr/openwin"; 
    static Bool sys_already_done = False;
    Bool block_found = False;
/*
    if (sys_already_done)
	return;
    else
	sys_already_done = True;
*/

    if ((ow_home = getenv("OPENWINHOME")) == NULL)
      ow_home = ow_home_default;
    sprintf(filename, "%s/lib/locale/%s/xim/hotkey.dat", ow_home, locale);
    if (stat(filename, &stat_buf)) {
       sprintf(filename, "%s/lib/locale/common/xim/hotkey.dat", ow_home);
       if (stat(filename, &stat_buf)) {
          sprintf(filename, "%s/lib/locale/%s/htt/hotkey.dat", ow_home, locale);
	  if (stat(filename, &stat_buf)) 
	     path_formed = False;
       }
    }		
    if (!path_formed)
	return;	 

    if (stat_buf.st_size <= 0)
       return;

    if ((fp = fopen(filename, "r")) == NULL)
        return;

    while (1) {
	memset(file_line, 0, LINE_SIZE);
	memset(keylist, 0, 128);
	memset(engine_name, 0, 64);
	memset(method_name, 0, 64);
        fgets(file_line, LINE_SIZE, fp);
        if (feof(fp))
           break;
	if (!block_found) {
	   if (!strncmp(file_line, "@BEGIN_SYSTEM", 13))
	      block_found = True;
	   continue;
	}
	if (!strncmp(file_line, "@END_SYSTEM", 11))
	     break;
        if (file_line[0] == ' ' || file_line[0] == '\t' || file_line[0] == '#')
	   continue;
        sscanf(file_line, "%s%s%s", &keylist, &engine_name, &method_name);
	if (engine_name[0] == '\0')
	   continue;
        sprintf(if_method_name, "%s:%s", engine_name, method_name);
        add_keylist(locale, keylist, engine_name, method_name, SystemLevel);
    }
    fclose(fp);
}

void
HotKey::buildUserHotKeyTable(char *locale) {
#define LINE_SIZE	256
    FILE *fp;
    struct stat stat_buf;
    char keylist[128], if_method_name[128];
    char engine_name[64], method_name[64];
    char file_line[LINE_SIZE];
    char filename[128];
    char *ow_home = NULL;
    char *user_home = NULL;
    Bool path_formed  = True;
    static char * ow_home_default = "/usr/openwin"; 
    static Bool usr_already_done = False;
    Bool block_found = False;
/*
    if (usr_already_done)
	return;
    else
	usr_already_done = True;

    if ((user_home = getenv("HOME")) != NULL) {
       sprintf(filename, "%s/.Xlocale/%s/xim/hotkey.dat", user_home, locale);
       if (stat(filename, &stat_buf))
	  path_formed = False;
       else
	  path_formed = True;
    } else {
	path_formed = False;
    }	 
*/
    path_formed = False;

    if (!path_formed) {
        path_formed = True;
        if ((ow_home = getenv("OPENWINHOME")) == NULL)
           ow_home = ow_home_default;
        sprintf(filename, "%s/lib/locale/%s/xim/hotkey.dat", ow_home, locale);
        if (stat(filename, &stat_buf)) {
           sprintf(filename, "%s/lib/locale/common/xim/hotkey.dat", ow_home);
           if (stat(filename, &stat_buf)) {
              sprintf(filename, "%s/lib/locale/%s/htt/hotkey.dat", ow_home, locale);
              path_formed = False;
           }
        }
    }

    if (!path_formed)
	return;	 

    if (stat_buf.st_size <= 0)
       return;

    if ((fp = fopen(filename, "r")) == NULL)
        return;

    while (1) {
	memset(file_line, 0, LINE_SIZE);
	memset(keylist, 0, 128);
	memset(engine_name, 0, 64);
	memset(method_name, 0, 64);
        fgets(file_line, LINE_SIZE, fp);
        if (feof(fp))
           break;
	if (!block_found) {
	   if (!strncmp(file_line, "@BEGIN_USER", 11))
	      block_found = True;
	   continue;
	}
	if (!strncmp(file_line, "@END_USER", 9))
	     break;
        if (file_line[0] == ' ' || file_line[0] == '\t' || file_line[0] == '#')
	   continue;
        sscanf(file_line, "%s%s%s", &keylist, &engine_name, &method_name);
	if (engine_name[0] == '\0')
	   continue;
        sprintf(if_method_name, "%s:%s", engine_name, method_name);
        add_keylist(locale, keylist, engine_name, method_name, UserLevel);
    }
    fclose(fp);
}

void
HotKey::add_keylist(char *locale, char *keylist, char *engine_name, char *method_name, LevelTag tag)
{
    char keyid[128];
    char *strptr, *tstr;

    strptr = keylist;
    while ( 1 ) {
	if ( (tstr = strchr(strptr, '|') ) != NULL ) {
	   if ( tstr == strptr ) break;
	   strncpy(keyid, strptr, (tstr-strptr));
           addHotKeyTable(locale, keyid, engine_name, method_name, tag);
	   strptr = tstr+1;
	   if ( strlen(strptr) == 0 ) break;
	} else {
	   strcpy(keyid, strptr);
           addHotKeyTable(locale, keyid, engine_name, method_name, tag);
	   break;
	}
    }
}

void
HotKey::deleteHotKeyTable(void)
{
  HotKeyNode *delnode;
  HotKeyNode *tmplist, *tmp1list;
  HotKeyNode *prev_node = (HotKeyNode *)0;

  tmplist = HKeyList;
  while ( tmplist ) {
    if (tmplist->tag == UserLevel) {
       tmp1list = tmplist;
       while (tmp1list) {
           delnode = tmp1list;
	   tmp1list = delnode->next;
	   free(delnode);
       }	
       if (prev_node)
	 prev_node->next = (HotKeyNode *)0;
       else
	 HKeyList = (HotKeyNode *)0;
       break;	
    }
    prev_node = tmplist;
    tmplist = tmplist->next;
  }
  return;
}

