/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#ifdef	DEBUG
#include <stdio.h>
#endif
#include <stdlib.h>
#include <string.h>
#include <locale.h>
#include <unistd.h>
#include <errno.h>
#include <pwd.h>
#include "VMPublic.h"

#ifdef  USE_DOOR
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <door.h>
#endif

#include "VM_Driver.hh"
#include "DrvManager.hh"

#ifdef  USE_DOOR
static void object_server(void *, caddr_t, size_t, door_desc_t *, size_t);

static void
object_server(
    void *cookie,
    caddr_t arg_ptr,
    size_t arg_size,
    door_desc_t * d,
    size_t n
)
{
    VMSignalData receive, reply;
    VM_Driver *le_driver = (VM_Driver *) cookie;
    memcpy(&receive, arg_ptr, arg_size);
    le_driver->TransService(&receive, &reply);
    (void) door_return((char *) &reply, sizeof(VMSignalData), 0, 0);
}
#endif

VM_Driver::VM_Driver(
    DrvManager *p_drv_man,
    char *lc,
    char *le,
    char *methods,
    int csocket
)
{
    state = True;
    drv_man = p_drv_man;
 
    locale = (char *) strdup(lc);

    setlocale(LC_ALL, locale);

    static char *tmp_locale = (char *) calloc(1, sizeof(char) * (1 + strlen("LANG=") + strlen(locale)));
    sprintf(tmp_locale, "LANG=%s", locale);
    putenv(tmp_locale);

    /* putenv HOME for cm */
    if(getenv("HOME")==NULL){
        putenv("HOME=/");
    }

    if(csocket == -2){
	return;
    }

#ifdef  USE_DOOR
    if(csocket == -1){
        int did, fd;
        if ((did = door_create(object_server, (void *) this, 0)) < 0) {
            perror("door_create");
	    state = False;
	    return;
        }
        /* attach it to the filesystem */
        fd = open(DOOR_TMP_FILE, O_CREAT, 0666);
        if (fd != -1) {
            close(fd);
        }
        fdetach(DOOR_TMP_FILE);
        if (fattach(did, DOOR_TMP_FILE) < 0) {
            perror("fattach");
	    state = False;
	    return;
        }
    }
#endif
    channel = csocket;
}

VM_Driver::~VM_Driver()
{
    free(locale);
}

void
VM_Driver::TransService()
{
    VMSignalData receive, reply;
    while (1) {
        if (read(channel, &receive, sizeof(VMSignalData)) < 0) {
#ifdef	DEBUG
            printf("LE Driver: error %d reading socket\n", errno);
#endif
            break;
        }
        TransService(&receive, &reply);

        if (write(channel, &reply, sizeof(VMSignalData)) < 0) {
#ifdef	DEBUG
            printf("LE Driver: error %d writing socket\n", errno);
#endif
            break;
        }
    }
    close(channel);
}

void
VM_Driver::TransService(VMSignalData * request,
			VMSignalData * reply)
{
  switch (request->type) {
  case CONNECT_START :
    drvmanager = drv_man;
    drv_man->addRequestData(request);
    break;
  default :
    drvmanager->handleRequest(request, reply);
    break;
  }
}

