/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#ifdef DEBUG
#include <stdio.h>
#endif
#include <unistd.h>
#include <stdlib.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <X11/Xlib.h>

#include "VMSharedMemory.hh"

VMSharedMemory::VMSharedMemory()
{
    maxsize = MAX_SHM_SIZE;
    VMSharedMemory(MAX_SHM_SIZE);
}

VMSharedMemory::VMSharedMemory(
    int size
)
{
    maxsize = size;
    rs = NULL;
    if (init(size)) {
#ifdef	DEBUG
        printf("init shared memory successfully!\n");
#endif
    } else {
#ifdef	DEBUG
        printf("init shared memory failed!\n");
#endif
    }
}

VMSharedMemory::~VMSharedMemory()
{
#ifdef	DEBUG
    printf("unmap shared memory\n");
#endif
    munmap((char *) sharedmem, maxsize);
}

Bool
VMSharedMemory::init(
    int size
)
{
    
    maxsize = size;
    int fd = open("/dev/zero", O_RDWR);
    
    if (fd < 0) {
        return False;
    }
    if ((sharedmem = (long *) mmap(0, maxsize, PROT_READ | PROT_WRITE, MAP_SHARED, fd, 0)) == (long *) -1) {
        return False;
    }
    *sharedmem = sizeof(sharedmem);
#ifdef	DEBUG
    printf("shm is from %ld\n", sharedmem);
#endif
    close(fd);
    return True;
}

void
VMSharedMemory::add_shm_to_recyle_chain(
    void *addr,
    int size
)
{
    VMRecyleShm *p, *q;
    
    p = (VMRecyleShm *) malloc(sizeof(VMRecyleShm));
    p->addr = addr;
    p->size = size;
    p->status = SHM_BUSY;
    p->next = NULL;
    
    if (rs == NULL)
        rs = p;
    else {
        q = rs;
        while (q->next)
        q = q->next;
        q->next = p;
    }
}

void
VMSharedMemory::free_shm_in_recyle_chain(
    void *addr,
    int size
)
{
    VMRecyleShm *p;
    
    p = rs;
    while (p) {
        if ((p->addr == addr) && (p->size == size)) {
            p->status = SHM_FREE;
            break;
        }
        p = p->next;
    }
}

void *
VMSharedMemory::alloc_shm_in_recyle_chain(
    int size
)
{
    VMRecyleShm *p;
    
    p = rs;
    while (p) {
        if ((p->status == SHM_FREE) && (size <= p->size)) {
            p->status = SHM_BUSY;
            return p->addr;
        }
        p = p->next;
    }
    return NULL;
}

void *
VMSharedMemory::ShmAlloc(
    int size
)
{
#define CUROFFSET (*sharedmem)
    char *addr;
    
    addr = (char *) alloc_shm_in_recyle_chain(size);
    if (addr)
        return addr;
    
    if (CUROFFSET + size < maxsize) {
        addr = (char *) sharedmem + CUROFFSET;
        CUROFFSET += size;
        add_shm_to_recyle_chain(addr, size);
        return addr;
    }
#ifdef	DEBUG
    fprintf(stderr, "Htt: %s\n", "Htt: shared memory over flown");
#endif
    return NULL;
}

Bool
VMSharedMemory::ShmFree(
    char *address,
    int size
)
{
    free_shm_in_recyle_chain(address, size);
    return True;
}

Bool
VMSharedMemory::ShmRead(
    char *address,
    char *reader,
    int size
)
{
    return True;
}

Bool
VMSharedMemory::ShmWrite(
    char *address,
    char *writer,
    int size
)
{
    return True;
}
