/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include <stdlib.h>
#include <string.h>

#include "VMSharedMemory.hh"
#include "DataRep.hh"

DataRep::DataRep(VMSharedArgumentsArea t_put_area, VMSharedArgumentsArea t_get_area)
{
  put_area = t_put_area;
  get_area = t_get_area;
}

void
DataRep::setArgsArea(VMSharedArgumentsArea t_put_area, 
			VMSharedArgumentsArea t_get_area)
{
  put_area = t_put_area;
  get_area = t_get_area;
}

void
DataRep::putInt(int i)
{
  memcpy((void *)put_area, (void *)&i, sizeof(int));
  put_area += sizeof(int);
  return;
}

void
DataRep::putChar(char c)
{
  memcpy((void *)put_area, (void *)&c, sizeof(char));
  put_area += sizeof(char);
  return;
}

void
DataRep::putUTFChar(UTFCHAR utfchar)
{
  memcpy((void *)put_area, (void *)&utfchar, sizeof(UTFCHAR));
  put_area += sizeof(UTFCHAR);
  return; 
}

void
DataRep::putUTFString(UTFCHAR *s, int len)
{
  UTFCHAR *t_s = s;
  for (int i=0; i<len; i++) {
      putUTFChar(*t_s++);
  }
  return;
}

void
DataRep::putLong(long l)
{
  memcpy((void *)put_area, (void *)&l, sizeof(long));
  put_area += sizeof(long);
  return;
}

void
DataRep::putShort(short s)
{
  memcpy((void *)put_area, (void *)&s, sizeof(short));
  put_area += sizeof(short);
  return;
}

void
DataRep::putString(char *s, int len)
{
  char *t_s = s;
  for (int i=0; i<len; i++) {
      putChar(*t_s++);
  }
  return;
}

void
DataRep::putWChar(wchar_t wc)
{
  memcpy((void *)put_area, (void *)&wc, sizeof(wchar_t));
  put_area += sizeof(wchar_t);
  return;
}

void
DataRep::putAny(void *any, int len)
{
  memcpy((void *)put_area, (void *)any, len);
  put_area += len;
  return;
}

void
DataRep::putArgs(IMArg *args, int num_args, int is_set)
{
 int i = 0;
 for (i = 0; i< num_args; i++) {
    putInt(args[i].id);
    if (is_set) {
       putInt(strlen((char *)args[i].value));
       putString((char *)args[i].value,
                         strlen((char *)args[i].value) );
    }
 }
}

void
DataRep::putXIMText(
			XIMText *text)
{
  putShort(text->length);
  putInt((int )text->encoding_is_wchar);
  XIMFeedback *feedback = text->feedback;
  if (feedback) {
    putInt(1);
    for (int i=0; i<text->length; i++)
      putLong(*feedback++);
  } else {
    putInt(0);
  }
  if (text->encoding_is_wchar) {
    wchar_t *wide_char = (wchar_t *)text->string.wide_char;
    for (int i = 0; i < text->length; i++)
      putWChar(*wide_char++);
  } else {
    char *multi_byte = (char *)text->string.multi_byte;
    int byte_len = strlen(multi_byte);

    for (int i = 0; i < byte_len; i++)
      putChar(*multi_byte++);
    putChar('\0');		// explicit terminator
  }
}

void
DataRep::getInt(int * val)
{
  memcpy((void *)val, (void *)get_area, sizeof(int));
  get_area += sizeof(int);
  return;
}

void
DataRep::getShort(short * val)
{
  memcpy((void *)val, (void *)get_area, sizeof(short));
  get_area += sizeof(short);
  return;
}

void
DataRep::getChar(char *val)
{
  memcpy((void *)val, (void *)get_area, sizeof(char));
  get_area += sizeof(char);
  return;
}

void
DataRep::getWChar(wchar_t *val)
{
  memcpy((void *)val, (void *)get_area, sizeof(wchar_t));
  get_area += sizeof(wchar_t);
  return;
}

void
DataRep::getLong(long *val)
{
  memcpy((void *)val, (void *)get_area, sizeof(long));
  get_area += sizeof(long);
  return;
}

void
DataRep::getString(char *str, int len)
{
  char *t_str = str;
  for (int i=0; i<len; i++) {
      getChar(t_str++);
  }
  return;
}

void
DataRep::getUTFChar(UTFCHAR *val)
{
  memcpy((void *)val, (void *)get_area, sizeof(UTFCHAR));
  get_area += sizeof(UTFCHAR);
  return;
}

void
DataRep::getUTFString(UTFCHAR *str, int len)
{
  UTFCHAR *t_str = str;
  for (int i=0; i<len; i++) {
      getUTFChar(t_str++);
  }
  return;
}

void
DataRep::getArgs(IMArg *args, int num_args, int is_set)
{
 int i = 0;
 for (i = 0; i< num_args; i++) {
     getInt(&(args[i].id));
     int len;
     if (is_set) {
        getInt(&len);
  	char * ts = (char *)new char[len+1];
        args[i].value = (char *)ts;
        getString((char *)(args[i].value),
                                        len);
	args[i].value[len] = '\0';
     }
 }     
}

void
DataRep::getAny(void *any, int len)
{
 memcpy(any, (void *)get_area, len);
 get_area += len;
 return;
} 

#ifdef	notdef
void
DataRep::getXIMText(
                        XIMText *text)
{
  getShort((short *)&(text->length));
  getInt((int *)&(text->encoding_is_wchar));
  // Check if feedback is given
  int is_feedback;
  getInt(&is_feedback);
  if (is_feedback) {
    text->feedback = (XIMFeedback *)new XIMFeedback[text->length];
    XIMFeedback *feedback = text->feedback;
    for (int i = 0; i<text->length; i++)
      getLong((long *)feedback++);
  }
  if (text->encoding_is_wchar) {
    text->string.wide_char = (wchar_t *)new wchar_t[text->length + 1];
    wchar_t *wide_char = (wchar_t *)text->string.wide_char;
    for (int i = 0; i < text->length; i++)
      getWChar(wide_char++);
    text->string.wide_char[text->length] = (wchar_t)0;
  } else {
    int max_mb_len = MB_CUR_MAX * text->length;
    text->string.multi_byte = (char *)new char[max_mb_len + 1];
    char *multi_byte = (char *)text->string.multi_byte;
    for (int i = 0; i < max_mb_len + 1; i++, multi_byte++) {
      getChar(multi_byte);
      if (*multi_byte == '\0') break;
    }
  }
}
#endif
