/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include <stdio.h>
#include <stdlib.h>

#include "sunim.hh"

#ifdef	sun
#include <unistd.h>
#include "SystemMessage.h"
#endif

#define DOOR_TMP_FILE   "/tmp/.htt_server_door"

extern "C" {
    Public iml_inst *iml_execute_iml_wrapper(iml_session_t *, iml_inst **);
    Public iml_if_t *if_OpenIF(char *if_path, char *if_name, char *locale, Bool);
    Public void if_CloseIF(iml_if_t *, Bool);
    Public Bool if_GetIFValues(iml_if_t *, IMArgList, int);
    Public Bool if_SetIFValues(iml_if_t *, IMArgList, int);
    Public iml_session_t *if_CreateSC(iml_if_t *, IMArgList, int);
    Public Bool if_DestroySC(iml_session_t *);
    Public Bool if_GetSCValues(iml_session_t *, IMArgList, int);
    Public Bool if_SetSCValues(iml_session_t *, IMArgList, int);
    Public void if_SendEvent(iml_session_t *, IMInputEvent *);
    Public IMText *if_ResetSC(iml_session_t *);
    Public void if_SetSCFocus(iml_session_t *);
    Public void if_UnsetSCFocus(iml_session_t *);
    Public void sunim_slot_manager_init();

#ifdef	USE_XSUNIM_ADAPTER
    Public void xsunim_slot_manager_init();
#endif /* USE_XSUNIM_ADAPTER */
}

#ifdef	 sun
mutex_t sunim_if_block_mutex;
#elif	WIN32
HANDLE sunim_if_block_mutex;
#else	/* Linux */
pthread_mutex_t sunim_if_block_mutex;
#endif

UserInfo::UserInfo(
    IMArgList p_args,
    int p_num_args
)
{
    set_values(p_args, p_num_args);
}

UserInfo::UserInfo(
    char *p_user_name,
    char *p_host_name,
    char *p_display_id
)
{
    IMArg p[3];
    IMSetArg(p[0], UI_USER_NAME, p_user_name);
    IMSetArg(p[1], UI_HOST_NAME, p_host_name);
    IMSetArg(p[2], UI_DISPLAY_ID, p_display_id);
    set_values(p, 3);
}

UserInfo::~UserInfo()
{
    for (int i = 1; i <= MAX_UI_ATTRIBUTE; i++) {
        char *value = &(uiargs.getItemByKey(i));
        if (value) {
            delete value;
        }
    }
    uiargs.destroy();
}

Bool
UserInfo::get_values(
    IMArgList p_args,
    int p_num_args
)
{
    if (p_num_args == 0) {
        return False;
    }
    int i;
    IMArg *p = p_args;
    for (i = 0; i < p_num_args; i++, p++) {
        if (p->id >= 1 && p->id <= MAX_UI_ATTRIBUTE) {
            p->value = &(uiargs.getItemByKey(p->id));
        }
    }
    return True;
}

Bool
UserInfo::set_values(
    IMArgList p_args,
    int p_num_args
)
{
    if (p_num_args == 0) {
        return False;
    }
    int i;
    IMArg *p = p_args;
    char *value;
    for (i = 0; i < p_num_args; i++, p++) {
        if (p->id >= 1 && p->id <= MAX_UI_ATTRIBUTE) {
            value = (char *) p->value;
            if (value && strlen(value)) {
                char *tmp_value = &(uiargs.getItemByKey(p->id));
                if (tmp_value) {
                    delete tmp_value;
                }
                tmp_value = new char[strlen(value) + 1];
                strcpy(tmp_value, value);
                tmp_value[strlen(value)] = '\0';
                
                uiargs.addItemByKey(tmp_value, p->id);
                
                if (p->id == UI_USER_NAME) {
                    user_name = tmp_value;
                } else if (p->id == UI_HOST_NAME) {
                    host_name = tmp_value;
                } else if (p->id == UI_DISPLAY_ID) {
                    display_id = tmp_value;
                }
            }
        }
    }
    return True;
}

void
LEInterface::initialize()
{
#ifdef	sun
    unlink(DOOR_TMP_FILE);
#endif

#ifdef  sun
#elif   WIN32
    if ((sunim_if_block_mutex = CreateMutex(NULL, FALSE, NULL)) == 0) {
        printf("WIN32 Thread: CreateMutex() ERROR\n");
        return;
    }
#else   /* Linux */
#endif

    sunim_slot_manager_init();

#ifdef	USE_XSUNIM_ADAPTER
    xsunim_slot_manager_init();
#endif /* USE_XSUNIM_ADAPTER */
}

void
LEInterface::le_lock()
{
    if (need_thread_lock == True) {
        le_force_lock();
    }
}

void
LEInterface::le_force_lock()
{
#ifdef  sun
    if (mutex_lock(&sunim_if_block_mutex) != 0) {
        system_message(MSG_ERROR, "mutex_lock() FAILED\n");
    }
#elif   WIN32
    if (WaitForSingleObject(sunim_if_block_mutex, INFINITE) == WAIT_FAILED) {
        printf("WaitForSingleObject() FAILED\n");
    }
#else	/* Linux */
    if (pthread_mutex_lock(&sunim_if_block_mutex) != 0) {
        printf("pthread_mutex_lock() FAILED\n");
    }
#endif
}

void
LEInterface::le_unlock()
{
    if (need_thread_lock == True) {
        le_force_unlock();
    }
}

void
LEInterface::le_force_unlock()
{
#ifdef  sun
    if (mutex_unlock(&sunim_if_block_mutex) != 0) {
        system_message(MSG_ERROR, "mutex_unlock() FAILED\n");
    }
#elif   WIN32
    if (ReleaseMutex(sunim_if_block_mutex) == 0) {
        printf("ReleaseMutex() FAILED\n");
    }
#else	/* Linux */
    if (pthread_mutex_unlock(&sunim_if_block_mutex) != 0) {
        printf("pthread_mutex_unlock() FAILED\n");
    }
#endif
}

LEInterface *
LEInterface::getLEInterface(
    char *p_ifpath,
    char *p_interface_module,
    char *p_locale
)
{
    LEInterface *le = new LEInterface(p_ifpath, p_interface_module, p_locale, True);
    if (le->itf_t == NULL) {
        delete le;
        return (LEInterface *) NULL;
    }
    return le;
}

LEInterface *
LEInterface::getLEInterfaceWithoutOpen(
    char *p_ifpath,
    char *p_interface_module,
    char *p_locale
)
{
    LEInterface *le = new LEInterface(p_ifpath, p_interface_module, p_locale, False);
    if (le->itf_t == NULL) {
        delete le;
        return (LEInterface *) NULL;
    }
    return le;
}

LEInterface::LEInterface(
    char *p_ifpath,
    char *p_interface_module,
    char *p_locale,
    Bool p_call_openif
)
{
    interface_module = strdup(p_interface_module);
    locale = strdup(p_locale);
    call_openif = p_call_openif;
    need_thread_lock = False;
    
    le_force_lock();
    itf_t = if_OpenIF(p_ifpath, interface_module, locale, p_call_openif);
    le_force_unlock();
    
    if (!itf_t) {
        return;
    }
    ifm = itf_t->ifm;
    need_thread_lock = itf_t->need_thread_lock;
}

LEInterface::~LEInterface()
{
    if (!itf_t) {
        return;
    }
    le_force_lock();
    if_CloseIF(itf_t, call_openif);
    le_force_unlock();
    free(locale);
    free(interface_module);
}

/*
 * if_SetIFValues()
 */

Bool
LEInterface::set_values(
    IMArgList args,
    int num_args
)
{
    le_force_lock();
    Bool ret = if_SetIFValues(itf_t, args, num_args);
    le_force_unlock();
    return ret;
}

/*
 * if_GetIFValues()
 */
Bool
LEInterface::get_values(
    IMArgList args,
    int num_args
)
{
    le_force_lock();
    Bool ret = if_GetIFValues(itf_t, args, num_args);
    le_force_unlock();
    return ret;
}

LESessionContext *
LESessionContext::getLESessionContext(
    LEInterface * p_interface,
    UserInfo * p_user
)
{
    LESessionContext *sc = new LESessionContext(p_interface, p_user);
    if (sc->s == NULL) {
        delete sc;
        return (LESessionContext *) NULL;
    }
    return sc;
}

LESessionContext::LESessionContext(
    LEInterface * p_interface,
    UserInfo * p_user
)
{
    s = (iml_session_t *) NULL;
    itf = p_interface;
    realize = False;
    
    if (p_interface == NULL || p_user == NULL) {
        return;
    }
    IMArg imarg[MAX_UI_ATTRIBUTE + 1];
    for (int i = 1; i <= MAX_UI_ATTRIBUTE; i++) {
        IMSetArg(imarg[i - 1], i, NULL);
    }
    p_user->get_values(imarg, MAX_UI_ATTRIBUTE);
    
    itf->le_force_lock();
    s = if_CreateSC(itf->itf_t, imarg, MAX_UI_ATTRIBUTE);
    itf->le_force_unlock();
}

/*
 * if_DestroySC()
 */

LESessionContext::~LESessionContext()
{
    if (s) {
        itf->le_force_lock();
        if_DestroySC(s);
        itf->le_force_unlock();
    }
}

void
LESessionContext::addIMLListener(
    iml_inst * (*p_iml_execute) (iml_inst **, void *),
    void *p_closure
)
{
    iml_execute = p_iml_execute;
    closure = p_closure;
    s->SessionContext = (void *) this;
}

/*
 * if_GetSCValues()
 */

Bool
LESessionContext::get_values(
    IMArgList args,
    int num_args
)
{
    itf->le_force_lock();
    Bool ret = if_GetSCValues(s, args, num_args);
    itf->le_force_unlock();
    return ret;
}

/*
 * if_SetSCValues()
 */
Bool
LESessionContext::set_values(
    IMArgList args,
    int num_args
)
{
    /* called from htt core, but ignore */
    if(itf->itf_t->xsunim == False && num_args == 1 &&
	args[0].id == SC_REALIZE){
	    return True;
    }

    /* at engine switching on en_US.UTF-8, SC_TRIGGER_ON_NOTIFY is
	called before SC_REALIZE */
    if(num_args == 1 && args[0].id == SC_TRIGGER_ON_NOTIFY){
        if(itf->itf_t->xsunim == False && realize == False){
	    IMArg args[1];
	    IMSetArg(args[0], SC_REALIZE, 0);
	    if_SetSCValues(s, args, 1);
	    realize = True;
	}
    }

    itf->le_force_lock();
    Bool ret = if_SetSCValues(s, args, num_args);
    itf->le_force_unlock();
    return ret;
}

/*
 * if_SendEvent()
 */
void
LESessionContext::send_event(
    IMInputEvent * ev
)
{
    itf->le_lock();
    if_SendEvent(s, ev);
    itf->le_unlock();
}

/*
 * if_ResetSC()
 */
IMText *
LESessionContext::reset()
{
    itf->le_lock();
    IMText *ret = (IMText *) if_ResetSC(s);
    itf->le_unlock();
    return ret;
}

void LESessionContext::set_focus()
{
    itf->le_lock();
    /* the first set_focus() generates SC_REALIZE */
    if(itf->itf_t->xsunim == False && realize == False){
        IMArg args[1];
        IMSetArg(args[0], SC_REALIZE, 0);
    	if_SetSCValues(s, args, 1);
        realize = True;
    }
    if_SetSCFocus(s);
    itf->le_unlock();
}

/*
 * if_UnsetSCFocus()
 */
void
LESessionContext::unset_focus()
{
    itf->le_lock();
    if_UnsetSCFocus(s);
    itf->le_unlock();
}

/*
 * wrapper of iml_execute()
 */
void
LESessionContext::callIMLExecute(
    iml_inst ** rrv
)
{
    if (iml_execute) {
        (*iml_execute) (rrv, closure);
    }
}

Public
iml_inst * iml_execute_iml_wrapper(
    iml_session_t * s,
    iml_inst ** rrv
)
{
    LESessionContext *p = (LESessionContext *) s->SessionContext;
    if (p) {
        p->callIMLExecute(rrv);
    }
    return (iml_inst *) NULL;
}

void
LEInterface::BC_xsunim_filterevent(
    IMInputEvent * e
)
{
    return;
}
