/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "sunim.hh"

#include "InterfaceModule.hh"
#include "LELookup.hh"

extern iml_inst *iml_execute(iml_inst **, void *);

void show_desktop_list(iml_if_t *);
void show_session_list(iml_desktop_t *);

#ifdef	WIN32
#define	IFPATH	"c:\\temp\\"
#else
#define	IFPATH	"/usr/lib/im/leif"
#endif

int mainp();
int mainkk();

main(){
	mainkk();
}

mainl()
{
int i, j;

    LEInterface *If1 = LEInterface::getLEInterface(IFPATH, "cm2", "ja");
    LEInterface *If2 = LEInterface::getLEInterface(IFPATH, "xci", "ja");

    UserInfo *user1 = new UserInfo("user1", "host1", "#1");
    UserInfo *user2 = new UserInfo("user2", "host2", "#1");

    LESessionContext *scs[100];

for(j=1;j<=10;j++){
    for(i=0;i<25;i++){
	 scs[i] = LESessionContext::getLESessionContext(If1, user1);
    }
    for(i=25;i<50;i++){
	 scs[i] = LESessionContext::getLESessionContext(If1, user2);
    }
    for(i=50;i<75;i++){
	 scs[i] = LESessionContext::getLESessionContext(If2, user1);
    }
    for(i=75;i<100;i++){
	 scs[i] = LESessionContext::getLESessionContext(If2, user2);
    }

    for(i=0;i<100;i++){
	 LESessionContext *sc = scs[i];

    IMArg arg[1];
    IMSetArg(arg[0], SC_TRIGGER_ON_NOTIFY, (char *)0);
    sc->set_values(arg, 1);

    IMInputEvent *ev;
    ev = (IMInputEvent *) new IMInputEvent;

    ev->type = IM_EventKeyList;
    ev->keylist.n_key = 1;
    ev->keylist.keylist = (IMKeyList) new IMKeyEventStruct;
    ev->keylist.keylist->keyCode = IM_VK_H;
    ev->keylist.keylist->keyChar = 'h';
    ev->keylist.keylist->modifier = 0;

    sc->send_event(ev);

    ev->type = IM_EventKeyList;
    ev->keylist.n_key = 1;
    ev->keylist.keylist->keyCode = IM_VK_A;
    ev->keylist.keylist->keyChar = 'a';
    ev->keylist.keylist->modifier = 0;

    sc->send_event(ev);

    ev->type = IM_EventKeyList;
    ev->keylist.n_key = 1;
    ev->keylist.keylist->keyCode = IM_VK_A;
    ev->keylist.keylist->keyChar = 'A';
    ev->keylist.keylist->modifier = 1;

    sc->send_event(ev);

    delete ev->keylist.keylist;
    delete ev;

    IMSetArg(arg[0], SC_TRIGGER_OFF_NOTIFY, (char *)0);
    sc->set_values(arg, 1);

    }

    for(i=0;i<100;i++){
	 LESessionContext *sc = scs[i];
	delete sc;
    }
}

    delete If1;
    delete If2;

    delete user1;
    delete user2;

    return 0;
}

mainj()
{
    LEInterface *If = LEInterface::getLEInterface(IFPATH, "cm2", "zh");
    UserInfo *user = new UserInfo("user1", "host1", "#1");
    LESessionContext *sc = LESessionContext::getLESessionContext(If, user);
    sc->addIMLListener(iml_execute, sc);

    IMArg arg[1];
    IMSetArg(arg[0], SC_TRIGGER_ON_NOTIFY, (char *)0);
    sc->set_values(arg, 1);

    IMInputEvent *ev;
    ev = (IMInputEvent *) new IMInputEvent;

    ev->type = IM_EventKeyList;
    ev->keylist.n_key = 1;
    ev->keylist.keylist = (IMKeyList) new IMKeyEventStruct;
    ev->keylist.keylist->keyCode = IM_VK_H;
    ev->keylist.keylist->keyChar = 'h';
    ev->keylist.keylist->modifier = 0;

    sc->send_event(ev);

    ev->type = IM_EventKeyList;
    ev->keylist.n_key = 1;
    ev->keylist.keylist->keyCode = IM_VK_A;
    ev->keylist.keylist->keyChar = 'a';
    ev->keylist.keylist->modifier = 0;

    sc->send_event(ev);

    ev->type = IM_EventKeyList;
    ev->keylist.n_key = 1;
    ev->keylist.keylist->keyCode = IM_VK_A;
    ev->keylist.keylist->keyChar = 'A';
    ev->keylist.keylist->modifier = 1;

    sc->send_event(ev);

    delete ev->keylist.keylist;
    delete ev;

    IMSetArg(arg[0], SC_TRIGGER_OFF_NOTIFY, (char *)0);
    sc->set_values(arg, 1);

    delete sc;
    delete If;

    delete user;

    return 0;
}

mainkk()
{
    int n;
    int i;
    IMArg p[10];
    InterfaceModuleList *mlist;

    LEInterface::initialize();
    
    mlist = LELookup::getListOfLEs(
        IFPATH,
        (char *) 0,
        (char *) 0,
        (char *) 0);
    LELookup::showListOfLEs(mlist);
    LELookup::freeListOfLEs(mlist);
    
    LEInterface *If = LEInterface::getLEInterface(IFPATH, "cm", "ja");

    delete If;

return 1;
}

mainp()
{
    int n;
    int i;
    IMArg p[10];
    InterfaceModuleList *mlist;

    LEInterface::initialize();
    
    mlist = LELookup::getListOfLEs(
        IFPATH,
        (char *) 0,
        (char *) 0,
        (char *) 0);
    
    LELookup::showListOfLEs(mlist);
    LELookup::freeListOfLEs(mlist);

    /*
    * open LE
    */
    LEInterface *If = LEInterface::getLEInterface(IFPATH, "sampleja", "ja");
    LEInterface *If2 = LEInterface::getLEInterface(IFPATH, "template", "");
    LEInterface *If3 = LEInterface::getLEInterface(IFPATH, "sampleja", "ja");
    
    if (If == 0 || If2 == 0 || If3 == 0) {
        exit(1);
    }
    /*
    * remove If for testing
    */
    delete If;
    delete If2;
    
    If2 = LEInterface::getLEInterface(IFPATH, "template", "");
    If = LEInterface::getLEInterface(IFPATH, "sampleja", "ja");
    
    /*
    * new session
    */
    UserInfo *user1 = new UserInfo("user1", "host1", "#1");
    UserInfo *user2 = new UserInfo("user2", "host2", "#2");
    
    /*
    * new session
    */
    
    /*
    * desktop info will be created automatically
    */
    
    printf("create SCs for IF user1\n");
    LESessionContext *sc1 = LESessionContext::getLESessionContext(If, user1);
    sc1->addIMLListener(iml_execute, sc1);
    
    LESessionContext *sc2 = LESessionContext::getLESessionContext(If, user1);
    sc2->addIMLListener(iml_execute, sc2);
    
    LESessionContext *sc3 = LESessionContext::getLESessionContext(If, user1);
    sc3->addIMLListener(iml_execute, sc3);
    
    LESessionContext *sc4 = LESessionContext::getLESessionContext(If, user1);
    sc4->addIMLListener(iml_execute, sc4);
    
    printf("create SCs for IF user2\n");
    LESessionContext *sc10 = LESessionContext::getLESessionContext(If, user2);
    sc10->addIMLListener(iml_execute, sc10);
    
    LESessionContext *sc11 = LESessionContext::getLESessionContext(If, user2);
    sc11->addIMLListener(iml_execute, sc11);
    
    show_desktop_list(If->itf_t);
    
    /*
    * user another engine
    */
    
    printf("create SC for IF2 user1\n");
    LESessionContext *sc101 = LESessionContext::getLESessionContext(If2, user1);
    
    printf("Delete SC for IF2 user1\n");
    delete sc101;
    
    /*
    * delete session
    */
    
    IMInputEvent *ev;
    ev = (IMInputEvent *) new IMInputEvent;
    ev->type = IM_EventKeyList;
    ev->keylist.n_key = 1;
    ev->keylist.keylist = (IMKeyList) new IMKeyEventStruct;
    ev->keylist.keylist->keyCode = IM_VK_A;
    ev->keylist.keylist->keyChar = 'a';
    ev->keylist.keylist->modifier = 0;
    
    sc1->send_event(ev);
    sc1->send_event(ev);
    sc1->send_event(ev);
    
    ev->type = IM_EventKeyList;
    ev->keylist.n_key = 1;
    ev->keylist.keylist->keyCode = IM_VK_SPACE;
    ev->keylist.keylist->keyChar = ' ';
    ev->keylist.keylist->modifier = 0;
    
    sc1->send_event(ev);
    sc1->send_event(ev);
    sc1->send_event(ev);
    
    ev->type = IM_EventKeyList;
    ev->keylist.n_key = 1;
    ev->keylist.keylist->keyCode = IM_VK_1;
    ev->keylist.keylist->keyChar = '1';
    ev->keylist.keylist->modifier = 0;
    
    sc1->send_event(ev);
    
    delete ev->keylist.keylist;
    delete ev;
    
    /*
    * delete session
    */
    
    printf("delete SCs for IF user1\n");
    delete sc1;
    delete sc2;
    delete sc3;
    delete sc4;
    
    printf("delete SCs for IF user2\n");
    delete sc10;
    delete sc11;
    
    delete user1;
    delete user2;
    
    delete If3;
    delete If2;
    delete If;

    return 0;
}

/*
 * need to register to LESessionContext by addIMLListener()
 */

iml_inst *
iml_execute(iml_inst ** rrv, void *closure)
{
    printf("registered:iml_execute rrv=%x closure=%x\n", rrv, closure);
    return (iml_inst *) NULL;
}

static int
UTFCHAR_len(UTFCHAR * p)
{
    int i;
    for (i = 0; *p; i++, p++);
    return i;
}

static UTFCHAR *
UTFCHAR_cpy(UTFCHAR * to, UTFCHAR * from)
{
    int i;
    UTFCHAR *to_ = to;
    for (i = 0; *from; i++, from++, to++) {
        *to = *from;
    }
    return to_;
}

void
show_desktop_list(iml_if_t * If)
{
    printf("## exising desktops and sessions\n");
    iml_desktop_t *p = If->desktop_list;
    while (p) {
        printf("user name=%s host=%s\n",
            p->user_name,
            p->host_name);
        show_session_list(p);
        if (p->next)
            p = p->next;
        else
        break;
    }
}

void
show_session_list(iml_desktop_t * desktop)
{
    iml_session_t *p = desktop->session_list;
    while (p) {
        printf("\tsession=%x\n", p);
        if (p->next)
            p = p->next;
        else
        break;
    }
}
