/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#ifdef	USE_XSUNIM_ADAPTER

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "SunIM.h"

/* Only for XSunIM based engines */
typedef struct _old_iml_session {
    struct _old_iml_session *next ;
    unsigned char *classname ;
    unsigned char *enginename ;
    unsigned char *locale ;
    int language_engine ;
    int session_id ;
    int public_status ;
    int initial_public_status ;
    int private_status ;
    iml_inst        *remainder ;
    iml_inst        *remainder2 ;
    iml_inst       **rrv ;
    iml_inst_slot_t *short_term_slot;
    iml_inst_slot_t *long_term_slot;
} old_iml_session;

Private void *slot_manager(int, slot_op_t, register old_iml_session *, int);

Public void
xsunim_slot_manager_init(){
    /* xsunim based leif can't find _iml_new() */
}

/*
 * IMLogic_session link terminal
 */

Private char *
im_memalign(
    int align,
    int size
)
{
    char *p;
    
    p = (char *) malloc(size + align);
    p = (char *) ((((long) p + align - 1) / align) * align);
    return ((char *) p);
}

Private iml_inst_slot_t *free_slot_q1;
Private iml_inst_slot_t *free_slot_q2;

Public void *
_iml_new(
    old_iml_session * s,
    int size
)
{
    /* to avoid memory trash bug temporary */
    size = (((size + SLOTMINSIZE) / SLOTMINSIZE) * SLOTMINSIZE);
    return (slot_manager(0, ALLOC_SLOT, s, size));
}

Public void *
_iml_new2(
    old_iml_session * s,
    int size
)
{
    /* to avoid memory trash bug temporary */
    size = (((size + SLOTMINSIZE) / SLOTMINSIZE) * SLOTMINSIZE);
    return (slot_manager(1, ALLOC_SLOT, s, size));
}

Public void *
_iml_delete(
    old_iml_session * s
)
{
    return (slot_manager(0, RELEASE_SLOT, s, 0));
}

Public void *
_iml_delete2(
    old_iml_session * s
)
{
    return (slot_manager(1, RELEASE_SLOT, s, 0));
}

Private void *
slot_manager(
    int luc,
    slot_op_t action,
    register old_iml_session * s,
    int size
)
{
    iml_inst_slot_t *free_slot;
    iml_inst_slot_t *new_slot, *p;
#if defined(SLOW_SLOT_MANAGER)
    int link_depth = 0;
#endif /* SLOW_SLOT_MANAGER */
    register iml_inst_slot_t *next_slot;

    if (luc) {
        next_slot = s->long_term_slot;
        free_slot = free_slot_q2;
    } else {
        next_slot = s->short_term_slot;
        free_slot = free_slot_q1;
    }
    
    switch (action) {
        case ALLOC_SLOT:
            if (free_slot) {
                p = new_slot = free_slot;
                while (new_slot && new_slot->size < size) {
                    p = new_slot;
                    new_slot = new_slot->next;
#if defined(SLOW_SLOT_MANAGER)
                    link_depth++;
#endif /* SLOW_SLOT_MANAGER */
                }
                if (!new_slot) {
                    goto allocate_new;
                } else if (p != new_slot) {
                    p->next = new_slot->next;
                } else {
                    /* p == new means got top of free_slot */
#if !defined(SLOW_SLOT_MANAGER)
                    free_slot = free_slot->next;
#else /* SLOW_SLOT_MANAGER */
                    if (free_slot->next) {
                        free_slot = free_slot->next;
                    } else {
                        free_slot = 0;
                    }
#endif /* SLOW_SLOT_MANAGER */
                }
                new_slot->next = NULL;
            } else {
                allocate_new:
#if defined(SLOW_SLOT_MANAGER)
                link_depth = -1;
#endif /* SLOW_SLOT_MANAGER */
                new_slot = (iml_inst_slot_t *) im_memalign(sizeof(iml_inst_slot_t *), sizeof(iml_inst_slot_t));
                new_slot->size = size;
                new_slot->ptr = im_memalign(max(sizeof(int), sizeof(wchar_t)), size);
                new_slot->next = 0;
            }
#if !defined(SLOW_SLOT_MANAGER)
	    if (luc) {
		new_slot->next = s->long_term_slot;
		s->long_term_slot = new_slot;
	    } else {
		new_slot->next = s->short_term_slot;
		s->short_term_slot = new_slot;
	    }
#else /* SLOW_SLOT_MANAGER */
            new_slot->busy = BUSY;
            if (next_slot) {
                while (next_slot->next) {
                    next_slot = next_slot->next;
                }
                next_slot->next = new_slot;
            } else {
                if (luc) {
                    next_slot = s->long_term_slot = new_slot;
                } else {
                    next_slot = s->short_term_slot = new_slot;
                }
            }
#endif /* SLOW_SLOT_MANAGER */

	    /* need to call for XSunIM Adapter */
            memset(new_slot->ptr, 0, new_slot->size);

            if (luc) {
                free_slot_q2 = free_slot;
            } else {
                free_slot_q1 = free_slot;
            }

            return ((void *) new_slot->ptr);
            break;
        case RELEASE_SLOT:
            if (free_slot) {
                p = free_slot;
                while (p && p->next) {
                    p = p->next;
                }
                p->next = next_slot;
            } else {
                p = free_slot = next_slot;
            }
            if (luc) {
                s->long_term_slot = NULL;
            } else {
                s->short_term_slot = NULL;
            }
#if defined(SLOW_SLOT_MANAGER)
            while (p && p->next) {
                p = p->next;
                p->busy = FREE;
                link_depth++;
            }
#endif /* SLOW_SLOT_MANAGER */
            break;
    }
    if (luc) {
        free_slot_q2 = free_slot;
    } else {
        free_slot_q1 = free_slot;
    }
    return ((void *) 0);
}

#endif /* USE_XSUNIM_ADAPTER */
