%{

/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
// Lex version of IMTriggerKeyList
//
#undef lex_input
#undef unput

#include "IMTriggerKeyList.hh"
#include "CompoundString.hh"
#include <X11/Xlib.h>
#include <X11/keysym.h>
#include <X11/Xutil.h>
#include <string.h>
#include <iostream.h>

int is_modmask = 0;
int start_modifier = 0;
int mod;
int mod_mask;
int tmp_mask;
unsigned int keysym;
unsigned int modifier;
unsigned int modifier_mask;
%}

greater <
less >
tilde ~
%%

[\t ;]+ ;

{greater}    { if (start_modifier == 1) {
		return -1;
	       }
               start_modifier = 1;
	     }

{less}	  { if (start_modifier == 0) {
	     return -1;
            }
            start_modifier = 0;
          }

{tilde}    { if (is_modmask == 1) return -1;
             is_modmask = 1;
           }

Ctrl  |
Shift |
Meta  |
Alt { if (start_modifier) {
	cerr << "modifier string is " << yytext << endl;
	CompoundString modifier(yytext);
	if (modifier == "Ctrl") tmp_mask = ControlMask;
	if (modifier == "Shift") tmp_mask = ShiftMask;
	if (modifier == "Meta") tmp_mask = Mod4Mask;
	if (modifier == "Alt") tmp_mask = Mod1Mask;
      } else {
	return -1;
      }
      if (is_modmask) {
	mod_mask |= tmp_mask;
	is_modmask = 0;
      } else {
	mod |= tmp_mask;
      }
    }

[a-zA-Z0-9]+ { if (is_modmask) {
		return -1;
	       }
	       if (start_modifier == 1) {
		return -1;
		}
	       cerr << "key string is " << yytext << endl;
	       keysym = XStringToKeysym(yytext);
	       cerr << "keysym is " << keysym << endl;
	       cerr << "modifier is " << mod << endl;
	       cerr << "mod mask is " << mod_mask << endl;
	       modifier = mod;
	       modifier_mask = mod_mask;
	       modifier_mask = modifier;
	       mod = 0; mod_mask = 0; modifier = 0;
	       tmp_mask = 0;
	       return 0;
	     }

.	; /* ignore anything else */
%%

static char *in_str;
unsigned int offset = 0;

void
IMTriggerKeyList::add(const char *str) {
  if (!str) return;

  cerr << "str = " << str << endl;
  in_str = (char*)str;
  while (yylex() == 0) {
    add(keysym, modifier, modifier_mask);
    if (offset == 0) return;
  }
}

int
lex_input(void) {
  char c;
  if ((c = in_str[offset++]) != '\0')
    return(c);
  offset = 0;
  return(' ');
}

void
unput(int ch) {
  if (ch == 0)
    return;
  if (offset) {
    offset--;
    return;
  }
  return;
}

yywrap() {return 1;}
