/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#ifndef _XInputContext_hh
#define _XInputContext_hh

#include <X11/Xlib.h>
#include "XIMProto.hh"
#include "R6IMProtocol.hh"

// for preedit start callback
typedef int (*XIMProc1)(XIC, XPointer, XPointer);
typedef struct {
  XPointer client_data;
  XIMProc1 callback;
} XIMCallback1;

// for any other else
typedef void (*XIMProc2)(XIC, XPointer, XPointer);
typedef struct {
  XPointer client_data;
  XIMProc2 callback;
} XIMCallback2;

class XIMPublic;

class XInputContext {
 public:
  XInputContext(XIMPublic*, CARD16, int);
  ~XInputContext();

// XIM callbacks
  static int preedit_start_cbproc(XIC xic, XPointer client_data,
				  XPointer call_data_p);
  static void preedit_draw_cbproc(XIC xic, XPointer client_data,
				  XPointer call_data_p);
  static void preedit_caret_cbproc(XIC xic, XPointer client_data,
				   XPointer call_data_p);
  static void preedit_done_cbproc(XIC xic, XPointer client_data,
				  XPointer call_data_p);
  static void status_start_cbproc(XIC xic, XPointer client_data,
				  XPointer call_data_p);
  static void status_draw_cbproc(XIC xic, XPointer client_data,
				 XPointer call_data_p);
  static void status_done_cbproc(XIC xic, XPointer client_data,
				 XPointer call_data_p);
  static void state_notify_cbproc(XIC xic, XPointer client_data,
				  XPointer call_data_p);
  static void commit_string_cbproc(XIC xic, XPointer client_data,
				   XPointer call_data_p);
  static void forward_event_cbproc(XIC xic, XPointer client_data,
				   XPointer call_data_p);

  // get ic value
  int get_client_window(Window &ret) {
    ret = client_win;
    return client_win != 0;
  }
  int get_focus_window(Window &ret) {
    if (!(attr_mask & XIMP_FOCUS_WIN_MASK4)) return False;
    ret = focus_win;
    return True;
  }
  int get_fwin_select_mask(CARD32 &ret) {
    ret = ev_masks;
    return ev_masks != 0;
  }
  Bool is_conv_state() {return is_conv_on;}

  int get_preedit_fontset(char *ret) {
    if (!(attr_mask & XIMP_PRE_FONT_MASK4)) return False;
    ret = (char*)preedit_fontname;
    return True;
  }
  int get_preedit_area(long &x, long &y, unsigned long &width,
		       unsigned long &height) {
    if (!(attr_mask & XIMP_PRE_AREA_MASK4)) return False;
    x = preedit_attr4.area.x;
    y = preedit_attr4.area.y;    
    width = preedit_attr4.area.width;
    height = preedit_attr4.area.height;
    return True;
  }
  int get_preedit_area_needed(long &x, long &y, unsigned long &width,
			      unsigned long &height) {
    if (!(attr_mask & XIMP_PRE_AREANEED_MASK4)) return False;
    x = 0;
    y = 0;
    width = preedit_attr4.area_needed.width;
    height = preedit_attr4.area_needed.height;
    return True;
  }
  int get_preedit_spot_location(long &x, long &y) {
    if (!(attr_mask & XIMP_PRE_SPOTL_MASK4)) return False;
    x = preedit_attr4.spot_location.x;
    y = preedit_attr4.spot_location.y;
    return True;
  }
  int get_preedit_fg(CARD32 &fg) {
    if (!(attr_mask & XIMP_PRE_FG_MASK4)) return False;
    fg = preedit_attr4.foreground;
    return True;
  }
  int get_preedit_bg(CARD32 &bg) {
    if (!(attr_mask & XIMP_PRE_BG_MASK4)) return False;
    bg = preedit_attr4.background;
    return True;
  }
  int get_preedit_bg_pixmap(CARD32 &bg_pixmap) {
    if (!(attr_mask & XIMP_PRE_BGPIXMAP_MASK4)) return False;
    bg_pixmap = preedit_attr4.bg_pixmap;
    return True;
  }
  int get_preedit_line_spacing(CARD32 &linesp) {
    if (!(attr_mask & XIMP_PRE_LINESP_MASK4)) return False;
    linesp = preedit_attr4.line_spacing;
    return True;
  }
  int get_preedit_cursor(Cursor &cursor) {
    if (!(attr_mask & XIMP_PRE_CURSOR_MASK4)) return False;
    cursor = preedit_attr4.cursor;
    return True;
  }
  int get_preedit_colormap(Colormap &colormap) {
    if (!(attr_mask & XIMP_PRE_COLORMAP_MASK4)) return False;
    colormap = preedit_attr4.colormap;
    return True;
  }

  int get_status_fontset(char *ret) {
    if (!(attr_mask & XIMP_STS_FONT_MASK4)) return False;
    ret = (char*)status_fontname;
    return True;
  }
  int get_status_area(long &x, long &y, unsigned long &width,
		       unsigned long &height) {
    if (!(attr_mask & XIMP_STS_AREA_MASK4)) return False;
    x = status_attr4.area.x;
    y = status_attr4.area.y;    
    width = status_attr4.area.width;
    height = status_attr4.area.height;
    return True;
  }
  int get_status_area_needed(long &x, long &y, unsigned long &width,
			      unsigned long &height) {
    if (!(attr_mask & XIMP_STS_AREANEED_MASK4)) return False;
    x = 0;
    y = 0;
    width = status_attr4.area_needed.width;
    height = status_attr4.area_needed.height;
    return True;
  }
  int get_status_fg(CARD32 &fg) {
    if (!(attr_mask & XIMP_STS_FG_MASK4)) return False;
    fg = status_attr4.foreground;
    return True;
  }
  int get_status_bg(CARD32 &bg) {
    if (!(attr_mask & XIMP_STS_BG_MASK4)) return False;
    bg = status_attr4.background;
    return True;
  }
  int get_status_bg_pixmap(CARD32 &bg_pixmap) {
    if (!(attr_mask & XIMP_STS_BGPIXMAP_MASK4)) return False;
    bg_pixmap = status_attr4.bg_pixmap;
    return True;
  }
  int get_status_line_spacing(CARD32 &linesp) {
    if (!(attr_mask & XIMP_STS_LINESP_MASK4)) return False;
    linesp = status_attr4.line_spacing;
    return True;
  }
  int get_status_cursor(Cursor &cursor) {
    if (!(attr_mask & XIMP_STS_CURSOR_MASK4)) return False;
    cursor = status_attr4.cursor;
    return True;
  }
  int get_status_colormap(Colormap &colormap) {
    if (!(attr_mask & XIMP_STS_COLORMAP_MASK4)) return False;
    colormap = status_attr4.colormap;
    return True;
  }

  // set ic value
  void set_client_window(Window new_win);
  void set_focus_window(Window new_win);

  void set_fwin_select_mask(long mask);

  void set_preedit_spot_location(long x, long y);
  void set_preedit_fontset(char*);
  void set_preedit_area(long x, long y, unsigned long width,
			unsigned long height);
  void set_preedit_area_needed(unsigned long width, unsigned long height);
  void set_preedit_colormap(Colormap colormap);
  void set_preedit_fg(unsigned long);
  void set_preedit_bg(unsigned long);
  void set_preedit_bg_pixmap(Pixmap pixmap);
  void set_preedit_line_spacing(long);
  void set_preedit_cursor(Cursor cursor);

  void set_status_fontset(char*);
  void set_status_area(long x, long y, unsigned long width,
		       unsigned long height);
  void set_status_area_needed(unsigned long width, unsigned long height);
  void set_status_colormap(Colormap colormap);
  void set_status_fg(unsigned long);
  void set_status_bg(unsigned long);
  void set_status_bg_pixmap(Pixmap pixmap);
  void set_status_line_spacing(long);
  void set_status_cursor(Cursor cursor);

  void set_focus();
  void unset_focus();
  Bool is_focused() {return focused;}

  char *reset();
  void destroy();
  void filter_event(XEvent*);

  void conversion_start(Bool reply_back);
  void conversion_end(Bool reply_back);

  Bool being_reset;	// whether XIC is being reset or not
private:
  static Bool destroy_clientwin_filter(Display *, Window, XEvent*, XPointer);
  void register_clientwin_destroy_filter();
  void unregister_clientwin_destroy_filter();
  long filters;
  enum XimpFilterMode {
    FLT_NONE = (0L), FLT_KEYPRESS = (1L<<0),
    FLT_KEYRELEASE = (1L<<1), FLT_DESTROY = (1L<<2)
  };

  XIMCallback1 *preedit_start_cb;

  XIMCallback2 *preedit_draw_cb;
  XIMCallback2 *preedit_caret_cb;
  XIMCallback2 *preedit_done_cb;
  XIMCallback2 *status_start_cb;
  XIMCallback2 *status_draw_cb;
  XIMCallback2 *status_done_cb;

  XIMCallback2 *state_notify_cb;
  XIMCallback2 *commit_string_cb;
  XIMCallback2 *forward_event_cb;

  Ximp_PreeditPropRec4	preedit_attr4;
  CompoundString	preedit_fontname;
  Ximp_StatusPropRec4	status_attr4;
  CompoundString	status_fontname;

  void select_destroy_emask();

  XIMPublic *ximp_protocol;
  CARD16 connect_id;

  XIC xic;
  XIMStyle inputstyle;
  Display *dpy;

  Window client_win;
  Window focus_win;

  long attr_mask;
  long ev_masks;
  Bool is_conv_on;
  CompoundString reset_text;

  Bool focused;

  enum Ximp40ICMask {
    XIMP_FOCUS_WIN_MASK4	= (1L <<  0),
    XIMP_PRE_AREA_MASK4		= (1L <<  1),
    XIMP_PRE_AREANEED_MASK4	= (1L <<  2),
    XIMP_PRE_COLORMAP_MASK4	= (1L <<  3),
    XIMP_PRE_STD_COLORMAP_MASK4 = (1L <<  4),
    XIMP_PRE_FG_MASK4		= (1L <<  5),
    XIMP_PRE_BG_MASK4		= (1L <<  6),
    XIMP_PRE_BGPIXMAP_MASK4	= (1L <<  7),
    XIMP_PRE_LINESP_MASK4	= (1L <<  8),
    XIMP_PRE_CURSOR_MASK4	= (1L <<  9),
    XIMP_PRE_SPOTL_MASK4	= (1L << 10),
    XIMP_STS_AREA_MASK4		= (1L << 11),
    XIMP_STS_AREANEED_MASK4	= (1L << 12),
    XIMP_STS_COLORMAP_MASK4	= (1L << 13),
    XIMP_STS_STD_COLORMAP_MASK4	= (1L << 14),
    XIMP_STS_FG_MASK4		= (1L << 15),
    XIMP_STS_BG_MASK4		= (1L << 16),
    XIMP_STS_BGPIXMAP_MASK4	= (1L << 17),
    XIMP_STS_LINESP_MASK4	= (1L << 18),
    XIMP_STS_CURSOR_MASK4	= (1L << 19),
    XIMP_STS_WINDOW_MASK4	= (1L << 20),
    XIMP_PRE_FONT_MASK4		= (1L << 21),
    XIMP_STS_FONT_MASK4		= (1L << 22),
    XIMP_SERVERTYPE_MASK4	= (1L << 23)
  };

  void SetExtensionCallbacks();
  void SetPreeditCallbacks();
  void SetStatusCallbacks();
};

#endif
