/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include "XInputContext.hh"
#include "XIMPublic.hh"
#include "Xfactory.hh"
#include <string.h>
#include <stdio.h>

extern "C" {
  extern int _Xi18nPreeditStartCallback(XIMS, X11R6IMProtocol);
  extern int _Xi18nPreeditDrawCallback(XIMS, X11R6IMProtocol);
  extern int _Xi18nPreeditCaretCallback(XIMS, X11R6IMProtocol);
  extern int _Xi18nPreeditDoneCallback(XIMS, X11R6IMProtocol);
  extern int _Xi18nStatusStartCallback(XIMS, X11R6IMProtocol);
  extern int _Xi18nStatusDrawCallback(XIMS, X11R6IMProtocol);
  extern int _Xi18nStatusDoneCallback(XIMS, X11R6IMProtocol);
	   }

XInputContext::XInputContext(XIMPublic *ximp, CARD16 imid,
			     int style) {
  XIM xim = ximp->getXIM();
  client_win = focus_win = 0;
  ev_masks = 0;
  attr_mask = 0;
  is_conv_on = 0;
  connect_id = imid;
  inputstyle = style;
  filters = 0;

  focused = False;

  // for XIMProtocol::reset() can return reset text
  being_reset = False;
  reset_text = "";

  ximp_protocol = ximp;

  dpy = ximp_protocol->getDisplay();

  if (xim)
    xic = XCreateIC(xim,
		    XNInputStyle, inputstyle,
		    0);

  state_notify_cb = new XIMCallback2;
  state_notify_cb->client_data = (char*)this;
  state_notify_cb->callback = state_notify_cbproc;

  commit_string_cb = new XIMCallback2;
  commit_string_cb->client_data = (char*)this;
  commit_string_cb->callback = commit_string_cbproc;

  forward_event_cb = new XIMCallback2;
  forward_event_cb->client_data = (char*)this;
  forward_event_cb->callback = forward_event_cbproc;

  SetExtensionCallbacks();

  // callback styles?
  if (inputstyle & XIMPreeditCallbacks) {
    preedit_start_cb = new XIMCallback1;
    preedit_start_cb->client_data = (char*)this;
    preedit_start_cb->callback = preedit_start_cbproc;

    preedit_draw_cb = new XIMCallback2;
    preedit_draw_cb->client_data = (char*)this;
    preedit_draw_cb->callback = preedit_draw_cbproc;

    preedit_caret_cb = new XIMCallback2;
    preedit_caret_cb->client_data = (char*)this;
    preedit_caret_cb->callback = preedit_caret_cbproc;

    preedit_done_cb = new XIMCallback2;
    preedit_done_cb->client_data = (char*)this;
    preedit_done_cb->callback = preedit_done_cbproc;

    SetPreeditCallbacks();
  }
  if (inputstyle & XIMStatusCallbacks) {
    status_start_cb = new XIMCallback2;
    status_start_cb->client_data = (char*)this;
    status_start_cb->callback = status_start_cbproc;

    status_draw_cb = new XIMCallback2;
    status_draw_cb->client_data = (char*)this;
    status_draw_cb->callback = status_draw_cbproc;

    status_done_cb = new XIMCallback2;
    status_done_cb->client_data = (char*)this;
    status_done_cb->callback = status_done_cbproc;

    SetStatusCallbacks();
  }

}

XInputContext::~XInputContext() {
  /* FIX ME: need to free the following cb */
  /*
  preedit_start_cb
  preedit_draw_cb
  preedit_caret_cb
  preedit_done_cb
  status_start_cb
  status_draw_cb
  status_done_cb
  state_notify_cb
  commit_string_cb
  forward_event_cb
  */
}


void
XInputContext::
SetPreeditCallbacks() {
  if (xic) {
    XVaNestedList preedit_attr = XVaCreateNestedList(NULL,
			     XNPreeditStartCallback, preedit_start_cb,
			     XNPreeditDrawCallback, preedit_draw_cb,
			     XNPreeditCaretCallback, preedit_caret_cb,
			     XNPreeditDoneCallback, preedit_done_cb,
			     0);
    XSetICValues(xic,
		 XNPreeditAttributes, preedit_attr,
		 0);
    XFree(preedit_attr);
  }
  return;
}

void
XInputContext::
SetStatusCallbacks() {
  if (xic) {
    XVaNestedList status_attr = XVaCreateNestedList(NULL,
			    XNStatusStartCallback, status_start_cb,
			    XNStatusDrawCallback, status_draw_cb,
			    XNStatusDoneCallback, status_done_cb,
			    0);
    XSetICValues(xic,
		 XNStatusAttributes, status_attr,
		 0);
    XFree(status_attr);
  }
}

void
XInputContext::
SetExtensionCallbacks() {
  if (xic)
    XSetICValues(xic,
		 XNPreeditStateNotifyCallback, state_notify_cb,
		 // private XIC attribute
		 "commitStringCallback", commit_string_cb,
		 "forwardEventCallback", forward_event_cb,
		 0);
  return;
}

// set IC attributes
void
XInputContext::set_client_window(Window new_win) {
  if (client_win != new_win) {
    unregister_clientwin_destroy_filter();
    client_win = new_win;
    if (xic) {
      // client_win might have been set already, but even for
      // such cases, we allow to set client_win again.
      XSetICValues(xic,
		   XNClientWindow, client_win,
		   0);
      register_clientwin_destroy_filter();
    }
  }
  return;
}

Bool
XInputContext::destroy_clientwin_filter(Display *display,
					Window win, XEvent *ev,
					XPointer client_data) {
  XInputContext *ic = (XInputContext*)client_data;
  ic->unregister_clientwin_destroy_filter();
  // client_window is destroyed, so xic is no longer valid
  if (ic->xic) {
    ic->destroy();
    return True;
  }
  return False;
}

void
XInputContext::register_clientwin_destroy_filter() {
  XFactory::register_filter(dpy, client_win,
			    DestroyNotify, DestroyNotify,
			    destroy_clientwin_filter, (XPointer)this);
}
void
XInputContext::unregister_clientwin_destroy_filter() {
  XFactory::unregister_filter(dpy, client_win,
			      destroy_clientwin_filter, (XPointer)this);
}

void
XInputContext::select_destroy_emask() {
  if (!(filters & FLT_DESTROY)) {
    ximp_protocol->select_destroy_emask(focus_win);
    filters |= FLT_DESTROY;
  }
}

void
XInputContext::set_focus_window(Window new_win) {
  if (focus_win != new_win) {
    filters &= ~FLT_KEYPRESS;
    filters &= ~FLT_KEYRELEASE;
    filters &= ~FLT_DESTROY;
    focus_win = new_win;
    select_destroy_emask();

    attr_mask |= XIMP_FOCUS_WIN_MASK4;
    // as XIM client
    if (xic)
      XSetICValues(xic,
		   XNFocusWindow, focus_win,
		   0);
  }
  return;
}

void
XInputContext::set_fwin_select_mask(long mask) {
  ev_masks = mask;
  return;
}

void
XInputContext::set_focus() {
  if (xic) {
    XSetICFocus(xic);
  }
  focused = True;
}

void
XInputContext::unset_focus() {
  if (xic) {
    XUnsetICFocus(xic);
  }
  focused = False;
}

void
XInputContext::destroy() {
  if (xic) {
    XDestroyIC(xic);
    xic = 0;
  }
}

void
XInputContext::filter_event(XEvent *event) {
  /* Forward event doesn't work after commit on kedit */
  /*  sometimes focus_win isn't get jusst after Qt start up */
  if(focus_win == 0){
        focus_win = client_win;
        set_focus_window(focus_win);
  }
  if (event->type == KeyPress || event->type == KeyRelease) {
    event->xkey.window = focus_win;
  }
  if (!XFilterEvent(event, 0)) {
    forward_event_cbproc(xic, (XPointer)this, (XPointer)event);
  }
  return;
}

char*
XInputContext::reset() {
  being_reset = True;
  reset_text = "";
  if (xic) {
    return XmbResetIC(xic);
  }
  return 0;
}

void
XInputContext::conversion_start(Bool reply_back) {
  if (reply_back && xic) {
    XSetICValues(xic,
		 XNPreeditState, XIMPreeditEnable,
		 0);
  }
  is_conv_on = 1;
}

void
XInputContext::conversion_end(Bool reply_back) {
  if (reply_back && xic) {
    XSetICValues(xic,
		 XNPreeditState, XIMPreeditDisable,
		 0);
  }
  is_conv_on = 0;
}
		    
void
XInputContext::set_preedit_spot_location(long x, long y) {
  attr_mask |= XIMP_PRE_SPOTL_MASK4;

  preedit_attr4.spot_location.x = x;
  preedit_attr4.spot_location.y = y;

  // as XIM client
  XVaNestedList preedit_attr;
  XPoint spot;
  spot.x = x; spot.y = y;
  preedit_attr = XVaCreateNestedList(NULL,
				     XNSpotLocation, &spot,
				     NULL);
  XSetICValues(xic,
	       XNPreeditAttributes, preedit_attr,
	       0);
  XFree(preedit_attr);
  return;
}
void
XInputContext::set_preedit_area(long x, long y, unsigned long width,
				unsigned long height) {
  attr_mask |= XIMP_PRE_AREA_MASK4;

  preedit_attr4.area.x = x;
  preedit_attr4.area.y = y;
  preedit_attr4.area.width = width;
  preedit_attr4.area.height = height;

  // as XIM client
  XVaNestedList preedit_attr;
  XRectangle area;
  area.x = x; area.y = y; area.width = width; area.height = height;
  preedit_attr = XVaCreateNestedList(NULL,
				     XNArea, &area,
				     NULL);
  XSetICValues(xic,
	       XNPreeditAttributes, preedit_attr,
	       0);
  XFree(preedit_attr);
  return;
}
void
XInputContext::set_preedit_area_needed(unsigned long width,
					  unsigned long height) {
  attr_mask |= XIMP_PRE_AREANEED_MASK4;

  preedit_attr4.area_needed.width = width;
  preedit_attr4.area_needed.height = height;

  // as XIM client
  XVaNestedList preedit_attr;
  XRectangle area;
  area.x = 0; area.y = 0; area.width = width; area.height = height;
  preedit_attr = XVaCreateNestedList(NULL,
				     XNAreaNeeded, &area,
				     NULL);
  XSetICValues(xic,
	       XNPreeditAttributes, preedit_attr,
	       0);
  XFree(preedit_attr);
  if (width == 0 || height == 0) {
    // do geometry negotiation
    XRectangle *area2 = (XRectangle*)0;
    preedit_attr = XVaCreateNestedList(NULL,
				       XNAreaNeeded, &area2,
				       NULL);
    XGetICValues(xic,
		 XNPreeditAttributes, preedit_attr,
		 0);
    XFree(preedit_attr);
    if (area2) {
      if (width == 0) {
	preedit_attr4.area_needed.width = area2->width;
      }
      if (height == 0) {
	preedit_attr4.area_needed.height = area2->height;
      }
      XFree(area2);
    }
    // fallback to avoid setting 0
    if (preedit_attr4.area_needed.width == 0) {
      XFontSet font_set = XFactory::create_fontset(dpy, preedit_fontname);
      XFontSetExtents *fsx = XExtentsOfFontSet(font_set);
      preedit_attr4.area_needed.width = fsx->max_logical_extent.width *10;
      XFactory::free_fontset(dpy, font_set);
    }
    if (preedit_attr4.area_needed.height == 0) {
      XFontSet font_set = XFactory::create_fontset(dpy, preedit_fontname);
      XFontSetExtents *fsx = XExtentsOfFontSet(font_set);
      preedit_attr4.area_needed.height = fsx->max_logical_extent.height;
      XFactory::free_fontset(dpy, font_set);
    }
  }
  return;
}
void
XInputContext::set_preedit_colormap(Colormap colormap) {
  attr_mask |= XIMP_PRE_COLORMAP_MASK4;

  preedit_attr4.colormap = colormap;

  // as XIM client
  XVaNestedList preedit_attr;
  preedit_attr = XVaCreateNestedList(NULL,
				     XNColormap, colormap,
				     NULL);
  XSetICValues(xic,
	       XNPreeditAttributes, preedit_attr,
	       0);
  XFree(preedit_attr);
  return;
}
void
XInputContext::set_preedit_bg_pixmap(Pixmap bg_pixmap) {
  attr_mask |= XIMP_PRE_BGPIXMAP_MASK4;

  preedit_attr4.bg_pixmap = bg_pixmap;

  // as XIM client
  XVaNestedList preedit_attr;
  preedit_attr = XVaCreateNestedList(NULL,
				     XNBackgroundPixmap, bg_pixmap,
				     NULL);
  XSetICValues(xic,
	       XNPreeditAttributes, preedit_attr,
	       0);
  XFree(preedit_attr);
}
void
XInputContext::set_preedit_line_spacing(long line_spacing) {
  attr_mask |= XIMP_PRE_LINESP_MASK4;

  preedit_attr4.line_spacing = line_spacing;

  // as XIM client
  XVaNestedList preedit_attr;
  preedit_attr = XVaCreateNestedList(NULL,
				     XNLineSpace, line_spacing,
				     NULL);
  XSetICValues(xic,
	       XNPreeditAttributes, preedit_attr,
	       0);
  XFree(preedit_attr);
}
void
XInputContext::set_preedit_cursor(Cursor cursor) {
  attr_mask |= XIMP_PRE_CURSOR_MASK4;

  preedit_attr4.cursor = cursor;

  // as XIM client
  XVaNestedList preedit_attr;
  preedit_attr = XVaCreateNestedList(NULL,
				     XNCursor, cursor,
				     NULL);
  XSetICValues(xic,
	       XNPreeditAttributes, preedit_attr,
	       0);
  XFree(preedit_attr);
}
void
XInputContext::set_preedit_bg(unsigned long bg) {
  attr_mask |= XIMP_PRE_BG_MASK4;

  preedit_attr4.background = bg;

  // as XIM client
  XVaNestedList preedit_attr;
  preedit_attr = XVaCreateNestedList(NULL,
				     XNBackground, bg,
				     NULL);
  XSetICValues(xic,
	       XNPreeditAttributes, preedit_attr,
	       0);
  XFree(preedit_attr);
}
void
XInputContext::set_preedit_fg(unsigned long fg) {
  attr_mask |= XIMP_PRE_FG_MASK4;

  preedit_attr4.foreground = fg;

  XVaNestedList preedit_attr;
  preedit_attr = XVaCreateNestedList(NULL,
				     XNForeground, fg,
				     NULL);
  XSetICValues(xic,
	       XNPreeditAttributes, preedit_attr,
	       0);
  XFree(preedit_attr);
}
void
XInputContext::set_preedit_fontset(char *fontname) {
  attr_mask |= XIMP_PRE_FONT_MASK4;

  preedit_fontname = fontname;

  XVaNestedList preedit_attr;
  XFontSet font_set = XFactory::create_fontset(dpy, preedit_fontname);
  preedit_attr = XVaCreateNestedList(NULL,
				     XNFontSet, font_set,
				     NULL);
  XSetICValues(xic,
	       XNPreeditAttributes, preedit_attr,
	       0);
  XFree(preedit_attr);
}

void
XInputContext::set_status_area(long x, long y, unsigned long width,
				  unsigned long height) {
  attr_mask |= XIMP_STS_AREA_MASK4;

  status_attr4.area.x = x;
  status_attr4.area.y = y;
  status_attr4.area.width = width;;
  status_attr4.area.height = height;

  // as XIM client
  XVaNestedList status_attr;
  XRectangle area;
  area.x = x; area.y = y; area.width = width; area.height = height;
  status_attr = XVaCreateNestedList(0,
				    XNArea, &area,
				    NULL);
  XSetICValues(xic,
	       XNStatusAttributes, status_attr,
	       0);
  XFree(status_attr);
  return;
}
void
XInputContext::set_status_area_needed(unsigned long width,
				      unsigned long height) {
  attr_mask |= XIMP_STS_AREANEED_MASK4;

  status_attr4.area_needed.width = width;;
  status_attr4.area_needed.height = height;

  // as XIM client
  XVaNestedList status_attr;
  XRectangle area;
  area.x = 0; area.y = 0; area.width = width; area.height = height;
  status_attr = XVaCreateNestedList(0,
				    XNAreaNeeded, &area,
				    NULL);
  XSetICValues(xic,
	       XNStatusAttributes, status_attr,
	       0);
  XFree(status_attr);
  if (width == 0 || height == 0) {
    // do geometry negotiation
    XRectangle *area2 = (XRectangle*)0;
    status_attr = XVaCreateNestedList(0,
				      XNAreaNeeded, &area2,
				      NULL);
    XGetICValues(xic,
		 XNStatusAttributes, status_attr,
		 0);
    XFree(status_attr);
    if (area2) {
      if (width == 0 ||
	  inputstyle & XIMPreeditArea) {
	status_attr4.area_needed.width = area2->width;
      }
      if (height == 0) {
	status_attr4.area_needed.height = area2->height;
      }
      XFree(area2);
    }
    // fallback to avoid setting 0
    if (status_attr4.area_needed.width == 0) {
      XFontSet font_set = XFactory::create_fontset(dpy, status_fontname);
      XFontSetExtents *fsx = XExtentsOfFontSet(font_set);
      status_attr4.area_needed.width = fsx->max_logical_extent.width *10;
      XFactory::free_fontset(dpy, font_set);
    }
    if (status_attr4.area_needed.height == 0) {
      XFontSet font_set = XFactory::create_fontset(dpy, status_fontname);
      XFontSetExtents *fsx = XExtentsOfFontSet(font_set);
      status_attr4.area_needed.height = fsx->max_logical_extent.height;
      XFactory::free_fontset(dpy, font_set);
    }
  }
  return;
}

void
XInputContext::set_status_colormap(Colormap colormap) {
  attr_mask |= XIMP_STS_COLORMAP_MASK4;

  status_attr4.colormap = colormap;

  // as XIM client
  XVaNestedList status_attr;
  status_attr = XVaCreateNestedList(0,
				    XNColormap, colormap,
				    NULL);
  XSetICValues(xic,
	       XNStatusAttributes, status_attr,
	       0);
  XFree(status_attr);
  return;
}
void
XInputContext::set_status_bg(unsigned long bg) {
  attr_mask |= XIMP_STS_BG_MASK4;

  status_attr4.background = bg;

  // as XIM client
  XVaNestedList status_attr;
  status_attr = XVaCreateNestedList(0,
				    XNBackground, bg,
				    NULL);
  XSetICValues(xic,
	       XNStatusAttributes, status_attr,
	       0);
  XFree(status_attr);
}
void
XInputContext::set_status_fg(unsigned long fg) {
  attr_mask |= XIMP_STS_FG_MASK4;

  status_attr4.foreground = fg;

  // as XIM client
  XVaNestedList status_attr;
  status_attr = XVaCreateNestedList(0,
				    XNForeground, fg,
				    NULL);
  XSetICValues(xic,
	       XNStatusAttributes, status_attr,
	       0);
  XFree(status_attr);
}
void
XInputContext::set_status_bg_pixmap(Pixmap bg_pixmap) {
  attr_mask |= XIMP_STS_BGPIXMAP_MASK4;

  status_attr4.bg_pixmap = bg_pixmap;

  // as XIM client
  XVaNestedList status_attr;
  status_attr = XVaCreateNestedList(0,
				    XNBackgroundPixmap, bg_pixmap,
				    NULL);
  XSetICValues(xic,
	       XNStatusAttributes, status_attr,
	       0);
  XFree(status_attr);
}
void
XInputContext::set_status_line_spacing(long line_spacing) {
  attr_mask |= XIMP_STS_LINESP_MASK4;

  status_attr4.line_spacing = line_spacing;

  // as XIM client
  XVaNestedList status_attr;
  status_attr = XVaCreateNestedList(0,
				    XNLineSpace, line_spacing,
				    NULL);
  XSetICValues(xic,
	       XNStatusAttributes, status_attr,
	       0);
  XFree(status_attr);
}
void
XInputContext::set_status_cursor(Cursor cursor) {
  attr_mask |= XIMP_STS_CURSOR_MASK4;

  status_attr4.cursor = cursor;

  // as XIM client
  XVaNestedList status_attr;
  status_attr = XVaCreateNestedList(0,
				    XNCursor, cursor,
				    NULL);
  XSetICValues(xic,
	       XNStatusAttributes, status_attr,
	       0);
  XFree(status_attr);
}
void
XInputContext::set_status_fontset(char *fontname) {
  attr_mask |= XIMP_STS_FONT_MASK4;

  status_fontname = fontname;

  XVaNestedList status_attr;
  XFontSet font_set = XFactory::create_fontset(dpy, status_fontname);
  status_attr = XVaCreateNestedList(0,
				    XNFontSet, font_set,
				    NULL);
  XSetICValues(xic,
	       XNStatusAttributes, status_attr,
	       0);
  XFree(status_attr);
}

// XIM callbacks
int
XInputContext::preedit_start_cbproc(XIC xic, XPointer client_data,
				    XPointer call_data) {
  XInputContext *ic = (XInputContext*)client_data;
  XIMPublic *ximp_protocol = ic->ximp_protocol;

  XIMS ims = ((R6IMProtocol*)ximp_protocol)->getXIMS();
  int icid = R6IMProtocol::getICID(ic);
  IMPreeditCBStruct data;
  memset(&data, 0, sizeof(IMPreeditCBStruct));
  data.icid = icid;
  data.connect_id = ic->connect_id;
  _Xi18nPreeditStartCallback(ims, (X11R6IMProtocol)&data);

  return -1;
}

void
XInputContext::preedit_draw_cbproc(XIC xic, XPointer client_data,
				   XPointer call_data_p) {
  XInputContext *ic = (XInputContext*)client_data;
  XIMPreeditDrawCallbackStruct preedit_cb;
  XIMPreeditDrawCallbackStruct *call_data =
    (XIMPreeditDrawCallbackStruct*)call_data_p;
  XTextProperty prop;

  memmove(&preedit_cb, call_data, sizeof(XIMPreeditDrawCallbackStruct));

  prop.value = 0;
  if (call_data->text) {
    // call_data is native encoding, so need to convert to CT
    char *mb_data = call_data->text->string.multi_byte;
    XmbTextListToTextProperty(ic->dpy, &mb_data,
			      1, XCompoundTextStyle, &prop);
    preedit_cb.text = new XIMText;
    preedit_cb.text->length = call_data->text->length;
    preedit_cb.text->feedback = call_data->text->feedback;
    preedit_cb.text->encoding_is_wchar =
      call_data->text->encoding_is_wchar;
    preedit_cb.text->string.multi_byte = (char*)prop.value;
  }

  XIMPublic *ximp_protocol = ic->ximp_protocol;
  XIMS ims = ((R6IMProtocol*)ximp_protocol)->getXIMS();
  int icid = R6IMProtocol::getICID(ic);
  IMPreeditCBStruct data;
  memset(&data, 0, sizeof(IMPreeditCBStruct));
  data.icid = icid;
  data.connect_id = ic->connect_id;
  data.todo.draw = preedit_cb;

  _Xi18nPreeditDrawCallback(ims, (X11R6IMProtocol)&data);

  if (prop.value) XFree(prop.value);
  delete preedit_cb.text;

  return;
}
void
XInputContext::preedit_caret_cbproc(XIC xic, XPointer client_data,
				    XPointer call_data_p) {
  XInputContext *ic = (XInputContext*)client_data;
  XIMPreeditCaretCallbackStruct *call_data =
    (XIMPreeditCaretCallbackStruct*)call_data_p;

  XIMPublic *ximp_protocol = ic->ximp_protocol;
  XIMS ims = ((R6IMProtocol*)ximp_protocol)->getXIMS();
  int icid = R6IMProtocol::getICID(ic);
  IMPreeditCBStruct data;
  memset(&data, 0, sizeof(IMPreeditCBStruct));
  data.icid = icid;
  data.connect_id = ic->connect_id;
  data.todo.caret = *call_data;

  _Xi18nPreeditCaretCallback(ims, (X11R6IMProtocol)&data);

  return;
}
void
XInputContext::preedit_done_cbproc(XIC xic, XPointer client_data,
				   XPointer call_data) {
  XInputContext *ic = (XInputContext*)client_data;

  XIMPublic *ximp_protocol = ic->ximp_protocol;
  XIMS ims = ((R6IMProtocol*)ximp_protocol)->getXIMS();
  int icid = R6IMProtocol::getICID(ic);
  IMPreeditCBStruct data;
  memset(&data, 0, sizeof(IMPreeditCBStruct));
  data.icid = icid;
  data.connect_id = ic->connect_id;

  _Xi18nPreeditDoneCallback(ims, (X11R6IMProtocol)&data);

  return;
}
void
XInputContext::status_start_cbproc(XIC xic, XPointer client_data,
				   XPointer call_data) {
  XInputContext *ic = (XInputContext*)client_data;

  XIMPublic *ximp_protocol = ic->ximp_protocol;
  XIMS ims = ((R6IMProtocol*)ximp_protocol)->getXIMS();
  int icid = R6IMProtocol::getICID(ic);
  IMStatusCBStruct data;
  memset(&data, 0, sizeof(IMStatusCBStruct));
  data.icid = icid;
  data.connect_id = ic->connect_id;

  _Xi18nStatusStartCallback(ims, (X11R6IMProtocol)&data);

  return;
}

void
XInputContext::status_draw_cbproc(XIC xic, XPointer client_data,
				  XPointer call_data_p) {
  XInputContext *ic = (XInputContext*)client_data;
  XIMStatusDrawCallbackStruct status_cb;
  XIMStatusDrawCallbackStruct *call_data = 
    (XIMStatusDrawCallbackStruct*)call_data_p;
  XTextProperty prop;

  memmove(&status_cb, call_data, sizeof(XIMStatusDrawCallbackStruct));

  prop.value = 0;
  if (call_data->data.text) {
    // call_data is native encoding, so need to convert to CT
    char *mb_data = call_data->data.text->string.multi_byte;
    XmbTextListToTextProperty(ic->dpy, &mb_data,
			      1, XCompoundTextStyle, &prop);
    status_cb.data.text = new XIMText;
    status_cb.data.text->length = call_data->data.text->length;
    status_cb.data.text->feedback = call_data->data.text->feedback;
    status_cb.data.text->encoding_is_wchar =
      call_data->data.text->encoding_is_wchar;
    status_cb.data.text->string.multi_byte = (char*)prop.value;
  }

  XIMPublic *ximp_protocol = ic->ximp_protocol;
  XIMS ims = ((R6IMProtocol*)ximp_protocol)->getXIMS();
  int icid = R6IMProtocol::getICID(ic);
  IMStatusCBStruct data;
  memset(&data, 0, sizeof(IMStatusCBStruct));
  data.icid = icid;
  data.connect_id = ic->connect_id;
  data.todo.draw = status_cb;

  _Xi18nStatusDrawCallback(ims, (X11R6IMProtocol)&data);

  if (prop.value) XFree(prop.value);
  delete status_cb.data.text;

  return;
}
void
XInputContext::status_done_cbproc(XIC xic, XPointer client_data,
				  XPointer call_data) {
  XInputContext *ic = (XInputContext*)client_data;

  XIMPublic *ximp_protocol = ic->ximp_protocol;
  XIMS ims = ((R6IMProtocol*)ximp_protocol)->getXIMS();
  int icid = R6IMProtocol::getICID(ic);
  IMStatusCBStruct data;
  memset(&data, 0, sizeof(IMStatusCBStruct));
  data.icid = icid;
  data.connect_id = ic->connect_id;

  _Xi18nStatusDoneCallback(ims, (X11R6IMProtocol)&data);

  return;
}


void
XInputContext::commit_string_cbproc(XIC xic, XPointer client_data,
					XPointer call_data_p) {
  XIMText *cbtext = (XIMText*)call_data_p;
  char *mb_data = (char*)cbtext->string.multi_byte;
  XInputContext *ic = (XInputContext*)client_data;

  if (mb_data == 0 || *mb_data == 0) return;

  // mb_data is native encoding, so need to convert to CT
  XTextProperty prop;
  XmbTextListToTextProperty(ic->dpy, &mb_data,
			    1, XCompoundTextStyle, &prop);
  char *ret = (char *)prop.value;
  if (ic->being_reset)
    ic->reset_text += ret;
  else {
    XIMPublic *ximp_protocol = ic->ximp_protocol;
    XIMS ims = ((R6IMProtocol*)ximp_protocol)->getXIMS();
    int icid = R6IMProtocol::getICID(ic);
    IMCommitEventStruct data;
    memset(&data, 0, sizeof(IMCommitEventStruct));
    data.icid = icid;
    data.connect_id = ic->connect_id;
    data.flag = XimLookupChars;
    data.commit_string = ret;
    ims->methods->commitString(ims, &data);
  }

  if (prop.value) XFree(prop.value);
  return;
}

void
XInputContext::forward_event_cbproc(XIC xic, XPointer client_data,
				    XPointer call_data_p) {
  XEvent *call_data = (XEvent*)call_data_p;
  XInputContext *ic = (XInputContext*)client_data;

  XIMPublic *ximp_protocol = ic->ximp_protocol;
  XIMS ims = ((R6IMProtocol*)ximp_protocol)->getXIMS();
  int icid = R6IMProtocol::getICID(ic);
  IMForwardEventStruct data;
  memset(&data, 0, sizeof(IMForwardEventStruct));
  data.icid = icid;
  data.connect_id = ic->connect_id;
  data.event = *call_data;

  ims->methods->forwardEvent(ims, &data);

  return;
}

void
XInputContext::state_notify_cbproc(XIC xic, XPointer client_data,
				       XPointer call_data_p) {
  XIMPreeditStateNotifyCallbackStruct *call_data =
    (XIMPreeditStateNotifyCallbackStruct *)call_data_p;
  XInputContext *ic = (XInputContext*)client_data;

  XIMPublic *ximp_protocol = ic->ximp_protocol;
  XIMS ims = ((R6IMProtocol*)ximp_protocol)->getXIMS();
  int icid = R6IMProtocol::getICID(ic);
  IMPreeditStateStruct data;
  memset(&data, 0, sizeof(IMPreeditStateStruct));
  data.icid = icid;
  data.connect_id = ic->connect_id;

  if (call_data->state == XIMPreeditDisable) {
    ic->conversion_end(False);
    ims->methods->preeditEnd(ims, (X11R6IMProtocol)&data);
  }
  if (call_data->state == XIMPreeditEnable) {
    ic->conversion_start(False);
    ims->methods->preeditStart(ims, (X11R6IMProtocol)&data);
  }
  return;
}
