/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include "R6IMProtocol.hh"
#include "IMTrans.hh"
#include "IMThread.hh"
#include "CompoundString.hh"
#include "XInputContext.hh"
#ifdef DEBUG
#include <stdio.h>
#endif
#include "XIC_Interface.h"

#include "Xi18n.h"

IMList <XIMPublic> ximp_list;
IMList<XInputContext> xic_list;

int
R6IMProtocol::getICID(XInputContext *ic) {
  return xic_list.getIndex(ic);
}

R6IMProtocol::
R6IMProtocol(IMArg *args, int args_count) : XIMPublic(args, args_count) {
  ims = 0;
  protocol_name = "R6IMP";
}

R6IMProtocol::
~R6IMProtocol() {

  delete start_keys.keylist;
  delete stop_keys.keylist;
}

/* Supported Input Method list */
static XIMListOfAttr IMValues[] = {
    {XNQueryInputStyle, XimType_XIMStyles, 1},
    {(char *)NULL, (CARD16)0, (CARD16)0}
};

/* definitions of IC attribute identifiers. */
#define		XIC_INPUT_STYLE		1
#define		XIC_CLIENT_WINDOW	2
#define		XIC_FOCUS_WINDOW	3
#define		XIC_FILTER_EVENTS	4
#define		XIC_PREEDIT_ATTR	5
#define		XIC_STATUS_ATTR		6
#define		XIC_FONTSET		7
#define		XIC_AREA		8
#define		XIC_AREA_NEEDED		9
#define		XIC_COLORMAP		10
#define		XIC_STD_COLORMAP	11
#define		XIC_FOREGROUND		12
#define		XIC_BACKGROUND		13
#define		XIC_BACKGROUND_PIXMAP	14
#define		XIC_SPOTLOCATION	15
#define		XIC_LINESPACE		16
#define		XIC_PREEDIT_STATE	17
#define		XIC_FONTNAME		18
#define		XIC_CURSOR		19

/* Supported Input Context list */
static XIMListOfAttr ICValues[] = {
    {XNInputStyle, XimType_CARD32,	XIC_INPUT_STYLE},
    {XNClientWindow, XimType_Window,	XIC_CLIENT_WINDOW},
    {XNFocusWindow, XimType_Window,	XIC_FOCUS_WINDOW},
    {XNFilterEvents, XimType_CARD32,	XIC_FILTER_EVENTS},
    {XNPreeditAttributes, XimType_NEST, XIC_PREEDIT_ATTR},
    {XNStatusAttributes, XimType_NEST,	XIC_STATUS_ATTR},
    {XNFontSet, XimType_XFontSet,	XIC_FONTSET},
    {XNArea, XimType_XRectangle,	XIC_AREA},
    {XNAreaNeeded, XimType_XRectangle,	XIC_AREA_NEEDED},
    {XNColormap, XimType_CARD32,	XIC_COLORMAP},
    {XNStdColormap, XimType_CARD32,	XIC_STD_COLORMAP},
    {XNForeground, XimType_CARD32,	XIC_FOREGROUND},
    {XNBackground, XimType_CARD32,	XIC_BACKGROUND},
    {XNBackgroundPixmap, XimType_CARD32,XIC_BACKGROUND_PIXMAP},
    {XNSpotLocation, XimType_XPoint,	XIC_SPOTLOCATION},
    {XNLineSpace, XimType_CARD32,	XIC_LINESPACE},
    {XNPreeditState, XimType_CARD32,	XIC_PREEDIT_STATE},
    {(char *)NULL, (CARD16)0, (CARD16)0}
};

static XIMStyle  my_styles[] = {
	XIMPreeditCallbacks | XIMStatusCallbacks,
	XIMPreeditCallbacks | XIMStatusArea,
	XIMPreeditCallbacks | XIMStatusNothing,
	XIMPreeditCallbacks | XIMStatusNone,
	XIMPreeditPosition  | XIMStatusCallbacks,
	XIMPreeditPosition  | XIMStatusArea,
	XIMPreeditPosition  | XIMStatusNothing,
	XIMPreeditPosition  | XIMStatusNone,
	XIMPreeditArea	    | XIMStatusCallbacks,
	XIMPreeditArea      | XIMStatusArea,
	XIMPreeditArea      | XIMStatusNothing,
	XIMPreeditArea      | XIMStatusNone,
	XIMPreeditNothing   | XIMStatusCallbacks,
	XIMPreeditNothing   | XIMStatusArea,
	XIMPreeditNothing   | XIMStatusNothing,
        XIMPreeditNothing   | XIMStatusNone,
	XIMPreeditNone	    | XIMStatusCallbacks,
	XIMPreeditNone      | XIMStatusArea,
	XIMPreeditNone      | XIMStatusNothing,
	XIMPreeditNone	    | XIMStatusNone
};

/* styles for disable_status_area */
static XIMStyle my_styles2[] = {
  XIMPreeditCallbacks | XIMStatusNone,
  XIMPreeditPosition  | XIMStatusNone,
  XIMPreeditArea      | XIMStatusNone,
  XIMPreeditNothing   | XIMStatusNone,
  XIMPreeditNone      | XIMStatusNone
};

int
R6IMProtocol::run() {
  XIMArg args[20];
  int ret;
  extern IMMethodsRec Xi18n_im_methods;

  if (display == 0) {
    // nothing to do
#ifdef DEBUG
    fprintf(stderr, "   Error - No XDisplay connection\n");
    fprintf(stderr, "       X11R6IM cannot be used\n");
#endif
    return -1;
  }

  IMTriggerKey keyp;
  XIMTriggerKey *trigger_keyp;
  int i;

  start_keys.count_keys = on_keys.count();
  start_keys.keylist = new XIMTriggerKey[start_keys.count_keys];
  trigger_keyp = start_keys.keylist;
  for (i = 0; i < start_keys.count_keys; i++, trigger_keyp++) {
    keyp = on_keys.getKey(i+1);
    trigger_keyp->modifier = keyp.get_modifier();
    trigger_keyp->modifier_mask = keyp.get_modifier_mask();
    trigger_keyp->keysym = keyp.get_keyCode();
  }
  stop_keys.count_keys = off_keys.count();
  stop_keys.keylist = new XIMTriggerKey[stop_keys.count_keys];
  trigger_keyp = stop_keys.keylist;
  for (i = 0; i < stop_keys.count_keys; i++, trigger_keyp++) {
    keyp = on_keys.getKey(i+1);
    trigger_keyp->modifier = keyp.get_modifier();
    trigger_keyp->modifier_mask = keyp.get_modifier_mask();
    trigger_keyp->keysym = keyp.get_keyCode();
  }

  if (display) {
    screen = DefaultScreen(display);
    im_window = XCreateSimpleWindow(display,
				    DefaultRootWindow(display),
				    0, 0, 1, 1, 1, 0, 0);
  }

  XIMStyles styles;
  styles.count_styles = sizeof(my_styles)/sizeof(XIMStyle);
  styles.supported_styles = &my_styles[0];

  if (disable_status_area == True){
    styles.count_styles = sizeof(my_styles2)/sizeof(XIMStyle);
    styles.supported_styles = &my_styles2[0];
  }

  unsigned long filter_events = KeyPressMask;
  // unsigned long filter_events = KeyPressMask | KeyReleaseMask;

  int n = 0;
  args[n].name = (char*)IMServerName; args[n].value = im_name; n++;
  args[n].name = (char*)IMServerWindow; args[n].value = (char*)im_window; n++;
  args[n].name = (char*)IMLocale; args[n].value = input_locale; n++;
  args[n].name = (char*)IMServerTransport; args[n].value = im_address; n++;
  args[n].name = (char*)IMOnKeysList; args[n].value = (char*)&start_keys; n++;
  args[n].name = (char*)IMOffKeysList; args[n].value = (char*)&stop_keys; n++;
  args[n].name = (char*)IMInputStyles; args[n].value = (char*)&styles; n++;

  args[n].name = (char*)IMSupportedICValues; args[n].value = (char*)ICValues; n++;
  args[n].name = (char*)IMSupportedIMValues; args[n].value = (char*)IMValues; n++;
  args[n].name = (char*)IMFilterEventMask; args[n].value = (char*)filter_events; n++;
#if 0
  args[n].name = (char*)IMProtocolHandler;	&r6_proto_callback,
#endif
  args[n].name = 0; args[n].value = 0;

  ims = new XIMProtocolRec;
  memset(ims, 0, sizeof(XIMProtocolRec));
  ims->methods = &Xi18n_im_methods;
  ims->core.display = display;
  ims->protocol = (*ims->methods->setup)(display, args);

  OpenIM();

  ret = (ims->methods->openIM)(ims);

  ximp_list.addItem(this);
  ims->id = ximp_list.getIndex(this);
  
  IMThread *thread = new IMThread(xevent_loop, this);

  return 0;
}

void*
R6IMProtocol::xevent_loop(void* client_data) {
  R6IMProtocol *ximp_protocol = (R6IMProtocol*)client_data;
  for (;;) {
    XEvent event;
    XNextEvent(ximp_protocol->display, &event);
    if (XFilterEvent(&event, 0) == True)
      continue;
    switch (event.type) {
    case ClientMessage:
    default:
      break;
    }
  }
  return 0;
}

extern "C" {
  int
  CreateXIC(XIMS ims,
	    CARD16 connect_id,
	    CARD16 preedit_attr_num,
	    CARD16 status_attr_num,
	    CARD16 ic_attr_num,
	    XICAttribute *preedit_attr,
	    XICAttribute *status_attr,
	    XICAttribute *ic_attr) {
    int id = ims->id;
    XIMPublic *ximp = &(ximp_list.getItem(id));

    CARD32 input_style = 0;
    // get input_style from ic_attr
    XICAttribute *icp;
    for (icp = ic_attr; icp < &ic_attr[ic_attr_num]; icp++) {
      if (!strcmp(icp->name, XNInputStyle)) {
	input_style = (*(CARD32*)icp->value);
	break;
      }
    }
    if (input_style == 0) {
      // something is wrong
      return -1;
    }
    XInputContext *ic = new XInputContext((XIMPublic*)ximp,
					  connect_id,
					  input_style);
    xic_list.addItem(ic);
    int ic_id = xic_list.getIndex(ic);

    char *ret = SetICValues(ic_id,
			    preedit_attr_num, status_attr_num, ic_attr_num,
			    preedit_attr, status_attr, ic_attr);
    return ic_id;
  }
  char* GetICValues(int icid,
		    CARD16 preedit_attr_num,
		    CARD16 status_attr_num,
		    CARD16 ic_attr_num,
		    XICAttribute *preedit_attr,
		    XICAttribute *status_attr,
		    XICAttribute *ic_attr) {
    XInputContext *ic =(XInputContext*)&(xic_list.getItem(icid));
  
    // set ic_attr
    XICAttribute *icp;
    for (icp = ic_attr; icp < &ic_attr[ic_attr_num]; icp++) {
      if (!strcmp(icp->name, XNClientWindow)) {
	icp->value = new Window;
	ic->get_client_window((*(Window*)icp->value));
	icp->value_length = sizeof(Window);
      }
      else if (!strcmp(icp->name, XNFocusWindow)) {
	icp->value = new Window;
	ic->get_focus_window((*(Window*)icp->value));
	icp->value_length = sizeof(Window);
      }
      else if (!strcmp(icp->name, XNFilterEvents)) {
	icp->value = new CARD32;
	ic->get_fwin_select_mask((*(CARD32*)icp->value));
	icp->value_length = sizeof(CARD32);
      }
      else if (!strcmp(icp->name, XNPreeditState)) {
	icp->value = new CARD32;
	(*(CARD32*)icp->value) = ic->is_conv_state();
	icp->value_length = sizeof(CARD32);
      }
    }
    // get preedit_attr
    for (icp = preedit_attr; icp < &preedit_attr[preedit_attr_num]; icp++) {
      if (!strcmp(icp->name, XNFontSet)) {
	char *ret = 0;
	ic->get_preedit_fontset(ret);
	icp->value = strdup(ret);
	icp->value_length = strlen(ret);
      }
      else if (!strcmp(icp->name, XNPreeditState)) {
	icp->value = new CARD32;
	(*(CARD32*)icp->value) = ic->is_conv_state();
	icp->value_length = sizeof(CARD32);
      }
      else if (!strcmp(icp->name, XNArea)) {
	icp->value = new XRectangle;
	long x = 0, y = 0;
	unsigned long width = 0, height = 0;
	ic->get_preedit_area(x, y, width, height);
	XRectangle rect;
	rect.x = x; rect.y = y; rect.width = width;
	rect.height = height;
	(*(XRectangle*)icp->value) = rect;
	icp->value_length = sizeof(XRectangle);
      }
      else if (!strcmp(icp->name, XNAreaNeeded)) {
	icp->value = new XRectangle;
	long x = 0, y = 0;
	unsigned long width = 0, height = 0;
	ic->get_preedit_area_needed(x, y, width, height);
	XRectangle rect;
	rect.x = x; rect.y = y; rect.width = width;
	rect.height = height;
	(*(XRectangle*)icp->value) = rect;
	icp->value_length = sizeof(XRectangle);
      }
      else if (!strcmp(icp->name, XNSpotLocation)) {
	icp->value = new XPoint;
	long x = 0, y = 0;
	ic->get_preedit_spot_location(x, y);
	XPoint point;
	point.x = x; point.y = y;
	(*(XPoint*)icp->value) = point;
	icp->value_length = sizeof(XPoint);
      }
      else if (!strcmp(icp->name, XNForeground)) {
	icp->value = new CARD32;
	ic->get_preedit_fg(*(CARD32*)icp->value);
	icp->value_length = sizeof(CARD32);
      }
      else if (!strcmp(icp->name, XNBackground)) {
	icp->value = new CARD32;
	ic->get_preedit_bg(*(CARD32*)icp->value);
	icp->value_length = sizeof(CARD32);
      }
      else if (!strcmp(icp->name, XNBackgroundPixmap)) {
	icp->value = new Pixmap;
	ic->get_preedit_bg_pixmap(*(Pixmap*)icp->value);
	icp->value_length = sizeof(Pixmap);
      }
      else if (!strcmp(icp->name, XNLineSpace)) {
	icp->value = new CARD32;
	ic->get_preedit_line_spacing(*(CARD32*)icp->value);
	icp->value_length = sizeof(CARD32);
      }
      else if (!strcmp(icp->name, XNCursor)) {
	icp->value = new Cursor;
	ic->get_preedit_cursor(*(Cursor*)icp->value);
	icp->value_length = sizeof(Cursor);
      }
      else if (!strcmp(icp->name, XNColormap)) {
	icp->value = new Colormap;
	ic->get_preedit_colormap(*(Colormap*)icp->value);
	icp->value_length = sizeof(Colormap);
      }
    }
    // get status_attr
    for (icp = status_attr; icp < &status_attr[status_attr_num]; icp++) {
      if (!strcmp(icp->name, XNFontSet)) {
	char *ret = 0;
	ic->get_status_fontset(ret);
	icp->value = strdup(ret);
	icp->value_length = strlen(ret);
      }
      else if (!strcmp(icp->name, XNArea)) {
	icp->value = new XRectangle;
	long x = 0, y = 0;
	unsigned long width = 0, height = 0;
	ic->get_status_area(x, y, width, height);
	XRectangle rect;
	rect.x = x; rect.y = y; rect.width = width;
	rect.height = height;
	(*(XRectangle*)icp->value) = rect;
	icp->value_length = sizeof(XRectangle);
      }
      else if (!strcmp(icp->name, XNAreaNeeded)) {
	icp->value = new XRectangle;
	long x = 0, y = 0;
	unsigned long width = 0, height = 0;
	ic->get_status_area_needed(x, y, width, height);
	XRectangle rect;
	rect.x = x; rect.y = y; rect.width = width;
	rect.height = height;
	(*(XRectangle*)icp->value) = rect;
	icp->value_length = sizeof(XRectangle);
      }
      else if (!strcmp(icp->name, XNForeground)) {
	icp->value = new CARD32;
	ic->get_status_fg(*(CARD32*)icp->value);
	icp->value_length = sizeof(CARD32);
      }
      else if (!strcmp(icp->name, XNBackground)) {
	icp->value = new CARD32;
	ic->get_status_bg(*(CARD32*)icp->value);
	icp->value_length = sizeof(CARD32);
      }
      else if (!strcmp(icp->name, XNBackgroundPixmap)) {
	icp->value = new Pixmap;
	ic->get_status_bg_pixmap(*(Pixmap*)icp->value);
	icp->value_length = sizeof(Pixmap);
      }
      else if (!strcmp(icp->name, XNLineSpace)) {
	icp->value = new CARD32;
	ic->get_status_line_spacing(*(CARD32*)icp->value);
	icp->value_length = sizeof(CARD32);
      }
      else if (!strcmp(icp->name, XNCursor)) {
	icp->value = new Cursor;
	ic->get_status_cursor(*(Cursor*)icp->value);
	icp->value_length = sizeof(Cursor);
      }
      else if (!strcmp(icp->name, XNColormap)) {
	icp->value = new Colormap;
	ic->get_status_colormap(*(Colormap*)icp->value);
	icp->value_length = sizeof(Colormap);
      }
    }
    return (char*)0;
  }
  char* SetICValues(int icid,
		    CARD16 preedit_attr_num,
		    CARD16 status_attr_num,
		    CARD16 ic_attr_num,
		    XICAttribute *preedit_attr,
		    XICAttribute *status_attr,
		    XICAttribute *ic_attr) {
    XInputContext *ic =(XInputContext*)&(xic_list.getItem(icid));
  
    // set ic_attr
    XICAttribute *icp;
    for (icp = ic_attr; icp < &ic_attr[ic_attr_num]; icp++) {
      if (!strcmp(icp->name, XNClientWindow)) {
	ic->set_client_window((*(Window*)icp->value));
      }
      else if (!strcmp(icp->name, XNFocusWindow)) {
	ic->set_focus_window((*(Window*)icp->value));
      }
      else if (!strcmp(icp->name, XNFilterEvents)) {
	ic->set_fwin_select_mask(*(CARD32*)icp->value);
      }
      else if (!strcmp(icp->name, XNPreeditState)) {
	if ((int)icp->value == XIMPreeditEnable) {
	  ic->conversion_start(True);
	}
	if ((int)icp->value == XIMPreeditDisable) {
	  ic->conversion_end(True);
	}
      }
    }
    // set preedit_attr
    for (icp = preedit_attr; icp < &preedit_attr[preedit_attr_num]; icp++) {
      if (!strcmp(icp->name, XNFontSet)) {
	ic->set_preedit_fontset((char*)icp->value);
      }
      else if (!strcmp(icp->name, XNPreeditState)) {
	if ((int)icp->value == XIMPreeditEnable) {
	  ic->conversion_start(True);
	}
	if ((int)icp->value == XIMPreeditDisable) {
	  ic->conversion_end(True);
	}
      }
      else if (!strcmp(icp->name, XNArea)) {
	XRectangle *rect = (XRectangle*)icp->value;
	ic->set_preedit_area(rect->x, rect->y, rect->width, rect->height);
      }
      else if (!strcmp(icp->name, XNAreaNeeded)) {
	XRectangle *rect = (XRectangle*)icp->value;
	ic->set_preedit_area_needed(rect->width, rect->height);
      }
      else if (!strcmp(icp->name, XNSpotLocation)) {
	XPoint *point = (XPoint*)icp->value;
	ic->set_preedit_spot_location(point->x, point->y);
      }
      else if (!strcmp(icp->name, XNForeground)) {
	ic->set_preedit_fg((*(CARD32*)icp->value));
      }
      else if (!strcmp(icp->name, XNBackground)) {
	ic->set_preedit_bg((*(CARD32*)icp->value));
      }
      else if (!strcmp(icp->name, XNBackgroundPixmap)) {
	ic->set_preedit_bg_pixmap((*(Pixmap*)icp->value));
      }
      else if (!strcmp(icp->name, XNLineSpace)) {
	ic->set_preedit_line_spacing((*(CARD32*)icp->value));
      }
      else if (!strcmp(icp->name, XNCursor)) {
	ic->set_preedit_cursor((*(Cursor*)icp->value));
      }
      else if (!strcmp(icp->name, XNColormap)) {
	ic->set_preedit_colormap((*(Colormap*)icp->value));
      }
    }
    // set status_attr
    for (icp = status_attr; icp < &status_attr[status_attr_num]; icp++) {
      if (!strcmp(icp->name, XNFontSet)) {
	ic->set_status_fontset((char*)icp->value);
      }
      else if (!strcmp(icp->name, XNArea)) {
	XRectangle *rect = (XRectangle*)icp->value;
	ic->set_status_area(rect->x, rect->y, rect->width, rect->height);
      }
      else if (!strcmp(icp->name, XNAreaNeeded)) {
	XRectangle *rect = (XRectangle*)icp->value;
	ic->set_status_area_needed(rect->width, rect->height);
      }
      else if (!strcmp(icp->name, XNForeground)) {
	ic->set_status_fg((*(CARD32*)icp->value));
      }
      else if (!strcmp(icp->name, XNBackground)) {
	ic->set_status_bg((*(CARD32*)icp->value));
      }
      else if (!strcmp(icp->name, XNBackgroundPixmap)) {
	ic->set_status_bg_pixmap((*(Pixmap*)icp->value));
      }
      else if (!strcmp(icp->name, XNLineSpace)) {
	ic->set_status_line_spacing((*(CARD32*)icp->value));
      }
      else if (!strcmp(icp->name, XNCursor)) {
	ic->set_status_cursor((*(Cursor*)icp->value));
      }
      else if (!strcmp(icp->name, XNColormap)) {
	ic->set_status_colormap((*(Colormap*)icp->value));
      }
    }
    return (char*)0;
  }
  void SetICFocus(int icid) {
    XInputContext *ic =(XInputContext*)&(xic_list.getItem(icid));

    if (ic) ic->set_focus();
  }
  void UnsetICFocus(int icid) {
    XInputContext *ic =(XInputContext*)&(xic_list.getItem(icid));

    if (ic) ic->unset_focus();
  }
  Bool IsFocused(int icid) {
    XInputContext *ic =(XInputContext*)&(xic_list.getItem(icid));

    if (ic) return ic->is_focused();
  }
  void FilterEvent(int icid, XEvent *event) {
    XInputContext *ic =(XInputContext*)&(xic_list.getItem(icid));

    if (ic) ic->filter_event(event);
  }
  void DestroyIC(int icid) {
    XInputContext *ic =(XInputContext*)&(xic_list.getItem(icid));

    if (ic) ic->destroy();
  }
  char *ResetIC(int icid) {
    XInputContext *ic =(XInputContext*)&(xic_list.getItem(icid));
    char *mb_data = 0;
    if (ic) {
      mb_data = ic->reset();
    }
    /* should reset to False */
    ic->being_reset = False;
    return mb_data;
  }
  void MoveSpot(int icid, int x, int y) {
    XInputContext *ic =(XInputContext*)&(xic_list.getItem(icid));

    if (ic) ic->set_preedit_spot_location(x, y);
  }
  void ConversionStart(int icid) {
    XInputContext *ic =(XInputContext*)&(xic_list.getItem(icid));

    if (ic) ic->conversion_start(True);
  }
  void ConversionEnd(int icid) {
    XInputContext *ic =(XInputContext*)&(xic_list.getItem(icid));

    if (ic) ic->conversion_end(True);
  }
	   }

