/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#ifndef _X11R6IMProtoData_h
#define _X11R6IMProtoData_h

#include <X11/Xmd.h>
#include "X11/Xlcint.h"
#include "XIMTriggerKey.h"

/* IM Attributes Name */
#define IMModifiers		"modifiers"
#define IMServerWindow		"serverWindow"
#define IMServerName		"serverName"
#define IMServerTransport	"serverTransport"
#define IMLocale		"locale"
#define IMInputStyles		"inputStyles"
#define IMProtocolHandler	"protocolHandler"
#define IMOnKeysList		"onKeysList"
#define IMOffKeysList		"offKeysList"
#define IMEncodingList		"encodingList"
#define IMFilterEventMask	"filterEventMask"
#define IMProtocolDepend	"protocolDepend"
#define IMSupportedIMValues	"supportedIMValues"
#define IMSupportedICValues	"supportedICValues"

/* Masks for IM Attributes Name */
#define I18N_IMSERVER_WIN	0x0001 /* IMServerWindow */
#define I18N_IM_NAME		0x0002 /* IMServerName */
#define I18N_IM_LOCALE		0x0004 /* IMLocale */
#define I18N_IM_ADDRESS		0x0008 /* IMServerTransport */
#define I18N_INPUT_STYLES	0x0010 /* IMInputStyles */
#define I18N_ON_KEYS		0x0020 /* IMOnKeysList */
#define I18N_OFF_KEYS		0x0040 /* IMOffKeysList */
#define I18N_IM_HANDLER		0x0080 /* IMProtocolHander */
#define I18N_ENCODINGS		0x0100 /* IMEncodingList */
#define I18N_FILTERMASK		0x0200 /* IMFilterEventMask */
#define I18N_PROTO_DEPEND	0x0400 /* IMProtoDepend */

typedef char *XIMEncoding;

typedef struct {
    unsigned short count_encodings;
    XIMEncoding *supported_encodings;
} XIMEncodings;

typedef struct _XIMS *XIMS;

typedef struct _IMForwardEventStruct *IMForwardEvent;
typedef struct _IMCommitEventStruct *IMCommitEvent;
typedef union _X11R6IMProtocolStruct *X11R6IMProtocol;

typedef struct {
    void*	(*setup)(Display*, XIMArg*);
    Status	(*openIM)(XIMS);
    Status	(*closeIM)(XIMS);
    char*	(*setIMValues)(XIMS, XIMArg*);
    char*	(*getIMValues)(XIMS, XIMArg*);
    Status	(*forwardEvent)(XIMS, IMForwardEvent);
    Status	(*commitString)(XIMS, IMCommitEvent);
    int		(*callCallback)(XIMS, X11R6IMProtocol);
    int		(*preeditStart)(XIMS, X11R6IMProtocol);
    int		(*preeditEnd)(XIMS, X11R6IMProtocol);
} IMMethodsRec, *IMMethods;

typedef struct {
    Display	*display;
    int		screen;
} IMCoreRec, *IMCore;

typedef struct _XIMS {
    IMMethods	methods;
    IMCoreRec	core;
    void	*protocol;
    int		id;
} XIMProtocolRec;

typedef struct {
    char *name;
    CARD16 type;
    CARD16 id;
} XIMListOfAttr;

typedef struct {
    char *name;
    CARD8 major_opcode;
    CARD8 minor_opcode;
} IMExtList;

typedef struct {
    int		attribute_id;
    CARD16	name_length; 
    char	*name;
    int		value_length;
    void	*value;
    int		type;
} XIMAttribute;

typedef struct {
    int		attribute_id;
    CARD16	name_length;
    char	*name;
    int		value_length;
    void	*value;
    int		type;
} XICAttribute;

typedef struct {
    int		length;
    char	*name;
} XIMStr;

/*
 * Callback Struct for XIM Protocol
 */
typedef struct {
    int		major_code;
    int		minor_code;
    CARD16	connect_id;
} IMAnyStruct;

typedef struct {
    int		major_code;
    int		minor_code;
    CARD16	connect_id;
    CARD8	byte_order;
    CARD16	major_version;
    CARD16	minor_version;
} IMConnectStruct;

typedef struct {
    int		major_code;
    int		minor_code;
    CARD16	connect_id;
} IMDisConnectStruct;

typedef struct {
    int		major_code;
    int		minor_code;
    CARD16	connect_id;
    XIMStr	lang;
} IMOpenStruct;

typedef struct {
    int		major_code;
    int		minor_code;
    CARD16	connect_id;
} IMCloseStruct;

typedef struct {
    int		major_code;
    int		minor_code;
    CARD16	connect_id;
    CARD16	number;
    XIMStr	*extension;
} IMQueryExtensionStruct;

typedef struct {
    int		major_code;
    int		minor_code;
    CARD16	connect_id;
    CARD16	number;
    char	**im_attr_list;
} IMGetIMValuesStruct;

typedef struct {
    int		major_code;
    int		minor_code;
    CARD16	connect_id;
    CARD16	icid;
    CARD16	preedit_attr_num;
    CARD16	status_attr_num;
    CARD16	ic_attr_num;
    XICAttribute *preedit_attr;
    XICAttribute *status_attr;
    XICAttribute *ic_attr;
} IMChangeICStruct;

typedef struct {
    int		major_code;
    int		minor_code;
    CARD16	connect_id;
    CARD16	icid;
} IMDestroyICStruct;

typedef struct {
    int		major_code;
    int		minor_code;
    CARD16	connect_id;
    CARD16	icid;
    CARD16	length;
    char	*commit_string;
} IMResetICStruct;

typedef struct {
    int		major_code;
    int		minor_code;
    CARD16	connect_id;
    CARD16	icid;
} IMChangeFocusStruct;

typedef struct _IMForwardEventStruct {
    int		major_code;
    int		minor_code;
    CARD16	connect_id;
    CARD16	icid;
    CARD16	sync_bit;
    CARD16	serial_number;
    XEvent	event;
} IMForwardEventStruct;

typedef struct _IMCommitEventStruct {
    int		major_code;
    int		minor_code;
    CARD16	connect_id;
    CARD16	icid;
    CARD16	flag;
    KeySym	keysym;
    char	*commit_string;
} IMCommitEventStruct;

typedef struct {
    int		major_code;
    int		minor_code;
    CARD16	connect_id;
    CARD16	icid;
    CARD32	flag;
    CARD32	key_index;
    CARD32	event_mask;
} IMTriggerNotifyStruct;

typedef struct {
    int		major_code;
    int		minor_code;
    CARD16	connect_id;
    CARD16	encoding_number;
    XIMStr	*encoding;	/* name information */
    CARD16	encoding_info_number;
    XIMStr	*encodinginfo;	/* detailed information */
    CARD16	category;	/* #0 for name, #1 for detail */
    INT16	enc_index;	/* index of the encoding determined */
} IMEncodingNegotiationStruct;

typedef struct {
    int		major_code;
    int		minor_code;
    CARD16	connect_id;
    CARD16	icid;
    CARD32	flag;
    CARD32	forward_event_mask;
    CARD32	sync_event_mask;
} IMSetEventMaskStruct;

typedef struct {
    int		major_code;
    int		minor_code;
    CARD16	connect_id;
    CARD16	icid;
    CARD32	flag;
    CARD32	intercept_event_mask;
    CARD32	select_event_mask;
    CARD32	forward_event_mask;
    CARD32	sync_event_mask;
} IMExtSetEventMaskStruct;

typedef struct {
    int		major_code;
    int		minor_code;
    CARD16	connect_id;
    CARD16	icid;
    CARD16	x;
    CARD16	y;
} IMMoveStruct;

typedef struct {
    int		major_code;
    int		minor_code;
    CARD16	connect_id;
    CARD16	icid;
    CARD16	flag;
    CARD16	error_code;
    CARD16	str_length;
    CARD16	error_type;
    char	*error_detail;
} IMErrorStruct;

typedef struct {
    int		major_code;
    int		minor_code;
    CARD16	connect_id;
    CARD16	icid;
    CARD32	operation;	/* True: set, False: get */
    CARD32	conv_state;
} IMPreeditStateStruct;

/* Callbacks */
typedef struct {
    int		major_code;
    int		minor_code;
    CARD16	connect_id;
    CARD16	icid;
} IMGeometryCBStruct;

typedef struct {
    int		major_code;
    int		minor_code;
    CARD16	connect_id;
    CARD16	icid;
    union {
	int return_value;			/* PreeditStart */
	XIMPreeditDrawCallbackStruct draw;	/* PreeditDraw */
	XIMPreeditCaretCallbackStruct caret; 	/* PreeditCaret */
    } todo;
} IMPreeditCBStruct;

typedef struct {
    int		major_code;
    int		minor_code;
    CARD16	connect_id;
    CARD16	icid;
    union {
	XIMStatusDrawCallbackStruct draw;	/* StatusDraw */
    } todo;
} IMStatusCBStruct;

typedef struct {
    int		major_code;
    int		minor_code;
    CARD16	connect_id;
    CARD16	icid;
    XIMStringConversionCallbackStruct strconv;
} IMStrConvCBStruct;

typedef union _X11R6IMProtocolStruct {
    int	major_code;
    IMAnyStruct any;
    IMConnectStruct imconnect;
    IMDisConnectStruct imdisconnect;
    IMOpenStruct imopen;
    IMCloseStruct imclose;
    IMQueryExtensionStruct queryext;
    IMGetIMValuesStruct getim;
    IMEncodingNegotiationStruct encodingnego;
    IMExtSetEventMaskStruct extsetevent;
    IMMoveStruct extmove;
    IMSetEventMaskStruct setevent;
    IMChangeICStruct changeic;
    IMDestroyICStruct destroyic;
    IMResetICStruct resetic;
    IMChangeFocusStruct changefocus;
    IMCommitEventStruct commitstring;
    IMForwardEventStruct forwardevent;
    IMTriggerNotifyStruct triggernotify;
    IMPreeditStateStruct preedit_state;
    IMErrorStruct imerror;
    IMGeometryCBStruct geometry_callback;
    IMPreeditCBStruct preedit_callback;
    IMStatusCBStruct status_callback;
    IMStrConvCBStruct strconv_callback;
    long pad[32];
} X11R6IMProtocolStruct;

typedef struct {
    int (*proc)(
		XIMS, X11R6IMProtocol *, XPointer
		);
    XPointer client_data;
} X11R6IMProtoHandler;

/*
 * value for the flag of XIM_FORWARD_EVENT, XIM_COMMIT
 */
#define XimSYNCHRONUS		  0x0001
#define XimLookupChars		  0x0002
#define XimLookupKeySym		  0x0004
#define XimLookupBoth		  0x0006

#endif /* _X11R6IMProtoData_h */
