/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#ifndef _inputcontext_hh
#define _inputcontext_hh

#include "IMList.hh"
#include "IMArg.h"
#include "IMProtocolStruct.h"

class CompoundString;
struct IMPreeditStruct;
struct IMStatusStruct;
struct IMLookupStruct;

class InputContext {
 public:
  InputContext() {};
  virtual ~InputContext() {};

  // query an ICValue of InputContext
  virtual const CompoundString& getUser() const =0;
  virtual const CompoundString& getLocaleName() const =0;
  virtual const CompoundString& getEngineName() const =0;

  // CLIENT DESCRIPTOR
  virtual const CompoundString& getApplicationName() const =0;
  virtual const CompoundString& getOSName() const=0;
  virtual const CompoundString& getOSArch() const=0;
  virtual const CompoundString& getOSVersion() const=0;
  // Client Display Info
  virtual const CompoundString& getXDisplayString() const=0;
  virtual const CompoundString& getXServerVendor() const=0;

  virtual int commit_string(IMText *text)=0;
  virtual int forward_event(IMKeyEventStruct *event)=0;

  virtual int preedit_start(IMPreeditStruct *preedit)=0;
  virtual int preedit_draw(IMPreeditStruct *preedit)=0;
  virtual int preedit_caret(IMPreeditStruct *preedit)=0;
  virtual int preedit_done(IMPreeditStruct *preedit)=0;

  virtual int status_start(IMStatusStruct *status)=0;
  virtual int status_draw(IMStatusStruct *status)=0;
  virtual int status_done(IMStatusStruct *status)=0;

  virtual int lookup_start(IMLookupStruct *lookup)=0;
  virtual int lookup_draw(IMLookupStruct *lookup)=0;
  // virtual int lookup_process(IMLookupStruct *lookup)=0;
  virtual int lookup_done(IMLookupStruct *lookup)=0;

  virtual int auxiliary_start(IMAuxStruct *auxiliary)=0;
  virtual int auxiliary_draw(IMAuxStruct *auxiliary)=0;
  virtual int auxiliary_done(IMAuxStruct *auxiliary)=0;

  virtual int conversion_start()=0;
  virtual int conversion_end()=0;

  void set_icvalues(IMArg *args, int n);
  void get_icvalues(IMArg *args, int n) const;

 private:
  IMList<char> arg_list;
};

#endif
