/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#ifndef _iiimpinputcontext_hh
#define _iiimpinputcontext_hh

#include "InputContext.hh"

class IIIMPClient;

class IIIMPInputContext : public InputContext {
 public:
  IIIMPInputContext(IIIMPClient *cl);
  ~IIIMPInputContext();

  const CompoundString& getUser() const;
  const CompoundString& getLocaleName() const;
  const CompoundString& getEngineName() const;

  // CLIENT DESCRIPTOR
  const CompoundString& getApplicationName() const;
  const CompoundString& getOSName() const;
  const CompoundString& getOSArch() const;
  const CompoundString& getOSVersion() const;
  // Client Display Info
  const CompoundString& getXDisplayString() const;
  const CompoundString& getXServerVendor() const;

  void setLocaleName(char*);
  void setEngineName(char*);

  int commit_string(IMText *text);
  int forward_event(IMKeyEventStruct *event);
  int preedit_start(IMPreeditStruct *preedit);
  int preedit_draw(IMPreeditStruct *preedit);
  int preedit_caret(IMPreeditStruct *preedit);
  int preedit_done(IMPreeditStruct *preedit);
  int status_start(IMStatusStruct *status);
  int status_draw(IMStatusStruct *status);
  int status_done(IMStatusStruct *status);
  int lookup_start(IMLookupStruct *lookup);
  int lookup_draw(IMLookupStruct *lookup);
  int lookup_process(IMLookupStruct *lookup);
  int lookup_done(IMLookupStruct *lookup);
  int auxiliary_start(IMAuxStruct *auxiliary);
  int auxiliary_draw(IMAuxStruct *auxiliary);
  int auxiliary_done(IMAuxStruct *auxiliary);
  int conversion_start();
  int conversion_end();

  void realize();
  void unrealize();
  int is_active() {return ic_state == is_realized;}

 private:
  enum IC_STATE {
    is_being_created = 0,
    is_realized = 1,
    is_destroyed = 2
  };
  IC_STATE ic_state;
  IIIMPClient *client;

  CompoundString localename;
  CompoundString enginename;
};

#endif
