/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#if !defined(USE_FRAMEMGR_ALWAYS)
#include <stddef.h>
#include <string.h>
#else /* USE_FRAMEMGR_ALWAYS */
#include "FrameMgr.h"
#endif /* USE_FRAMEMGR_ALWAYS */
#include "IIIMProtocol.hh"
#include "IIIMPClient.hh"
#include "IMProtoHandler.hh"
#include "IMProtocolStruct.h"
#include "IMProtocolStructP.hh"

#if !defined(USE_FRAMEMGR_ALWAYS)
int
IIIMPClient::string_list_count(char *p) {
  char *ptr;
  CARD32 str_list_size; 
  int num;
  CARD16 str_size;

  num = 0;
  ptr = p;
  if (False == need_swap) {
    req_get32(ptr, str_list_size);
    if (str_list_size & 0x03) {
      str_list_size &= (~0x03);
    }

    while (4 <= str_list_size) {
      req_get16(ptr, str_size);
      str_list_size -= 2;
      if ((str_size + 2) & 0x03) {	/* padding */
	str_size = (((str_size + 2) & (~0x03)) + 2);
      }
      if (str_list_size < str_size) {
	str_size = str_list_size;
      }

      ptr += str_size;
      str_list_size -= str_size;
      num += 1;
    }
  } else {
    req_get32s(ptr, str_list_size);
    if (str_list_size & 0x03) {
      str_list_size &= (~0x03);
    }

    while (4 <= str_list_size) {
      req_get16s(ptr, str_size);
      str_list_size -= 2;
      if ((str_size + 2) & 0x03) {	/* padding */
	str_size = (((str_size + 2) & (~0x03)) + 2);
      }
      if (str_list_size < str_size) {
	str_size = str_list_size;
      }

      ptr += str_size;
      str_list_size -= str_size;
      num += 1;
    }
  }
  return num;
}
#else /* USE_FRAMEMGR_ALWAYS */
#endif /* USE_FRAMEMGR_ALWAYS */

void
IIIMPClient::aux_set_values(IMProtocolStruct *call_data,
			    unsigned char *p) {
#if !defined(USE_FRAMEMGR_ALWAYS)
  char *ptr;
  int im_name_len;
  char *enginename;
  int i;
#else /* USE_FRAMEMGR_ALWAYS */
  FrameMgr fm;
  FmStatus status;
  extern XimFrameRec im_aux_setvalues_fr[], im_aux_setvalues_reply_fr[];
  XimFrameRec *input_fr = im_aux_setvalues_fr;
#endif /* USE_FRAMEMGR_ALWAYS */
  int class_index;
  CARD16 input_method_id, input_context_id;
  CARD32 byte_length = 0;
  int number;
#if !defined(USE_FRAMEMGR_ALWAYS)
  int string_list_num;
#else /* USE_FRAMEMGR_ALWAYS */
  int integer_list_num = IIIMPClient::MAX_ATTRNUM;
  int string_list_num = IIIMPClient::MAX_ATTRNUM;
#endif /* USE_FRAMEMGR_ALWAYS */
  IMAuxDrawCallbackStruct aux_draw;

#if !defined(USE_FRAMEMGR_ALWAYS)
  ptr = (char *)p;
  if (False == need_swap) {
    req_get16(ptr, input_method_id);
    req_get16(ptr, input_context_id);
    req_get32(ptr, class_index);
    req_get16(ptr, byte_length);
  } else {
    req_get16s(ptr, input_method_id);
    req_get16s(ptr, input_context_id);
    req_get32s(ptr, class_index);
    req_get16s(ptr, byte_length);
  }
  if (byte_length & 0x01) {
    byte_length += 1;
  }
  if (byte_length & 0x02) {
    im_name_len = byte_length;
  } else {
    im_name_len = (byte_length + 2);
  }

#else /* USE_FRAMEMGR_ALWAYS */
  /* create FrameMgr */
  fm = FrameMgrInit(input_fr, (char *)p, need_swap);

  /* get data */
  FrameMgrGetToken(fm, input_method_id);
  FrameMgrGetToken(fm, input_context_id);
  FrameMgrGetToken(fm, class_index);

  /* engine_name */
  CompoundString enginename;

  FrameMgrGetToken(fm, byte_length);
#endif /* USE_FRAMEMGR_ALWAYS */
  if (byte_length == 0) {
    /* something wrong */
    return;
  } else {
    CARD16 str;
    CARD8 byte_data;
    char *enginenamep;

#if !defined(USE_FRAMEMGR_ALWAYS)
    enginename = new char[byte_length + 1];
#else /* USE_FRAMEMGR_ALWAYS */
    enginename = CompoundString(byte_length);
    memset(enginename, 0, byte_length);
#endif /* USE_FRAMEMGR_ALWAYS */

    int i;
    if (need_swap) {
      for (i = 0, enginenamep = enginename;
	   i < byte_length; i += 2, enginenamep++) {
#if !defined(USE_FRAMEMGR_ALWAYS)
	req_get16(ptr, *enginenamep);
#else /* USE_FRAMEMGR_ALWAYS */
        FrameMgrGetToken(fm, byte_data);
	*(((unsigned char *)&str) + 1) = byte_data;
	FrameMgrGetToken(fm, byte_data);
	*(((unsigned char *)&str) + 0) = byte_data;
	*enginenamep = (char)str;
#endif /* USE_FRAMEMGR_ALWAYS */
      }
    } else {
      for (i = 0, enginenamep = enginename;
	   i < byte_length; i += 2, enginenamep++) {
#if !defined(USE_FRAMEMGR_ALWAYS)
	req_get16s(ptr, *enginenamep);
#else /* USE_FRAMEMGR_ALWAYS */
        FrameMgrGetToken(fm, byte_data);
	*(((unsigned char *)&str) + 0) = byte_data;
	FrameMgrGetToken(fm, byte_data);
	*(((unsigned char *)&str) + 1) = byte_data;
	*enginenamep = (char)str;
#endif /* USE_FRAMEMGR_ALWAYS */
      }
    }
    *enginenamep = (char)0;
  }
#if !defined(USE_FRAMEMGR_ALWAYS)
  if ((byte_length + 2) & 0x03) {
    ptr += (4 - ((byte_length + 2) & 0x03));
  }
#else /* USE_FRAMEMGR_ALWAYS */
#endif /* USE_FRAMEMGR_ALWAYS */


  aux_draw.aux_name = enginename;
  aux_draw.aux_index = class_index;

  /* integer value list */
#if !defined(USE_FRAMEMGR_ALWAYS)
  int *integer_list = NULL;
#else /* USE_FRAMEMGR_ALWAYS */
  int *integer_list = new int[integer_list_num];
#endif /* USE_FRAMEMGR_ALWAYS */

  number = 0;
#if !defined(USE_FRAMEMGR_ALWAYS)
  if (False == need_swap) {
    req_get32(ptr, byte_length);
  } else {
    req_get32s(ptr, byte_length);
  }
#else /* USE_FRAMEMGR_ALWAYS */
  FrameMgrGetToken(fm, byte_length);
#endif /* USE_FRAMEMGR_ALWAYS*/
  if (byte_length) {
#if !defined(USE_FRAMEMGR_ALWAYS)
    integer_list = new int[byte_length / 4];
    if (False == need_swap) {
      for (number = 0; number < (byte_length / 4); number++) {
	req_get32(ptr, *(integer_list + number));
      }
    } else {
      for (number = 0; number < (byte_length / 4); number++) {
	req_get32s(ptr, *(integer_list + number));
      }
    }
#else /* USE_FRAMEMGR_ALWAYS */
    while (FrameMgrIsIterLoopEnd(fm, &status) == False) {
      if (number == integer_list_num) {
	integer_list_num += IIIMPClient::MAX_ATTRNUM;
	int *temp = integer_list;
	integer_list = new int[integer_list_num];
	memmove(integer_list, temp, sizeof(int) * number);
	delete [] temp;
      }
      FrameMgrGetToken(fm, integer_list[number++]);
    }
#endif /* USE_FRAMEMGR_ALWAYS */
  }
  aux_draw.count_integer_values = number;
  aux_draw.integer_values = integer_list;

#if !defined(USE_FRAMEMGR_ALWAYS)
  /* string value list */
  string_list_num = string_list_count(ptr);
#endif

  IMText *string_list = new IMText[string_list_num];
  if (!string_list) {
    delete [] integer_list;
    return;
  }

  number = 0;
#if !defined(USE_FRAMEMGR_ALWAYS)
  if (False == need_swap) {
    req_get32(ptr, byte_length);
  } else {
    req_get32s(ptr, byte_length);
  }
#else /* USE_FRAMEMGR_ALWAYS */
  FrameMgrGetToken(fm, byte_length);
#endif /* USE_FRAMEMGR_ALWAYS */
  if (byte_length) {
#if !defined(USE_FRAMEMGR_ALWAYS)
    if (False == need_swap) {
      while (4 <= byte_length) {
	CARD16 str_length = 0;
	req_get16(ptr, str_length);
	byte_length -= 2;

	if (str_length & 0x01) {	/* incorrect request */
	  str_length += 1;
	}
	if (byte_length < str_length) {	/* incorrect request */
	  str_length = byte_length;
	}

	if (65000 < str_length) {
	  /* something wrong */
	} else {
	  int len = (str_length / 2);
	  UTFCHAR *utf_str = new UTFCHAR[len + 1];

	  for (i = 0; i < len; i++) {
	    req_get16(ptr, *(utf_str + i));
	  }
	  *(utf_str + len) = 0;

	  if ((str_length + 2) & 0x03) {
	    byte_length -= (((str_length + 2) & (~0x03)) + 2);
	    ptr += 2;
	  } else {
	    byte_length -= str_length;
	  }

	  string_list[number].encoding = UTF16_CODESET;
	  string_list[number].char_length = len;
	  string_list[number].text.utf_chars = utf_str;
	  number += 1;
	}
      }
    } else {
      while (4 <= byte_length) {
	CARD16 str_length = 0;
	req_get16s(ptr, str_length);
	byte_length -= 2;

	if (str_length & 0x01) {	/* incorrect request */
	  str_length += 1;
	}
	if (byte_length < str_length) {	/* incorrect request */
	  str_length = byte_length;
	}

	if (65000 < str_length) {
	  /* something wrong */
	} else {
	  int len = (str_length / 2);
	  UTFCHAR *utf_str = new UTFCHAR[len + 1];

	  for (i = 0; i < len; i++) {
	    req_get16s(ptr, *(utf_str + i));
	  }
	  *(utf_str + len) = 0;

	  if ((str_length + 2) & 0x03) {
	    byte_length -= (((str_length + 2) & (~0x03)) + 2);
	    ptr += 2;
	  } else {
	    byte_length -= str_length;
	  }

	  string_list[number].encoding = UTF16_CODESET;
	  string_list[number].char_length = len;
	  string_list[number].text.utf_chars = utf_str;
	  number += 1;
	}
      }
    }
#else /* USE_FRAMEMGR_ALWAYS */
    if (1 == (byte_length % 2)) {
      /*
       * byte_length must be even.
       * it should be safe to add 1 to byte_length when it is odd.
       */
      byte_length += 1;
    }

    while (byte_length > 0) {
      CARD16 str_length = 0;
      FrameMgrGetToken(fm, str_length);
      byte_length -= 2;

      if (1 == (str_length % 2)) {
	str_length += 1;
      }
      if (byte_length < str_length) {
	/* incorrect request */
	str_length = byte_length;
      }

      if (str_length > 65000) {
	/* something wrong */
      } else {
	CARD8 first_byte, second_byte;
	int len;
	char *utf_str = new char[str_length + 1];
	char *strp;
	int bl;

	for (strp = utf_str; strp < &utf_str[str_length];) {
	  FrameMgrGetToken(fm, first_byte);
	  byte_length--;
	  FrameMgrGetToken(fm, second_byte);
	  byte_length--;
	  if (need_swap) {
	    *strp++ = second_byte;
	    *strp++ = first_byte;
	  } else {
	    *strp++ = first_byte;
	    *strp++ = second_byte;
	  }
	}
	/* decrease padding */
	byte_length -= ((str_length + 2) % 4);

	*strp = (char)0;

	if (number == string_list_num) {
	  string_list_num += IIIMPClient::MAX_ATTRNUM;
	  IMText *temp = string_list;
	  string_list = new IMText[string_list_num];
	  memmove(string_list, temp, sizeof(IMText) * number);
	  delete [] temp;
	}
	const int one_unit = sizeof(UTFCHAR)/sizeof(char);
	string_list[number].encoding = UTF16_CODESET;
	string_list[number].char_length = str_length/one_unit;
	string_list[number++].text.utf_chars = (UTFCHAR*)utf_str;
      }
    }
#endif /* USE_FRAMEMGR_ALWAYS */
  }
  aux_draw.count_string_values = number;
  aux_draw.string_values = string_list;

#if !defined(USE_FRAMEMGR_ALWAYS)
#else /* USE_FRAMEMGR_ALWAYS */
  /* free FrameMgr */
  FrameMgrFree(fm);
#endif /* USE_FRAMEMGR_ALWAYS */

  InputContext *ic = &(input_context_list.getItem(input_context_id));
  if (ic) {
    IMAuxEvent aux_event;
    aux_event.type = IM_EventAux;
    aux_event.aux = &aux_draw;
    iiim_protocol->proto_handler->ForwardEvent((InputContext*)ic,
					       (IMInputEvent*)&aux_event);
  } else { 
    // need to treate as an error
  }

  /* return AUX_SET_VALUES_REPLY */

#if !defined(USE_FRAMEMGR_ALWAYS)
  const int total_size = (4 + 2 + 2 + 4 + 2 + im_name_len);
  char *reply = new char[total_size];
  memcpy(reply + 4, p, total_size - 4);

  send_message(IM_AUX_SETVALUES_REPLY, reply, total_size);

  delete [] reply;

#else /* USE_FRAMEMGR_ALWAYS */
  /* create FrameMgr */
  fm = FrameMgrInit(im_aux_setvalues_reply_fr, NULL, need_swap);

  /* set iteration count of engine name */
  byte_length = strlen(enginename);
  FrameMgrSetIterCount(fm, byte_length);

  const int total_size = FrameMgrGetTotalSize(fm);
  CompoundString reply = CompoundString(total_size);
  memset(reply, 0, total_size);
  FrameMgrSetBuffer(fm, reply);

  FrameMgrPutToken(fm, input_method_id);
  FrameMgrPutToken(fm, input_context_id);
  FrameMgrPutToken(fm, class_index);

  for (char *enginenamep = enginename;
       enginenamep < &enginename[byte_length];enginenamep++) {
    CARD16 str = (CARD16)*enginenamep;
    CARD8 byte_data;
    byte_data = (str << 8) & 0xff00;
    FrameMgrPutToken(fm, byte_data);
    byte_data = str & 0x00ff;
    FrameMgrPutToken(fm, byte_data);
  }
  send_message(IM_AUX_SETVALUES_REPLY, reply, total_size);
#endif /* USE_FRAMEMGR_ALWAYS */

#if !defined(USE_FRAMEMGR_ALWAYS)
#else /* USE_FRAMEMGR_ALWAYS */
  /* free FrameMgr */
  FrameMgrFree(fm);
#endif /* USE_FRAMEMGR_ALWAYS */

  delete [] integer_list;

  for (IMText *textp = aux_draw.string_values;
       textp < &aux_draw.string_values[aux_draw.count_string_values];
       textp++) {
    if (textp->text.utf_chars) delete [] textp->text.utf_chars;
  }
  delete [] string_list;

  return;
}
