/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include <X11/Xtrans.h>
#include "iiimpIM.h"
#include "iiimpTr.h"

/* Defined in libX11 for XIM */
extern XtransConnInfo _XimXTransOpenCOTSClient(
    char *		/* address */
);
extern int _XimXTransConnect(
    XtransConnInfo,	/* ciptr */
    char *		/* address */
);
extern int  _XimXTransDisconnect(
    XtransConnInfo	/* ciptr */
);
extern int _XimXTransClose(
    XtransConnInfo	/* ciptr */
);
extern int _XimXTransWrite(
    XtransConnInfo,	/* ciptr */
    char *,		/* buf */
    int			/* size */
);
extern int _XimXTransRead(
    XtransConnInfo,	/* ciptr */
    char *,		/* buf */
    int			/* size */
);

#ifdef	linux
/* 4354367: Linix Htt: htt_xbe can not start on standalone system */
/* try local */
#define	IIIMP_DEFAULT_UNIXADDRESS  "local/:/tmp/.iiim-unix/9010"
#endif

Bool
TransConnect(XimCommon im, int retly_count) {
  int connect_stat, retry;
  char *address = im->core.im_name;
  char *paddr;
  TransSpecRec *spec;

  if (!XIM_IIIMP(im, spec)) {
    if (!(paddr = (char *)Xmalloc(strlen(address) + 1)))
      return False;

    if (!(spec = (TransSpecRec *)Xmalloc(sizeof(TransSpecRec)))) {
      Xfree(paddr);
      return False;
    }
    bzero(spec, sizeof(TransSpecRec));

    (void)strcpy(paddr, address);
    spec->address = paddr;

    XIM_IIIMP(im, spec) = spec;
  } else {
    spec = XIM_IIIMP(im, spec);
  }

  for (retry = retly_count; retry >= 0; retry--) {
    if ((spec->trans_conn = (struct _XtransConnInfo*)
	 _XimXTransOpenCOTSClient(spec->address)) == NULL) {
      break;
    }
    if ((connect_stat =
	 _XimXTransConnect(spec->trans_conn, spec->address)) < 0) {
      /* Try the default address */
      if ((spec->trans_conn = (struct _XtransConnInfo*)
	_XimXTransOpenCOTSClient((char*)IIIMP_DEFAULT_ADDRESS)) == NULL) {
        break;
      }
      if ((connect_stat =
	   _XimXTransConnect(spec->trans_conn,
			     (char*)IIIMP_DEFAULT_ADDRESS)) < 0) {
#ifdef	linux
      /* 4354367: Linix Htt: htt_xbe can not start on standalone system */
      /* Try the default UNIX */
        if ((spec->trans_conn = (struct _XtransConnInfo*)
	  _XimXTransOpenCOTSClient((char*)IIIMP_DEFAULT_UNIXADDRESS)) == NULL) {
          break;
        }
        if ((connect_stat =
	     _XimXTransConnect(spec->trans_conn,
			       (char*)IIIMP_DEFAULT_UNIXADDRESS)) < 0) {
#endif
	  _XimXTransClose(spec->trans_conn);
	  spec->trans_conn = NULL;
	  if (connect_stat == TRANS_TRY_CONNECT_AGAIN) {
	    /*  	sleep(1); */
	    continue;
	  }
	  else
	    break;
#ifdef	linux
        }
#endif
      }
    }
    else
      break;
  }

  if (spec->trans_conn == NULL)
    return False;

  return True;
}

Bool
TransDisconnect(XimCommon im) {
  TransSpecRec *spec = (TransSpecRec *)XIM_IIIMP(im, spec);

  if (spec->trans_conn == NULL) return False;

  _XimXTransDisconnect(spec->trans_conn);
  (void)_XimXTransClose(spec->trans_conn);
  Xfree(spec->address);
  Xfree(spec);
  return True;
}

Bool
TransWrite(XimCommon im, int len, XPointer data) {
  TransSpecRec	*spec	= (TransSpecRec *)XIM_IIIMP(im, spec);
  char *buf = (char *)data;
  int nbyte;
  INT16 i16;

  if (spec->trans_conn == NULL) return False;

  while (len > 0) {
    i16 = ((0x00007fff < len) ? 0x7ff0 : len);
    if ((nbyte = _XimXTransWrite(spec->trans_conn, buf, i16)) <= 0)
      return False;
    len -= nbyte;
    buf += nbyte;
  }
  return True;
}

Bool
TransRead(XimCommon im, XPointer recv_buf, int buf_len, int *ret_len) {
  TransSpecRec	*spec = (TransSpecRec *)XIM_IIIMP(im, spec);
  int len;

  if (spec->trans_conn == NULL) return False;

  if ((len = _XimXTransRead(spec->trans_conn, recv_buf, buf_len)) <= 0)
    return False;
  *ret_len = len;
  return True;
}
