/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include "iiimpReq.h"
#include <X11/Xtrans.h>
#include "iiimpIM.h"
#include "guiIM.h"
#include "XimpIm.h"
#include "iiimp.h"
#include "iiimpData.h"
#include "iiimpAuth.h"
#include "iiimpAux.h"
#include "iiimpUtil.h"
#include "iiimpColor.h"
#include "iiimpTr.h"
#include "KeyMap.h"
#include <stdio.h>
#include <locale.h>
#include <string.h>
#include <sys/utsname.h>
#include <pwd.h>
#include <wchar.h>
#include "trace_message.h"

typedef struct _IIimpProtoHdr {
  CARD8	opcode;
  CARD8	length[3];
} IIimpProtoHdr;

extern int  _XimXTransDisconnect(
    XtransConnInfo	/* ciptr */
);

static int	IIIMP_Register_IIIMP_CB(XimCommon im);
static int	IIIMP_Unregister_IIIMP_CB(XimCommon im);
static void	IIIMP_CB(Display *dpy, int fd, XPointer call_data);
static void	convertToInputLanguage(char *src);

static unsigned char*
ReadMessage(XimCommon im) {
  char *ptr;
  IIimpProtoHdr hdr_buf;
  int total_size;
  unsigned char *p = NULL;
  unsigned char *pp;
  int read_length;
  IIimpProtoHdr *hdr;
  CARD8 opcode;
  CARD8 length[3];
  int data_length = 0;

  hdr = &hdr_buf;

  if (!TransRead(im, (char *)hdr, sizeof(IIimpProtoHdr), &read_length) ||
      read_length != sizeof(IIimpProtoHdr)) {
    goto read_error;
  } else {
    ptr = (char *)hdr;
    total_size = 4;
    req_get8(ptr, opcode);
    req_get8(ptr, length[2]);
    req_get8(ptr, length[1]);
    req_get8(ptr, length[0]);

    /* calculate length */
    data_length  = (length[2] << 16);
    data_length += (length[1] << 8);
    data_length += length[0];

    if ((p = (unsigned char *)Xmalloc(total_size + (data_length + 1) * 4))
	== NULL) {
      goto read_error;
    }
    pp = p;
    req_put8(pp, opcode);
    req_put8(pp, length[2]);
    req_put8(pp, length[1]);
    req_put8(pp, length[0]);

    if (data_length > 0) {
      int total_read_length = 0;
      while (True) {
	if (!TransRead(im, (char *)pp,
		       data_length * 4, &read_length)) {
	  Xfree(p);
	  goto read_error;
	}
	total_read_length += read_length;
	pp += read_length;
	data_length -= (read_length / 4);
	if (data_length == 0 || total_read_length == data_length * 4)
	  break;
      }
    }
  }
  return (unsigned char *)p;
 read_error:
  IIIMP_Unregister_IIIMP_CB(im);
  _XimXTransDisconnect(XIM_IIIMP(im, spec->trans_conn));
  XIM_IIIMP(im, spec->trans_conn) = NULL;
  return (unsigned char *)NULL;
}

static Bool
SendMessage(XimCommon im, int major_opcode,
	    unsigned char *message, int message_size,
	    Bool (*predicate)(XimCommon, unsigned char*, XicCommon,
			      XPointer),
	    XicCommon ic, XPointer ret) {
  char * ptr;
  int total_size;
  long p_len = message_size/4;
  CARD8 length[3];

  /* calculate length */
  length[2] = ((p_len >> 16) & 0xff);
  length[1] = ((p_len >> 8) & 0xff);
  length[0] = (p_len & 0xff);

  ptr = (char *)message;
  req_put8(ptr, major_opcode);
  req_put8(ptr, length[2]);
  req_put8(ptr, length[1]);
  req_put8(ptr, length[0]);
  total_size = ((sizeof (IIimpProtoHdr)) + message_size);

  if (!TransWrite(im, total_size, (XPointer)message)) {
    return False;
  }

  if (predicate) {
    unsigned char *reply;
    int iiimp_cb_registered;
    iiimp_cb_registered = IIIMP_Unregister_IIIMP_CB(im);
    while (True) {
      reply = ReadMessage(im);
      if (reply == NULL) {
	if (1 == iiimp_cb_registered) {
	  IIIMP_Register_IIIMP_CB(im);
	}
	return False;
      }
      if (predicate(im, reply, ic, ret)) {
	Xfree(reply);
	break;
      }
      Xfree(reply);
    }
    if (1 == iiimp_cb_registered) {
      IIIMP_Register_IIIMP_CB(im);
    }
  }
  return True;
}

/* IIIMP Message handlers */

/* forward declaration  */
static Bool IMPreeditStartCB(XicCommon, unsigned char*);
static Bool IMPreeditDrawCB(XicCommon, unsigned char*);
static Bool IMPreeditCaretCB(XicCommon, unsigned char*);
static Bool IMPreeditDoneCB(XicCommon, unsigned char*);
static Bool IMStatusStartCB(XicCommon, unsigned char*);
static Bool IMStatusDrawCB(XicCommon, unsigned char*);
static Bool IMStatusDoneCB(XicCommon, unsigned char*);
static Bool IMLookupStartCB(XicCommon, unsigned char*);
static Bool IMLookupDrawCB(XicCommon, unsigned char*);
static Bool IMLookupProcessCB(XicCommon, unsigned char*);
static Bool IMLookupDoneCB(XicCommon, unsigned char*);
static Bool IMForwardEventCB(XicCommon, unsigned char*);
static Bool IMCommitStringCB(XicCommon, unsigned char*);
static Bool IMTriggerNotifyCB(XicCommon, unsigned char*);
static Bool IMSetIMValuesCB(XicCommon, unsigned char*);
static Bool IMGetIMValuesCB(XicCommon, unsigned char*);
static Bool IMAuxStartCB(XicCommon, unsigned char*);
static Bool IMAuxDrawCB(XicCommon, unsigned char*);
static Bool IMAuxDoneCB(XicCommon, unsigned char*);
static Bool IMAuxSetValuesReplyCB(XicCommon, unsigned char*);

typedef Bool (*IIIMPCb)(
			XicCommon, unsigned char*
			);

static const IIIMPCb callback_table[] = {
  NULL, NULL, NULL, NULL, NULL, NULL, /* #000-005 */
  IMTriggerNotifyCB,		/* #006 */
  NULL,				/* #007 */
  IMSetIMValuesCB,		/* #008 */
  NULL,				/* #009 */
  IMGetIMValuesCB,		/* #010 */
  NULL,				/* #011 */
  IMForwardEventCB,		/* #012 */
  NULL,				/* #013 */
  IMCommitStringCB,		/* #014 */
  NULL, NULL, NULL, NULL, NULL, /* #015-019 */
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, /* #020-029 */
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, /* #030-039 */
  IMPreeditStartCB,		/* #040 */
  NULL,				/* #041 */
  IMPreeditDrawCB,		/* #042 */
  NULL,				/* #043 */
  IMPreeditCaretCB,		/* #044 */
  NULL,				/* #045 */
  IMPreeditDoneCB,		/* #046 */
  NULL, NULL, NULL,		/* #047-#049 */
  IMStatusStartCB,		/* #050 */
  NULL,				/* #051 */
  IMStatusDrawCB,		/* #052 */
  NULL,				/* #053 */
  IMStatusDoneCB,		/* #054 */
  NULL, NULL, NULL, NULL, NULL,	/* #055-#059 */
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, /* #060-069 */
  IMLookupStartCB,		/* #070 */
  NULL,				/* #071 */
  IMLookupDrawCB,		/* #072 */
  NULL,				/* #073 */
  IMLookupDoneCB,		/* #074 */
  NULL,				/* #075 */
  IMLookupProcessCB,		/* #076 */
  NULL,	NULL, NULL,		/* #077-#079 */
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, /* #080-089 */
  IMAuxStartCB,			/* #090 */
  NULL,				/* #091 */
  IMAuxDrawCB,			/* #092 */
  NULL,				/* #093 */
  IMAuxDoneCB,			/* #094 */
  NULL,				/* #095 */
  NULL,				/* #096 */
  IMAuxSetValuesReplyCB,	/* #097 */
  NULL,				/* #098 */
  NULL,				/* #099 */
  NULL,				/* #100 */
};

static void
DispatchMessage(XimCommon im, unsigned char *p,
		XicCommon ic, XPointer ret
		) {
  IIimpProtoHdr *hdr = (IIimpProtoHdr*)p;
  unsigned char *p1 = (unsigned char *)(hdr + 1);
  CARD16 ic_id;
  int	iiimp_cb_registered;

  if (hdr == (IIimpProtoHdr*)NULL) return;

  ic_id = *((CARD16 *)(p1 + 2));
  if ((NULL != ic) && (NULL != ic->iiimp_icpart) &&
      (ic_id != XIC_IIIMP(ic, icid))) {
    for (ic = (XicCommon)(im->core.ic_chain); NULL != ic;
	 ic = (XicCommon)(ic->core.next)) {
      if (ic_id == XIC_IIIMP(ic, icid)) {
	break;
      }
    }
    if (NULL == ic) {
      return;
    }
  }

  iiimp_cb_registered = IIIMP_Unregister_IIIMP_CB(im);

  if (!callback_table[hdr->opcode]) return;
  (void) (*callback_table[hdr->opcode])(ic, p1);

  if (1 == iiimp_cb_registered) {
    IIIMP_Register_IIIMP_CB(im);
  }
  return;
}

static Bool
IMPreeditStartCB(XicCommon ic, unsigned char *p) {
  XimCommon im;
  char *ptr;
  unsigned char data[(sizeof (IIimpProtoHdr)) + 2 + 2 + 4];
  int total_size;
  int input_method_id;
  int input_context_id;
  int max_len;

  if (NULL == ic) {
    return False;
  }
  im = (XimCommon)ic->core.im;

  ptr = (char *)p;
  req_get16(ptr, input_method_id);
  req_get16(ptr, input_context_id);

  max_len = CallPreeditStartCallback(ic, NULL);

  /* Send reply on IIIMP */
  total_size = (2 + 2 + 4);
  ptr = (char *)(data + (sizeof (IIimpProtoHdr)));
  req_put16(ptr, input_method_id);
  req_put16(ptr, input_context_id);
  req_put32(ptr, max_len);
  if (!SendMessage(im, IM_PREEDIT_START_REPLY, data, total_size,
		   NULL, NULL, NULL)) {
    goto Error;
  }
 Error:
  return True;
}

static Bool
IMPreeditDrawCB(XicCommon ic, unsigned char *p) {
  char *ptr;
  unsigned char data[(sizeof (IIimpProtoHdr)) + 2 + 2];
  int total_size;
  int input_method_id;
  int input_context_id;
  XIMPreeditDrawCallbackStruct call_data;
  int caret, change_first, change_length;
  XIMText cbtext;
  int contents_type;
  IMFeedbackList *feedback_list = 0;

  XimCommon im;
  XIMCallback *cb = &ic->core.preedit_attr.draw_callback;
  Bool useUnicode;

  if (NULL == ic) {
    return False;
  }
  im = (XimCommon)ic->core.im;

  memset(&call_data, 0, sizeof(XIMPreeditDrawCallbackStruct));
  memset(&cbtext, 0, sizeof(XIMText));

  ptr = (char *)p;
  req_get16(ptr, input_method_id);
  req_get16(ptr, input_context_id);
  req_get32(ptr, caret);
  req_get32(ptr, change_first);
  req_get32(ptr, change_length);
  req_get32(ptr, contents_type);

  p += 2 + 2 + 4 + 4 + 4 + 4;	/* 2(imid) + 2(icid) + 4(caret) + 
				   4(change_first) + 4(change_length) + 
				   4(type) */

  useUnicode = (XIM_USE_UNICODE(im) && cb->callback &&
		(ic->core.input_style & XIMPreeditCallbacks));

  if (contents_type == 0) {
    /* STRING type */
    (void)IMStringToXIMText(p, &cbtext, useUnicode);
  } else if (contents_type == 1) {
    /* TEXT type */
    (void)IMTextToXIMText(p, &cbtext, &feedback_list, useUnicode);
  }

  call_data.caret = caret;
  call_data.chg_first = change_first;
  call_data.chg_length = change_length;

  if ((cbtext.string.multi_byte == NULL) && cbtext.feedback == NULL) {
    /* text deletion */
    call_data.text = (XIMText*)NULL;
  } else {
    call_data.text = &cbtext;
  }
  CallPreeditDrawCallback(ic, &call_data, feedback_list);

  FreeFeedbackList(feedback_list, cbtext.length);
  if (cbtext.string.multi_byte) Xfree(cbtext.string.multi_byte);
  if (cbtext.feedback) Xfree(cbtext.feedback);

  /* Send reply on IIIMP */
  ptr = (char *)(data + (sizeof (IIimpProtoHdr)));
  req_put16(ptr, input_method_id);
  req_put16(ptr, input_context_id);
  total_size = (2 + 2);

  if (!SendMessage(im, IM_PREEDIT_DRAW_REPLY, data, total_size,
		   NULL, NULL, NULL)) {
    goto Error;
  }
 Error:
  return True;
}

static Bool
IMPreeditCaretCB(XicCommon ic, unsigned char *p) {
  XimCommon im;
  char *ptr;
  unsigned char data[(sizeof (IIimpProtoHdr)) + 2 + 2 + 4];
  int total_size;
  int input_method_id;
  int input_context_id;
  XIMPreeditCaretCallbackStruct call_data;
  int position, direction, style;

  if (NULL == ic) {
    return False;
  }
  im = (XimCommon)ic->core.im;

  ptr = (char *)p;
  req_get16(ptr, input_method_id);
  req_get16(ptr, input_context_id);
  req_get32(ptr, position);
  req_get32(ptr, direction);
  req_get32(ptr, style);

  call_data.position = position;
  call_data.direction = direction;
  call_data.style = style;

  CallPreeditCaretCallback(ic, (XPointer)&call_data);

  /* Send reply on IIIMP */
  ptr = (char *)(data + (sizeof (IIimpProtoHdr)));
  req_put16(ptr, input_method_id);
  req_put16(ptr, input_context_id);
  req_put32(ptr, position);
  total_size = (2 + 2 + 4);

  if (!SendMessage(im, IM_PREEDIT_CARET_REPLY, data, total_size,
		   NULL, NULL, NULL)) {
    goto Error;
  }
 Error:
  return True;
}

static Bool
IMPreeditDoneCB(XicCommon ic, unsigned char *p) {
  XimCommon im;
  char *ptr;
  unsigned char data[(sizeof (IIimpProtoHdr)) + 2 + 2];
  int total_size;
  int input_method_id;
  int input_context_id;

  if (NULL == ic) {
    return False;
  }
  im = (XimCommon)ic->core.im;

  ptr = (char *)p;
  req_get16(ptr, input_method_id);
  req_get16(ptr, input_context_id);

  CallPreeditDoneCallback(ic, NULL);

  /* Send reply on IIIMP */
  ptr = (char *)(data + (sizeof (IIimpProtoHdr)));
  req_put16(ptr, input_method_id);
  req_put16(ptr, input_context_id);
  total_size = (2 + 2);

  if (!SendMessage(im, IM_PREEDIT_DONE_REPLY, data, total_size,
		   NULL, NULL, NULL)) {
    goto Error;
  }
 Error:
  return True;
}

static Bool
IMStatusStartCB(XicCommon ic, unsigned char *p) {
  XimCommon im;
  char *ptr;
  unsigned char data[(sizeof (IIimpProtoHdr)) + 2 + 2];
  int total_size;
  int input_method_id;
  int input_context_id;

  if (NULL == ic) {
    return False;
  }
  im = (XimCommon)ic->core.im;

  ptr = (char *)p;
  req_get16(ptr, input_method_id);
  req_get16(ptr, input_context_id);

  CallStatusStartCallback(ic, NULL);

  /* Send reply on IIIMP */
  ptr = (char *)(data + (sizeof (IIimpProtoHdr)));
  req_put16(ptr, input_method_id);
  req_put16(ptr, input_context_id);
  total_size = (2 + 2);

  if (!SendMessage(im, IM_STATUS_START_REPLY, data, total_size,
		   NULL, NULL, NULL)) {
    goto Error;
  }
 Error:
  return True;
}

static Bool
IMStatusDrawCB(XicCommon ic, unsigned char *p) {
  char *ptr;
  unsigned char data[(sizeof (IIimpProtoHdr)) + 2 + 2];
  int total_size;
  int input_method_id;
  int input_context_id;
  XIMStatusDrawCallbackStruct call_data;
  XIMText cbtext;
  int contents_type;
  IMFeedbackList *feedback_list = 0;

  XimCommon im;
  XIMCallback *cb = &ic->core.status_attr.draw_callback;
  Bool useUnicode;

  if (NULL == ic) {
    return False;
  }
  im = (XimCommon)ic->core.im;

  memset(&call_data, 0, sizeof(XIMStatusDrawCallbackStruct));
  memset(&cbtext, 0, sizeof(XIMText));

  ptr = (char *)p;
  req_get16(ptr, input_method_id);
  req_get16(ptr, input_context_id);
  req_get32(ptr, contents_type);

  p += 2 + 2 + 4;	/* 2(imid) + 2(icid) + 4(type) */

  useUnicode = (XIM_USE_UNICODE(im) && cb->callback &&
		(ic->core.input_style & XIMStatusCallbacks));

  if (contents_type == 0) {
    /* STRING type */
    (void)IMStringToXIMText(p, &cbtext, useUnicode);
  } else if (contents_type == 1) {
    /* TEXT type */
    (void)IMTextToXIMText(p, &cbtext, &feedback_list, useUnicode);
  }

  call_data.data.text = &cbtext;
  call_data.type = XIMTextType;

  CallStatusDrawCallback(ic, &call_data, feedback_list);

  FreeFeedbackList(feedback_list, cbtext.length);
  if (cbtext.string.multi_byte) Xfree(cbtext.string.multi_byte);
  if (cbtext.feedback) Xfree(cbtext.feedback);

  /* Send reply on IIIMP */
  ptr = (char *)(data + (sizeof (IIimpProtoHdr)));
  req_put16(ptr, input_method_id);
  req_put16(ptr, input_context_id);
  total_size = (2 + 2);

  if (!SendMessage(im, IM_STATUS_DRAW_REPLY, data, total_size,
		   NULL, NULL, NULL)) {
    goto Error;
  }
 Error:
  return True;
}

static Bool
IMStatusDoneCB(XicCommon ic, unsigned char *p) {
  XimCommon im;
  char *ptr;
  unsigned char data[(sizeof (IIimpProtoHdr)) + 2 + 2];
  int total_size;
  int input_method_id;
  int input_context_id;

  if (NULL == ic) {
    return False;
  }
  im = (XimCommon)ic->core.im;

  ptr = (char *)p;
  req_get16(ptr, input_method_id);
  req_get16(ptr, input_context_id);

  CallStatusDoneCallback(ic, NULL);

  /* Send reply on IIIMP */
  ptr = (char *)(data + (sizeof (IIimpProtoHdr)));
  req_put16(ptr, input_method_id);
  req_put16(ptr, input_context_id);
  total_size = (2 + 2);

  if (!SendMessage(im, IM_STATUS_DONE_REPLY, data, total_size,
		   NULL, NULL, NULL)) {
    goto Error;
  }
 Error:
  return True;
}

static Bool
IMLookupStartCB(XicCommon ic, unsigned char *p) {
  XimCommon im;
  char *ptr;
  unsigned char data[(sizeof (IIimpProtoHdr)) + 2 + 2];
  int total_size;
  int input_method_id;
  int input_context_id;
  XIMLookupStartCallbackStruct2 call_data;

  if (NULL == ic) {
    return False;
  }
  im = (XimCommon)ic->core.im;

  ptr = (char *)p;
  req_get16(ptr, input_method_id);
  req_get16(ptr, input_context_id);
  req_get16(ptr, call_data.which_is_master);
  req_get16(ptr, call_data.choice_per_window);
  req_get16(ptr, call_data.nrows);
  req_get16(ptr, call_data.ncolumns);
  req_get16(ptr, call_data.draw_up_direction);
  req_get16(ptr, call_data.who_owns_label);

  if (ic->lookup_start_callback.callback) {
    XIMCallback *cb = &ic->lookup_start_callback;
    (*cb->callback)((XIC)ic, cb->client_data, (XPointer)&call_data);
  } else {
    XIC_GUI(ic, change_lookup)((XIC)ic, LOOKUP_START,
			       (XPointer)&call_data);
  }

  /* Send reply on IIIMP */
  ptr = (char *)(data + (sizeof (IIimpProtoHdr)));
  req_put16(ptr, input_method_id);
  req_put16(ptr, input_context_id);
  total_size = (2 + 2);

  if (!SendMessage(im, IM_LOOKUP_CHOICE_START_REPLY, data, total_size,
		   NULL, NULL, NULL)) {
    goto Error;
  }
 Error:
  return True;
}

static Bool
IMLookupDrawCB(XicCommon ic, unsigned char *p) {
  char *ptr;
  unsigned char data[(sizeof (IIimpProtoHdr)) + 2 + 2];
  int total_size;
  int input_method_id;
  int input_context_id;
  XIMLookupDrawCallbackStruct2 call_data;
  int read_len;
  XIMText *choice_list = (XIMText*)NULL, *label_list = (XIMText*)NULL;
  XIMText title_text;
  IMFeedbackList **choice_feedback = (IMFeedbackList**)NULL;
  IMFeedbackList **label_feedback = (IMFeedbackList**)NULL;
  int n_choices, n_labels;
  int i;

  XimCommon im;
  Bool useUnicode;

  if (NULL == ic) {
    return False;
  }
  im = (XimCommon)ic->core.im;

  ptr = (char *)p;
  req_get16(ptr, input_method_id);
  req_get16(ptr, input_context_id);
  req_get32(ptr, call_data.first_index);
  req_get32(ptr, call_data.last_index);
  req_get32(ptr, call_data.current_index);
  call_data.choices = NULL;
  call_data.n_choices = 0;
  call_data.title = NULL;

  p += 2 + 2 + 4 + 4 + 4;	/* 2(imid) + 2(icid) + 4(first_index) + 
				   4(last_index) + 4(current_index) */

  useUnicode = (XIM_USE_UNICODE(im) &&
		ic->lookup_draw_callback.callback);

  n_choices = 0;
  read_len = IMTextListToXIMTextList(p, &choice_list, &choice_feedback,
				     &n_choices,
				     useUnicode);
  p += read_len;

  n_labels = 0;
  read_len = IMTextListToXIMTextList(p, &label_list, &label_feedback,
				     &n_labels,
				     useUnicode);
  p += read_len;

  memset(&title_text, 0, sizeof(XIMText));
  read_len = IMTextToXIMText(p, &title_text, 0, useUnicode);

  if (n_choices > 0) {
    call_data.n_choices = n_choices;
    call_data.choices = (XIMChoiceObject2*)Xmalloc(sizeof(XIMChoiceObject2)
						   * n_choices);
    if (!call_data.choices) goto Error;
    call_data.choices->label_decoration = NO_DECORATION;
    call_data.choices->value = choice_list;
    call_data.choices->label = label_list;
    call_data.choices->value_feedback = choice_feedback;
    call_data.choices->label_feedback = label_feedback;
    call_data.title = &title_text;

    if (ic->lookup_draw_callback.callback) {
      XIMCallback *cb = &ic->lookup_draw_callback;
      (*cb->callback)((XIC)ic, cb->client_data, (XPointer)&call_data);
    } else {
      XIC_GUI(ic, change_lookup)((XIC)ic, LOOKUP_DRAW,
				 (XPointer)&call_data);
    }

    for (i = 0; i < n_choices; i++) {
      if (choice_feedback) {
	FreeFeedbackList(choice_feedback[i], choice_list[i].length);
      }
      if (choice_list[i].string.multi_byte) {
	Xfree(choice_list[i].string.multi_byte);
      }
      if (choice_list[i].feedback) {
	Xfree(choice_list[i].feedback);
      }
    }
    for (i = 0; i < n_labels; i++) {
      if (label_feedback) {
	FreeFeedbackList(label_feedback[i], label_list[i].length);
      }
      if (label_list[i].string.multi_byte) {
	Xfree(label_list[i].string.multi_byte);
      }
      if (label_list[i].feedback) {
	Xfree(label_list[i].feedback);
      }
    }
    if (choice_list) Xfree(choice_list);
    if (label_list) Xfree(label_list);
    if (choice_feedback) Xfree(choice_feedback);
    if (label_feedback) Xfree(label_feedback);
    Xfree(call_data.choices);

    if (call_data.title->string.multi_byte) {
      Xfree(call_data.title->string.multi_byte);
    }
    if (call_data.title->feedback) {
      Xfree(call_data.title->feedback);
    }
  }

  /* Send reply on IIIMP */
  ptr = (char *)(data + (sizeof (IIimpProtoHdr)));
  req_put16(ptr, input_method_id);
  req_put16(ptr, input_context_id);
  total_size = (2 + 2);

  if (!SendMessage(im, IM_LOOKUP_CHOICE_DRAW_REPLY, data, total_size,
		   NULL, NULL, NULL)) {
    goto Error;
  }
 Error:
  return True;
}

static Bool
IMLookupProcessCB(XicCommon ic, unsigned char *p) {
  XimCommon im;
  char *ptr;
  unsigned char data[(sizeof (IIimpProtoHdr)) + 2 + 2];
  int total_size;
  int input_method_id;
  int input_context_id;
  XIMLookupProcessCallbackStruct2 call_data;

  if (NULL == ic) {
    return False;
  }
  im = (XimCommon)ic->core.im;

  ptr = (char *)p;
  req_get16(ptr, input_method_id);
  req_get16(ptr, input_context_id);
  req_get16(ptr, call_data.type);
  req_get16(ptr, call_data.data.index_of_choice_selected);

  XIC_GUI(ic, change_lookup)((XIC)ic, LOOKUP_PROCESS,
			     (XPointer)&call_data);

  /* Send reply on IIIMP */
  ptr = (char *)(data + (sizeof (IIimpProtoHdr)));
  req_put16(ptr, input_method_id);
  req_put16(ptr, input_context_id);
  total_size = (2 + 2);

  if (!SendMessage(im, IM_LOOKUP_CHOICE_PROCESS_REPLY, data, total_size,
		   NULL, NULL, NULL)) {
    goto Error;
  }
 Error:
  return True;
}

static Bool
IMLookupDoneCB(XicCommon ic, unsigned char *p) {
  XimCommon im;
  char *ptr;
  unsigned char data[(sizeof (IIimpProtoHdr)) + 2 + 2];
  int total_size;
  int input_method_id;
  int input_context_id;

  if (NULL == ic) {
    return False;
  }
  im = (XimCommon)ic->core.im;

  ptr = (char *)p;
  req_get16(ptr, input_method_id);
  req_get16(ptr, input_context_id);

  if (ic->lookup_done_callback.callback) {
    XIMCallback *cb = &ic->lookup_done_callback;
    (*cb->callback)((XIC)ic, cb->client_data, (XPointer)NULL);
  } else {
    XIC_GUI(ic, change_lookup)((XIC)ic, LOOKUP_DONE, (XPointer)NULL);
  }

  /* Send reply on IIIMP */
  ptr = (char *)(data + (sizeof (IIimpProtoHdr)));
  req_put16(ptr, input_method_id);
  req_put16(ptr, input_context_id);
  total_size = (2 + 2);

  if (!SendMessage(im, IM_LOOKUP_CHOICE_DONE_REPLY, data, total_size,
		   NULL, NULL, NULL)) {
    goto Error;
  }
 Error:
  return True;
}

static Bool
IMForwardEventForwardEventCB(XicCommon ic, unsigned char *p) {
  XimCommon im;
  unsigned char data[(sizeof (IIimpProtoHdr)) + 2 + 2];
  char *ptr;
  int total_size;
  int input_method_id;
  int input_context_id;

  if (NULL == ic) {
    return False;
  }
  im = (XimCommon)ic->core.im;

  ptr = (char *)p;
  ptr += (sizeof (IIimpProtoHdr));
  req_get16(ptr, input_method_id);
  req_get16(ptr, input_context_id);

  ptr = (char *)(data + (sizeof (IIimpProtoHdr)));
  req_put16(ptr, input_method_id);
  req_put16(ptr, input_context_id);
  total_size = (2 + 2);

  SendMessage(im, IM_FORWARD_EVENT_REPLY, data, total_size, NULL, NULL, NULL);

  return False;
}

static Bool
IMForwardEventCB(XicCommon ic, unsigned char *p) {
  XimCommon im;
  char *ptr;
  int input_method_id;
  int input_context_id;
  int contents_type;

  if (NULL == ic) {
    return False;
  }
  im = (XimCommon)ic->core.im;

  ptr = (char *)p;
  req_get16(ptr, input_method_id);
  req_get16(ptr, input_context_id);
  req_get32(ptr, contents_type);

  p += 2 + 2 + 4;		/* 2(imid) + 2(icid) + 4(type) */
  if (contents_type == 0) {
    XIMText cbtext;
    /* STRING type */
    (void)IMStringToXIMText(p, &cbtext, False);
  } else if (contents_type == 1) {
    XIMText cbtext;
    /* TEXT type */
    (void)IMTextToXIMText(p, &cbtext, 0, False);
  } else if (contents_type == 2) {
    /* KEYEVENT type */
    CARD32 byte_length;

    ptr = (char *)p;
    req_get32(ptr, byte_length);
    if (byte_length > 65000) {
      /* something wrong */
      return False;
    } else {
      int keycode, keychar, state, time_stamp;
      XEvent ev;

      ev.type = (int)KeyPress;
      ev.xkey.serial = 0;
      ev.xkey.send_event = 0;
      ev.xkey.display = im->core.display;
      ev.xkey.window = ic->core.focus_window;
      ev.xkey.root = None;
      ev.xkey.subwindow = None;
      ev.xkey.x = 0;
      ev.xkey.y = 0;
      ev.xkey.x_root = 0;
      ev.xkey.y_root = 0;
      ev.xkey.state = 0;
      ev.xkey.keycode = 0;
      ev.xkey.same_screen = True;

      while ((4 * 4) <= byte_length) {
	req_get32(ptr, keycode);
	req_get32(ptr, keychar);
	req_get32(ptr, state);
	req_get32(ptr, time_stamp);
	byte_length -= 16;

	ev.xkey.time = time_stamp;
	VirtualKeyToXKeyEvent(keycode, keychar, state,
			      (XKeyEvent*)&ev);
	/* private XIC extension */
	if (ic->forward_event_callback.callback) {
	  ic->forward_event_callback.callback((XIC)ic,
	           ic->forward_event_callback.client_data,
		   (XPointer)&ev);
	} else {
	  HoldXKeyEvent(ic, &ev);
#if 0
	  if (ic->ximp_icpart->putback_key_event) {
	    /* A keyevent for XIM_COMPOSE_KEYCODE to commit string
	       is already in event que. */
	    memmove(&XIC_IIIMP(ic, keyevent_return), &ev,
		    sizeof(XKeyEvent));
	    XIC_IIIMP(ic, has_keyevent_return) = True;
	  } else {
	    ic->ximp_icpart->putback_key_event = True;
/*  	    XPutBackEvent(im->core.display, &ev); */
	    HoldXKeyEvent(ic, &ev);
	    XIC_IIIMP(ic, has_keyevent_return) = False;
	  }
#endif /* 0 */
	}
      }
    }
  }
  return True;
}

static Bool
IMCommitStringCB(XicCommon ic, unsigned char *p) {
  char *ptr;
  int input_method_id;
  int input_context_id;
  XIMText cbtext;
  int contents_type;
  XEvent ev;

  XimCommon im;
  Bool useUnicode;

  if (NULL == ic) {
    return False;
  }
  im = (XimCommon)ic->core.im;

  ptr = (char *)p;
  req_get16(ptr, input_method_id);
  req_get16(ptr, input_context_id);
  req_get32(ptr, contents_type);

  p += 2 + 2 + 4;		/* 2(imid) + 2(icid) + 4(type) */

  useUnicode = (XIM_USE_UNICODE(im) &&
		ic->commit_string_callback.callback);

  if (contents_type == 0) {
    /* STRING type */
    (void)IMStringToXIMText(p, &cbtext, useUnicode);
  } else if (contents_type == 1) {
    /* TEXT type */
    (void)IMTextToXIMText(p, &cbtext, 0, useUnicode);
  }

  /* private XIC extension */
  if (ic->commit_string_callback.callback) {
    XIMCallback *cb = &ic->commit_string_callback;
    (*cb->callback)((XIC)ic,
		    cb->client_data,
		    (XPointer)&cbtext);	/* for UNICODE1 */
    /* no need to fake a keyevent to be putback */
    if (cbtext.string.multi_byte) Xfree(cbtext.string.multi_byte);
    if (cbtext.feedback) Xfree(cbtext.feedback);
    return True;
  }

  if (XIC_IIIMP(ic, mb)) Xfree(XIC_IIIMP(ic, mb)); /* free previous one */
  XIC_IIIMP(ic, mb) = strdup(cbtext.string.multi_byte);
  if (!(XIC_IIIMP(ic, mb))) return True;

  /* fake a key press event */
  ev.type = (int)KeyPress;
  ev.xkey.serial = 0;
  ev.xkey.send_event = 0;
  ev.xkey.display = im->core.display;
  ev.xkey.window = ic->core.focus_window;
  ev.xkey.root = None;
  ev.xkey.subwindow = None;
  ev.xkey.x = 0;
  ev.xkey.y = 0;
  ev.xkey.x_root = 0;
  ev.xkey.y_root = 0;
  ev.xkey.keycode = XIM_COMPOSE_KEYCODE;
  ev.xkey.state = 0;
  ev.xkey.same_screen = True;
/*    XPutBackEvent(im->core.display, &ev); */
/*    ic->ximp_icpart->putback_key_event = True; */
  HoldXKeyEvent(ic, &ev);
  if (cbtext.string.multi_byte) Xfree(cbtext.string.multi_byte);
  if (cbtext.feedback) Xfree(cbtext.feedback);
  XIC_IIIMP(ic, keysym_return) = NoSymbol;
  XIC_IIIMP(ic, has_keyevent_return) = False;

  /* no reply for IM_COMMIT_STRING  */
  return True;
}

static Bool
IMTriggerNotifyCB(XicCommon ic, unsigned char *p) {
  char *ptr;
  int input_method_id;
  int input_context_id;
  int conv_mode;

  ptr = (char *)p;
  req_get16(ptr, input_method_id);
  req_get16(ptr, input_context_id);
  req_get16(ptr, conv_mode);

  SetConversionMode(ic, (conv_mode == CONV_ON));

  return True;
}

#define IM_ATTR_NUM 5
static Bool
IMSetIMValuesCB(XicCommon ic, unsigned char *p) {
  char *ptr;
  unsigned char data[(sizeof (IIimpProtoHdr)) + 2 + 2];
  int total_size;
  int input_method_id;
  XimCommon im;
  int byte_length;

  if (NULL == ic) {
    return False;
  }
  im = (XimCommon)ic->core.im;

  ptr = (char *)p;
  req_get16(ptr, input_method_id);
  ptr +=2 ;
  req_get32(ptr, byte_length);

  if (byte_length != 0) {
    while (0 < byte_length) {
      int		attr_id;
      int		value_length;
      void *		value;
      char *		ptr2;
      int		obj_cat;
      int		obj_size;
      int		obj_attr_id;
      int		obj_attr_id_dyn;
      XIMText		domain;
      XIMText		name;
      CARD16 *		name_ptr;
      int		name_len;
      XIMText		signature;
      XIMText		scope;
      unsigned char *	pp;
      int		len;
      IIIMObject	io;

      static int	padding[4] = {0, 3, 2, 1};

      req_get16(ptr, attr_id);
      ptr += 2;
      req_get32(ptr, value_length);
      value = ptr;
      byte_length -= (8 + value_length);

      pp = value;

      while ((pp - ((unsigned char *)value)) < value_length) {
	ptr2 = (char *)pp;
	req_get16(ptr2, obj_cat);
	ptr2 += 2;
	req_get32(ptr2, obj_size);
	req_get16(ptr2, obj_attr_id);
	req_get16(ptr2, obj_attr_id_dyn);

	pp += (2 + 2 /* padding */ + 4 + 2 + 2);

	len = IMStringToXIMText(pp, &domain, False);
	pp += (len + padding[len % 4]);
	len = IMStringToXIMText(pp, &name, False);
	name_ptr = (CARD16 *)(pp + 2);
	name_len = len;
	pp += (len + padding[len % 4]);
	len = IMStringToXIMText(pp, &signature, False);
	pp += (len + padding[len % 4]);
	len = IMStringToXIMText(pp, &scope, False);
	pp += (len + padding[len % 4]);

	for (io = XIM_IIIMP(im, iiim_object); NULL != io; io = io->next) {
	      /* need to check duplication */
	}

	io = (IIIMObjectRec *)Xmalloc(sizeof (IIIMObjectRec));
	if (NULL == io) {
	  break;
	}
	memset(io, 0, sizeof (IIIMObjectRec));

	io->obj_cat = obj_cat;
	io->obj_size = obj_size;
	io->id = obj_attr_id;
	io->id_dyn = obj_attr_id_dyn;
	io->domain = domain.string.multi_byte;
	io->name = (CARD16 *)Xmalloc(name_len);
	if (NULL == io->name) {
	  XFree(io->domain);
	  Xfree(io);
	  break;
	}
	memcpy(io->name, name_ptr, name_len);
	io->name_length = name_len;
	io->signature = signature.string.multi_byte;
	io->scope = scope.string.multi_byte;

	io->next = XIM_IIIMP(im, iiim_object);
	XIM_IIIMP(im, iiim_object) = io;

	Xfree(name.string.multi_byte);
      }
    }
  }

  /* Send reply on IIIMP */
  ptr = (char *)(data + (sizeof (IIimpProtoHdr)));
  req_put16(ptr, input_method_id);
  req_put16(ptr, 0); /* padding */
  total_size = (2 + 2);

  if (!SendMessage(im, IM_SETIMVALUES_REPLY, data, total_size,
		   NULL, NULL, NULL)) {
    goto Error;
  }
 Error:
  return True;
}
#undef IM_ATTR_NUM

static Bool
IMAuxStartCB(XicCommon ic, unsigned char *p) {
  XimCommon im;
  char *ptr;
  unsigned char *data;
  int total_size;
  int input_method_id;
  int input_context_id;
  int engine_class_index;
  int byte_length;

  if (NULL == ic) {
    return False;
  }
  im = (XimCommon)ic->core.im;

  /* AUX_DOWNLOAD should be called when object is downloaded */
/*  AuxChange(ic, AUX_DOWNLOAD, (XPointer)p); */
  AuxChange(ic, AUX_START, (XPointer)p);

  ptr = (char *)p;
  req_get16(ptr, input_method_id);
  req_get16(ptr, input_context_id);
  req_get32(ptr, engine_class_index);
  req_get16(ptr, byte_length);

  total_size = 2 + 2 + 4 + 2 + byte_length;
  switch (byte_length % 4) {
  case 0: total_size += 2; break;
  case 1: total_size += 1; break;
  case 2: total_size += 0; break;
  case 3: total_size += 3; break;
  }
  data = Xmalloc(total_size + (sizeof (IIimpProtoHdr)));
  if (NULL == data) {
    return False;
  }
  memcpy(data + (sizeof (IIimpProtoHdr)), p, total_size);
  SendMessage(im, IM_AUX_START_REPLY, data, total_size, NULL, NULL, NULL);
  Xfree(data);

  return True;
}

static Bool
IMAuxDrawCB(XicCommon ic, unsigned char *p) {
  XimCommon im;
  char *ptr;
  int total_size;
  int input_method_id;
  int input_context_id;
  int class_index;
  int byte_length = 0;
  unsigned char *data;

  if (NULL == ic) {
    return False;
  }
  im = (XimCommon)ic->core.im;

  AuxChange(ic, AUX_DRAW, (XPointer)p);

  ptr = (char *)p;
  req_get16(ptr, input_method_id);
  req_get16(ptr, input_context_id);
  req_get32(ptr, class_index);
  req_get16(ptr, byte_length);

  total_size = 2 + 2 + 4 + 2 + byte_length;
  switch (byte_length % 4) {
  case 0: total_size += 2; break;
  case 1: total_size += 1; break;
  case 2: total_size += 0; break;
  case 3: total_size += 3; break;
  }
  data = Xmalloc(total_size + (sizeof (IIimpProtoHdr)));
  if (NULL == data) {
    return False;
  }
  memcpy(data + (sizeof (IIimpProtoHdr)), p, total_size);
  SendMessage(im, IM_AUX_DRAW_REPLY, data, total_size, NULL, NULL, NULL);
  Xfree(data);

  return True;
}

static Bool
IMAuxDoneCB(XicCommon ic, unsigned char *p) {
  XimCommon im;
  char *ptr;
  int total_size;
  int input_method_id;
  int input_context_id;
  int engine_class_index;
  int byte_length;
  unsigned char *data;

  if (NULL == ic) {
    return False;
  }
  im = (XimCommon)ic->core.im;

  AuxChange(ic, AUX_DONE, (XPointer)p);

  ptr = (char *)p;
  req_get16(ptr, input_method_id);
  req_get16(ptr, input_context_id);
  req_get32(ptr, engine_class_index);
  req_get16(ptr, byte_length);

  total_size = 2 + 2 + 4 + 2 + byte_length;
  switch (byte_length % 4) {
  case 0: total_size += 2; break;
  case 1: total_size += 1; break;
  case 2: total_size += 0; break;
  case 3: total_size += 3; break;
  }
  data = Xmalloc(total_size + (sizeof (IIimpProtoHdr)));
  if (NULL == data) {
    return False;
  }
  memcpy(data + (sizeof (IIimpProtoHdr)), p, total_size);
  SendMessage(im, IM_AUX_DONE_REPLY, data, total_size, NULL, NULL, NULL);
  Xfree(data);

  return True;
}

static Bool
IMAuxSetValuesReplyCB(XicCommon ic, unsigned char *p) {
  return True;
}


static Bool
IMConnectReply(XimCommon im, unsigned char *p) {
  char *ptr;
  CARD16 im_id;
  CARD16 byte_length;
  XIMText *language_list = (XIMText*)0;
  int language_list_num = ATTRNUM;
  int number;
  int i;

  ptr = (char *)p;
  req_get16(ptr, im_id);

  XIM_IIIMP(im, input_method_id) = im_id;

  if (XIM_IIIMP(im, supported_languages)) {
    for (i = 0; i < XIM_IIIMP(im, count_languages); i++) {
      Xfree(XIM_IIIMP(im, supported_languages[i].string.multi_byte));
    }
    Xfree(XIM_IIIMP(im, supported_languages));
  }
  /* language names list */
  language_list = (XIMText*)Xmalloc(sizeof(XIMText) * language_list_num);
  memset(language_list, 0, sizeof(XIMText) * language_list_num);
  if (!language_list) {
    return False;
  }
  number = 0;
  req_get16(ptr, byte_length);
  if (byte_length != 0) {
    while (byte_length != 0) {
      CARD16 str_length = 0;
      if (number == language_list_num) {
	language_list_num += ATTRNUM;
	language_list = (XIMText*)Xrealloc((void*)language_list,
				  sizeof(XIMText) * language_list_num);
      }
      req_get16(ptr, str_length);
      byte_length -= 2;
      if (str_length == 0 || str_length > 65000) {
	/* something wrong */
	if (str_length == 0) {
	  /* decrease padding */
	  byte_length -= 2;
	  if (byte_length > 0)
	    fprintf(stderr, "something is wrong\n");
	}
	goto Error;
      } else {
	CARD8 first_byte, second_byte;
	int len;
	char *string_value;
	char *src;
	size_t dst_len;
	int bl;

	src = ptr;

	string_value = (char*)Xmalloc(str_length/2 * MB_CUR_MAX);
	dst_len = str_length/2 * MB_CUR_MAX;

	if ((str_length + 2) & 0x03) {	/* padding */
	  ptr += (((str_length + 2) & ~(0x03)) + 2);
	  byte_length -= (((str_length + 2) & ~(0x03)) + 2);
	} else {
	  ptr += str_length;
	  byte_length -= str_length;
	}

	IIimpConvertFromUTF16(src, str_length, &string_value, &dst_len);
	bl = (str_length/2 * MB_CUR_MAX - dst_len);
	string_value[bl] = '\0';
	language_list[number].length = bl;
	language_list[number].encoding_is_wchar = 0;
	language_list[number++].string.multi_byte = string_value;
      }
    }
  }
 Error:
  XIM_IIIMP(im, supported_languages) = language_list;
  XIM_IIIMP(im, count_languages) = number;
  return True;
}

static XIMTriggerKey*
GetTriggerKey(
	char **ptr,
	unsigned short *count_keys) {
  CARD16 byte_length;
  XIMTriggerKey *key_list = (XIMTriggerKey*)NULL;
  unsigned short number;

  *count_keys = number = 0;
  req_get32(*ptr, byte_length);

  if (byte_length != 0) {
    key_list = (XIMTriggerKey*)Xmalloc(byte_length);
    if (!key_list) {
      return (XIMTriggerKey*)NULL;
    }
    memset(key_list, 0, byte_length);
    while (16 <= byte_length) {
      req_get32(*ptr, key_list[number].keycode);
      req_get32(*ptr, key_list[number].keychar);
      req_get32(*ptr, key_list[number].modifier);
      req_get32(*ptr, key_list[number].time_stamp);
      byte_length -= 16;

      if (key_list[number].modifier & (1<<1)) {
	/* IIIMP's control_mask(1<<1) and X's control_mask(1<<2)is
	   different, so it should be changed */
	key_list[number].modifier -= (1<<1);
	key_list[number].modifier |= (1<<2);
      }
      number++;
    }
    *count_keys = number;
  }
  return key_list;
}

static Bool
IMRegisterTriggerKeys(XimCommon im, unsigned char *p) {
  char *ptr;
  CARD16 im_id;

  /* Free previous data */
  if (XIM_IIIMP(im, on_keys.keylist)) {
    Xfree(XIM_IIIMP(im, on_keys.keylist));
  }
  if (XIM_IIIMP(im, off_keys.keylist)) {
    Xfree(XIM_IIIMP(im, off_keys.keylist));
  }

  ptr = (char *)p;
  req_get16(ptr, im_id);
  ptr += 2;

  /* on-key list */
  XIM_IIIMP(im, on_keys.keylist) =
	  GetTriggerKey(&ptr, &(XIM_IIIMP(im, on_keys.count_keys)));
  
  /* off-key list */
  XIM_IIIMP(im, off_keys.keylist) =
	  GetTriggerKey(&ptr, &(XIM_IIIMP(im, off_keys.count_keys)));

  {
    char *current_locale = strdup(setlocale(LC_CTYPE, NULL));
    convertToInputLanguage(current_locale);
    AddConvKeysFromFile(&XIM_IIIMP(im, on_keys), current_locale);
    free(current_locale);
  }
  return True;
}

static Bool
IMCreateICReply(XimCommon im, unsigned char *p, XPointer ret) {
  char *ptr;
  int input_method_id;
  int input_context_id;

  ptr = (char *)p;
  req_get16(ptr, input_method_id);
  req_get16(ptr, input_context_id);

  if (ret && *ret)
    memmove(ret, &input_context_id, sizeof(int));

  return True;
}

/* Predicate functions */
static Bool
IIIMP_ConnectReplyCB(XimCommon im, unsigned char *p,
		     XicCommon ic, XPointer ret) {
  IIimpProtoHdr *hdr = (IIimpProtoHdr*)p;
  unsigned char *p1 = (unsigned char *)(hdr + 1);
  Bool status = True;
  if (hdr == (IIimpProtoHdr*)NULL) {
    return False;
  }

  switch (hdr->opcode) {
  case IM_CONNECT_REPLY:
    status = IMConnectReply(im, p1);
    break;
  case IM_REGISTER_TRIGGER_KEYS:
    IMRegisterTriggerKeys(im, p1);
    status = False;
    break;
  default:
    /* should not occur */
    DispatchMessage(im, p, ic, ret);
    status = False;
    break;
  }
  return status;
}

static Bool
IIIMP_CreateICReplyCB(XimCommon im, unsigned char *p,
		      XicCommon ic, XPointer ret) {
  IIimpProtoHdr *hdr = (IIimpProtoHdr*)p;
  unsigned char *p1 = (unsigned char *)(hdr + 1);
  Bool status = True;
  if (hdr == (IIimpProtoHdr*)NULL) {
    return False;
  }

  switch (hdr->opcode) {
  case IM_CREATEIC_REPLY:
    status = IMCreateICReply(im, p1, ret);
    break;
  default:
    /* should not occur */
    DispatchMessage(im, p, ic, ret);
    status = False;
    break;
  }
  return status;
}

static Bool
IIIMP_SetICValuesReplyCB(XimCommon im, unsigned char *p,
			 XicCommon ic, XPointer ret) {
  IIimpProtoHdr *hdr = (IIimpProtoHdr*)p;
  Bool status = True;
  if (hdr == (IIimpProtoHdr*)NULL) {
    return False;
  }

  switch (hdr->opcode) {
  case IM_SETICVALUES_REPLY:
    break;
  default:
    DispatchMessage(im, p, ic, ret);
    status = False;
    break;
  }
  return status;
}

static Bool
IIIMP_DisconnectReplyCB(XimCommon im, unsigned char *p,
			XicCommon ic, XPointer ret) {
  IIimpProtoHdr *hdr = (IIimpProtoHdr*)p;
  Bool status = True;
  if (hdr == (IIimpProtoHdr*)NULL) {
    return False;
  }

  switch (hdr->opcode) {
  case IM_DISCONNECT_REPLY:
    break;
  default:
    DispatchMessage(im, p, ic, ret);
    status = False;
    break;
  }
  return status;
}

static Bool
IIIMP_SetICFocusReplyCB(XimCommon im, unsigned char *p, 
			XicCommon ic, XPointer ret) {
  IIimpProtoHdr *hdr = (IIimpProtoHdr*)p;
  Bool status = True;
  if (hdr == (IIimpProtoHdr*)NULL) {
    return False;
  }

  switch (hdr->opcode) {
  case IM_SETICFOCUS_REPLY:
    break;
  default:
    DispatchMessage(im, p, ic, ret);
    status = False;
    break;
  }
  return status;
}

static Bool
IIIMP_UnsetICFocusReplyCB(XimCommon im, unsigned char *p,
			  XicCommon ic, XPointer ret) {
  IIimpProtoHdr *hdr = (IIimpProtoHdr*)p;
  Bool status = True;
  if (hdr == (IIimpProtoHdr*)NULL) {
    return False;
  }

  switch (hdr->opcode) {
  case IM_UNSETICFOCUS_REPLY:
    break;
  default:
    DispatchMessage(im, p, ic, ret);
    status = False;
    break;
  }
  return status;
}

static Bool
IIIMP_ResetICReplyCB(XimCommon im, unsigned char *p,
		     XicCommon ic, XPointer ret) {
  IIimpProtoHdr *hdr = (IIimpProtoHdr*)p;
  Bool status = True;
  if (hdr == (IIimpProtoHdr*)NULL) {
    return False;
  }

  switch (hdr->opcode) {
  case IM_RESETIC_REPLY:
    break;
  default:
    DispatchMessage(im, p, ic, ret);
    status = False;
    break;
  }
  return status;
}

static Bool
IIIMP_ForwardEventReplyCB(XimCommon im, unsigned char *p,
			  XicCommon ic, XPointer ret) {
  IIimpProtoHdr *hdr = (IIimpProtoHdr*)p;
  Bool status = True;
  if (hdr == (IIimpProtoHdr*)NULL) {
    return False;
  }

  if (1 == XIC_IIIMP(ic, key_event_forwarded)) {
    if (IM_FORWARD_EVENT == hdr->opcode) {
      IMForwardEventForwardEventCB(ic, p);
      XIC_IIIMP(ic, key_event_forwarded) = 2;
      return False;
    }
    XIC_IIIMP(ic, key_event_forwarded) = 0;
  }

  switch (hdr->opcode) {
  case IM_FORWARD_EVENT_REPLY:
    break;
  default:
    DispatchMessage(im, p, ic, ret);
    status = False;
    break;
  }
  return status;
}

static Bool
IIIMP_TriggerNotifyReplyCB(XimCommon im, unsigned char *p,
			   XicCommon ic, XPointer ret) {
  IIimpProtoHdr *hdr = (IIimpProtoHdr*)p;
  Bool status = True;
  if (hdr == (IIimpProtoHdr*)NULL) {
    return False;
  }

  switch (hdr->opcode) {
  case IM_TRIGGER_NOTIFY_REPLY:
    break;
  default:
    DispatchMessage(im, p, ic, ret);
    status = False;
    break;
  }
  return status;
}

static Bool
IIIMP_SetIMValuesReplyCB(XimCommon im, unsigned char *p,
			 XicCommon ic, XPointer ret) {
  IIimpProtoHdr *hdr = (IIimpProtoHdr*)p;
  Bool status = True;
  XicCommon dummy_ic = (XicCommon)NULL;

  if (hdr == (IIimpProtoHdr*)NULL) {
    return False;
  }

  /* ic is always NULL */
  dummy_ic = (XicCommon)Xmalloc(sizeof(XicCommonRec));
  if (!dummy_ic) {
    return False;
  }
  memset(dummy_ic, 0, sizeof (XicCommonRec));
  dummy_ic->core.im = (XIM)im;

  switch (hdr->opcode) {
  case IM_SETIMVALUES_REPLY:
    break;
  default:
    DispatchMessage(im, p, dummy_ic, ret);
    status = False;
    break;
  }
  if (dummy_ic) Xfree(dummy_ic);
  return status;
}

static Bool 
IMGetIMValuesReply(XimCommon im, unsigned char *p)
{
  char *ptr;
  int input_method_id;
  int byte_length;
  int i;
  IIIMObjectRec * io;

  ptr = (char *)p;
  req_get16(ptr, input_method_id);
  ptr += 2;
  req_get32(ptr, byte_length);

  if (byte_length != 0) {
    int attr_id;
    int value_length;
    void * value;

    while (0 < byte_length) {
      req_get16(ptr, attr_id);
      ptr += 2;
      req_get32(ptr, value_length);
      value = ptr;
      byte_length -= (8 + value_length);
      if (byte_length & 0x03) {	/* padding */
	ptr += ((value_length & ~(0x03)) + 4);
	byte_length -= ((value_length & ~(0x03)) + 4);
      } else {
	ptr += value_length;
	byte_length -= value_length;
      }

      for (io = XIM_IIIMP(im, iiim_object); NULL != io; io = io->next) {
	if (attr_id == io->id_dyn) {
	  switch (io->id) {
	  case INPUTMETHOD_LIST:
	  case OBJECT_DESCRIPTER_LIST:
	  case CLIENT_DESCRIPTER:
	  case CCDEF:
		  break;
	  case GUI_OBJECT:
		  if (NULL != io) {
		    int len;
		    XIMText text;
		    len = IMStringToXIMText((unsigned char *)value, &text,
					    False);
		    if (0 < len) {
		      io->path = text.string.multi_byte;
		    } else {
		      Xfree(text.string.multi_byte);
		    }
		  }
		  AuxChange(NULL, AUX_DOWNLOAD, (XPointer)value);
		  break;
	  case LWE_OBJECT:
	  case OS_VERSION:
	  case OS_NAME:
	  case OS_ARCH:
	  default:
		  break;
	  }
	  break;
	}
      }
    }
  }
  return True;
}

static Bool
IIIMP_GetIMValuesReplyCB(XimCommon im, unsigned char *p,
			 XicCommon ic, XPointer ret) {
  IIimpProtoHdr *hdr = (IIimpProtoHdr*)p;
  unsigned char *p1 = (unsigned char *)(hdr + 1);
  Bool status = True;
  XicCommon dummy_ic = (XicCommon)NULL;

  if (hdr == (IIimpProtoHdr*)NULL) {
    return False;
  }

  /* ic is always NULL */
  dummy_ic = (XicCommon)Xmalloc(sizeof(XicCommonRec));
  if (!dummy_ic) {
    return False;
  }
  dummy_ic->core.im = (XIM)im;

  switch (hdr->opcode) {
  case IM_GETIMVALUES_REPLY:
    status = IMGetIMValuesReply(im, p1);
    break;
  default:
    DispatchMessage(im, p, dummy_ic, ret);
    status = False;
    break;
  }
  if (dummy_ic) Xfree(dummy_ic);
  return status;
}

static Bool
IIIMP_DestroyICReplyCB(XimCommon im, unsigned char *p,
		       XicCommon ic, XPointer ret) {
  IIimpProtoHdr *hdr = (IIimpProtoHdr*)p;
  Bool status = True;
  if (hdr == (IIimpProtoHdr*)NULL) {
    return False;
  }

  switch (hdr->opcode) {
  case IM_DESTROYIC_REPLY:
    break;
  default:
    DispatchMessage(im, p, ic, ret);
    status = False;
    break;
  }
  return status;
}

static Bool
IIIMP_AuxSetValuesReplyCB(XimCommon im, unsigned char *p,
			  XicCommon ic, XPointer ret) {
  IIimpProtoHdr *hdr = (IIimpProtoHdr*)p;
  Bool status = True;
  if (hdr == (IIimpProtoHdr*)NULL) {
    return False;
  }

  switch (hdr->opcode) {
  case IM_AUX_SETVALUES_REPLY:
    break;
  default:
    DispatchMessage(im, p, ic, ret);
    status = False;
    break;
  }
  return status;
}

/* Public functions */
Bool
IMConnect(XimCommon im, int retry_count) {
  char *ptr;
  int padding_user;
  int total_size;
  unsigned char *data = (unsigned char*)NULL;
  int iter_count;
  CARD8 byte_order;
  CARD16 endian = 1;
  CARD8 protocol_version = '1';
  Bool status = True;
  int i;
  struct passwd *pwd;
  char *user_name;
  unsigned int user_name_len;
  char *host_name = 0;
  unsigned int host_name_len = 0;
  struct utsname un;
  unsigned int user_info_len;
  char *password;
  char *data_password;

  pwd = getpwuid(getuid());
  if (NULL == pwd) {
    status = False;
    goto Error;
  }
  user_name = pwd->pw_name;
  user_name_len = strlen(user_name);
  password = auth_password_get(pwd->pw_dir);
  data_password = NULL;
  endpwent();

  if (!TransConnect(im, retry_count)) {
    status = False;
    goto Error;
  }

  if (*(char *)&endian) {
    byte_order = 'l';
  } else {
    byte_order = 'B';
  }

  /* set byte length of user name */
  if (uname(&un) != -1) {
    host_name = un.nodename;
    host_name_len = strlen(host_name);
    user_info_len = user_name_len + host_name_len + 1;
  } else {
    user_info_len = user_name_len;
  }
  if (NULL != password) {
	  user_info_len += (1 /* '#' */ + AUTH_PASSWORD_LEN);
  }

  if (0 == (user_info_len & 0x01)) {
    padding_user = 2;
  } else {
    padding_user = 0;
  }
  total_size = (1 + 1 + 2 + (user_info_len * 2) + padding_user + 2);

  data = (unsigned char *)Xmalloc(total_size + (sizeof (IIimpProtoHdr)));
  if (!data) {
    status = False;
    goto Error;
  }

  ptr = (char *)(data + (sizeof (IIimpProtoHdr)));
  req_put8(ptr, byte_order);
  req_put8(ptr, protocol_version);
  req_put16(ptr, (user_info_len * 2));

  /* user_name is converted into a list of CARD16 */
  for (i = 0; i < user_name_len; i++) {
    req_put16(ptr, user_name[i]);
  }
  if (host_name_len > 0) {
    req_put16(ptr, '@');

    for (i = 0; i < host_name_len; i++) {
      req_put16(ptr, host_name[i]);
    }
  }

  if (NULL != password) {
    req_put16(ptr, '#');
    data_password = ptr;
    for (i = 0; i < AUTH_PASSWORD_LEN; i++) {
      req_put16(ptr, *(password + i));
    }
    memset(password, 0, AUTH_PASSWORD_LEN);
    free(password);
  }

  if (0 != padding_user) {
    req_put16(ptr, 0);
  }

  /* byte length of client auth protocol names */
  req_put16(ptr, 0);

  /* Send IM_CONNECT to the server, and
     Wait until IM_CONNECT_REPLY is sent back */
  if (!SendMessage(im, IM_CONNECT, data, total_size,
		   IIIMP_ConnectReplyCB, NULL, NULL)) {
    status = False;
  }
  if (XIM_IIIMP(im, count_languages) == 0) {
    status = False;
  }
Error:
  if (NULL != data_password) {
    memset(data_password, 0, AUTH_PASSWORD_LEN);
  }
  if (data) Xfree(data);

  if (True == status) {
    IIIMP_Register_IIIMP_CB(im);
  }
  return status;
}

Bool
IMDisconnect(XimCommon im) {
  Bool status = True;
  char *ptr;
  unsigned char data[(sizeof (IIimpProtoHdr)) + 2 + 2];
  int total_size;

  ptr = (char *)(data + (sizeof (IIimpProtoHdr)));
  req_put16(ptr, XIM_IIIMP(im, input_method_id));
  req_put16(ptr, 0);
  total_size = (2 + 2);

  if (!SendMessage(im, IM_DISCONNECT, data, total_size,
		   IIIMP_DisconnectReplyCB, NULL, NULL)) {
    status = False;
    goto Error;
  }
 Error:
  IIIMP_Unregister_IIIMP_CB(im);
  /* anyway disconnect TCP/IP */
  status = TransDisconnect(im);

  return status;
}

static void
convertToInputLanguage(char *src) {
  if (!strncmp(src, "ja", 2)) src[2] = '\0';
  else if (!strncmp(src, "ko", 2)) src[2] = '\0';
  else if (!strncmp(src, "zh_TW", 5)) src[5] = '\0';
  else if (!strncmp(src, "zh_CN", 5)) src[5] = '\0';
  else if (!strncmp(src, "zh.", 3) && (5 <= strlen(src))) strcpy(src,"zh_CN");
  return;
}

#define IC_ATTR_NUM 5
int
IMCreateIC(XimCommon im) {
  XICAttribute	*ic_attr = (XICAttribute*)0;
  int attr_count;
  char *ptr;
  int total_size;
  unsigned char *data = (unsigned char*)NULL;
  int i;
  int icid = -1;

  /* Exchange IM_CREATE_IC & IM_CREATE_IC_REPLY with Input Method */
  ic_attr = (XICAttribute*)Xmalloc(sizeof(XICAttribute) * IC_ATTR_NUM);
  if (!ic_attr) {
    goto Error;
  }

  attr_count = 0;

  if (NULL == XIM_IIIMP(im, iiim_object)) {
    /* Exchange IM_SETIMVALUES & IM_GETIMVALUES_REPLY with Input Method */
    XIMArg arg[2];
    arg[0].name = "applicationType";
    arg[0].value = IIIMP_CLIENT_TYPE;
    arg[1].name = NULL;
    arg[1].value = NULL;
    IIIMP_SetIMValues((XIM)im, arg);
  }

  /* primary input locale */
  {
    XIMText *language_list = XIM_IIIMP(im, supported_languages);
    char *loc_name = NULL;
    char *current_locale = strdup(setlocale(LC_CTYPE, NULL));
    convertToInputLanguage(current_locale);

    if (language_list) {
      int loc_len = strlen(current_locale);
      int n = XIM_IIIMP(im, count_languages);
      for (i = 0; i < n; i++) {
	if (!strncmp(current_locale, language_list[i].string.multi_byte,
		     loc_len)) {
	  loc_name = language_list[i].string.multi_byte;
	  break;
	}
      }
      if (!loc_name) {
	loc_name = language_list[0].string.multi_byte; /* default */
      }
    } else {
      loc_name = current_locale;
    }
    setICAttribute(loc_name, &ic_attr[attr_count],
		   INPUT_LANGUAGE);
    free(current_locale);
    attr_count++;
  }

  if (NULL != XIM_IIIMP(im, engine_name)) {
    setICAttribute(XIM_IIIMP(im, engine_name), &ic_attr[attr_count],
		   INPUT_METHOD);
    attr_count++;
  }

  total_size = 2;	/* input method id */
  total_size += 2;	/* byte length of ic-attribute */
  for (i = 0; i < attr_count; i++) {
    total_size += 2;	/* attribute id */
    total_size += 2;	/* byte length of value */
    total_size += ic_attr[i].value_length;	/* value */
  }

  data = (unsigned char *)Xmalloc(total_size + (sizeof (IIimpProtoHdr)));
  if (!data) {
    goto Error;
  }

  ptr = (char *)(data + (sizeof (IIimpProtoHdr)));
  req_put16(ptr, XIM_IIIMP(im, input_method_id));
  req_put16(ptr, total_size - (2 + 2));
  for (i = 0; i < attr_count; i++) {
    req_put16(ptr, ic_attr[i].attribute_id);
    req_put16(ptr, ic_attr[i].value_length);
    memcpy(ptr, ic_attr[i].value, ic_attr[i].value_length);
    ptr += ic_attr[i].value_length;
  }

  if (!SendMessage(im, IM_CREATEIC, data, total_size,
		   IIIMP_CreateICReplyCB, NULL, (XPointer)&icid)) {
    goto Error;
 }
Error:
  if (data) Xfree(data);
  if (ic_attr && attr_count > 0) {
    for (i = 0; i < attr_count; i++) {
      Xfree(ic_attr[i].value);
    }
    Xfree(ic_attr);
  }

  return icid;
}
#undef IC_ATTR_NUM

Bool
IMGetICValues(XicCommon ic, XICAttribute *ic_attr, int attr_count) {
  /* nothing to do from X client */
  return True;
}

Bool
IMSetPrimaryLocale(XicCommon ic, char *input_locale) {
  XICAttribute ic_attr[1];
  int attr_count = 0;
  setICAttribute(input_locale, &ic_attr[attr_count],
		 INPUT_LANGUAGE);
  attr_count++;
  IMSetICValues(ic, ic_attr, attr_count);

  if (ic_attr[0].value) Xfree(ic_attr[0].value);

  return True;
}

Bool
IMSetICValues(XicCommon ic, XICAttribute *ic_attr, int attr_count) {
  char *ptr;
  int total_size;
  unsigned char *data = (unsigned char*)NULL;
  int i;
  XimCommon im;

  if (ic == NULL) {
    return False;
  }
  im = (XimCommon)ic->core.im;

  total_size = 2;	/* input method id */
  total_size += 2;	/* input context id */
  total_size += 2;	/* byte length of ic-attribute */
  for (i = 0; i < attr_count; i++) {
    total_size += 2;	/* attribute id */
    total_size += 2;	/* byte length of value */
    total_size += ic_attr[i].value_length;	/* value */
  }
  total_size += 2;	/* padding */

  data = (unsigned char *)Xmalloc(total_size + (sizeof (IIimpProtoHdr)));
  if (!data) {
    goto Error;
  }

  ptr = (char *)(data + (sizeof (IIimpProtoHdr)));
  req_put16(ptr, XIM_IIIMP(im, input_method_id));
  req_put16(ptr, XIC_IIIMP(ic, icid));
  req_put16(ptr, total_size - (2 + 2 + 2 + 2));
  for (i = 0; i < attr_count; i++) {
    req_put16(ptr, ic_attr[i].attribute_id);
    req_put16(ptr, ic_attr[i].value_length);
    memcpy(ptr, ic_attr[i].value, ic_attr[i].value_length);
    ptr += ic_attr[i].value_length;
  }
  req_put16(ptr, 0);

  if (!SendMessage(im, IM_SETICVALUES, data, total_size,
		   IIIMP_SetICValuesReplyCB, ic, (XPointer)NULL)) {
    goto Error;
 }
Error:
  if (data) Xfree(data);
  return True;
}

Bool
IMSetFocus(XicCommon ic) {
  Bool status = True;
  char *ptr;
  unsigned char data[(sizeof (IIimpProtoHdr)) + 2 + 2];
  int total_size;
  XimCommon im;

  if (NULL == ic) {
    return False;
  }
  im = (XimCommon)ic->core.im;

  ptr = (char *)(data + (sizeof (IIimpProtoHdr)));
  req_put16(ptr, XIM_IIIMP(im, input_method_id));
  req_put16(ptr, XIC_IIIMP(ic, icid));
  total_size = (2 + 2);

  if (!SendMessage(im, IM_SETICFOCUS, data, total_size,
		   IIIMP_SetICFocusReplyCB, ic, NULL)) {
    IIIMP_Unregister_IIIMP_CB(im);

    /* Try to reconnect here */
    if (IMConnect(im, 1)) {
      XIC_IIIMP(ic, icid) = IMCreateIC(im);
      SetConversionMode(ic, False);
      IMSetFocus(ic);
    }
    status = False;
    goto Error;
  }
 Error:
  return status;
}

Bool
IMUnsetFocus(XicCommon ic) {
  Bool status = True;
  char *ptr;
  unsigned char data[(sizeof (IIimpProtoHdr)) + 2 + 2];
  int total_size;
  XimCommon im;

  if (NULL == ic) {
    return False;
  }
  im = (XimCommon)ic->core.im;

  ptr = (char *)(data + (sizeof (IIimpProtoHdr)));
  req_put16(ptr, XIM_IIIMP(im, input_method_id));
  req_put16(ptr, XIC_IIIMP(ic, icid));
  total_size = (2 + 2);

  if (!SendMessage(im, IM_UNSETICFOCUS, data, total_size,
		   IIIMP_UnsetICFocusReplyCB, ic, NULL)) {
    status = False;
    goto Error;
  }
 Error:
  return status;
}

Bool
IMResetIC(XicCommon ic) {
  Bool status = True;
  char *ptr;
  unsigned char data[(sizeof (IIimpProtoHdr)) + 2 + 2];
  int total_size;
  XimCommon im;

  if (NULL == ic) {
    return False;
  }
  im = (XimCommon)ic->core.im;

  ptr = (char *)(data + (sizeof (IIimpProtoHdr)));
  req_put16(ptr, XIM_IIIMP(im, input_method_id));
  req_put16(ptr, XIC_IIIMP(ic, icid));
  total_size = (2 + 2);

  if (!SendMessage(im, IM_RESETIC, data, total_size,
		   IIIMP_ResetICReplyCB, ic, NULL)) {
    status = False;
    goto Error;
  }
 Error:
  return status;
}

Bool
IMForwardEvent(XIC xic, XEvent *ev) {
  XicCommon ic = (XicCommon)xic;
  Bool status = True;
  char *ptr;
  unsigned char data[(sizeof (IIimpProtoHdr)) + 2 + 2 + 4 + 4 + ((4 * 4) * 1)];
  int total_size;
  XimCommon im;
  int iter_count;
  int keycode, keychar, state;
  XKeyEvent *kev = (XKeyEvent*)ev;
  int type;

  if (NULL == ic) {
    return False;
  }
  im = (XimCommon)ic->core.im;

  /* IIIMP only takes KeyPress events */
  if (ev->type != KeyPress) return True;

  total_size = (2 + 2 + 4 + 4 + ((4 * 4) * 1));
	      /* imid + icid + type + len + (key event) */

  ptr = (char *)(data + (sizeof (IIimpProtoHdr)));
  req_put16(ptr, XIM_IIIMP(im, input_method_id));
  req_put16(ptr, XIC_IIIMP(ic, icid));
  req_put32(ptr, 2);	/* KEYEVENT type = #02 */
  req_put32(ptr, 16);	/* size */

  if (!KeyEventToVirtualKey(kev, &keycode, &keychar, &state)) {
    status = True;
    goto Error;
  }

  req_put32(ptr, keycode);
  req_put32(ptr, keychar);
  req_put32(ptr, state);
  req_put32(ptr, kev->time);

  XIC_IIIMP(ic, key_event_forwarded) = 1;

  if (!SendMessage(im, IM_FORWARD_EVENT, data, total_size,
		   IIIMP_ForwardEventReplyCB, ic, NULL)) {
    status = False;
    goto Error;
  }
 Error:
  if (0 != XIC_IIIMP(ic, key_event_forwarded)) {
    XIC_IIIMP(ic, key_event_forwarded) = 0;
    status = False;
  }
  return status;
}

Bool
IMTriggerNotify(XicCommon ic, XICConversionMode conv_mode) {
  Bool status = True;
  char *ptr;
  unsigned char data[(sizeof (IIimpProtoHdr)) + 2 + 2 + 2 + 2];
  int total_size;
  XimCommon im;

  if (NULL == ic) {
    return False;
  }
  im = (XimCommon)ic->core.im;

  total_size = (2 + 2 + 2 + 2);
  ptr = (char *)(data + (sizeof (IIimpProtoHdr)));
  req_put16(ptr, XIM_IIIMP(im, input_method_id));
  req_put16(ptr, XIC_IIIMP(ic, icid));
  req_put16(ptr, conv_mode);	/* 0 for ON, 1 for OFF */
  req_put16(ptr, 0);

  if (!SendMessage(im, IM_TRIGGER_NOTIFY, data, total_size,
		   IIIMP_TriggerNotifyReplyCB, ic, NULL)) {
    status = False;
    goto Error;
  }
 Error:
  return status;
}

#define IM_ATTR_NUM 10
Bool
IMSetIMValues(XimCommon im) {
  XICAttribute	*im_attr = (XICAttribute*)0;
  int attr_count;
  char *ptr;
  int total_size;
  unsigned char *data = (unsigned char*)NULL;
  int i;
  
  /* Exchange IM_SETIMVALUES & IM_SETIMVALUES_REPLY with Input Method */
  im_attr = (XICAttribute*)Xmalloc(sizeof(XICAttribute) * IM_ATTR_NUM);
  if (!im_attr) {
    return False;
  }

  attr_count = 0;

  if (NULL == XIM_IIIMP(im, client_type)) {
    XIM_IIIMP(im, client_type) = IIIMP_CLIENT_TYPE; /* default */
  }
  makeClientDescripter(im->core.display,
		       XIM_IIIMP(im, client_type),
		       &im_attr[attr_count], CLIENT_DESCRIPTER);
  attr_count++;

  total_size = 2;	/* input method id */
  total_size += 2;	/* pad */
  total_size += 4;	/* byte length of im-attribute */
  for (i = 0; i < attr_count; i++) {
    total_size += 2;	/* attribute id */
    total_size += 2;	/* pad */
    total_size += 4;	/* byte length of value */
    total_size += im_attr[i].value_length;	/* value */
    if (im_attr[i].value_length & 0x03) {
      total_size += (4 - (im_attr[i].value_length & 0x03));
    }
  }

  data = (unsigned char *)Xmalloc(total_size + (sizeof (IIimpProtoHdr)));
  if (!data) {
    return False;
  }

  ptr = (char *)(data + (sizeof (IIimpProtoHdr)));
  req_put16(ptr, XIM_IIIMP(im, input_method_id));
  req_put16(ptr, 0);	/* pad */
  req_put32(ptr, total_size - (2 + 2 + 4));
  for (i = 0; i < attr_count; i++) {
    req_put16(ptr, im_attr[i].attribute_id);
    req_put16(ptr, 0);	/* pad */
    req_put32(ptr, im_attr[i].value_length);
    memcpy(ptr, im_attr[i].value, im_attr[i].value_length);
    ptr += im_attr[i].value_length;
    if (im_attr[i].value_length & 0x03) {	/* padding */
      int j;
      for (j = ((im_attr[i].value_length & ~(0x03)) - 1); 0 <= j; --j) {
	*(ptr++) = 0;
      }
    }
  }

  if (!SendMessage(im, IM_SETIMVALUES, data, total_size,
		   IIIMP_SetIMValuesReplyCB, NULL, NULL)) {
    return False;
 }
Error:
  if (data) Xfree(data);
  if (im_attr && attr_count > 0) {
    for (i = 0; i < attr_count; i++) {
      Xfree(im_attr[i].value);
    }
    Xfree(im_attr);
  }
  return True;
}
#undef IM_ATTR_NUM

Bool
IMGetIMValue(XimCommon im, int attr_id) {
  int attr_count=0;
  int total_size;
  unsigned char data[(sizeof (IIimpProtoHdr)) + 2 + 2 + 4 + 2 + 2];
  char *ptr;
  int i;
  
  ptr = (char *)(data + (sizeof (IIimpProtoHdr)));
  req_put16(ptr, XIM_IIIMP(im, input_method_id));
  req_put16(ptr, 0);
  req_put32(ptr, 2);
  req_put16(ptr, attr_id);
  req_put16(ptr, 0);
  total_size = (2 + 2 + 4 + 2 + 2);

  if (!SendMessage(im, IM_GETIMVALUES, data, total_size,
		   IIIMP_GetIMValuesReplyCB, NULL, NULL)) {
    return False;
  }

  return True;
}

static Bool
IMGetIMValuesCB(XicCommon ic, unsigned char *p) {
  char *ptr;
  int total_size;
  unsigned char *data = (unsigned char*)NULL;
  int input_method_id;
  XimCommon im;

  if (NULL == ic) {
    return False;
  }
  im = (XimCommon)ic->core.im;

  ptr = (char *)p;
  req_get16(ptr, input_method_id);

  /* need to get imvalues.... */

  /* Send reply on IIIMP */
  total_size = (2 + 2 + 4);

  data = (unsigned char *)Xmalloc(total_size + (sizeof (IIimpProtoHdr)));
  if (!data) {
    /* Send IM_ERROR */
    goto Error;
  }

  ptr = (char *)(data + (sizeof (IIimpProtoHdr)));
  req_put16(ptr, input_method_id);
  req_put16(ptr, 0);	/* pad */
  req_put32(ptr, 0);	/* byte length of im-attribute */

  if (!SendMessage(im, IM_GETIMVALUES_REPLY, data, total_size,
		   IIIMP_GetIMValuesReplyCB, NULL, NULL)) {
    goto Error;
  }
 Error:
  if (data) Xfree(data);
  return True;
}

Bool
IMAuxSetValues(XicCommon ic, unsigned char * p, int len, XPointer ret) {
  XimCommon im;
  unsigned char *data;

  if (NULL == ic) {
    return False;
  }
  im = (XimCommon)ic->core.im;

  data = Xmalloc(len + (sizeof (IIimpProtoHdr)));
  if (NULL == data) {
    return False;
  }
  memcpy(data + (sizeof (IIimpProtoHdr)), p, len);
  if (!SendMessage(im, IM_AUX_SETVALUES, data, len,
		   IIIMP_AuxSetValuesReplyCB, ic, NULL)) {
    Xfree(data);
    return False;
  } else {
    Xfree(data);
    return True;
  }
}

Bool
IMDestroyIC(XicCommon ic) {
  Bool status = True;
  char *ptr;
  unsigned char data[(sizeof (IIimpProtoHdr)) + 2 + 2];
  int total_size;
  XimCommon im;

  if (NULL == ic) {
    return False;
  }
  im = (XimCommon)ic->core.im;

  ptr = (char *)(data + (sizeof (IIimpProtoHdr)));
  req_put16(ptr, XIM_IIIMP(im, input_method_id));
  req_put16(ptr, XIC_IIIMP(ic, icid));
  total_size = (2 + 2);

  if (!SendMessage(im, IM_DESTROYIC, data, total_size,
		   IIIMP_DestroyICReplyCB, ic, NULL)) {
    status = False;
    goto Error;
  }
 Error:
  return status;
}

static const int iiimp_with_ic[] = {
  -1, -1, -1, -1, -1, -1,			/* #000-005 */
  1,						/* #006 */
  -1,						/* #007 */
  0,						/* #008 */
  -1,						/* #009 */
  0,						/* #010 */
  -1,						/* #011 */
  1,						/* #012 */
  -1,						/* #013 */
  1,						/* #014 */
  -1, -1, -1, -1, -1, 				/* #015-019 */
  -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 	/* #020-029 */
  -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 	/* #030-039 */
  1,						/* #040 */
  -1,						/* #041 */
  1,						/* #042 */
  -1,						/* #043 */
  1,						/* #044 */
  -1,						/* #045 */
  1,						/* #046 */
  -1, -1, -1,					/* #047-#049 */
  1,						/* #050 */
  -1,						/* #051 */
  1,						/* #052 */
  -1,						/* #053 */
  1,						/* #054 */
  -1, -1, -1, -1, -1,				/* #055-#059 */
  -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 	/* #060-069 */
  1,						/* #070 */
  -1,						/* #071 */
  1,						/* #072 */
  -1,						/* #073 */
  1,						/* #074 */
  -1,						/* #075 */
  1,						/* #076 */
  -1, -1, -1,					/* #077-#079 */
  -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 	/* #080-089 */
  1,						/* #090 */
  -1,						/* #091 */
  1,						/* #092 */
  -1,						/* #093 */
  1,						/* #094 */
  -1,						/* #095 */
  -1,						/* #096 */
  1,						/* #097 */
  -1,						/* #098 */
  -1,						/* #099 */
  -1,						/* #100 */
};

static void
iiimp_disconnected(XicCommon ic) {
  TRACE_MESSAGE('i', ("iiimp_disconnected: ic=%08x\n", ic));

  if (ic->core.im && XIM_IS_IIIMP(ic->core.im)) {
    XIC_GUI(ic, change_status)((XIC)ic, STATUS_DONE, (XPointer)NULL);
    XIC_GUI(ic, change_status)((XIC)ic, STATUS_DESTROY, (XPointer)NULL);
  }
}

static int
IIIMP_Register_IIIMP_CB(XimCommon im) {
    int fd;
    extern int _XimXTransGetConnectionNumber(struct _XtransConnInfo *);

    if ((1 == XIM_IIIMP(im, iiimp_cb_registered)) ||
	(NULL == XIM_IIIMP(im, spec)) ||
	(NULL == XIM_IIIMP(im, spec->trans_conn))) {
	return 0;
    }
    fd = _XimXTransGetConnectionNumber(XIM_IIIMP(im, spec->trans_conn));
    _XRegisterInternalConnection(im->core.display, fd, IIIMP_CB, (XPointer)im);
    XIM_IIIMP(im, iiimp_cb_registered) = 1;
    return 1;
}

static int
IIIMP_Unregister_IIIMP_CB(XimCommon im) {
    int fd;
    extern int _XimXTransGetConnectionNumber(struct _XtransConnInfo *);

    if ((0 == XIM_IIIMP(im, iiimp_cb_registered)) ||
	(NULL == XIM_IIIMP(im, spec)) ||
	(NULL == XIM_IIIMP(im, spec->trans_conn))) {
	return 0;
    }
    fd = _XimXTransGetConnectionNumber(XIM_IIIMP(im, spec->trans_conn));
    _XUnregisterInternalConnection(im->core.display, fd);
    XIM_IIIMP(im, iiimp_cb_registered) = 0;
    return 1;
}

static void
IIIMP_CB(Display *dpy, int fd, XPointer call_data) {
  unsigned char *p;
  XimCommon im;
  XicCommon ic = 0;
  CARD16 ic_id;
  int	with_ic;
  XicCommon dummy_ic;
  CARD8 opcode;
  CARD8 length[3];
  int data_length;
  char *ptr;
  im = (XimCommon)call_data;

  p = ReadMessage(im);
  if (p == NULL) {
    for (ic = (XicCommon)(im->core.ic_chain); NULL != ic;
	 ic = (XicCommon)(ic->core.next)) {
      iiimp_disconnected(ic);
    }

    if (XIM_IIIMP(im, supported_languages)) {
      int i;
      for (i = 0; i < XIM_IIIMP(im, count_languages); i++) {
	Xfree(XIM_IIIMP(im, supported_languages[i].string.multi_byte));
      }
      Xfree(XIM_IIIMP(im, supported_languages));
      XIM_IIIMP(im, supported_languages) = NULL;
      XIM_IIIMP(im, count_languages) = 0;
    }
    return;
  }

  ptr = (char *)p;
  req_get8(ptr, opcode);
  req_get8(ptr, length[2]);
  req_get8(ptr, length[1]);
  req_get8(ptr, length[0]);

  /* calculate length */
  data_length  = (length[2] << 16);
  data_length += (length[1] << 8);
  data_length += length[0];

  switch (iiimp_with_ic[opcode]) {
  case -1:
    break;
  case 0:
    dummy_ic = (XicCommon)Xmalloc(sizeof(XicCommon));
    if (NULL == dummy_ic) {
      break;
    }
    dummy_ic->core.im = (XIM)im;
    DispatchMessage(im, p, dummy_ic, NULL);
    Xfree(dummy_ic);
    break;
  case 1:
    if (data_length < 2) {
      break;
    }
    ic_id = *((CARD16 *)(p + 6));

    for (ic = (XicCommon)(im->core.ic_chain); NULL != ic;
	 ic = (XicCommon)(ic->core.next)) {
      if (XIC_IIIMP(ic, icid) == ic_id) {
	DispatchMessage(im, p, ic, NULL);
	break;
      }
    }
    break;
  }

  Xfree(p);

  if (ic) PutBackXKeyEvent(ic);

  return;
}
