/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include "iiimpIM.h"
#include "iiimpUtil.h"

/* workaround for Linux */
#ifdef linux
#define ARCH "x86"
#else
#ifdef ARCH
#undef ARCH
#endif /* ARCH */
#endif

#ifndef ARCH
#include <sys/systeminfo.h>	/* For os_arch */
#endif
#include <sys/utsname.h>	/* For os_name and os_version */

static char *node_name = (char*)0;
static char *os_name = (char*)0;
static char *os_version = (char*)0;
static char *os_arch = (char*)0;
static char *xDisplayName = (char*)0;
static char *xServerVendor = (char*)0;

/* os properties */
static void
getOSProperties(void) {
  struct utsname name;
  char arch[12];
  uname(&name);
  node_name = (char*)strdup(name.nodename);
  os_name = (char*)strdup(name.sysname);
  os_version = (char*)strdup(name.release);

#ifdef ARCH
  os_arch = ARCH;
#else
  sysinfo(SI_ARCHITECTURE, arch, sizeof(arch));
  if (strcmp(arch,"sparc") == 0 ) {
    os_arch = "sparc";
  } else if (strcmp(arch,"i386") == 0 ) {
    /* use x86 to match the value received on win32 */
    os_arch = "x86";
  } else if (strcmp(arch, "ppc") == 0 ) {
    os_arch = "ppc";
  } else {
    os_arch = "Unknown";
  }
#endif
}

void
makeClientDescripter(Display *dpy, char *client_name, XICAttribute *ic_attr,
		     int icid) {
  int n;
  XICAttribute temp_ic_attr[10], *p;
  const int dummy_id = 0;
  char *buf = (char*)0, *bufp;
  size_t buf_len = 0, total_length = 0;

  if (!os_name) {
    getOSProperties();
    if (dpy) {			/* display info */
      char *ptr;

      xServerVendor = ServerVendor(dpy);
      if (NULL != xServerVendor) {
	ptr = Xmalloc(strlen(xServerVendor) + 1);
	strcpy(ptr, xServerVendor);
	xServerVendor = ptr;
      }

      xDisplayName = DisplayString(dpy);
      if (NULL != xDisplayName) {
	if (':' == *xDisplayName) {
	  ptr = Xmalloc(strlen(node_name) + strlen(xDisplayName) + 1);
	  strcpy(ptr, node_name);
	  strcat(ptr, xDisplayName);
	} else {
	  ptr = Xmalloc(strlen(xDisplayName) + 1);
	  strcpy(ptr, xDisplayName);
	}
	xDisplayName = ptr;

#define CHOP_SCREEN_NUM
#if defined(CHOP_SCREEN_NUM)
	if ((NULL != (ptr = strchr(ptr, ':'))) &&
	    (NULL != (ptr = strchr(ptr, '.')))) {
	  *ptr = '\0';
	}
#endif /* CHOP_SCREEN_NUM */
      }
    }
  }

  n = 0;
  p = temp_ic_attr;
  /* client_name */
  setICAttribute(client_name, p, dummy_id);
  buf_len += p->value_length;
  p++; n++;

  /* os_name */
  setICAttribute(os_name, p, dummy_id);
  buf_len += p->value_length;
  p++; n++;

  /* os_arch */
  setICAttribute(os_arch, p, dummy_id);
  buf_len += p->value_length;
  p++; n++;

  /* os_version */
  setICAttribute(os_version, p, dummy_id);
  buf_len += p->value_length;
  p++; n++;

  /* x display name */
  if (xDisplayName) {
    setICAttribute(xDisplayName, p, dummy_id);
    buf_len += p->value_length;
    p++; n++;
  }

  /* x server vendor */
  if (xServerVendor) {
    setICAttribute(xServerVendor, p, dummy_id);
    buf_len += p->value_length;
    p++; n++;
  }

  /* make ListofString value */
  total_length =  buf_len + PADDING(buf_len);
  buf = Xmalloc(total_length);
  if (!buf) return;

  memset(buf, 0, total_length);
 
  bufp = buf;
  for (p = temp_ic_attr; p < &temp_ic_attr[n]; p++) {
    memmove(bufp, p->value, p->value_length);
    bufp += p->value_length;
  }

  ic_attr->attribute_id = icid;
  ic_attr->value_length = total_length;
  ic_attr->value = buf;

  return;
}
